/*
 * Decompiled with CFR 0.152.
 */
package Zevac.SurvivalFlight;

import Zevac.SurvivalFlight.Proxy.ClientProxy;
import Zevac.SurvivalFlight.SurvivalFlight;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final String CATEGORY_KEYS = "keys";
    private static final String CATEGORY_RENDITION = "Rendition";
    public static int keyAllowFlight = 211;
    public static int keyFlyFaster = 78;
    public static int keyFlySlower = 74;
    public static boolean showStatusText = true;
    public static boolean dontShowWhenInDebug = true;
    public static String statusTextColor = "FFAA00";
    public static int statusTextPosX = 1;
    public static int statusTextPosY = 1;

    public static void readConfig() {
        Configuration cfg = ClientProxy.config;
        try {
            cfg.load();
            Config.initKeyConfig(cfg);
        }
        catch (Exception e1) {
            SurvivalFlight.LOGGER.error("Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initKeyConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_KEYS, "Key configuration");
        keyAllowFlight = cfg.getInt("AllowFlight", CATEGORY_KEYS, keyAllowFlight, 0, 128, "Key mapping for Allow Flight");
        keyFlyFaster = cfg.getInt("FlyFaster", CATEGORY_KEYS, keyFlyFaster, 0, 128, "Key mapping for flying faster");
        keyFlySlower = cfg.getInt("FlySlower", CATEGORY_KEYS, keyFlySlower, 0, 128, "Key mapping for flying slower");
        cfg.addCustomCategoryComment(CATEGORY_RENDITION, "Rendition configuration");
        showStatusText = cfg.getBoolean("ShowStatusText", CATEGORY_RENDITION, showStatusText, "Show Status text or not");
        dontShowWhenInDebug = cfg.getBoolean("DontShowWhenInDebugMode", CATEGORY_RENDITION, dontShowWhenInDebug, "Dont Show Status text when debugscreen is on");
        statusTextColor = cfg.getString("StatusTextColor", CATEGORY_RENDITION, statusTextColor, "Color of Status Text in HEX, https://minecraft.gamepedia.com/Formatting_codes#Color_codes");
        statusTextPosX = cfg.getInt("StatusTextPosX", CATEGORY_RENDITION, statusTextPosX, 1, 2000, "The X position (column) of the Status text in relative pixels");
        statusTextPosY = cfg.getInt("StatusTextPosY", CATEGORY_RENDITION, statusTextPosY, 1, 2000, "The Y position (row) of the Status text in relative pixels");
    }
}

