/*
 * Decompiled with CFR 0.152.
 */
package Zevac.SurvivalFlight.Proxy;

import Zevac.SurvivalFlight.EventHandler.KeyEventHandler;
import Zevac.SurvivalFlight.EventHandler.RenderGameOverlayEventhandler;
import Zevac.SurvivalFlight.ModConfig;
import Zevac.SurvivalFlight.Proxy.CommonProxy;
import Zevac.SurvivalFlight.Ref;
import Zevac.SurvivalFlight.SurvivalFlight;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static Configuration config;
    public static KeyBinding[] keyBindings;
    public static boolean tmpAllowFlight;
    public static Float tmpFlightSpeed;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        SurvivalFlight.LOGGER.info("(Client-side) Reading/Creating config...");
        File directory = event.getModConfigurationDirectory();
        config = new Configuration(new File(directory.getPath(), "zevac.survivalflight.cfg"));
        ModConfig.readConfig();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        SurvivalFlight.LOGGER.info("(Client-side) Binding keys...");
        keyBindings = new KeyBinding[3];
        ClientProxy.keyBindings[0] = new KeyBinding("Toggle Flight", ModConfig.keys.ToggleFlight, "Zevac's SurvivalFlight");
        ClientProxy.keyBindings[1] = new KeyBinding("Fly Faster", ModConfig.keys.FlyFaster, "Zevac's SurvivalFlight");
        ClientProxy.keyBindings[2] = new KeyBinding("Fly Slower", ModConfig.keys.FlySlower, "Zevac's SurvivalFlight");
        for (int i = 0; i < keyBindings.length; ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
        }
        KeyEventHandler keys = new KeyEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)keys);
        RenderGameOverlayEventhandler r = new RenderGameOverlayEventhandler();
        MinecraftForge.EVENT_BUS.register((Object)r);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setAllowFlight(boolean value) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = value;
            tmpAllowFlight = value;
            if (!player.field_71075_bZ.field_75101_c && player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            ModConfig.saveConfig();
        }
    }

    public static Float setFlightSpeed(Float value) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.field_71075_bZ.field_75098_d && (double)value.floatValue() <= Ref.MAX_FLY_SPEED && (double)value.floatValue() >= Ref.MIN_FLY_SPEED) {
            player.field_71075_bZ.func_75092_a(value.floatValue());
            tmpFlightSpeed = value;
            ModConfig.saveConfig();
            return value;
        }
        return Float.valueOf(player.field_71075_bZ.func_75093_a());
    }
}

