/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.CustomSkinLoader;
import customskinloader.utils.HttpRequestUtil;
import java.io.File;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.ThreadDownloadImageData;
import net.minecraft.util.ResourceLocation;

public class FakeThreadDownloadImageData {
    private static IThreadDownloadImageDataBuilder builder;

    public static SimpleTexture createThreadDownloadImageData(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocationIn, IImageBuffer imageBufferIn, MinecraftProfileTexture.Type textureTypeIn) {
        SimpleTexture texture = null;
        if (builder == null) {
            EnumMap<ThreadDownloadImageDataBuilder, Throwable> throwables = new EnumMap<ThreadDownloadImageDataBuilder, Throwable>(ThreadDownloadImageDataBuilder.class);
            for (ThreadDownloadImageDataBuilder builder : ThreadDownloadImageDataBuilder.values()) {
                try {
                    FakeThreadDownloadImageData.builder = builder.get().get();
                    texture = FakeThreadDownloadImageData.builder.build(cacheFileIn, imageUrlIn, textureResourceLocationIn, imageBufferIn, textureTypeIn);
                    CustomSkinLoader.logger.info("ThreadDownloadImageData Class: %s", texture.getClass().getName());
                    break;
                }
                catch (Throwable t) {
                    throwables.put(builder, t);
                }
            }
            if (texture == null) {
                CustomSkinLoader.logger.warning("Unable to get ThreadDownloadImageData Class: ");
                throwables.forEach((k, v) -> {
                    CustomSkinLoader.logger.warning("Caused by: (%s)", k.name());
                    CustomSkinLoader.logger.warning((Throwable)v);
                });
                throw new RuntimeException("Unable to get ThreadDownloadImageData Class!");
            }
        } else {
            texture = builder.build(cacheFileIn, imageUrlIn, textureResourceLocationIn, imageBufferIn, textureTypeIn);
        }
        return texture;
    }

    public static void downloadTexture(File cacheFile, String imageUrl) {
        HttpRequestUtil.HttpRequest request = new HttpRequestUtil.HttpRequest(imageUrl).setLoadContent(false).setCacheTime(0).setCacheFile(cacheFile);
        for (int i = 0; i <= CustomSkinLoader.config.retryTime; ++i) {
            if (i != 0) {
                CustomSkinLoader.logger.debug("Retry to download texture %s (%s)", imageUrl, i);
            }
            if (HttpRequestUtil.makeHttpRequest((HttpRequestUtil.HttpRequest)request).success) break;
        }
    }

    private static enum ThreadDownloadImageDataBuilder {
        V1(() -> new IThreadDownloadImageDataBuilder(){

            @Override
            public SimpleTexture build(File cacheFile, String imageUrl, ResourceLocation textureResourceLocation, IImageBuffer imageBuffer, MinecraftProfileTexture.Type textureType) {
                return new net.minecraft.client.renderer.ThreadDownloadImageData(cacheFile, imageUrl, textureResourceLocation, imageBuffer);
            }
        }),
        V2(() -> new IThreadDownloadImageDataBuilder(){

            @Override
            public SimpleTexture build(File cacheFile, String imageUrl, ResourceLocation textureResourceLocation, IImageBuffer imageBuffer, MinecraftProfileTexture.Type textureType) {
                return new ThreadDownloadImageData(cacheFile, imageUrl, textureResourceLocation, imageBuffer);
            }
        }),
        V3(() -> new IThreadDownloadImageDataBuilder(){

            @Override
            public SimpleTexture build(File cacheFile, String imageUrl, ResourceLocation textureResourceLocation, IImageBuffer imageBuffer, MinecraftProfileTexture.Type textureType) {
                return new DownloadingTexture(cacheFile, imageUrl, textureResourceLocation, imageBuffer);
            }
        }),
        V4(() -> new IThreadDownloadImageDataBuilder(){

            @Override
            public SimpleTexture build(File cacheFile, String imageUrl, ResourceLocation textureResourceLocation, IImageBuffer imageBuffer, MinecraftProfileTexture.Type textureType) {
                return new DownloadingTexture(cacheFile, imageUrl, textureResourceLocation, true, (Runnable)imageBuffer);
            }
        });

        private final Supplier<IThreadDownloadImageDataBuilder> builder;

        private ThreadDownloadImageDataBuilder(Supplier<IThreadDownloadImageDataBuilder> builder) {
            this.builder = builder;
        }

        public Supplier<IThreadDownloadImageDataBuilder> get() {
            return this.builder;
        }
    }

    private static interface IThreadDownloadImageDataBuilder {
        public SimpleTexture build(File var1, String var2, ResourceLocation var3, IImageBuffer var4, MinecraftProfileTexture.Type var5);
    }
}

