# flake8: noqa

"""
    Bonds API For Digital Portals

    Search for fixed income instruments, using a criteria-based screener. The API provides also fundamental data and key figures, basic interest rate information and derived coupon lists.  Available search criteria include:  * validation: filter for only active listings, by price quality and latest/previous available price dates * traded markets: filter and indicate a market priority for the validation * important dates in and features of the life cycle of the fixed income instruments * filter by issuer, its country of registration and the issued volume * coupon data: occurrence and frequency of coupon payments, current interest rate range * yield and yield to maturity range, spread * Macaulay duration * sensitivity ranges: base point value, modified duration, elasticity, convexity * cash flow for all transactions over a certain time range: sum or average * country-specific attributes: for Germany: is eligible for trustees        The key figures are calculated using delayed prices with an additional delay of 10 minutes after an update of the debt instrument's price. Special product features such as the right to a maturity extension, an attached option, or convertibility are not considered for the key figure calculation. Further, a calculation is not performed for perpetual products and for products with variable interest rate.  This API is fully integrated with the corresponding Quotes API, allowing access to detailed price and performance information of instruments, as well as basic security identifier cross-reference. For direct access to price histories, please refer to the Time Series API for Digital Portals.  Similar criteria based screener APIs exist for equity instruments and securitized derivatives: See the Stocks API and the Securitized Derivatives API for details.  # noqa: E501

    The version of the OpenAPI document: 2
    Generated by: https://openapi-generator.tech
"""


__version__ = "0.10.2"

# import ApiClient
from fds.sdk.BondsAPIforDigitalPortals.api_client import ApiClient

# import Configuration
from fds.sdk.BondsAPIforDigitalPortals.configuration import Configuration

# import exceptions
from fds.sdk.BondsAPIforDigitalPortals.exceptions import OpenApiException
from fds.sdk.BondsAPIforDigitalPortals.exceptions import ApiAttributeError
from fds.sdk.BondsAPIforDigitalPortals.exceptions import ApiTypeError
from fds.sdk.BondsAPIforDigitalPortals.exceptions import ApiValueError
from fds.sdk.BondsAPIforDigitalPortals.exceptions import ApiKeyError
from fds.sdk.BondsAPIforDigitalPortals.exceptions import ApiException
