# Generated by Django 2.1.13 on 2019-12-10 10:15

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Person",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                ("role", models.CharField(max_length=255)),
                (
                    "department",
                    models.CharField(
                        choices=[("department one", "Department One"), ("department two", "Department Two")],
                        max_length=255,
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("location one", "Location One"), ("location two", "Location Two")], max_length=255
                    ),
                ),
                (
                    "linkedin_url",
                    models.URLField(
                        help_text="Enter the full URL of the LinkedIn page",
                        validators=[
                            django.core.validators.URLValidator(
                                message="Please enter the full URL of the LinkedIn page",
                                regex="www.linkedin.com",
                                schemes=["https"],
                            )
                        ],
                    ),
                ),
                (
                    "image",
                    filer.fields.image.FilerImageField(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="person_image",
                        to=settings.FILER_IMAGE_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Tags",
            fields=[("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),],
        ),
        migrations.AddField(model_name="person", name="tags", field=models.ManyToManyField(to="people.Tags"),),
    ]
