# Generated by Django 1.11.20 on 2019-09-11 10:56

from django.db import connection, migrations, models


def alter_rel_date_column(apps, schema_editor):
    """
    Alters the 'rel_date' column in the 'edx_when_datepolicy' table to ensure
    it uses the correct data type for the database engine.

    For PostgreSQL, the column is converted to the 'interval' type using a cast.
    For MySQL, the column is modified to use the 'BIGINT' type.

    This function is necessary because Django's default handling of DurationField
    may not automatically align with the existing schema or database-specific
    requirements, especially when migrating legacy data.
    """
    db_engine = connection.settings_dict['ENGINE']
    with connection.cursor() as cursor:
        if 'postgres' in db_engine:
            cursor.execute(
                'ALTER TABLE edx_when_datepolicy '
                'ALTER COLUMN rel_date TYPE interval USING rel_date::interval;'
            )
        elif 'mysql' in db_engine:
            cursor.execute(
                'ALTER TABLE edx_when_datepolicy '
                'MODIFY rel_date BIGINT;'
            )


def reverse_alter_rel_date_column(apps, schema_editor):
    """
    Reverts the 'rel_date' column in the 'edx_when_datepolicy' table to its
    previous data type.

    For PostgreSQL, the column is converted back to 'varchar' using a cast.
    For MySQL, the column is modified to use the 'VARCHAR(255)' type.

    This function is necessary to ensure that the schema can be rolled back
    to its original state, maintaining compatibility with the previous data
    type and structure.
    """
    db_engine = connection.settings_dict['ENGINE']
    with connection.cursor() as cursor:
        if 'postgres' in db_engine:
            cursor.execute(
                'ALTER TABLE edx_when_datepolicy '
                'ALTER COLUMN rel_date TYPE varchar USING rel_date::varchar;'
            )
        elif 'mysql' in db_engine:
            cursor.execute(
                'ALTER TABLE edx_when_datepolicy '
                'MODIFY rel_date VARCHAR(255);'
            )


class Migration(migrations.Migration):
    dependencies = [
        ('edx_when', '0004_datepolicy_rel_date'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='datepolicy',
            name='abs_date'
        ),
        migrations.AddField(
            model_name='datepolicy',
            name='abs_date',
            field=models.DateTimeField(blank=True, db_index=True, null=True),
        ),
        migrations.RemoveField(
            model_name='datepolicy',
            name='rel_date'
        ),
        migrations.AddField(
            model_name='datepolicy',
            name='rel_date',
            field=models.DurationField(blank=True, db_index=True, null=True),
        ),
        migrations.RemoveField(
            model_name='userdate',
            name='rel_date'
        ),
        migrations.AddField(
            model_name='userdate',
            name='rel_date',
            field=models.DurationField(blank=True, db_index=True, null=True),
        ),
        migrations.RunPython(alter_rel_date_column, reverse_alter_rel_date_column),
    ]
