import abc
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from functools import cached_property as cached_property
from typing import Any, Callable, Literal

class UninterpretableNumberError(ValueError): ...

def dataclasss_backport(cls) -> Any: ...

class NumberSystemToken:
    word: str
    allowed_position: Literal['beginning', 'end', 'anywhere', 'anywhere-except-at-beginning', 'anywhere-except-at-end', 'anywhere-except-ends']
    is_unique: bool
    number: int | float | None
    is_usable_as_decimal: bool
    is_unit: bool
    is_usable_as_regular_denominator: bool
    irregular_denominator: str | None
    additional_validation: Callable[[int, list[NumberSystemToken]], bool] | None
    @cached_property
    def is_standalone(self) -> bool: ...
    @cached_property
    def is_fraction(self) -> bool: ...
    def as_fractional_tokens(self) -> list[NumberSystemToken]: ...

class NumberSystemVocabulary(ABC, metaclass=abc.ABCMeta):
    @cached_property
    @abstractmethod
    def tokens(self) -> dict[str, NumberSystemToken]: ...
    @cached_property
    @abstractmethod
    def negative_indicators(self) -> list[str]: ...
    @cached_property
    @abstractmethod
    def decimal_indicators(self) -> list[str]: ...
    @abstractmethod
    def is_valid_sequence(self, tokens: list[NumberSystemToken], allow_numerical_sequences: bool) -> bool: ...
    @cached_property
    @abstractmethod
    def language_code(self) -> str: ...

class AmericanNumberSystemVocabulary(NumberSystemVocabulary):
    @cached_property
    def language_code(self) -> str: ...
    @cached_property
    def negative_indicators(self) -> list[str]: ...
    @cached_property
    def decimal_indicators(self) -> list[str]: ...
    @cached_property
    def noop_words(self) -> list[str]: ...
    @cached_property
    def irregular_denominators(self) -> dict[str, str]: ...
    @cached_property
    def tokens(self) -> dict[str, NumberSystemToken]: ...
    def is_valid_sequence(self, tokens: list[NumberSystemToken], allow_numerical_sequences: bool = False) -> bool: ...

class NumberSystem:
    vocabulary: Incomplete
    allow_numerical_sequences: Incomplete
    def __init__(self, vocabulary: NumberSystemVocabulary = ..., allow_numerical_sequences: bool = False) -> None: ...
    def tokenize(self, string: str) -> list[NumberSystemToken]: ...
    def interpret(self, string: str) -> float: ...

def word2num(string: str, allow_numerical_sequences: bool = False) -> float: ...
