import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import * as ssm from 'aws-cdk-lib/aws-ssm';
/**
 * Exposed secret for log configuration
 */
export declare class ExposedSecret {
    /**
     * Use Secrets Manager Secret
     * @param optionName - The name of the option
     * @param secret - A secret from secrets manager
     */
    static fromSecretsManager(optionName: string, secret: secretsmanager.ISecret): ExposedSecret;
    /**
     * User Parameters Store Parameter
     * @param optionName - The name of the option
     * @param parameter - A parameter from parameters store
     */
    static fromParametersStore(optionName: string, parameter: ssm.IParameter): ExposedSecret;
    /**
     * Name of the option
     */
    optionName: string;
    /**
     * ARN of the secret option
     */
    secretArn: string;
    constructor(optionName: string, secretArn: string);
}
