"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvoke = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an AWS Lambda function as a target for AWS EventBridge Scheduler.
 */
class LambdaInvoke extends target_1.ScheduleTargetBase {
    constructor(func, props) {
        super(props, func.functionArn);
        this.func = func;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvoke);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.func.env.region, schedule.env.region)) {
            throw new Error(`Cannot assign function in region ${this.func.env.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the function must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.func.env.account, schedule.env.account)) {
            throw new Error(`Cannot assign function in account ${this.func.env.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the function must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.func.env.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.func.node)} in account ${this.func.env.account}. Both the target and the execution role must be in the same account.`);
        }
        this.func.grantInvoke(role);
    }
}
exports.LambdaInvoke = LambdaInvoke;
_a = JSII_RTTI_SYMBOL_1;
LambdaInvoke[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.LambdaInvoke", version: "2.113.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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