"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsPublish = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an Amazon SNS topic as a target for AWS EventBridge Scheduler.
 */
class SnsPublish extends target_1.ScheduleTargetBase {
    constructor(topic, props = {}) {
        super(props, topic.topicArn);
        this.topic = topic;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsPublish);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        // Check if target and schedule are in the region
        if (!(0, util_1.sameEnvDimension)(this.topic.env.region, schedule.env.region)) {
            throw new Error(`Cannot assign topic in region ${this.topic.env.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the topic must be in the same region.`);
        }
        // Check if target and schedule are in the same account
        if (!(0, util_1.sameEnvDimension)(this.topic.env.account, schedule.env.account)) {
            throw new Error(`Cannot assign topic in account ${this.topic.env.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${role.env.account}. Both the schedule and the topic must be in the same account.`);
        }
        // Check if target and role are in the same account
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.topic.env.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to publish to target ${aws_cdk_lib_1.Names.nodeUniqueId(this.topic.node)} in account ${this.topic.env.account}. Both the target and the execution role must be in the same account.`);
        }
        this.topic.grantPublish(role);
    }
}
exports.SnsPublish = SnsPublish;
_a = JSII_RTTI_SYMBOL_1;
SnsPublish[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SnsPublish", version: "2.113.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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