"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sameEnvDimension = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Whether two string probably contain the same environment dimension (region or account)
 *
 * Used to compare either accounts or regions, and also returns true if both
 * are unresolved (in which case both are expted to be "current region" or "current account").
 */
function sameEnvDimension(dim1, dim2) {
    return [aws_cdk_lib_1.TokenComparison.SAME, aws_cdk_lib_1.TokenComparison.BOTH_UNRESOLVED].includes(aws_cdk_lib_1.Token.compareStrings(dim1, dim2));
}
exports.sameEnvDimension = sameEnvDimension;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkNBQXFEO0FBRXJEOzs7OztHQUtHO0FBQ0gsU0FBZ0IsZ0JBQWdCLENBQUMsSUFBWSxFQUFFLElBQVk7SUFDekQsT0FBTyxDQUFDLDZCQUFlLENBQUMsSUFBSSxFQUFFLDZCQUFlLENBQUMsZUFBZSxDQUFDLENBQUMsUUFBUSxDQUFDLG1CQUFLLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFDO0FBQzVHLENBQUM7QUFGRCw0Q0FFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuLCBUb2tlbkNvbXBhcmlzb24gfSBmcm9tICdhd3MtY2RrLWxpYic7XG5cbi8qKlxuICogV2hldGhlciB0d28gc3RyaW5nIHByb2JhYmx5IGNvbnRhaW4gdGhlIHNhbWUgZW52aXJvbm1lbnQgZGltZW5zaW9uIChyZWdpb24gb3IgYWNjb3VudClcbiAqXG4gKiBVc2VkIHRvIGNvbXBhcmUgZWl0aGVyIGFjY291bnRzIG9yIHJlZ2lvbnMsIGFuZCBhbHNvIHJldHVybnMgdHJ1ZSBpZiBib3RoXG4gKiBhcmUgdW5yZXNvbHZlZCAoaW4gd2hpY2ggY2FzZSBib3RoIGFyZSBleHB0ZWQgdG8gYmUgXCJjdXJyZW50IHJlZ2lvblwiIG9yIFwiY3VycmVudCBhY2NvdW50XCIpLlxuICovXG5leHBvcnQgZnVuY3Rpb24gc2FtZUVudkRpbWVuc2lvbihkaW0xOiBzdHJpbmcsIGRpbTI6IHN0cmluZykge1xuICByZXR1cm4gW1Rva2VuQ29tcGFyaXNvbi5TQU1FLCBUb2tlbkNvbXBhcmlzb24uQk9USF9VTlJFU09MVkVEXS5pbmNsdWRlcyhUb2tlbi5jb21wYXJlU3RyaW5ncyhkaW0xLCBkaW0yKSk7XG59XG4iXX0=