"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Send an event to an AWS EventBridge by AWS EventBridge Scheduler.
 */
class EventBridgePutEvents extends target_1.ScheduleTargetBase {
    constructor(entry, props) {
        super(props, entry.eventBus.eventBusArn);
        this.entry = entry;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_EventBridgePutEventsEntry(entry);
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgePutEvents);
            }
            throw error;
        }
        if (this.props.input) {
            throw new Error('ScheduleTargetBaseProps.input is not supported for EventBridgePutEvents. Please use entry.detail instead.');
        }
    }
    addTargetActionToRole(schedule, role) {
        const eventBus = this.entry.eventBus;
        const eventBusEnv = eventBus.env;
        if (!(0, util_1.sameEnvDimension)(eventBusEnv.region, schedule.env.region)) {
            throw new Error(`Cannot assign eventBus in region ${eventBusEnv.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the eventBus must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(eventBusEnv.account, schedule.env.account)) {
            throw new Error(`Cannot assign eventBus in account ${eventBusEnv.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the eventBus must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, eventBusEnv.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(eventBus.node)} in account ${eventBusEnv.account}. Both the target and the execution role must be in the same account.`);
        }
        eventBus.grantPutEventsTo(role);
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            input: this.entry.detail,
            eventBridgeParameters: {
                detailType: this.entry.detailType,
                source: this.entry.source,
            },
        };
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.EventBridgePutEvents", version: "2.113.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnQtYnJpZGdlLXB1dC1ldmVudHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJldmVudC1icmlkZ2UtcHV0LWV2ZW50cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSw2Q0FBb0M7QUFHcEMscUNBQXVFO0FBQ3ZFLGlDQUEwQztBQTJDMUM7O0dBRUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLDJCQUFrQjtJQUMxRCxZQUNtQixLQUFnQyxFQUNoQyxLQUE4QjtRQUUvQyxLQUFLLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7UUFIeEIsVUFBSyxHQUFMLEtBQUssQ0FBMkI7UUFDaEMsVUFBSyxHQUFMLEtBQUssQ0FBeUI7Ozs7Ozs7K0NBSHRDLG9CQUFvQjs7OztRQU03QixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFO1lBQ3BCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkdBQTJHLENBQUMsQ0FBQztTQUM5SDtLQUNGO0lBRVMscUJBQXFCLENBQUMsUUFBbUIsRUFBRSxJQUFXO1FBQzlELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQ3JDLE1BQU0sV0FBVyxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDakMsSUFBSSxDQUFDLElBQUEsdUJBQWdCLEVBQUMsV0FBVyxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQzlELE1BQU0sSUFBSSxLQUFLLENBQUMsb0NBQW9DLFdBQVcsQ0FBQyxNQUFNLG9CQUFvQixtQkFBSyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxNQUFNLGtFQUFrRSxDQUFDLENBQUM7U0FDak87UUFFRCxJQUFJLENBQUMsSUFBQSx1QkFBZ0IsRUFBQyxXQUFXLENBQUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLEVBQUU7WUFDaEUsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQ0FBcUMsV0FBVyxDQUFDLE9BQU8sb0JBQW9CLG1CQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsZUFBZSxRQUFRLENBQUMsR0FBRyxDQUFDLE1BQU0sbUVBQW1FLENBQUMsQ0FBQztTQUNyTztRQUVELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFBLHVCQUFnQixFQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsV0FBVyxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQzFGLE1BQU0sSUFBSSxLQUFLLENBQUMsd0RBQXdELElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLHFCQUFxQixtQkFBSyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGVBQWUsV0FBVyxDQUFDLE9BQU8sdUVBQXVFLENBQUMsQ0FBQztTQUNyUTtRQUVELFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUNqQztJQUVTLG9CQUFvQixDQUFDLFNBQW9CO1FBQ2pELE9BQU87WUFDTCxHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUM7WUFDeEMsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTTtZQUN4QixxQkFBcUIsRUFBRTtnQkFDckIsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtnQkFDakMsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTTthQUMxQjtTQUNGLENBQUM7S0FDSDs7QUF0Q0gsb0RBdUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVNjaGVkdWxlVGFyZ2V0LCBJU2NoZWR1bGUsIFNjaGVkdWxlVGFyZ2V0SW5wdXQsIFNjaGVkdWxlVGFyZ2V0Q29uZmlnIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNjaGVkdWxlci1hbHBoYSc7XG5pbXBvcnQgeyBOYW1lcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGV2ZW50cyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZXZlbnRzJztcbmltcG9ydCB7IElSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBTY2hlZHVsZVRhcmdldEJhc2UsIFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi90YXJnZXQnO1xuaW1wb3J0IHsgc2FtZUVudkRpbWVuc2lvbiB9IGZyb20gJy4vdXRpbCc7XG5cbi8qKlxuICogQW4gZW50cnkgdG8gYmUgc2VudCB0byBFdmVudEJyaWRnZVxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2ZW50YnJpZGdlL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1B1dEV2ZW50c1JlcXVlc3RFbnRyeS5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRXZlbnRCcmlkZ2VQdXRFdmVudHNFbnRyeSB7XG4gIC8qKlxuICAgKiBUaGUgZXZlbnQgYm9keVxuICAgKlxuICAgKiBDYW4gZWl0aGVyIGJlIHByb3ZpZGVkIGFzIGFuIG9iamVjdCBvciBhcyBhIEpTT04tc2VyaWFsaXplZCBzdHJpbmdcbiAgICogQGV4YW1wbGVcbiAgICpcbiAgICogU2NoZWR1bGVUYXJnZXRJbnB1dC5mcm9tVGV4dCgne1wiaW5zdGFuY2UtaWRcIjogXCJpLTEyMzQ1Njc4OTBhYmNkZWYwXCIsIFwic3RhdGVcIjogXCJ0ZXJtaW5hdGVkXCJ9Jyk7XG4gICAqIFNjaGVkdWxlVGFyZ2V0SW5wdXQuZnJvbU9iamVjdCh7IE1lc3NhZ2U6ICdIZWxsbyBmcm9tIGEgZnJpZW5kbHkgZXZlbnQgOiknIH0pO1xuICAgKi9cbiAgcmVhZG9ubHkgZGV0YWlsOiBTY2hlZHVsZVRhcmdldElucHV0O1xuXG4gIC8qKlxuICAgKiBVc2VkIGFsb25nIHdpdGggdGhlIHNvdXJjZSBmaWVsZCB0byBoZWxwIGlkZW50aWZ5IHRoZSBmaWVsZHMgYW5kIHZhbHVlcyBleHBlY3RlZCBpbiB0aGUgZGV0YWlsIGZpZWxkXG4gICAqXG4gICAqIEZvciBleGFtcGxlLCBldmVudHMgYnkgQ2xvdWRUcmFpbCBoYXZlIGRldGFpbCB0eXBlIFwiQVdTIEFQSSBDYWxsIHZpYSBDbG91ZFRyYWlsXCJcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZXZlbnRicmlkZ2UvbGF0ZXN0L3VzZXJndWlkZS9lYi1ldmVudHMuaHRtbFxuICAgKi9cbiAgcmVhZG9ubHkgZGV0YWlsVHlwZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZXZlbnQgYnVzIHRoZSBlbnRyeSB3aWxsIGJlIHNlbnQgdG8uXG4gICAqXG4gICAqL1xuICByZWFkb25seSBldmVudEJ1czogZXZlbnRzLklFdmVudEJ1cztcblxuICAvKipcbiAgICogVGhlIHNlcnZpY2Ugb3IgYXBwbGljYXRpb24gdGhhdCBjYXVzZWQgdGhpcyBldmVudCB0byBiZSBnZW5lcmF0ZWRcbiAgICpcbiAgICogRXhhbXBsZSB2YWx1ZTogYGNvbS5leGFtcGxlLnNlcnZpY2VgXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2V2ZW50YnJpZGdlL2xhdGVzdC91c2VyZ3VpZGUvZWItZXZlbnRzLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IHNvdXJjZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFNlbmQgYW4gZXZlbnQgdG8gYW4gQVdTIEV2ZW50QnJpZGdlIGJ5IEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBFdmVudEJyaWRnZVB1dEV2ZW50cyBleHRlbmRzIFNjaGVkdWxlVGFyZ2V0QmFzZSBpbXBsZW1lbnRzIElTY2hlZHVsZVRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgZW50cnk6IEV2ZW50QnJpZGdlUHV0RXZlbnRzRW50cnksXG4gICAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHByb3BzLCBlbnRyeS5ldmVudEJ1cy5ldmVudEJ1c0Fybik7XG4gICAgaWYgKHRoaXMucHJvcHMuaW5wdXQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMuaW5wdXQgaXMgbm90IHN1cHBvcnRlZCBmb3IgRXZlbnRCcmlkZ2VQdXRFdmVudHMuIFBsZWFzZSB1c2UgZW50cnkuZGV0YWlsIGluc3RlYWQuJyk7XG4gICAgfVxuICB9XG5cbiAgcHJvdGVjdGVkIGFkZFRhcmdldEFjdGlvblRvUm9sZShzY2hlZHVsZTogSVNjaGVkdWxlLCByb2xlOiBJUm9sZSk6IHZvaWQge1xuICAgIGNvbnN0IGV2ZW50QnVzID0gdGhpcy5lbnRyeS5ldmVudEJ1cztcbiAgICBjb25zdCBldmVudEJ1c0VudiA9IGV2ZW50QnVzLmVudjtcbiAgICBpZiAoIXNhbWVFbnZEaW1lbnNpb24oZXZlbnRCdXNFbnYucmVnaW9uLCBzY2hlZHVsZS5lbnYucmVnaW9uKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBDYW5ub3QgYXNzaWduIGV2ZW50QnVzIGluIHJlZ2lvbiAke2V2ZW50QnVzRW52LnJlZ2lvbn0gdG8gdGhlIHNjaGVkdWxlICR7TmFtZXMubm9kZVVuaXF1ZUlkKHNjaGVkdWxlLm5vZGUpfSBpbiByZWdpb24gJHtzY2hlZHVsZS5lbnYucmVnaW9ufS4gQm90aCB0aGUgc2NoZWR1bGUgYW5kIHRoZSBldmVudEJ1cyBtdXN0IGJlIGluIHRoZSBzYW1lIHJlZ2lvbi5gKTtcbiAgICB9XG5cbiAgICBpZiAoIXNhbWVFbnZEaW1lbnNpb24oZXZlbnRCdXNFbnYuYWNjb3VudCwgc2NoZWR1bGUuZW52LmFjY291bnQpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCBhc3NpZ24gZXZlbnRCdXMgaW4gYWNjb3VudCAke2V2ZW50QnVzRW52LmFjY291bnR9IHRvIHRoZSBzY2hlZHVsZSAke05hbWVzLm5vZGVVbmlxdWVJZChzY2hlZHVsZS5ub2RlKX0gaW4gYWNjb3VudCAke3NjaGVkdWxlLmVudi5yZWdpb259LiBCb3RoIHRoZSBzY2hlZHVsZSBhbmQgdGhlIGV2ZW50QnVzIG11c3QgYmUgaW4gdGhlIHNhbWUgYWNjb3VudC5gKTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5wcm9wcy5yb2xlICYmICFzYW1lRW52RGltZW5zaW9uKHRoaXMucHJvcHMucm9sZS5lbnYuYWNjb3VudCwgZXZlbnRCdXNFbnYuYWNjb3VudCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGdyYW50IHBlcm1pc3Npb24gdG8gZXhlY3V0aW9uIHJvbGUgaW4gYWNjb3VudCAke3RoaXMucHJvcHMucm9sZS5lbnYuYWNjb3VudH0gdG8gaW52b2tlIHRhcmdldCAke05hbWVzLm5vZGVVbmlxdWVJZChldmVudEJ1cy5ub2RlKX0gaW4gYWNjb3VudCAke2V2ZW50QnVzRW52LmFjY291bnR9LiBCb3RoIHRoZSB0YXJnZXQgYW5kIHRoZSBleGVjdXRpb24gcm9sZSBtdXN0IGJlIGluIHRoZSBzYW1lIGFjY291bnQuYCk7XG4gICAgfVxuXG4gICAgZXZlbnRCdXMuZ3JhbnRQdXRFdmVudHNUbyhyb2xlKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBiaW5kQmFzZVRhcmdldENvbmZpZyhfc2NoZWR1bGU6IElTY2hlZHVsZSk6IFNjaGVkdWxlVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4uc3VwZXIuYmluZEJhc2VUYXJnZXRDb25maWcoX3NjaGVkdWxlKSxcbiAgICAgIGlucHV0OiB0aGlzLmVudHJ5LmRldGFpbCxcbiAgICAgIGV2ZW50QnJpZGdlUGFyYW1ldGVyczoge1xuICAgICAgICBkZXRhaWxUeXBlOiB0aGlzLmVudHJ5LmRldGFpbFR5cGUsXG4gICAgICAgIHNvdXJjZTogdGhpcy5lbnRyeS5zb3VyY2UsXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==