# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class AddUserToOrganizationalUnitsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The organization IDs. You can add an account to a maximum of 100 organizations.
        # 
        # This parameter is required.
        self.organizational_unit_ids = organizational_unit_ids
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class AddUserToOrganizationalUnitsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUserToOrganizationalUnitsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUserToOrganizationalUnitsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUserToOrganizationalUnitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUsersToGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instance_id: str = None,
        user_ids: List[str] = None,
    ):
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The account IDs.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class AddUsersToGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUsersToGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUsersToGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUsersToGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeApplicationToGroupsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        group_ids: List[str] = None,
        instance_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The group IDs. You can specify up to 100 group IDs at a time.
        # 
        # This parameter is required.
        self.group_ids = group_ids
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class AuthorizeApplicationToGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeApplicationToGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AuthorizeApplicationToGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeApplicationToGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeApplicationToOrganizationalUnitsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
    ):
        # The ID of the application on which you want to grant permissions.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of the organizations to which you want to grant permissions. You can grant permissions to a maximum of 100 organizations at a time.
        # 
        # This parameter is required.
        self.organizational_unit_ids = organizational_unit_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        return self


class AuthorizeApplicationToOrganizationalUnitsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeApplicationToOrganizationalUnitsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AuthorizeApplicationToOrganizationalUnitsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeApplicationToOrganizationalUnitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeApplicationToUsersRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        user_ids: List[str] = None,
    ):
        # The ID of the application on which you want to grant permissions.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of the accounts to which you want to grant permissions. You can grant permissions to a maximum of 100 accounts at a time.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class AuthorizeApplicationToUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeApplicationToUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AuthorizeApplicationToUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeApplicationToUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationRequest(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        application_source_type: str = None,
        application_template_id: str = None,
        description: str = None,
        instance_id: str = None,
        logo_url: str = None,
        sso_type: str = None,
    ):
        # The name of the application.
        # 
        # This parameter is required.
        self.application_name = application_name
        # The type of the application source. Valid values:
        # 
        # *   urn:alibaba:idaas:app:source:template: application template
        # *   urn:alibaba:idaas:app:source:standard: standard protocol
        # 
        # This parameter is required.
        self.application_source_type = application_source_type
        # The ID of the application template. This parameter is required if you set the ApplicationSourceType parameter to urn:alibaba:idaas:app:source:template.
        self.application_template_id = application_template_id
        # The description of the application.
        self.description = description
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The URL of the application logo.
        self.logo_url = logo_url
        # The SSO protocol. Valid values:
        # 
        # *   saml2: the SAML 2.0 protocol.
        # *   oidc: the OpenID Connect protocol.
        # 
        # This parameter is required.
        self.sso_type = sso_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_source_type is not None:
            result['ApplicationSourceType'] = self.application_source_type
        if self.application_template_id is not None:
            result['ApplicationTemplateId'] = self.application_template_id
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.sso_type is not None:
            result['SsoType'] = self.sso_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSourceType') is not None:
            self.application_source_type = m.get('ApplicationSourceType')
        if m.get('ApplicationTemplateId') is not None:
            self.application_template_id = m.get('ApplicationTemplateId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('SsoType') is not None:
            self.sso_type = m.get('SsoType')
        return self


class CreateApplicationResponseBody(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        request_id: str = None,
    ):
        # The ID of the application.
        self.application_id = application_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationClientSecretRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application for which you want to create a client key.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateApplicationClientSecretResponseBodyApplicationClientSecret(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_secret: str = None,
        secret_id: str = None,
    ):
        # The client ID of the application.
        self.client_id = client_id
        # The client key secret of the application.
        self.client_secret = client_secret
        # The client key ID of the application.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class CreateApplicationClientSecretResponseBody(TeaModel):
    def __init__(
        self,
        application_client_secret: CreateApplicationClientSecretResponseBodyApplicationClientSecret = None,
        request_id: str = None,
    ):
        # The information about the client key.
        self.application_client_secret = application_client_secret
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application_client_secret:
            self.application_client_secret.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_client_secret is not None:
            result['ApplicationClientSecret'] = self.application_client_secret.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationClientSecret') is not None:
            temp_model = CreateApplicationClientSecretResponseBodyApplicationClientSecret()
            self.application_client_secret = temp_model.from_map(m['ApplicationClientSecret'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateApplicationClientSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationClientSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationClientSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConditionalAccessPolicyRequestConditionsConfigApplications(TeaModel):
    def __init__(
        self,
        exclude_applications: List[str] = None,
        include_applications: List[str] = None,
    ):
        # Excluded applications
        self.exclude_applications = exclude_applications
        # Included applications
        self.include_applications = include_applications

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_applications is not None:
            result['ExcludeApplications'] = self.exclude_applications
        if self.include_applications is not None:
            result['IncludeApplications'] = self.include_applications
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeApplications') is not None:
            self.exclude_applications = m.get('ExcludeApplications')
        if m.get('IncludeApplications') is not None:
            self.include_applications = m.get('IncludeApplications')
        return self


class CreateConditionalAccessPolicyRequestConditionsConfigNetworkZones(TeaModel):
    def __init__(
        self,
        exclude_network_zones: List[str] = None,
        include_network_zones: List[str] = None,
    ):
        # Excluded network zones
        self.exclude_network_zones = exclude_network_zones
        # Included network zones
        self.include_network_zones = include_network_zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_network_zones is not None:
            result['ExcludeNetworkZones'] = self.exclude_network_zones
        if self.include_network_zones is not None:
            result['IncludeNetworkZones'] = self.include_network_zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeNetworkZones') is not None:
            self.exclude_network_zones = m.get('ExcludeNetworkZones')
        if m.get('IncludeNetworkZones') is not None:
            self.include_network_zones = m.get('IncludeNetworkZones')
        return self


class CreateConditionalAccessPolicyRequestConditionsConfigUsers(TeaModel):
    def __init__(
        self,
        exclude_groups: List[str] = None,
        exclude_organizational_units: List[str] = None,
        exclude_users: List[str] = None,
        include_groups: List[str] = None,
        include_organizational_units: List[str] = None,
        include_users: List[str] = None,
    ):
        # Excluded user groups
        self.exclude_groups = exclude_groups
        # Excluded organizations
        self.exclude_organizational_units = exclude_organizational_units
        # Excluded users
        self.exclude_users = exclude_users
        # Included user groups
        self.include_groups = include_groups
        # Included organizations
        self.include_organizational_units = include_organizational_units
        # Selected user
        self.include_users = include_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_groups is not None:
            result['ExcludeGroups'] = self.exclude_groups
        if self.exclude_organizational_units is not None:
            result['ExcludeOrganizationalUnits'] = self.exclude_organizational_units
        if self.exclude_users is not None:
            result['ExcludeUsers'] = self.exclude_users
        if self.include_groups is not None:
            result['IncludeGroups'] = self.include_groups
        if self.include_organizational_units is not None:
            result['IncludeOrganizationalUnits'] = self.include_organizational_units
        if self.include_users is not None:
            result['IncludeUsers'] = self.include_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeGroups') is not None:
            self.exclude_groups = m.get('ExcludeGroups')
        if m.get('ExcludeOrganizationalUnits') is not None:
            self.exclude_organizational_units = m.get('ExcludeOrganizationalUnits')
        if m.get('ExcludeUsers') is not None:
            self.exclude_users = m.get('ExcludeUsers')
        if m.get('IncludeGroups') is not None:
            self.include_groups = m.get('IncludeGroups')
        if m.get('IncludeOrganizationalUnits') is not None:
            self.include_organizational_units = m.get('IncludeOrganizationalUnits')
        if m.get('IncludeUsers') is not None:
            self.include_users = m.get('IncludeUsers')
        return self


class CreateConditionalAccessPolicyRequestConditionsConfig(TeaModel):
    def __init__(
        self,
        applications: CreateConditionalAccessPolicyRequestConditionsConfigApplications = None,
        network_zones: CreateConditionalAccessPolicyRequestConditionsConfigNetworkZones = None,
        users: CreateConditionalAccessPolicyRequestConditionsConfigUsers = None,
    ):
        # Target applications for the conditional access policy
        self.applications = applications
        # Network zones for conditional access policy
        self.network_zones = network_zones
        # Target users of the conditional access policy
        self.users = users

    def validate(self):
        if self.applications:
            self.applications.validate()
        if self.network_zones:
            self.network_zones.validate()
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applications is not None:
            result['Applications'] = self.applications.to_map()
        if self.network_zones is not None:
            result['NetworkZones'] = self.network_zones.to_map()
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applications') is not None:
            temp_model = CreateConditionalAccessPolicyRequestConditionsConfigApplications()
            self.applications = temp_model.from_map(m['Applications'])
        if m.get('NetworkZones') is not None:
            temp_model = CreateConditionalAccessPolicyRequestConditionsConfigNetworkZones()
            self.network_zones = temp_model.from_map(m['NetworkZones'])
        if m.get('Users') is not None:
            temp_model = CreateConditionalAccessPolicyRequestConditionsConfigUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class CreateConditionalAccessPolicyRequestDecisionConfig(TeaModel):
    def __init__(
        self,
        active_session_reuse_status: str = None,
        effect: str = None,
        mfa_authentication_interval_seconds: int = None,
        mfa_authentication_methods: List[str] = None,
        mfa_type: str = None,
    ):
        # Whether to enable session reuse
        self.active_session_reuse_status = active_session_reuse_status
        # Decision action for the conditional access policy, with the following options:
        # 
        # - allow: Allow.
        # - deny: Deny.
        self.effect = effect
        # Re-authentication interval (in seconds) for the conditional access policy
        # 
        # - Maximum MFA re-authentication interval: 86400
        # - Minimum MFA re-authentication interval: 300
        self.mfa_authentication_interval_seconds = mfa_authentication_interval_seconds
        # Allowed MFA types for the conditional access policy, with the following options:
        # - ia_otp_sms: SMS verification code
        # - ia_otp_email: Email verification code
        # - ia_totp: OTP dynamic password
        # - ia_webauthn: WebAuthn
        self.mfa_authentication_methods = mfa_authentication_methods
        # MFA type for the conditional access policy, with the following options:
        # 
        # - directly_access: Direct access
        # - mfa_required: MFA required
        self.mfa_type = mfa_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_reuse_status is not None:
            result['ActiveSessionReuseStatus'] = self.active_session_reuse_status
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.mfa_authentication_interval_seconds is not None:
            result['MfaAuthenticationIntervalSeconds'] = self.mfa_authentication_interval_seconds
        if self.mfa_authentication_methods is not None:
            result['MfaAuthenticationMethods'] = self.mfa_authentication_methods
        if self.mfa_type is not None:
            result['MfaType'] = self.mfa_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionReuseStatus') is not None:
            self.active_session_reuse_status = m.get('ActiveSessionReuseStatus')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('MfaAuthenticationIntervalSeconds') is not None:
            self.mfa_authentication_interval_seconds = m.get('MfaAuthenticationIntervalSeconds')
        if m.get('MfaAuthenticationMethods') is not None:
            self.mfa_authentication_methods = m.get('MfaAuthenticationMethods')
        if m.get('MfaType') is not None:
            self.mfa_type = m.get('MfaType')
        return self


class CreateConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        conditional_access_policy_name: str = None,
        conditional_access_policy_type: str = None,
        conditions_config: CreateConditionalAccessPolicyRequestConditionsConfig = None,
        decision_config: CreateConditionalAccessPolicyRequestDecisionConfig = None,
        decision_type: str = None,
        description: str = None,
        evaluate_at: str = None,
        instance_id: str = None,
        priority: int = None,
    ):
        # Idempotent token.
        self.client_token = client_token
        # Conditional access policy name
        # 
        # This parameter is required.
        self.conditional_access_policy_name = conditional_access_policy_name
        # Type of the conditional access policy, with the following options:
        # 
        # arn:alibaba:idaas:authn:access:policy:system: System policy.
        # 
        # This parameter is required.
        self.conditional_access_policy_type = conditional_access_policy_type
        # Condition content configuration for the conditional access policy
        self.conditions_config = conditions_config
        # Action configuration for the conditional access policy
        self.decision_config = decision_config
        # Execution type of the conditional access policy, with the following options:
        # 
        # enforcement: Enforce the policy.
        # 
        # This parameter is required.
        self.decision_type = decision_type
        # Description of the conditional access policy
        self.description = description
        # Execution point of the conditional access policy, with the following options:
        # 
        # - arn:alibaba:idaas:authn:access:rule:eval_at:after_step1: Allow.
        # 
        # This parameter is required.
        self.evaluate_at = evaluate_at
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Priority of the conditional access policy, lower values indicate higher priority
        # Minimum value: 1
        # Maximum value: 100
        self.priority = priority

    def validate(self):
        if self.conditions_config:
            self.conditions_config.validate()
        if self.decision_config:
            self.decision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.conditional_access_policy_name is not None:
            result['ConditionalAccessPolicyName'] = self.conditional_access_policy_name
        if self.conditional_access_policy_type is not None:
            result['ConditionalAccessPolicyType'] = self.conditional_access_policy_type
        if self.conditions_config is not None:
            result['ConditionsConfig'] = self.conditions_config.to_map()
        if self.decision_config is not None:
            result['DecisionConfig'] = self.decision_config.to_map()
        if self.decision_type is not None:
            result['DecisionType'] = self.decision_type
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluate_at is not None:
            result['EvaluateAt'] = self.evaluate_at
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConditionalAccessPolicyName') is not None:
            self.conditional_access_policy_name = m.get('ConditionalAccessPolicyName')
        if m.get('ConditionalAccessPolicyType') is not None:
            self.conditional_access_policy_type = m.get('ConditionalAccessPolicyType')
        if m.get('ConditionsConfig') is not None:
            temp_model = CreateConditionalAccessPolicyRequestConditionsConfig()
            self.conditions_config = temp_model.from_map(m['ConditionsConfig'])
        if m.get('DecisionConfig') is not None:
            temp_model = CreateConditionalAccessPolicyRequestDecisionConfig()
            self.decision_config = temp_model.from_map(m['DecisionConfig'])
        if m.get('DecisionType') is not None:
            self.decision_type = m.get('DecisionType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluateAt') is not None:
            self.evaluate_at = m.get('EvaluateAt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class CreateConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        request_id: str = None,
    ):
        # Conditional Access Policy ID
        self.conditional_access_policy_id = conditional_access_policy_id
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDomainRequestFiling(TeaModel):
    def __init__(
        self,
        icp_number: str = None,
    ):
        # 域名关联的备案号，长度最大限制64。
        self.icp_number = icp_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icp_number is not None:
            result['IcpNumber'] = self.icp_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IcpNumber') is not None:
            self.icp_number = m.get('IcpNumber')
        return self


class CreateDomainRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        filing: CreateDomainRequestFiling = None,
        instance_id: str = None,
    ):
        # 域名。最大长度限制255，格式由数字、字母、横线（-）点（.）组成;
        # 
        # This parameter is required.
        self.domain = domain
        # 备案信息参数。
        self.filing = filing
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        if self.filing:
            self.filing.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.filing is not None:
            result['Filing'] = self.filing.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Filing') is not None:
            temp_model = CreateDomainRequestFiling()
            self.filing = temp_model.from_map(m['Filing'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDomainResponseBody(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        request_id: str = None,
    ):
        self.domain_id = domain_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDomainProxyTokenRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDomainProxyTokenResponseBody(TeaModel):
    def __init__(
        self,
        domain_proxy_token_id: str = None,
        request_id: str = None,
    ):
        self.domain_proxy_token_id = domain_proxy_token_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDomainProxyTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDomainProxyTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDomainProxyTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        group_external_id: str = None,
        group_name: str = None,
        instance_id: str = None,
    ):
        # The description of the group. The value can be up to 256 characters in length.
        self.description = description
        # The external ID of the group, which can be used to associate the group with an external system. By default, the external ID is the group ID. The value can be up to 64 characters in length.
        self.group_external_id = group_external_id
        # The name of the group. The name can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.group_name = group_name
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.group_external_id is not None:
            result['GroupExternalId'] = self.group_external_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupExternalId') is not None:
            self.group_external_id = m.get('GroupExternalId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        # The group ID.
        self.group_id = group_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIdentityProviderRequestAuthnConfig(TeaModel):
    def __init__(
        self,
        authn_status: str = None,
        auto_update_password_status: str = None,
    ):
        # 对应IdP是否支持认证
        # 
        # This parameter is required.
        self.authn_status = authn_status
        # 是否支持自动更新密码
        self.auto_update_password_status = auto_update_password_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_status is not None:
            result['AuthnStatus'] = self.authn_status
        if self.auto_update_password_status is not None:
            result['AutoUpdatePasswordStatus'] = self.auto_update_password_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnStatus') is not None:
            self.authn_status = m.get('AuthnStatus')
        if m.get('AutoUpdatePasswordStatus') is not None:
            self.auto_update_password_status = m.get('AutoUpdatePasswordStatus')
        return self


class CreateIdentityProviderRequestAutoCreateUserConfig(TeaModel):
    def __init__(
        self,
        auto_create_user_status: str = None,
        target_organizational_unit_ids: List[str] = None,
    ):
        # 自动创建账户是否开启
        self.auto_create_user_status = auto_create_user_status
        self.target_organizational_unit_ids = target_organizational_unit_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_create_user_status is not None:
            result['AutoCreateUserStatus'] = self.auto_create_user_status
        if self.target_organizational_unit_ids is not None:
            result['TargetOrganizationalUnitIds'] = self.target_organizational_unit_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoCreateUserStatus') is not None:
            self.auto_create_user_status = m.get('AutoCreateUserStatus')
        if m.get('TargetOrganizationalUnitIds') is not None:
            self.target_organizational_unit_ids = m.get('TargetOrganizationalUnitIds')
        return self


class CreateIdentityProviderRequestAutoUpdateUserConfig(TeaModel):
    def __init__(
        self,
        auto_update_user_status: str = None,
    ):
        # 自动更新账户是否开启
        self.auto_update_user_status = auto_update_user_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_update_user_status is not None:
            result['AutoUpdateUserStatus'] = self.auto_update_user_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoUpdateUserStatus') is not None:
            self.auto_update_user_status = m.get('AutoUpdateUserStatus')
        return self


class CreateIdentityProviderRequestBindingConfigAutoMatchUserProfileExpressions(TeaModel):
    def __init__(
        self,
        expression_mapping_type: str = None,
        source_value_expression: str = None,
        target_field: str = None,
        target_field_description: str = None,
    ):
        # 表达式的类型
        # 
        # This parameter is required.
        self.expression_mapping_type = expression_mapping_type
        # 映射属性取值表达式
        # 
        # This parameter is required.
        self.source_value_expression = source_value_expression
        # 映射目标属性名称
        # 
        # This parameter is required.
        self.target_field = target_field
        # 映射目标属性名称
        self.target_field_description = target_field_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression_mapping_type is not None:
            result['ExpressionMappingType'] = self.expression_mapping_type
        if self.source_value_expression is not None:
            result['SourceValueExpression'] = self.source_value_expression
        if self.target_field is not None:
            result['TargetField'] = self.target_field
        if self.target_field_description is not None:
            result['TargetFieldDescription'] = self.target_field_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpressionMappingType') is not None:
            self.expression_mapping_type = m.get('ExpressionMappingType')
        if m.get('SourceValueExpression') is not None:
            self.source_value_expression = m.get('SourceValueExpression')
        if m.get('TargetField') is not None:
            self.target_field = m.get('TargetField')
        if m.get('TargetFieldDescription') is not None:
            self.target_field_description = m.get('TargetFieldDescription')
        return self


class CreateIdentityProviderRequestBindingConfig(TeaModel):
    def __init__(
        self,
        auto_match_user_profile_expressions: List[CreateIdentityProviderRequestBindingConfigAutoMatchUserProfileExpressions] = None,
        auto_match_user_status: str = None,
        mapping_binding_status: str = None,
    ):
        # 自动匹配账户的规则
        self.auto_match_user_profile_expressions = auto_match_user_profile_expressions
        # 自动匹配账户是否开启
        self.auto_match_user_status = auto_match_user_status
        # 用户手动绑定账户功能是否开启
        self.mapping_binding_status = mapping_binding_status

    def validate(self):
        if self.auto_match_user_profile_expressions:
            for k in self.auto_match_user_profile_expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoMatchUserProfileExpressions'] = []
        if self.auto_match_user_profile_expressions is not None:
            for k in self.auto_match_user_profile_expressions:
                result['AutoMatchUserProfileExpressions'].append(k.to_map() if k else None)
        if self.auto_match_user_status is not None:
            result['AutoMatchUserStatus'] = self.auto_match_user_status
        if self.mapping_binding_status is not None:
            result['MappingBindingStatus'] = self.mapping_binding_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_match_user_profile_expressions = []
        if m.get('AutoMatchUserProfileExpressions') is not None:
            for k in m.get('AutoMatchUserProfileExpressions'):
                temp_model = CreateIdentityProviderRequestBindingConfigAutoMatchUserProfileExpressions()
                self.auto_match_user_profile_expressions.append(temp_model.from_map(k))
        if m.get('AutoMatchUserStatus') is not None:
            self.auto_match_user_status = m.get('AutoMatchUserStatus')
        if m.get('MappingBindingStatus') is not None:
            self.mapping_binding_status = m.get('MappingBindingStatus')
        return self


class CreateIdentityProviderRequestDingtalkAppConfig(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        app_secret: str = None,
        corp_id: str = None,
        dingtalk_version: str = None,
    ):
        # 钉钉一方应用的AppKey
        self.app_key = app_key
        # 钉钉一方应用的AppSecret
        self.app_secret = app_secret
        # 钉钉一方应用的corpId
        self.corp_id = corp_id
        # 钉钉版本
        self.dingtalk_version = dingtalk_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.dingtalk_version is not None:
            result['DingtalkVersion'] = self.dingtalk_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DingtalkVersion') is not None:
            self.dingtalk_version = m.get('DingtalkVersion')
        return self


class CreateIdentityProviderRequestLarkConfig(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_secret: str = None,
        encrypt_key: str = None,
        enterprise_number: str = None,
        verification_token: str = None,
    ):
        self.app_id = app_id
        self.app_secret = app_secret
        self.encrypt_key = encrypt_key
        self.enterprise_number = enterprise_number
        self.verification_token = verification_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.encrypt_key is not None:
            result['EncryptKey'] = self.encrypt_key
        if self.enterprise_number is not None:
            result['EnterpriseNumber'] = self.enterprise_number
        if self.verification_token is not None:
            result['VerificationToken'] = self.verification_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('EncryptKey') is not None:
            self.encrypt_key = m.get('EncryptKey')
        if m.get('EnterpriseNumber') is not None:
            self.enterprise_number = m.get('EnterpriseNumber')
        if m.get('VerificationToken') is not None:
            self.verification_token = m.get('VerificationToken')
        return self


class CreateIdentityProviderRequestLdapConfig(TeaModel):
    def __init__(
        self,
        administrator_password: str = None,
        administrator_username: str = None,
        certificate_fingerprint_status: str = None,
        certificate_fingerprints: List[str] = None,
        group_member_attribute_name: str = None,
        group_object_class: str = None,
        group_object_class_custom_filter: str = None,
        ldap_protocol: str = None,
        ldap_server_host: str = None,
        ldap_server_port: int = None,
        organization_unit_object_class: str = None,
        start_tls_status: str = None,
        user_login_identifier: str = None,
        user_object_class: str = None,
        user_object_class_custom_filter: str = None,
    ):
        # 管理员密码
        self.administrator_password = administrator_password
        # 管理员账号
        self.administrator_username = administrator_username
        # 是否验证指纹证书
        self.certificate_fingerprint_status = certificate_fingerprint_status
        # 证书指纹列表
        self.certificate_fingerprints = certificate_fingerprints
        # 组成员标识
        self.group_member_attribute_name = group_member_attribute_name
        # 组objectClass
        self.group_object_class = group_object_class
        # 组自定义Filter
        self.group_object_class_custom_filter = group_object_class_custom_filter
        # 通信协议
        self.ldap_protocol = ldap_protocol
        # ad/ldap 服务器地址
        self.ldap_server_host = ldap_server_host
        # 端口号
        self.ldap_server_port = ldap_server_port
        # 组织objectClass
        self.organization_unit_object_class = organization_unit_object_class
        # startTls是否开启
        self.start_tls_status = start_tls_status
        # 用户登录标识
        self.user_login_identifier = user_login_identifier
        # 用户objectClass
        self.user_object_class = user_object_class
        # 用户自定义Filter
        self.user_object_class_custom_filter = user_object_class_custom_filter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrator_password is not None:
            result['AdministratorPassword'] = self.administrator_password
        if self.administrator_username is not None:
            result['AdministratorUsername'] = self.administrator_username
        if self.certificate_fingerprint_status is not None:
            result['CertificateFingerprintStatus'] = self.certificate_fingerprint_status
        if self.certificate_fingerprints is not None:
            result['CertificateFingerprints'] = self.certificate_fingerprints
        if self.group_member_attribute_name is not None:
            result['GroupMemberAttributeName'] = self.group_member_attribute_name
        if self.group_object_class is not None:
            result['GroupObjectClass'] = self.group_object_class
        if self.group_object_class_custom_filter is not None:
            result['GroupObjectClassCustomFilter'] = self.group_object_class_custom_filter
        if self.ldap_protocol is not None:
            result['LdapProtocol'] = self.ldap_protocol
        if self.ldap_server_host is not None:
            result['LdapServerHost'] = self.ldap_server_host
        if self.ldap_server_port is not None:
            result['LdapServerPort'] = self.ldap_server_port
        if self.organization_unit_object_class is not None:
            result['OrganizationUnitObjectClass'] = self.organization_unit_object_class
        if self.start_tls_status is not None:
            result['StartTlsStatus'] = self.start_tls_status
        if self.user_login_identifier is not None:
            result['UserLoginIdentifier'] = self.user_login_identifier
        if self.user_object_class is not None:
            result['UserObjectClass'] = self.user_object_class
        if self.user_object_class_custom_filter is not None:
            result['UserObjectClassCustomFilter'] = self.user_object_class_custom_filter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdministratorPassword') is not None:
            self.administrator_password = m.get('AdministratorPassword')
        if m.get('AdministratorUsername') is not None:
            self.administrator_username = m.get('AdministratorUsername')
        if m.get('CertificateFingerprintStatus') is not None:
            self.certificate_fingerprint_status = m.get('CertificateFingerprintStatus')
        if m.get('CertificateFingerprints') is not None:
            self.certificate_fingerprints = m.get('CertificateFingerprints')
        if m.get('GroupMemberAttributeName') is not None:
            self.group_member_attribute_name = m.get('GroupMemberAttributeName')
        if m.get('GroupObjectClass') is not None:
            self.group_object_class = m.get('GroupObjectClass')
        if m.get('GroupObjectClassCustomFilter') is not None:
            self.group_object_class_custom_filter = m.get('GroupObjectClassCustomFilter')
        if m.get('LdapProtocol') is not None:
            self.ldap_protocol = m.get('LdapProtocol')
        if m.get('LdapServerHost') is not None:
            self.ldap_server_host = m.get('LdapServerHost')
        if m.get('LdapServerPort') is not None:
            self.ldap_server_port = m.get('LdapServerPort')
        if m.get('OrganizationUnitObjectClass') is not None:
            self.organization_unit_object_class = m.get('OrganizationUnitObjectClass')
        if m.get('StartTlsStatus') is not None:
            self.start_tls_status = m.get('StartTlsStatus')
        if m.get('UserLoginIdentifier') is not None:
            self.user_login_identifier = m.get('UserLoginIdentifier')
        if m.get('UserObjectClass') is not None:
            self.user_object_class = m.get('UserObjectClass')
        if m.get('UserObjectClassCustomFilter') is not None:
            self.user_object_class_custom_filter = m.get('UserObjectClassCustomFilter')
        return self


class CreateIdentityProviderRequestOidcConfigAuthnParam(TeaModel):
    def __init__(
        self,
        authn_method: str = None,
        client_id: str = None,
        client_secret: str = None,
    ):
        # OIDC/oAuth2 认证方法。
        self.authn_method = authn_method
        # OIDC/oAuth2 客户端ID。
        self.client_id = client_id
        # OIDC/oAuth2 客户端密钥。
        self.client_secret = client_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_method is not None:
            result['AuthnMethod'] = self.authn_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnMethod') is not None:
            self.authn_method = m.get('AuthnMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        return self


class CreateIdentityProviderRequestOidcConfigEndpointConfig(TeaModel):
    def __init__(
        self,
        authorization_endpoint: str = None,
        issuer: str = None,
        jwks_uri: str = None,
        token_endpoint: str = None,
        userinfo_endpoint: str = None,
    ):
        # oAuth2 授权端点。
        self.authorization_endpoint = authorization_endpoint
        # OIDC issuer信息。
        self.issuer = issuer
        # OIDC jwks地址。
        self.jwks_uri = jwks_uri
        # oAuth2 Token端点。
        self.token_endpoint = token_endpoint
        # OIDC 用户信息端点。
        self.userinfo_endpoint = userinfo_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_endpoint is not None:
            result['AuthorizationEndpoint'] = self.authorization_endpoint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.jwks_uri is not None:
            result['JwksUri'] = self.jwks_uri
        if self.token_endpoint is not None:
            result['TokenEndpoint'] = self.token_endpoint
        if self.userinfo_endpoint is not None:
            result['UserinfoEndpoint'] = self.userinfo_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationEndpoint') is not None:
            self.authorization_endpoint = m.get('AuthorizationEndpoint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('JwksUri') is not None:
            self.jwks_uri = m.get('JwksUri')
        if m.get('TokenEndpoint') is not None:
            self.token_endpoint = m.get('TokenEndpoint')
        if m.get('UserinfoEndpoint') is not None:
            self.userinfo_endpoint = m.get('UserinfoEndpoint')
        return self


class CreateIdentityProviderRequestOidcConfig(TeaModel):
    def __init__(
        self,
        authn_param: CreateIdentityProviderRequestOidcConfigAuthnParam = None,
        endpoint_config: CreateIdentityProviderRequestOidcConfigEndpointConfig = None,
        grant_scopes: List[str] = None,
        grant_type: str = None,
        pkce_challenge_method: str = None,
        pkce_required: bool = None,
    ):
        # OIDC客户端认证配置。
        self.authn_param = authn_param
        # OIDC 端点配置。
        self.endpoint_config = endpoint_config
        # OIDC标准参数，如profile、email等
        self.grant_scopes = grant_scopes
        # OIDC授权类型。
        self.grant_type = grant_type
        # 支持的PKCE算法类型。
        self.pkce_challenge_method = pkce_challenge_method
        # AuthorizationCode授权模式下是否使用PKCE。
        self.pkce_required = pkce_required

    def validate(self):
        if self.authn_param:
            self.authn_param.validate()
        if self.endpoint_config:
            self.endpoint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_param is not None:
            result['AuthnParam'] = self.authn_param.to_map()
        if self.endpoint_config is not None:
            result['EndpointConfig'] = self.endpoint_config.to_map()
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.grant_type is not None:
            result['GrantType'] = self.grant_type
        if self.pkce_challenge_method is not None:
            result['PkceChallengeMethod'] = self.pkce_challenge_method
        if self.pkce_required is not None:
            result['PkceRequired'] = self.pkce_required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnParam') is not None:
            temp_model = CreateIdentityProviderRequestOidcConfigAuthnParam()
            self.authn_param = temp_model.from_map(m['AuthnParam'])
        if m.get('EndpointConfig') is not None:
            temp_model = CreateIdentityProviderRequestOidcConfigEndpointConfig()
            self.endpoint_config = temp_model.from_map(m['EndpointConfig'])
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('GrantType') is not None:
            self.grant_type = m.get('GrantType')
        if m.get('PkceChallengeMethod') is not None:
            self.pkce_challenge_method = m.get('PkceChallengeMethod')
        if m.get('PkceRequired') is not None:
            self.pkce_required = m.get('PkceRequired')
        return self


class CreateIdentityProviderRequestUdPullConfigPeriodicSyncConfig(TeaModel):
    def __init__(
        self,
        periodic_sync_cron: str = None,
        periodic_sync_times: List[int] = None,
        periodic_sync_type: str = None,
    ):
        self.periodic_sync_cron = periodic_sync_cron
        self.periodic_sync_times = periodic_sync_times
        self.periodic_sync_type = periodic_sync_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.periodic_sync_cron is not None:
            result['PeriodicSyncCron'] = self.periodic_sync_cron
        if self.periodic_sync_times is not None:
            result['PeriodicSyncTimes'] = self.periodic_sync_times
        if self.periodic_sync_type is not None:
            result['PeriodicSyncType'] = self.periodic_sync_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeriodicSyncCron') is not None:
            self.periodic_sync_cron = m.get('PeriodicSyncCron')
        if m.get('PeriodicSyncTimes') is not None:
            self.periodic_sync_times = m.get('PeriodicSyncTimes')
        if m.get('PeriodicSyncType') is not None:
            self.periodic_sync_type = m.get('PeriodicSyncType')
        return self


class CreateIdentityProviderRequestUdPullConfigUdSyncScopeConfig(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class CreateIdentityProviderRequestUdPullConfig(TeaModel):
    def __init__(
        self,
        group_sync_status: str = None,
        incremental_callback_status: str = None,
        periodic_sync_config: CreateIdentityProviderRequestUdPullConfigPeriodicSyncConfig = None,
        periodic_sync_status: str = None,
        ud_sync_scope_config: CreateIdentityProviderRequestUdPullConfigUdSyncScopeConfig = None,
    ):
        # 是否支持组同步，默认为disabled
        self.group_sync_status = group_sync_status
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        self.periodic_sync_config = periodic_sync_config
        self.periodic_sync_status = periodic_sync_status
        # 同步入配置信息
        # 
        # This parameter is required.
        self.ud_sync_scope_config = ud_sync_scope_config

    def validate(self):
        if self.periodic_sync_config:
            self.periodic_sync_config.validate()
        if self.ud_sync_scope_config:
            self.ud_sync_scope_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_sync_status is not None:
            result['GroupSyncStatus'] = self.group_sync_status
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.periodic_sync_config is not None:
            result['PeriodicSyncConfig'] = self.periodic_sync_config.to_map()
        if self.periodic_sync_status is not None:
            result['PeriodicSyncStatus'] = self.periodic_sync_status
        if self.ud_sync_scope_config is not None:
            result['UdSyncScopeConfig'] = self.ud_sync_scope_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupSyncStatus') is not None:
            self.group_sync_status = m.get('GroupSyncStatus')
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('PeriodicSyncConfig') is not None:
            temp_model = CreateIdentityProviderRequestUdPullConfigPeriodicSyncConfig()
            self.periodic_sync_config = temp_model.from_map(m['PeriodicSyncConfig'])
        if m.get('PeriodicSyncStatus') is not None:
            self.periodic_sync_status = m.get('PeriodicSyncStatus')
        if m.get('UdSyncScopeConfig') is not None:
            temp_model = CreateIdentityProviderRequestUdPullConfigUdSyncScopeConfig()
            self.ud_sync_scope_config = temp_model.from_map(m['UdSyncScopeConfig'])
        return self


class CreateIdentityProviderRequestUdPushConfigUdSyncScopeConfigs(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class CreateIdentityProviderRequestUdPushConfig(TeaModel):
    def __init__(
        self,
        incremental_callback_status: str = None,
        periodic_sync_status: str = None,
        ud_sync_scope_configs: List[CreateIdentityProviderRequestUdPushConfigUdSyncScopeConfigs] = None,
    ):
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        self.periodic_sync_status = periodic_sync_status
        # 同步出配置信息
        self.ud_sync_scope_configs = ud_sync_scope_configs

    def validate(self):
        if self.ud_sync_scope_configs:
            for k in self.ud_sync_scope_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.periodic_sync_status is not None:
            result['PeriodicSyncStatus'] = self.periodic_sync_status
        result['UdSyncScopeConfigs'] = []
        if self.ud_sync_scope_configs is not None:
            for k in self.ud_sync_scope_configs:
                result['UdSyncScopeConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('PeriodicSyncStatus') is not None:
            self.periodic_sync_status = m.get('PeriodicSyncStatus')
        self.ud_sync_scope_configs = []
        if m.get('UdSyncScopeConfigs') is not None:
            for k in m.get('UdSyncScopeConfigs'):
                temp_model = CreateIdentityProviderRequestUdPushConfigUdSyncScopeConfigs()
                self.ud_sync_scope_configs.append(temp_model.from_map(k))
        return self


class CreateIdentityProviderRequestWeComConfig(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        authorize_callback_domain: str = None,
        corp_id: str = None,
        corp_secret: str = None,
        trustable_domain: str = None,
    ):
        # 企业微信自建应用的Id
        self.agent_id = agent_id
        # 授权回调域
        self.authorize_callback_domain = authorize_callback_domain
        # 企业微信自建应用的corpId
        self.corp_id = corp_id
        # 企业微信自建应用的corpSecret
        self.corp_secret = corp_secret
        # 可信域名
        self.trustable_domain = trustable_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.authorize_callback_domain is not None:
            result['AuthorizeCallbackDomain'] = self.authorize_callback_domain
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_secret is not None:
            result['CorpSecret'] = self.corp_secret
        if self.trustable_domain is not None:
            result['TrustableDomain'] = self.trustable_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AuthorizeCallbackDomain') is not None:
            self.authorize_callback_domain = m.get('AuthorizeCallbackDomain')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpSecret') is not None:
            self.corp_secret = m.get('CorpSecret')
        if m.get('TrustableDomain') is not None:
            self.trustable_domain = m.get('TrustableDomain')
        return self


class CreateIdentityProviderRequest(TeaModel):
    def __init__(
        self,
        authn_config: CreateIdentityProviderRequestAuthnConfig = None,
        auto_create_user_config: CreateIdentityProviderRequestAutoCreateUserConfig = None,
        auto_update_user_config: CreateIdentityProviderRequestAutoUpdateUserConfig = None,
        binding_config: CreateIdentityProviderRequestBindingConfig = None,
        dingtalk_app_config: CreateIdentityProviderRequestDingtalkAppConfig = None,
        identity_provider_name: str = None,
        identity_provider_type: str = None,
        instance_id: str = None,
        lark_config: CreateIdentityProviderRequestLarkConfig = None,
        ldap_config: CreateIdentityProviderRequestLdapConfig = None,
        logo_url: str = None,
        network_access_endpoint_id: str = None,
        oidc_config: CreateIdentityProviderRequestOidcConfig = None,
        ud_pull_config: CreateIdentityProviderRequestUdPullConfig = None,
        ud_push_config: CreateIdentityProviderRequestUdPushConfig = None,
        we_com_config: CreateIdentityProviderRequestWeComConfig = None,
    ):
        # 认证配置
        self.authn_config = authn_config
        # 自动创建账户账户规则配置。
        self.auto_create_user_config = auto_create_user_config
        # 自动更新账户规则配置。
        self.auto_update_user_config = auto_update_user_config
        # 账户绑定规则配置。
        self.binding_config = binding_config
        # 钉钉配置
        self.dingtalk_app_config = dingtalk_app_config
        # 身份提供方名称
        # 
        # This parameter is required.
        self.identity_provider_name = identity_provider_name
        # 身份提供发类型
        # 
        # This parameter is required.
        self.identity_provider_type = identity_provider_type
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 飞书配置
        self.lark_config = lark_config
        # AD/LDAP配置
        self.ldap_config = ldap_config
        self.logo_url = logo_url
        # 网络端点ID
        self.network_access_endpoint_id = network_access_endpoint_id
        # OIDC IdP配置。
        self.oidc_config = oidc_config
        # 同步入配置
        self.ud_pull_config = ud_pull_config
        # 同步出配置
        self.ud_push_config = ud_push_config
        # WeCom配置
        self.we_com_config = we_com_config

    def validate(self):
        if self.authn_config:
            self.authn_config.validate()
        if self.auto_create_user_config:
            self.auto_create_user_config.validate()
        if self.auto_update_user_config:
            self.auto_update_user_config.validate()
        if self.binding_config:
            self.binding_config.validate()
        if self.dingtalk_app_config:
            self.dingtalk_app_config.validate()
        if self.lark_config:
            self.lark_config.validate()
        if self.ldap_config:
            self.ldap_config.validate()
        if self.oidc_config:
            self.oidc_config.validate()
        if self.ud_pull_config:
            self.ud_pull_config.validate()
        if self.ud_push_config:
            self.ud_push_config.validate()
        if self.we_com_config:
            self.we_com_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_config is not None:
            result['AuthnConfig'] = self.authn_config.to_map()
        if self.auto_create_user_config is not None:
            result['AutoCreateUserConfig'] = self.auto_create_user_config.to_map()
        if self.auto_update_user_config is not None:
            result['AutoUpdateUserConfig'] = self.auto_update_user_config.to_map()
        if self.binding_config is not None:
            result['BindingConfig'] = self.binding_config.to_map()
        if self.dingtalk_app_config is not None:
            result['DingtalkAppConfig'] = self.dingtalk_app_config.to_map()
        if self.identity_provider_name is not None:
            result['IdentityProviderName'] = self.identity_provider_name
        if self.identity_provider_type is not None:
            result['IdentityProviderType'] = self.identity_provider_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lark_config is not None:
            result['LarkConfig'] = self.lark_config.to_map()
        if self.ldap_config is not None:
            result['LdapConfig'] = self.ldap_config.to_map()
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.oidc_config is not None:
            result['OidcConfig'] = self.oidc_config.to_map()
        if self.ud_pull_config is not None:
            result['UdPullConfig'] = self.ud_pull_config.to_map()
        if self.ud_push_config is not None:
            result['UdPushConfig'] = self.ud_push_config.to_map()
        if self.we_com_config is not None:
            result['WeComConfig'] = self.we_com_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnConfig') is not None:
            temp_model = CreateIdentityProviderRequestAuthnConfig()
            self.authn_config = temp_model.from_map(m['AuthnConfig'])
        if m.get('AutoCreateUserConfig') is not None:
            temp_model = CreateIdentityProviderRequestAutoCreateUserConfig()
            self.auto_create_user_config = temp_model.from_map(m['AutoCreateUserConfig'])
        if m.get('AutoUpdateUserConfig') is not None:
            temp_model = CreateIdentityProviderRequestAutoUpdateUserConfig()
            self.auto_update_user_config = temp_model.from_map(m['AutoUpdateUserConfig'])
        if m.get('BindingConfig') is not None:
            temp_model = CreateIdentityProviderRequestBindingConfig()
            self.binding_config = temp_model.from_map(m['BindingConfig'])
        if m.get('DingtalkAppConfig') is not None:
            temp_model = CreateIdentityProviderRequestDingtalkAppConfig()
            self.dingtalk_app_config = temp_model.from_map(m['DingtalkAppConfig'])
        if m.get('IdentityProviderName') is not None:
            self.identity_provider_name = m.get('IdentityProviderName')
        if m.get('IdentityProviderType') is not None:
            self.identity_provider_type = m.get('IdentityProviderType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LarkConfig') is not None:
            temp_model = CreateIdentityProviderRequestLarkConfig()
            self.lark_config = temp_model.from_map(m['LarkConfig'])
        if m.get('LdapConfig') is not None:
            temp_model = CreateIdentityProviderRequestLdapConfig()
            self.ldap_config = temp_model.from_map(m['LdapConfig'])
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('OidcConfig') is not None:
            temp_model = CreateIdentityProviderRequestOidcConfig()
            self.oidc_config = temp_model.from_map(m['OidcConfig'])
        if m.get('UdPullConfig') is not None:
            temp_model = CreateIdentityProviderRequestUdPullConfig()
            self.ud_pull_config = temp_model.from_map(m['UdPullConfig'])
        if m.get('UdPushConfig') is not None:
            temp_model = CreateIdentityProviderRequestUdPushConfig()
            self.ud_push_config = temp_model.from_map(m['UdPushConfig'])
        if m.get('WeComConfig') is not None:
            temp_model = CreateIdentityProviderRequestWeComConfig()
            self.we_com_config = temp_model.from_map(m['WeComConfig'])
        return self


class CreateIdentityProviderResponseBody(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        request_id: str = None,
    ):
        self.identity_provider_id = identity_provider_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateIdentityProviderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateIdentityProviderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIdentityProviderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
    ):
        # The description of the instance. The description can be up to 128 characters in length.
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        request_id: str = None,
    ):
        # The ID of the instance that is created.
        self.instance_id = instance_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkAccessEndpointRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        network_access_endpoint_name: str = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
        vpc_region_id: str = None,
    ):
        # 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。ClientToken只支持ASCII字符，且不能超过64个字符。
        self.client_token = client_token
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 专属网络端点名称。
        # 
        # This parameter is required.
        self.network_access_endpoint_name = network_access_endpoint_name
        # 专属网络端点连接的指定vSwitch。
        self.v_switch_ids = v_switch_ids
        # 专属网络端点连接的VpcID。
        # 
        # This parameter is required.
        self.vpc_id = vpc_id
        # 专属网络端点连接的VpcID所属地域，该地域取值必须在ListNetworkAccessEndpointAvailableRegions接口中返回。
        # 
        # This parameter is required.
        self.vpc_region_id = vpc_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_name is not None:
            result['NetworkAccessEndpointName'] = self.network_access_endpoint_name
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointName') is not None:
            self.network_access_endpoint_name = m.get('NetworkAccessEndpointName')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class CreateNetworkAccessEndpointResponseBody(TeaModel):
    def __init__(
        self,
        network_access_endpoint_id: str = None,
        request_id: str = None,
    ):
        self.network_access_endpoint_id = network_access_endpoint_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkAccessEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNetworkAccessEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkAccessEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        instance_id: str = None,
        organizational_unit_external_id: str = None,
        organizational_unit_name: str = None,
        parent_id: str = None,
    ):
        # The description of the organization. The value can be up to 256 characters in length.
        self.description = description
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The external ID of the organization, which can be used to associate the organization with an external system. By default, the external ID is the organization ID. The value can be up to 64 characters in length.
        self.organizational_unit_external_id = organizational_unit_external_id
        # The name of the organization. The name can be up to 64 characters in length.
        # 
        # This parameter is required.
        self.organizational_unit_name = organizational_unit_name
        # The parent organization ID.
        # 
        # This parameter is required.
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_external_id is not None:
            result['OrganizationalUnitExternalId'] = self.organizational_unit_external_id
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitExternalId') is not None:
            self.organizational_unit_external_id = m.get('OrganizationalUnitExternalId')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        organizational_unit_id: str = None,
        request_id: str = None,
    ):
        # The organization ID.
        self.organizational_unit_id = organizational_unit_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequestCustomFields(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        field_value: str = None,
    ):
        # The name of the extended field. You must create the extended field in advance. To create an extended field, log on to the IDaaS console. In the left-side navigation pane, choose Accounts > Extended Fields, and then click Create Field on the Extended Fields page.
        self.field_name = field_name
        # The value of the extended field. The value follows the limits on the properties of the extended field.
        self.field_value = field_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        return self


class CreateUserRequestPasswordInitializationConfig(TeaModel):
    def __init__(
        self,
        password_forced_update_status: str = None,
        password_initialization_policy_priority: str = None,
        password_initialization_type: str = None,
        user_notification_channels: List[str] = None,
    ):
        # Specifies whether to forcibly change the password status. Default value: disabled. Valid values:
        # 
        # *   enabled: forcibly changes the password status.
        # *   disabled: does not forcibly change the password status.
        self.password_forced_update_status = password_forced_update_status
        # The priority of the password initialization policy. By default, this parameter does not take effect. Valid values:
        # 
        # *   global: The password initialization policy globally takes effect.
        # *   custom: The password initialization policy takes effect based on custom settings.
        self.password_initialization_policy_priority = password_initialization_policy_priority
        # The password initialization method. Set the value to random,
        # 
        # *   which indicates that the password is randomly generated.
        self.password_initialization_type = password_initialization_type
        # The password notification methods.
        self.user_notification_channels = user_notification_channels

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_forced_update_status is not None:
            result['PasswordForcedUpdateStatus'] = self.password_forced_update_status
        if self.password_initialization_policy_priority is not None:
            result['PasswordInitializationPolicyPriority'] = self.password_initialization_policy_priority
        if self.password_initialization_type is not None:
            result['PasswordInitializationType'] = self.password_initialization_type
        if self.user_notification_channels is not None:
            result['UserNotificationChannels'] = self.user_notification_channels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordForcedUpdateStatus') is not None:
            self.password_forced_update_status = m.get('PasswordForcedUpdateStatus')
        if m.get('PasswordInitializationPolicyPriority') is not None:
            self.password_initialization_policy_priority = m.get('PasswordInitializationPolicyPriority')
        if m.get('PasswordInitializationType') is not None:
            self.password_initialization_type = m.get('PasswordInitializationType')
        if m.get('UserNotificationChannels') is not None:
            self.user_notification_channels = m.get('UserNotificationChannels')
        return self


class CreateUserRequest(TeaModel):
    def __init__(
        self,
        custom_fields: List[CreateUserRequestCustomFields] = None,
        description: str = None,
        display_name: str = None,
        email: str = None,
        email_verified: bool = None,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
        password: str = None,
        password_initialization_config: CreateUserRequestPasswordInitializationConfig = None,
        phone_number: str = None,
        phone_number_verified: bool = None,
        phone_region: str = None,
        primary_organizational_unit_id: str = None,
        user_external_id: str = None,
        username: str = None,
    ):
        # The extended fields.
        self.custom_fields = custom_fields
        # The description of the organizational unit. The description can be up to 256 characters in length.
        self.description = description
        # The display name of the account. The display name can be up to 64 characters in length.
        self.display_name = display_name
        # The email address of the user who owns the account. The email address prefix can contain letters, digits, underscores (_), periods (.), and hyphens (-).
        self.email = email
        # Specifies whether the email address is a trusted email address. This parameter is required if the Email parameter is specified. If you have no special business requirements, set this parameter to true.
        self.email_verified = email_verified
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of organizational units to which the account belongs. An account can belong to multiple organizational units.
        self.organizational_unit_ids = organizational_unit_ids
        # The password of the account. For more information, view the password policy of the instance in the IDaaS console.
        self.password = password
        # The configurations for password initialization.
        self.password_initialization_config = password_initialization_config
        # The mobile phone number, which contains 6 to 15 digits.
        self.phone_number = phone_number
        # Specifies whether the mobile phone number is a trusted mobile phone number. This parameter is required if the PhoneNumber parameter is specified. If you have no special business requirements, set this parameter to true.
        self.phone_number_verified = phone_number_verified
        # The country code of the mobile phone number. The country code contains only digits and does not contain a plus sign (+).
        self.phone_region = phone_region
        # The ID of the primary organizational unit to which the account belongs.
        # 
        # This parameter is required.
        self.primary_organizational_unit_id = primary_organizational_unit_id
        # The external ID of the account. The external ID can be used to associate the account with an external system. The external ID can be up to 64 characters in length. If you do not specify an external ID for the account, the ID of the account is used as the external ID by default.
        self.user_external_id = user_external_id
        # The name of the account. The name can be up to 64 characters in length and can contain letters, digits, underscores (_), periods (.), at signs (@), and hyphens (-).
        # 
        # This parameter is required.
        self.username = username

    def validate(self):
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()
        if self.password_initialization_config:
            self.password_initialization_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['CustomFields'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.email_verified is not None:
            result['EmailVerified'] = self.email_verified
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.password is not None:
            result['Password'] = self.password
        if self.password_initialization_config is not None:
            result['PasswordInitializationConfig'] = self.password_initialization_config.to_map()
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.phone_number_verified is not None:
            result['PhoneNumberVerified'] = self.phone_number_verified
        if self.phone_region is not None:
            result['PhoneRegion'] = self.phone_region
        if self.primary_organizational_unit_id is not None:
            result['PrimaryOrganizationalUnitId'] = self.primary_organizational_unit_id
        if self.user_external_id is not None:
            result['UserExternalId'] = self.user_external_id
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_fields = []
        if m.get('CustomFields') is not None:
            for k in m.get('CustomFields'):
                temp_model = CreateUserRequestCustomFields()
                self.custom_fields.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('EmailVerified') is not None:
            self.email_verified = m.get('EmailVerified')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInitializationConfig') is not None:
            temp_model = CreateUserRequestPasswordInitializationConfig()
            self.password_initialization_config = temp_model.from_map(m['PasswordInitializationConfig'])
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PhoneNumberVerified') is not None:
            self.phone_number_verified = m.get('PhoneNumberVerified')
        if m.get('PhoneRegion') is not None:
            self.phone_region = m.get('PhoneRegion')
        if m.get('PrimaryOrganizationalUnitId') is not None:
            self.primary_organizational_unit_id = m.get('PrimaryOrganizationalUnitId')
        if m.get('UserExternalId') is not None:
            self.user_external_id = m.get('UserExternalId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the account.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class CreateUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to delete.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApplicationClientSecretRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        secret_id: str = None,
    ):
        # The ID of the application for which you want to delete a client key.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the client key that you want to delete for the application.
        # 
        # This parameter is required.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class DeleteApplicationClientSecretResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteApplicationClientSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApplicationClientSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApplicationClientSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        instance_id: str = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDomainRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDomainProxyTokenRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # 域名代理Token ID。
        # 
        # This parameter is required.
        self.domain_proxy_token_id = domain_proxy_token_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDomainProxyTokenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDomainProxyTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDomainProxyTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDomainProxyTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instance_id: str = None,
    ):
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIdentityProviderRequest(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM的实例id
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteIdentityProviderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIdentityProviderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIdentityProviderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIdentityProviderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the instance to be deleted.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkAccessEndpointRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 专属网络端点ID。
        # 
        # This parameter is required.
        self.network_access_endpoint_id = network_access_endpoint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        return self


class DeleteNetworkAccessEndpointResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkAccessEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNetworkAccessEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkAccessEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The organization ID.
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        return self


class DeleteOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOrganizationalUnitChildrenRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Organizational Unit ID.
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        return self


class DeleteOrganizationalUnitChildrenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOrganizationalUnitChildrenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOrganizationalUnitChildrenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOrganizationalUnitChildrenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to disable.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableApplicationApiInvokeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableApplicationApiInvokeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableApplicationApiInvokeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableApplicationApiInvokeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableApplicationApiInvokeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableApplicationClientSecretRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        secret_id: str = None,
    ):
        # The ID of the application for which you want to disable a client key.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The client key ID of the application.
        # 
        # This parameter is required.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class DisableApplicationClientSecretResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableApplicationClientSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableApplicationClientSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableApplicationClientSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableApplicationProvisioningRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableApplicationProvisioningResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableApplicationProvisioningResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableApplicationProvisioningResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableApplicationProvisioningResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableApplicationSsoRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的应用主键id
        # 
        # This parameter is required.
        self.application_id = application_id
        # IDaaS EIAM的实例id
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableApplicationSsoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableApplicationSsoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableApplicationSsoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableApplicationSsoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        instance_id: str = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID。
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDomainProxyTokenRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # 域名代理Token ID。
        # 
        # This parameter is required.
        self.domain_proxy_token_id = domain_proxy_token_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableDomainProxyTokenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableDomainProxyTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableDomainProxyTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDomainProxyTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableIdentityProviderUdPullRequest(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM的实例id
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableIdentityProviderUdPullResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableIdentityProviderUdPullResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableIdentityProviderUdPullResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableIdentityProviderUdPullResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableInitDomainAutoRedirectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableInitDomainAutoRedirectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableInitDomainAutoRedirectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableInitDomainAutoRedirectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableInitDomainAutoRedirectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the account.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DisableUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to enable.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableApplicationApiInvokeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableApplicationApiInvokeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableApplicationApiInvokeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableApplicationApiInvokeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableApplicationApiInvokeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableApplicationClientSecretRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        secret_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The client key ID of the application.
        # 
        # This parameter is required.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class EnableApplicationClientSecretResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableApplicationClientSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableApplicationClientSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableApplicationClientSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableApplicationProvisioningRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableApplicationProvisioningResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableApplicationProvisioningResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableApplicationProvisioningResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableApplicationProvisioningResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableApplicationSsoRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的应用主键id
        # 
        # This parameter is required.
        self.application_id = application_id
        # IDaaS EIAM的实例id
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableApplicationSsoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableApplicationSsoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableApplicationSsoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableApplicationSsoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        instance_id: str = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID。
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDomainProxyTokenRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # 域名代理Token ID。
        # 
        # This parameter is required.
        self.domain_proxy_token_id = domain_proxy_token_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableDomainProxyTokenResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableDomainProxyTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableDomainProxyTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDomainProxyTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableIdentityProviderUdPullRequest(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM的实例id
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableIdentityProviderUdPullResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableIdentityProviderUdPullResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableIdentityProviderUdPullResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableIdentityProviderUdPullResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableInitDomainAutoRedirectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EnableInitDomainAutoRedirectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableInitDomainAutoRedirectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableInitDomainAutoRedirectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableInitDomainAutoRedirectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class EnableUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to query.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetApplicationResponseBodyApplication(TeaModel):
    def __init__(
        self,
        api_invoke_status: str = None,
        application_id: str = None,
        application_name: str = None,
        application_source_type: str = None,
        application_template_id: str = None,
        application_visibility: List[str] = None,
        authorization_type: str = None,
        client_id: str = None,
        create_time: int = None,
        description: str = None,
        features: str = None,
        instance_id: str = None,
        logo_url: str = None,
        m_2mclient_status: str = None,
        managed_service_code: str = None,
        resource_server_identifier: str = None,
        resource_server_status: str = None,
        service_managed: bool = None,
        sso_type: str = None,
        status: str = None,
        update_time: int = None,
    ):
        # The status of the Developer API feature. Valid values:
        # 
        # *   Enabled: The Developer API feature is enabled.
        # *   Disabled: The Developer API feature is disabled.
        self.api_invoke_status = api_invoke_status
        # The ID of the application.
        self.application_id = application_id
        # The name of the application.
        self.application_name = application_name
        # The origin of the application. Valid values:
        # 
        # *   urn:alibaba:idaas:app:source:template: The application is created based on a template.
        # *   urn:alibaba:idaas: The application is created based on the standard protocol.
        self.application_source_type = application_source_type
        # The ID of the template based on which the application is created. This parameter is returned only if the application is created based on a template.
        self.application_template_id = application_template_id
        self.application_visibility = application_visibility
        # The authorization type of the EIAM application. Valid values:
        # 
        # *   authorize_required: Only the user with explicit authorization can access the application.
        # *   default_all: By default, all users can access the application.
        self.authorization_type = authorization_type
        # The client ID of the application.
        self.client_id = client_id
        # The time when the application was created. The value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the application.
        self.description = description
        # The features that are supported by the application. The value is a JSON array. Valid values:
        # 
        # *   sso: The application supports SSO.
        # *   provision: The application supports account synchronization.
        # *   api_invoke: The application supports custom APIs.
        self.features = features
        # The ID of the instance.
        self.instance_id = instance_id
        # The URL of the application icon.
        self.logo_url = logo_url
        self.m_2mclient_status = m_2mclient_status
        # The service code of the cloud service that manages the application template.
        self.managed_service_code = managed_service_code
        self.resource_server_identifier = resource_server_identifier
        self.resource_server_status = resource_server_status
        # Indicates whether the application template is managed by a cloud service.
        self.service_managed = service_managed
        # The type of the single sign-on (SSO) protocol. Valid values:
        # 
        # *   saml2: the Security Assertion Markup Language (SAML) 2.0 protocol.
        # *   oidc: the OpenID Connect (OIDC) protocol.
        self.sso_type = sso_type
        # The status of the application. Valid values:
        # 
        # *   Enabled: The application is enabled.
        # *   Disabled: The application is disabled.
        self.status = status
        # The time when the application was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_invoke_status is not None:
            result['ApiInvokeStatus'] = self.api_invoke_status
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_source_type is not None:
            result['ApplicationSourceType'] = self.application_source_type
        if self.application_template_id is not None:
            result['ApplicationTemplateId'] = self.application_template_id
        if self.application_visibility is not None:
            result['ApplicationVisibility'] = self.application_visibility
        if self.authorization_type is not None:
            result['AuthorizationType'] = self.authorization_type
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.features is not None:
            result['Features'] = self.features
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.m_2mclient_status is not None:
            result['M2MClientStatus'] = self.m_2mclient_status
        if self.managed_service_code is not None:
            result['ManagedServiceCode'] = self.managed_service_code
        if self.resource_server_identifier is not None:
            result['ResourceServerIdentifier'] = self.resource_server_identifier
        if self.resource_server_status is not None:
            result['ResourceServerStatus'] = self.resource_server_status
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.sso_type is not None:
            result['SsoType'] = self.sso_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiInvokeStatus') is not None:
            self.api_invoke_status = m.get('ApiInvokeStatus')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSourceType') is not None:
            self.application_source_type = m.get('ApplicationSourceType')
        if m.get('ApplicationTemplateId') is not None:
            self.application_template_id = m.get('ApplicationTemplateId')
        if m.get('ApplicationVisibility') is not None:
            self.application_visibility = m.get('ApplicationVisibility')
        if m.get('AuthorizationType') is not None:
            self.authorization_type = m.get('AuthorizationType')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Features') is not None:
            self.features = m.get('Features')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('M2MClientStatus') is not None:
            self.m_2mclient_status = m.get('M2MClientStatus')
        if m.get('ManagedServiceCode') is not None:
            self.managed_service_code = m.get('ManagedServiceCode')
        if m.get('ResourceServerIdentifier') is not None:
            self.resource_server_identifier = m.get('ResourceServerIdentifier')
        if m.get('ResourceServerStatus') is not None:
            self.resource_server_status = m.get('ResourceServerStatus')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('SsoType') is not None:
            self.sso_type = m.get('SsoType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetApplicationResponseBody(TeaModel):
    def __init__(
        self,
        application: GetApplicationResponseBodyApplication = None,
        request_id: str = None,
    ):
        # The details of the application.
        self.application = application
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application:
            self.application.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            temp_model = GetApplicationResponseBodyApplication()
            self.application = temp_model.from_map(m['Application'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationGrantScopeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetApplicationGrantScopeResponseBodyApplicationGrantScope(TeaModel):
    def __init__(
        self,
        grant_scopes: List[str] = None,
    ):
        # The permissions of the Developer API feature.
        self.grant_scopes = grant_scopes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        return self


class GetApplicationGrantScopeResponseBody(TeaModel):
    def __init__(
        self,
        application_grant_scope: GetApplicationGrantScopeResponseBodyApplicationGrantScope = None,
        request_id: str = None,
    ):
        # The permissions of the Developer API feature.
        self.application_grant_scope = application_grant_scope
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application_grant_scope:
            self.application_grant_scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_grant_scope is not None:
            result['ApplicationGrantScope'] = self.application_grant_scope.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationGrantScope') is not None:
            temp_model = GetApplicationGrantScopeResponseBodyApplicationGrantScope()
            self.application_grant_scope = temp_model.from_map(m['ApplicationGrantScope'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApplicationGrantScopeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationGrantScopeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationGrantScopeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationProvisioningConfigRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigCallbackProvisioningConfig(TeaModel):
    def __init__(
        self,
        callback_url: str = None,
        encrypt_key: str = None,
        encrypt_required: bool = None,
        listen_event_scopes: List[str] = None,
    ):
        # The URL that the application uses to receive IDaaS event callbacks.
        self.callback_url = callback_url
        # The symmetric key for IDaaS event callbacks. The key is an AES-256 encryption key in the HEX format.
        self.encrypt_key = encrypt_key
        # Indicates whether IDaaS event callback messages are encrypted. Valid values:
        # 
        # *   true: The messages are encrypted.
        # *   false: The messages are transmitted in plaintext.
        self.encrypt_required = encrypt_required
        # The list of types of IDaaS event callback messages that are supported by the listener.
        self.listen_event_scopes = listen_event_scopes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.encrypt_key is not None:
            result['EncryptKey'] = self.encrypt_key
        if self.encrypt_required is not None:
            result['EncryptRequired'] = self.encrypt_required
        if self.listen_event_scopes is not None:
            result['ListenEventScopes'] = self.listen_event_scopes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('EncryptKey') is not None:
            self.encrypt_key = m.get('EncryptKey')
        if m.get('EncryptRequired') is not None:
            self.encrypt_required = m.get('EncryptRequired')
        if m.get('ListenEventScopes') is not None:
            self.listen_event_scopes = m.get('ListenEventScopes')
        return self


class GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfigurationAuthnParam(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        authn_method: str = None,
        client_id: str = None,
        client_secret: str = None,
        token_endpoint: str = None,
    ):
        # The access token. This parameter is returned when the GrantType parameter is set to bearer_token.
        self.access_token = access_token
        # The authentication mode of the SCIM protocol. Valid values:
        # 
        # *   client_secret_basic: The client secret is passed in the request header.
        # *   client_secret_post: The client secret is passed in the request body.
        self.authn_method = authn_method
        # The client ID of the application.
        self.client_id = client_id
        # The client secret of the application.
        self.client_secret = client_secret
        # The token endpoint.
        self.token_endpoint = token_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['AccessToken'] = self.access_token
        if self.authn_method is not None:
            result['AuthnMethod'] = self.authn_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.token_endpoint is not None:
            result['TokenEndpoint'] = self.token_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessToken') is not None:
            self.access_token = m.get('AccessToken')
        if m.get('AuthnMethod') is not None:
            self.authn_method = m.get('AuthnMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('TokenEndpoint') is not None:
            self.token_endpoint = m.get('TokenEndpoint')
        return self


class GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfiguration(TeaModel):
    def __init__(
        self,
        authn_mode: str = None,
        authn_param: GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfigurationAuthnParam = None,
        grant_type: str = None,
    ):
        # The authentication mode of the SCIM protocol. Valid value:
        # 
        # *   oauth2: OAuth2.0 mode.
        self.authn_mode = authn_mode
        # The configuration parameters related to authorization.
        # 
        # *   If the GrantType parameter is set to client_credentials, the configuration parameters ClientId, ClientSecret, and AuthnMethod are returned.
        # *   If the GrantType parameter is set to bearer_token, the configuration parameter AccessToken is returned.
        self.authn_param = authn_param
        # The grant type of the SCIM protocol. Valid values:
        # 
        # *   client_credentials: client mode.
        # *   bearer_token: key mode.
        self.grant_type = grant_type

    def validate(self):
        if self.authn_param:
            self.authn_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_mode is not None:
            result['AuthnMode'] = self.authn_mode
        if self.authn_param is not None:
            result['AuthnParam'] = self.authn_param.to_map()
        if self.grant_type is not None:
            result['GrantType'] = self.grant_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnMode') is not None:
            self.authn_mode = m.get('AuthnMode')
        if m.get('AuthnParam') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfigurationAuthnParam()
            self.authn_param = temp_model.from_map(m['AuthnParam'])
        if m.get('GrantType') is not None:
            self.grant_type = m.get('GrantType')
        return self


class GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfig(TeaModel):
    def __init__(
        self,
        authn_configuration: GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfiguration = None,
        full_push_scopes: List[str] = None,
        provisioning_actions: List[str] = None,
        scim_base_url: str = None,
    ):
        # The configuration parameters related to SCIM-based synchronization.
        self.authn_configuration = authn_configuration
        # The full synchronization scope of the SCIM protocol. Valid value:
        # 
        # *   urn:alibaba:idaas:app:scim:User:PUSH: full account data synchronization.
        self.full_push_scopes = full_push_scopes
        # The resource operations of the SCIM protocol. Valid values:
        # 
        # *   urn:alibaba:idaas:app:scim:User:CREATE: account creation.
        # *   urn:alibaba:idaas:app:scim:User:UPDATE: account update.
        # *   urn:alibaba:idaas:app:scim:User:DELETE: account deletion.
        self.provisioning_actions = provisioning_actions
        # The base URL that the application uses to receive the SCIM protocol for IDaaS synchronization.
        self.scim_base_url = scim_base_url

    def validate(self):
        if self.authn_configuration:
            self.authn_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_configuration is not None:
            result['AuthnConfiguration'] = self.authn_configuration.to_map()
        if self.full_push_scopes is not None:
            result['FullPushScopes'] = self.full_push_scopes
        if self.provisioning_actions is not None:
            result['ProvisioningActions'] = self.provisioning_actions
        if self.scim_base_url is not None:
            result['ScimBaseUrl'] = self.scim_base_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnConfiguration') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfigAuthnConfiguration()
            self.authn_configuration = temp_model.from_map(m['AuthnConfiguration'])
        if m.get('FullPushScopes') is not None:
            self.full_push_scopes = m.get('FullPushScopes')
        if m.get('ProvisioningActions') is not None:
            self.provisioning_actions = m.get('ProvisioningActions')
        if m.get('ScimBaseUrl') is not None:
            self.scim_base_url = m.get('ScimBaseUrl')
        return self


class GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfig(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        callback_provisioning_config: GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigCallbackProvisioningConfig = None,
        config_operate_mode: str = None,
        instance_id: str = None,
        provision_jwks_endpoint: str = None,
        provision_password: bool = None,
        provision_protocol_type: str = None,
        scim_provisioning_config: GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfig = None,
        status: str = None,
    ):
        # The ID of the application.
        self.application_id = application_id
        # The configuration of the custom event callback protocol of IDaaS.
        self.callback_provisioning_config = callback_provisioning_config
        # The rendering mode of the account synchronization page. Valid values:
        # 
        # *   standard: standard mode
        # *   template: template mode
        self.config_operate_mode = config_operate_mode
        # The ID of the instance.
        self.instance_id = instance_id
        # The public key endpoint for signature verification of the synchronization callback information.
        self.provision_jwks_endpoint = provision_jwks_endpoint
        # Indicates whether the password is synchronized in IDaaS user event callbacks. Valid values:
        # 
        # *   true: The password is synchronized.
        # *   false: The password is not synchronized.
        self.provision_password = provision_password
        # The synchronization protocol type of the application. Valid values:
        # 
        # *   idaas_callback: custom event callback protocol of IDaaS.
        # *   scim2: System for Cross-domain Identity Management (SCIM) protocol.
        self.provision_protocol_type = provision_protocol_type
        # The configuration of SCIM-based IDaaS synchronization.
        self.scim_provisioning_config = scim_provisioning_config
        # The status of the IDaaS account synchronization feature. Valid values:
        # 
        # *   enabled: The feature is enabled.
        # *   disabled: The feature is disabled.
        self.status = status

    def validate(self):
        if self.callback_provisioning_config:
            self.callback_provisioning_config.validate()
        if self.scim_provisioning_config:
            self.scim_provisioning_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.callback_provisioning_config is not None:
            result['CallbackProvisioningConfig'] = self.callback_provisioning_config.to_map()
        if self.config_operate_mode is not None:
            result['ConfigOperateMode'] = self.config_operate_mode
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.provision_jwks_endpoint is not None:
            result['ProvisionJwksEndpoint'] = self.provision_jwks_endpoint
        if self.provision_password is not None:
            result['ProvisionPassword'] = self.provision_password
        if self.provision_protocol_type is not None:
            result['ProvisionProtocolType'] = self.provision_protocol_type
        if self.scim_provisioning_config is not None:
            result['ScimProvisioningConfig'] = self.scim_provisioning_config.to_map()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CallbackProvisioningConfig') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigCallbackProvisioningConfig()
            self.callback_provisioning_config = temp_model.from_map(m['CallbackProvisioningConfig'])
        if m.get('ConfigOperateMode') is not None:
            self.config_operate_mode = m.get('ConfigOperateMode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProvisionJwksEndpoint') is not None:
            self.provision_jwks_endpoint = m.get('ProvisionJwksEndpoint')
        if m.get('ProvisionPassword') is not None:
            self.provision_password = m.get('ProvisionPassword')
        if m.get('ProvisionProtocolType') is not None:
            self.provision_protocol_type = m.get('ProvisionProtocolType')
        if m.get('ScimProvisioningConfig') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfigScimProvisioningConfig()
            self.scim_provisioning_config = temp_model.from_map(m['ScimProvisioningConfig'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetApplicationProvisioningConfigResponseBody(TeaModel):
    def __init__(
        self,
        application_provisioning_config: GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfig = None,
        request_id: str = None,
    ):
        # The configuration of the account synchronization feature for the application.
        self.application_provisioning_config = application_provisioning_config
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.application_provisioning_config:
            self.application_provisioning_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_provisioning_config is not None:
            result['ApplicationProvisioningConfig'] = self.application_provisioning_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationProvisioningConfig') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBodyApplicationProvisioningConfig()
            self.application_provisioning_config = temp_model.from_map(m['ApplicationProvisioningConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApplicationProvisioningConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationProvisioningConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationProvisioningConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationProvisioningScopeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetApplicationProvisioningScopeResponseBodyApplicationProvisioningScope(TeaModel):
    def __init__(
        self,
        group_ids: List[str] = None,
        max_quota: int = None,
        organizational_unit_ids: List[str] = None,
        used_quota: int = None,
    ):
        # Synchronize the list of authorized groups
        self.group_ids = group_ids
        # Instance Indicates the maximum quota number of authorized agents
        self.max_quota = max_quota
        # The list of organizational units that are authorized for account synchronization.
        self.organizational_unit_ids = organizational_unit_ids
        # Indicates the quota number of used authorized agents
        self.used_quota = used_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.max_quota is not None:
            result['MaxQuota'] = self.max_quota
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.used_quota is not None:
            result['UsedQuota'] = self.used_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('MaxQuota') is not None:
            self.max_quota = m.get('MaxQuota')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('UsedQuota') is not None:
            self.used_quota = m.get('UsedQuota')
        return self


class GetApplicationProvisioningScopeResponseBody(TeaModel):
    def __init__(
        self,
        application_provisioning_scope: GetApplicationProvisioningScopeResponseBodyApplicationProvisioningScope = None,
        request_id: str = None,
    ):
        # The scope of account synchronization.
        self.application_provisioning_scope = application_provisioning_scope
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application_provisioning_scope:
            self.application_provisioning_scope.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_provisioning_scope is not None:
            result['ApplicationProvisioningScope'] = self.application_provisioning_scope.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationProvisioningScope') is not None:
            temp_model = GetApplicationProvisioningScopeResponseBodyApplicationProvisioningScope()
            self.application_provisioning_scope = temp_model.from_map(m['ApplicationProvisioningScope'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApplicationProvisioningScopeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationProvisioningScopeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationProvisioningScopeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetApplicationSsoConfigRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfigCustomClaims(TeaModel):
    def __init__(
        self,
        claim_name: str = None,
        claim_value_expression: str = None,
    ):
        # The claim name.
        self.claim_name = claim_name
        # The expression that is used to generate the value of the claim.
        self.claim_value_expression = claim_value_expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.claim_name is not None:
            result['ClaimName'] = self.claim_name
        if self.claim_value_expression is not None:
            result['ClaimValueExpression'] = self.claim_value_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClaimName') is not None:
            self.claim_name = m.get('ClaimName')
        if m.get('ClaimValueExpression') is not None:
            self.claim_value_expression = m.get('ClaimValueExpression')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfig(TeaModel):
    def __init__(
        self,
        access_token_effective_time: int = None,
        code_effective_time: int = None,
        custom_claims: List[GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfigCustomClaims] = None,
        grant_scopes: List[str] = None,
        grant_types: List[str] = None,
        id_token_effective_time: int = None,
        password_authentication_source_id: str = None,
        password_totp_mfa_required: bool = None,
        pkce_challenge_methods: List[str] = None,
        pkce_required: bool = None,
        post_logout_redirect_uris: List[str] = None,
        redirect_uris: List[str] = None,
        refresh_token_effective: int = None,
        response_types: List[str] = None,
        subject_id_expression: str = None,
    ):
        # The validity period of the issued access token. Unit: seconds. Default value: 1200.
        self.access_token_effective_time = access_token_effective_time
        # The validity period of the issued code. Unit: seconds. Default value: 60.
        self.code_effective_time = code_effective_time
        # The custom claims that are returned for the ID token.
        self.custom_claims = custom_claims
        # The scopes of user attributes that can be returned for the UserInfo endpoint or ID token.
        self.grant_scopes = grant_scopes
        # The list of grant types that are supported for OIDC protocols.
        self.grant_types = grant_types
        # The validity period of the issued ID token. Unit: seconds. Default value: 300.
        self.id_token_effective_time = id_token_effective_time
        # The ID of the identity authentication source in password mode. This parameter is returned only when the value of the GrantTypes parameter includes the password mode.
        self.password_authentication_source_id = password_authentication_source_id
        # Indicates whether time-based one-time password (TOTP) authentication is required in password mode. This parameter is returned only when the value of the GrantTypes parameter includes the password mode.
        self.password_totp_mfa_required = password_totp_mfa_required
        # The algorithms that are used to calculate the code challenge for PKCE.
        self.pkce_challenge_methods = pkce_challenge_methods
        # Indicates whether the SSO of the application requires Proof Key for Code Exchange (PKCE) (RFC 7636).
        self.pkce_required = pkce_required
        # The list of logout redirect URIs that are supported by the application.
        self.post_logout_redirect_uris = post_logout_redirect_uris
        # The list of redirect URIs that are supported by the application.
        self.redirect_uris = redirect_uris
        # The validity period of the issued refresh token. Unit: seconds. Default value: 86400.
        self.refresh_token_effective = refresh_token_effective
        # The response types that are supported by the application. This parameter is returned when the value of the GrantTypes parameter includes the implicit mode.
        self.response_types = response_types
        # The custom expression that is used to generate the subject ID returned for the ID token.
        self.subject_id_expression = subject_id_expression

    def validate(self):
        if self.custom_claims:
            for k in self.custom_claims:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token_effective_time is not None:
            result['AccessTokenEffectiveTime'] = self.access_token_effective_time
        if self.code_effective_time is not None:
            result['CodeEffectiveTime'] = self.code_effective_time
        result['CustomClaims'] = []
        if self.custom_claims is not None:
            for k in self.custom_claims:
                result['CustomClaims'].append(k.to_map() if k else None)
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.grant_types is not None:
            result['GrantTypes'] = self.grant_types
        if self.id_token_effective_time is not None:
            result['IdTokenEffectiveTime'] = self.id_token_effective_time
        if self.password_authentication_source_id is not None:
            result['PasswordAuthenticationSourceId'] = self.password_authentication_source_id
        if self.password_totp_mfa_required is not None:
            result['PasswordTotpMfaRequired'] = self.password_totp_mfa_required
        if self.pkce_challenge_methods is not None:
            result['PkceChallengeMethods'] = self.pkce_challenge_methods
        if self.pkce_required is not None:
            result['PkceRequired'] = self.pkce_required
        if self.post_logout_redirect_uris is not None:
            result['PostLogoutRedirectUris'] = self.post_logout_redirect_uris
        if self.redirect_uris is not None:
            result['RedirectUris'] = self.redirect_uris
        if self.refresh_token_effective is not None:
            result['RefreshTokenEffective'] = self.refresh_token_effective
        if self.response_types is not None:
            result['ResponseTypes'] = self.response_types
        if self.subject_id_expression is not None:
            result['SubjectIdExpression'] = self.subject_id_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessTokenEffectiveTime') is not None:
            self.access_token_effective_time = m.get('AccessTokenEffectiveTime')
        if m.get('CodeEffectiveTime') is not None:
            self.code_effective_time = m.get('CodeEffectiveTime')
        self.custom_claims = []
        if m.get('CustomClaims') is not None:
            for k in m.get('CustomClaims'):
                temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfigCustomClaims()
                self.custom_claims.append(temp_model.from_map(k))
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('GrantTypes') is not None:
            self.grant_types = m.get('GrantTypes')
        if m.get('IdTokenEffectiveTime') is not None:
            self.id_token_effective_time = m.get('IdTokenEffectiveTime')
        if m.get('PasswordAuthenticationSourceId') is not None:
            self.password_authentication_source_id = m.get('PasswordAuthenticationSourceId')
        if m.get('PasswordTotpMfaRequired') is not None:
            self.password_totp_mfa_required = m.get('PasswordTotpMfaRequired')
        if m.get('PkceChallengeMethods') is not None:
            self.pkce_challenge_methods = m.get('PkceChallengeMethods')
        if m.get('PkceRequired') is not None:
            self.pkce_required = m.get('PkceRequired')
        if m.get('PostLogoutRedirectUris') is not None:
            self.post_logout_redirect_uris = m.get('PostLogoutRedirectUris')
        if m.get('RedirectUris') is not None:
            self.redirect_uris = m.get('RedirectUris')
        if m.get('RefreshTokenEffective') is not None:
            self.refresh_token_effective = m.get('RefreshTokenEffective')
        if m.get('ResponseTypes') is not None:
            self.response_types = m.get('ResponseTypes')
        if m.get('SubjectIdExpression') is not None:
            self.subject_id_expression = m.get('SubjectIdExpression')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigProtocolEndpointDomain(TeaModel):
    def __init__(
        self,
        oauth_2authorization_endpoint: str = None,
        oauth_2device_authorization_endpoint: str = None,
        oauth_2revoke_endpoint: str = None,
        oauth_2token_endpoint: str = None,
        oauth_2userinfo_endpoint: str = None,
        oidc_issuer: str = None,
        oidc_jwks_endpoint: str = None,
        oidc_logout_endpoint: str = None,
        saml_meta_endpoint: str = None,
        saml_sso_endpoint: str = None,
    ):
        # The OAuth2.0 authorization endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oauth_2authorization_endpoint = oauth_2authorization_endpoint
        # The OAuth2.0 device authorization endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oauth_2device_authorization_endpoint = oauth_2device_authorization_endpoint
        # The OAuth2.0 token revocation endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oauth_2revoke_endpoint = oauth_2revoke_endpoint
        # The OAuth2.0 token endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oauth_2token_endpoint = oauth_2token_endpoint
        # The OIDC UserInfo endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oauth_2userinfo_endpoint = oauth_2userinfo_endpoint
        # The information about the OIDC issuer. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oidc_issuer = oidc_issuer
        # The JSON Web Key Set (JWKS) URL of the OIDC issuer. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oidc_jwks_endpoint = oidc_jwks_endpoint
        # The OIDC relying party (RP)-initiated logout endpoint. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oidc_logout_endpoint = oidc_logout_endpoint
        # The metadata URL of the SAML protocol. This parameter is returned only when the SSO protocol of the application is SAML 2.0.
        self.saml_meta_endpoint = saml_meta_endpoint
        # The request receiving URL of the SAML protocol. This parameter is returned only when the SSO protocol of the application is SAML 2.0.
        self.saml_sso_endpoint = saml_sso_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oauth_2authorization_endpoint is not None:
            result['Oauth2AuthorizationEndpoint'] = self.oauth_2authorization_endpoint
        if self.oauth_2device_authorization_endpoint is not None:
            result['Oauth2DeviceAuthorizationEndpoint'] = self.oauth_2device_authorization_endpoint
        if self.oauth_2revoke_endpoint is not None:
            result['Oauth2RevokeEndpoint'] = self.oauth_2revoke_endpoint
        if self.oauth_2token_endpoint is not None:
            result['Oauth2TokenEndpoint'] = self.oauth_2token_endpoint
        if self.oauth_2userinfo_endpoint is not None:
            result['Oauth2UserinfoEndpoint'] = self.oauth_2userinfo_endpoint
        if self.oidc_issuer is not None:
            result['OidcIssuer'] = self.oidc_issuer
        if self.oidc_jwks_endpoint is not None:
            result['OidcJwksEndpoint'] = self.oidc_jwks_endpoint
        if self.oidc_logout_endpoint is not None:
            result['OidcLogoutEndpoint'] = self.oidc_logout_endpoint
        if self.saml_meta_endpoint is not None:
            result['SamlMetaEndpoint'] = self.saml_meta_endpoint
        if self.saml_sso_endpoint is not None:
            result['SamlSsoEndpoint'] = self.saml_sso_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Oauth2AuthorizationEndpoint') is not None:
            self.oauth_2authorization_endpoint = m.get('Oauth2AuthorizationEndpoint')
        if m.get('Oauth2DeviceAuthorizationEndpoint') is not None:
            self.oauth_2device_authorization_endpoint = m.get('Oauth2DeviceAuthorizationEndpoint')
        if m.get('Oauth2RevokeEndpoint') is not None:
            self.oauth_2revoke_endpoint = m.get('Oauth2RevokeEndpoint')
        if m.get('Oauth2TokenEndpoint') is not None:
            self.oauth_2token_endpoint = m.get('Oauth2TokenEndpoint')
        if m.get('Oauth2UserinfoEndpoint') is not None:
            self.oauth_2userinfo_endpoint = m.get('Oauth2UserinfoEndpoint')
        if m.get('OidcIssuer') is not None:
            self.oidc_issuer = m.get('OidcIssuer')
        if m.get('OidcJwksEndpoint') is not None:
            self.oidc_jwks_endpoint = m.get('OidcJwksEndpoint')
        if m.get('OidcLogoutEndpoint') is not None:
            self.oidc_logout_endpoint = m.get('OidcLogoutEndpoint')
        if m.get('SamlMetaEndpoint') is not None:
            self.saml_meta_endpoint = m.get('SamlMetaEndpoint')
        if m.get('SamlSsoEndpoint') is not None:
            self.saml_sso_endpoint = m.get('SamlSsoEndpoint')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigAttributeStatements(TeaModel):
    def __init__(
        self,
        attribute_name: str = None,
        attribute_value_expression: str = None,
    ):
        # The attribute name.
        self.attribute_name = attribute_name
        # The expression that is used to generate the value of the attribute.
        self.attribute_value_expression = attribute_value_expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_value_expression is not None:
            result['AttributeValueExpression'] = self.attribute_value_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValueExpression') is not None:
            self.attribute_value_expression = m.get('AttributeValueExpression')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigOptionalRelayStates(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        relay_state: str = None,
    ):
        # The display name of the RelayState
        self.display_name = display_name
        # RelayState.The user will see the display names of multiple optional redirect addresses in the application card of the application portal. After the user clicks and completes SSO, they will automatically jump to the corresponding address. This field can only be filled in after the default redirect address is filled in.
        self.relay_state = relay_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.relay_state is not None:
            result['RelayState'] = self.relay_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('RelayState') is not None:
            self.relay_state = m.get('RelayState')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfig(TeaModel):
    def __init__(
        self,
        assertion_signed: bool = None,
        attribute_statements: List[GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigAttributeStatements] = None,
        default_relay_state: str = None,
        id_pentity_id: str = None,
        name_id_format: str = None,
        name_id_value_expression: str = None,
        optional_relay_states: List[GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigOptionalRelayStates] = None,
        response_signed: bool = None,
        signature_algorithm: str = None,
        sp_entity_id: str = None,
        sp_sso_acs_url: str = None,
    ):
        # Whether the Assertion needs a signature. ResponseSigned and AssertionSigned cannot be false at the same time.
        # 
        # true: signature is required.
        # false: signature is not required.
        self.assertion_signed = assertion_signed
        # The additional user attributes in the SAML assertion.
        self.attribute_statements = attribute_statements
        # The default value of the RelayState attribute. If the SSO request is initiated in EIAM, the RelayState attribute in the SAML response is set to this default value.
        self.default_relay_state = default_relay_state
        # The custom issuer ID.
        self.id_pentity_id = id_pentity_id
        # The Format attribute of the NameID element in the SAML assertion. Valid values:
        # 
        # *   urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified: No format is specified. How to resolve the NameID element depends on the application.
        # *   urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress: The NameID element must be an email address.
        # *   urn:oasis:names:tc:SAML:2.0:nameid-format:persistent: The NameID element must be persistent.
        # *   urn:oasis:names:tc:SAML:2.0:nameid-format:transient: The NameID element must be transient.
        self.name_id_format = name_id_format
        # The expression that is used to generate the value of NameID in the SAML assertion.
        self.name_id_value_expression = name_id_value_expression
        # Optional RelayState. The user will see the display names of multiple optional redirect addresses in the application card of the application portal. After the user clicks and completes SSO, they will automatically jump to the corresponding address. This field can only be filled in after the default redirect address is filled in.
        self.optional_relay_states = optional_relay_states
        # Whether the response needs to be signed. ResponseSigned and AssertionSigned cannot be false at the same time.
        # 
        # true: signature is required.
        # false: signature is not required.
        self.response_signed = response_signed
        # The algorithm that is used to calculate the signature for the SAML assertion.
        self.signature_algorithm = signature_algorithm
        # The entity ID of the application in SAML. The application assumes the role of service provider.
        self.sp_entity_id = sp_entity_id
        # The Assertion Consumer Service (ACS) URL of the application in SAML. The application assumes the role of service provider.
        self.sp_sso_acs_url = sp_sso_acs_url

    def validate(self):
        if self.attribute_statements:
            for k in self.attribute_statements:
                if k:
                    k.validate()
        if self.optional_relay_states:
            for k in self.optional_relay_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assertion_signed is not None:
            result['AssertionSigned'] = self.assertion_signed
        result['AttributeStatements'] = []
        if self.attribute_statements is not None:
            for k in self.attribute_statements:
                result['AttributeStatements'].append(k.to_map() if k else None)
        if self.default_relay_state is not None:
            result['DefaultRelayState'] = self.default_relay_state
        if self.id_pentity_id is not None:
            result['IdPEntityId'] = self.id_pentity_id
        if self.name_id_format is not None:
            result['NameIdFormat'] = self.name_id_format
        if self.name_id_value_expression is not None:
            result['NameIdValueExpression'] = self.name_id_value_expression
        result['OptionalRelayStates'] = []
        if self.optional_relay_states is not None:
            for k in self.optional_relay_states:
                result['OptionalRelayStates'].append(k.to_map() if k else None)
        if self.response_signed is not None:
            result['ResponseSigned'] = self.response_signed
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.sp_entity_id is not None:
            result['SpEntityId'] = self.sp_entity_id
        if self.sp_sso_acs_url is not None:
            result['SpSsoAcsUrl'] = self.sp_sso_acs_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssertionSigned') is not None:
            self.assertion_signed = m.get('AssertionSigned')
        self.attribute_statements = []
        if m.get('AttributeStatements') is not None:
            for k in m.get('AttributeStatements'):
                temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigAttributeStatements()
                self.attribute_statements.append(temp_model.from_map(k))
        if m.get('DefaultRelayState') is not None:
            self.default_relay_state = m.get('DefaultRelayState')
        if m.get('IdPEntityId') is not None:
            self.id_pentity_id = m.get('IdPEntityId')
        if m.get('NameIdFormat') is not None:
            self.name_id_format = m.get('NameIdFormat')
        if m.get('NameIdValueExpression') is not None:
            self.name_id_value_expression = m.get('NameIdValueExpression')
        self.optional_relay_states = []
        if m.get('OptionalRelayStates') is not None:
            for k in m.get('OptionalRelayStates'):
                temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfigOptionalRelayStates()
                self.optional_relay_states.append(temp_model.from_map(k))
        if m.get('ResponseSigned') is not None:
            self.response_signed = m.get('ResponseSigned')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('SpEntityId') is not None:
            self.sp_entity_id = m.get('SpEntityId')
        if m.get('SpSsoAcsUrl') is not None:
            self.sp_sso_acs_url = m.get('SpSsoAcsUrl')
        return self


class GetApplicationSsoConfigResponseBodyApplicationSsoConfig(TeaModel):
    def __init__(
        self,
        init_login_type: str = None,
        init_login_url: str = None,
        oidc_sso_config: GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfig = None,
        protocol_endpoint_domain: GetApplicationSsoConfigResponseBodyApplicationSsoConfigProtocolEndpointDomain = None,
        saml_sso_config: GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfig = None,
        sso_status: str = None,
    ):
        # The initial SSO method. Valid values:
        # 
        # *   only_app_init_sso: Only application-initiated SSO is allowed. This method is selected by default when the SSO protocol of the application is an OIDC protocol. If this method is selected when the SSO protocol of the application is SAML, the InitLoginUrl parameter is required.
        # *   idaas_or_app_init_sso: IDaaS-initiated SSO and application-initiated SSO are allowed. This method is selected by default when the SSO protocol of the application is SAML. If this method is selected when the SSO protocol of the application is an OIDC protocol, the InitLoginUrl parameter is required.
        self.init_login_type = init_login_type
        # The initial webhook URL of SSO. This parameter is required when the SSO protocol of the application is an OIDC protocol and the InitLoginType parameters is set to idaas_or_app_init_sso or when the SSO protocol of the application is SAML and the InitLoginType parameter is set to only_app_init_sso.
        self.init_login_url = init_login_url
        # The Open ID Connect (OIDC)-based SSO configuration attributes of the application. This parameter is returned only when the SSO protocol of the application is an OIDC protocol.
        self.oidc_sso_config = oidc_sso_config
        # The configuration of the metadata endpoint provided by the application.
        self.protocol_endpoint_domain = protocol_endpoint_domain
        # The Security Assertion Markup Language (SAML)-based SSO configuration attributes of the application. This parameter is returned only if the SSO protocol of the application is SAML 2.0.
        self.saml_sso_config = saml_sso_config
        # The SSO feature status of the application. Valid values:
        # 
        # *   enabled: The feature is enabled.
        # *   disabled: The feature is disabled.
        self.sso_status = sso_status

    def validate(self):
        if self.oidc_sso_config:
            self.oidc_sso_config.validate()
        if self.protocol_endpoint_domain:
            self.protocol_endpoint_domain.validate()
        if self.saml_sso_config:
            self.saml_sso_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.init_login_type is not None:
            result['InitLoginType'] = self.init_login_type
        if self.init_login_url is not None:
            result['InitLoginUrl'] = self.init_login_url
        if self.oidc_sso_config is not None:
            result['OidcSsoConfig'] = self.oidc_sso_config.to_map()
        if self.protocol_endpoint_domain is not None:
            result['ProtocolEndpointDomain'] = self.protocol_endpoint_domain.to_map()
        if self.saml_sso_config is not None:
            result['SamlSsoConfig'] = self.saml_sso_config.to_map()
        if self.sso_status is not None:
            result['SsoStatus'] = self.sso_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InitLoginType') is not None:
            self.init_login_type = m.get('InitLoginType')
        if m.get('InitLoginUrl') is not None:
            self.init_login_url = m.get('InitLoginUrl')
        if m.get('OidcSsoConfig') is not None:
            temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigOidcSsoConfig()
            self.oidc_sso_config = temp_model.from_map(m['OidcSsoConfig'])
        if m.get('ProtocolEndpointDomain') is not None:
            temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigProtocolEndpointDomain()
            self.protocol_endpoint_domain = temp_model.from_map(m['ProtocolEndpointDomain'])
        if m.get('SamlSsoConfig') is not None:
            temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfigSamlSsoConfig()
            self.saml_sso_config = temp_model.from_map(m['SamlSsoConfig'])
        if m.get('SsoStatus') is not None:
            self.sso_status = m.get('SsoStatus')
        return self


class GetApplicationSsoConfigResponseBody(TeaModel):
    def __init__(
        self,
        application_sso_config: GetApplicationSsoConfigResponseBodyApplicationSsoConfig = None,
        request_id: str = None,
    ):
        # The single sign-on (SSO) configuration information of the application.
        self.application_sso_config = application_sso_config
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application_sso_config:
            self.application_sso_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_sso_config is not None:
            result['ApplicationSsoConfig'] = self.application_sso_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationSsoConfig') is not None:
            temp_model = GetApplicationSsoConfigResponseBodyApplicationSsoConfig()
            self.application_sso_config = temp_model.from_map(m['ApplicationSsoConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetApplicationSsoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetApplicationSsoConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetApplicationSsoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        instance_id: str = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigApplications(TeaModel):
    def __init__(
        self,
        exclude_applications: List[str] = None,
        include_applications: List[str] = None,
    ):
        # Excluded applications
        self.exclude_applications = exclude_applications
        # Selected applications
        self.include_applications = include_applications

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_applications is not None:
            result['ExcludeApplications'] = self.exclude_applications
        if self.include_applications is not None:
            result['IncludeApplications'] = self.include_applications
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeApplications') is not None:
            self.exclude_applications = m.get('ExcludeApplications')
        if m.get('IncludeApplications') is not None:
            self.include_applications = m.get('IncludeApplications')
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigNetworkZones(TeaModel):
    def __init__(
        self,
        exclude_network_zones: List[str] = None,
        include_network_zones: List[str] = None,
    ):
        # Excluded network zones
        self.exclude_network_zones = exclude_network_zones
        # Included network zones
        self.include_network_zones = include_network_zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_network_zones is not None:
            result['ExcludeNetworkZones'] = self.exclude_network_zones
        if self.include_network_zones is not None:
            result['IncludeNetworkZones'] = self.include_network_zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeNetworkZones') is not None:
            self.exclude_network_zones = m.get('ExcludeNetworkZones')
        if m.get('IncludeNetworkZones') is not None:
            self.include_network_zones = m.get('IncludeNetworkZones')
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigUsers(TeaModel):
    def __init__(
        self,
        exclude_groups: List[str] = None,
        exclude_organizational_units: List[str] = None,
        exclude_users: List[str] = None,
        include_groups: List[str] = None,
        include_organizational_units: List[str] = None,
        include_users: List[str] = None,
    ):
        # Excluded user groups
        self.exclude_groups = exclude_groups
        # Excluded organizations
        self.exclude_organizational_units = exclude_organizational_units
        # Excluded users
        self.exclude_users = exclude_users
        # Selected user groups
        self.include_groups = include_groups
        # Included organizations
        self.include_organizational_units = include_organizational_units
        # Selected users
        self.include_users = include_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_groups is not None:
            result['ExcludeGroups'] = self.exclude_groups
        if self.exclude_organizational_units is not None:
            result['ExcludeOrganizationalUnits'] = self.exclude_organizational_units
        if self.exclude_users is not None:
            result['ExcludeUsers'] = self.exclude_users
        if self.include_groups is not None:
            result['IncludeGroups'] = self.include_groups
        if self.include_organizational_units is not None:
            result['IncludeOrganizationalUnits'] = self.include_organizational_units
        if self.include_users is not None:
            result['IncludeUsers'] = self.include_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeGroups') is not None:
            self.exclude_groups = m.get('ExcludeGroups')
        if m.get('ExcludeOrganizationalUnits') is not None:
            self.exclude_organizational_units = m.get('ExcludeOrganizationalUnits')
        if m.get('ExcludeUsers') is not None:
            self.exclude_users = m.get('ExcludeUsers')
        if m.get('IncludeGroups') is not None:
            self.include_groups = m.get('IncludeGroups')
        if m.get('IncludeOrganizationalUnits') is not None:
            self.include_organizational_units = m.get('IncludeOrganizationalUnits')
        if m.get('IncludeUsers') is not None:
            self.include_users = m.get('IncludeUsers')
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfig(TeaModel):
    def __init__(
        self,
        applications: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigApplications = None,
        network_zones: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigNetworkZones = None,
        users: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigUsers = None,
    ):
        # Target applications of the conditional access policy
        self.applications = applications
        # Network zones for the conditional access policy
        self.network_zones = network_zones
        # Target users of the conditional access policy
        self.users = users

    def validate(self):
        if self.applications:
            self.applications.validate()
        if self.network_zones:
            self.network_zones.validate()
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applications is not None:
            result['Applications'] = self.applications.to_map()
        if self.network_zones is not None:
            result['NetworkZones'] = self.network_zones.to_map()
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applications') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigApplications()
            self.applications = temp_model.from_map(m['Applications'])
        if m.get('NetworkZones') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigNetworkZones()
            self.network_zones = temp_model.from_map(m['NetworkZones'])
        if m.get('Users') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfigUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyDecisionConfig(TeaModel):
    def __init__(
        self,
        active_session_reuse_status: str = None,
        effect: str = None,
        mfa_authentication_interval_seconds: int = None,
        mfa_authentication_methods: List[str] = None,
        mfa_type: str = None,
    ):
        # Whether to enable session reuse
        self.active_session_reuse_status = active_session_reuse_status
        # Decision action of the conditional access policy
        self.effect = effect
        # Re-authentication interval (in seconds) for the conditional access policy
        self.mfa_authentication_interval_seconds = mfa_authentication_interval_seconds
        # Allowed MFA types for the conditional access policy
        self.mfa_authentication_methods = mfa_authentication_methods
        # MFA authentication type of the conditional access policy
        self.mfa_type = mfa_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_reuse_status is not None:
            result['ActiveSessionReuseStatus'] = self.active_session_reuse_status
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.mfa_authentication_interval_seconds is not None:
            result['MfaAuthenticationIntervalSeconds'] = self.mfa_authentication_interval_seconds
        if self.mfa_authentication_methods is not None:
            result['MfaAuthenticationMethods'] = self.mfa_authentication_methods
        if self.mfa_type is not None:
            result['MfaType'] = self.mfa_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionReuseStatus') is not None:
            self.active_session_reuse_status = m.get('ActiveSessionReuseStatus')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('MfaAuthenticationIntervalSeconds') is not None:
            self.mfa_authentication_interval_seconds = m.get('MfaAuthenticationIntervalSeconds')
        if m.get('MfaAuthenticationMethods') is not None:
            self.mfa_authentication_methods = m.get('MfaAuthenticationMethods')
        if m.get('MfaType') is not None:
            self.mfa_type = m.get('MfaType')
        return self


class GetConditionalAccessPolicyResponseBodyConditionalAccessPolicy(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        conditional_access_policy_name: str = None,
        conditional_access_policy_type: str = None,
        conditions_config: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfig = None,
        create_time: int = None,
        decision_config: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyDecisionConfig = None,
        decision_type: str = None,
        description: str = None,
        evaluate_at: str = None,
        instance_id: str = None,
        last_updated_time: int = None,
        priority: int = None,
        status: str = None,
    ):
        # Conditional Access Policy ID
        self.conditional_access_policy_id = conditional_access_policy_id
        # Conditional Access Policy Name
        self.conditional_access_policy_name = conditional_access_policy_name
        # Type of the conditional access policy
        self.conditional_access_policy_type = conditional_access_policy_type
        # Conditional access policy content
        self.conditions_config = conditions_config
        # Creation time
        self.create_time = create_time
        # Action of the conditional access policy
        self.decision_config = decision_config
        # Execution type of the conditional access policy
        self.decision_type = decision_type
        # Description of the conditional access policy
        self.description = description
        # Execution point of the conditional access policy
        self.evaluate_at = evaluate_at
        # Instance ID
        self.instance_id = instance_id
        # Last updated time
        self.last_updated_time = last_updated_time
        # Priority
        self.priority = priority
        # Enable or disable status of the conditional access policy
        self.status = status

    def validate(self):
        if self.conditions_config:
            self.conditions_config.validate()
        if self.decision_config:
            self.decision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.conditional_access_policy_name is not None:
            result['ConditionalAccessPolicyName'] = self.conditional_access_policy_name
        if self.conditional_access_policy_type is not None:
            result['ConditionalAccessPolicyType'] = self.conditional_access_policy_type
        if self.conditions_config is not None:
            result['ConditionsConfig'] = self.conditions_config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.decision_config is not None:
            result['DecisionConfig'] = self.decision_config.to_map()
        if self.decision_type is not None:
            result['DecisionType'] = self.decision_type
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluate_at is not None:
            result['EvaluateAt'] = self.evaluate_at
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_updated_time is not None:
            result['LastUpdatedTime'] = self.last_updated_time
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('ConditionalAccessPolicyName') is not None:
            self.conditional_access_policy_name = m.get('ConditionalAccessPolicyName')
        if m.get('ConditionalAccessPolicyType') is not None:
            self.conditional_access_policy_type = m.get('ConditionalAccessPolicyType')
        if m.get('ConditionsConfig') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyConditionsConfig()
            self.conditions_config = temp_model.from_map(m['ConditionsConfig'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DecisionConfig') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicyDecisionConfig()
            self.decision_config = temp_model.from_map(m['DecisionConfig'])
        if m.get('DecisionType') is not None:
            self.decision_type = m.get('DecisionType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluateAt') is not None:
            self.evaluate_at = m.get('EvaluateAt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUpdatedTime') is not None:
            self.last_updated_time = m.get('LastUpdatedTime')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        conditional_access_policy: GetConditionalAccessPolicyResponseBodyConditionalAccessPolicy = None,
        request_id: str = None,
    ):
        # Details of the conditional access policy
        self.conditional_access_policy = conditional_access_policy
        # Request ID.
        self.request_id = request_id

    def validate(self):
        if self.conditional_access_policy:
            self.conditional_access_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy is not None:
            result['ConditionalAccessPolicy'] = self.conditional_access_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicy') is not None:
            temp_model = GetConditionalAccessPolicyResponseBodyConditionalAccessPolicy()
            self.conditional_access_policy = temp_model.from_map(m['ConditionalAccessPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDomainRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDomainResponseBodyDomainFiling(TeaModel):
    def __init__(
        self,
        icp_number: str = None,
    ):
        # 域名关联的备案号, 长度最大限制64。
        self.icp_number = icp_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icp_number is not None:
            result['IcpNumber'] = self.icp_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IcpNumber') is not None:
            self.icp_number = m.get('IcpNumber')
        return self


class GetDomainResponseBodyDomain(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        default_domain: bool = None,
        domain: str = None,
        domain_id: str = None,
        domain_type: str = None,
        filing: GetDomainResponseBodyDomainFiling = None,
        instance_id: str = None,
        lock_mode: str = None,
        update_time: int = None,
    ):
        # 域名创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 是否默认域名。true表示实例默认域名，false表示非默认域名
        self.default_domain = default_domain
        # 域名。
        self.domain = domain
        # 域名ID。
        self.domain_id = domain_id
        # 域名类型。枚举取值:system_init(系统初始化)、user_custom(用户自定义)。
        self.domain_type = domain_type
        # 域名备案信息。
        self.filing = filing
        # 实例ID。
        self.instance_id = instance_id
        # 域名锁定状态。枚举取值:unlock(正常)、lockByLicense(因License限制不可用)。
        self.lock_mode = lock_mode
        # 域名最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time

    def validate(self):
        if self.filing:
            self.filing.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.default_domain is not None:
            result['DefaultDomain'] = self.default_domain
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.filing is not None:
            result['Filing'] = self.filing.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DefaultDomain') is not None:
            self.default_domain = m.get('DefaultDomain')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('Filing') is not None:
            temp_model = GetDomainResponseBodyDomainFiling()
            self.filing = temp_model.from_map(m['Filing'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetDomainResponseBody(TeaModel):
    def __init__(
        self,
        domain: GetDomainResponseBodyDomain = None,
        request_id: str = None,
    ):
        self.domain = domain
        self.request_id = request_id

    def validate(self):
        if self.domain:
            self.domain.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            temp_model = GetDomainResponseBodyDomain()
            self.domain = temp_model.from_map(m['Domain'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDomainDnsChallengeRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        instance_id: str = None,
    ):
        # 域名。
        # 
        # This parameter is required.
        self.domain = domain
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDomainDnsChallengeResponseBodyDomainDnsChallenge(TeaModel):
    def __init__(
        self,
        dns_challenge_name: str = None,
        dns_challenge_value: str = None,
        dns_type: str = None,
    ):
        # DNS challenge名称。
        self.dns_challenge_name = dns_challenge_name
        # DNS challenge值。
        self.dns_challenge_value = dns_challenge_value
        # DNS记录类型。
        self.dns_type = dns_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_challenge_name is not None:
            result['DnsChallengeName'] = self.dns_challenge_name
        if self.dns_challenge_value is not None:
            result['DnsChallengeValue'] = self.dns_challenge_value
        if self.dns_type is not None:
            result['DnsType'] = self.dns_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsChallengeName') is not None:
            self.dns_challenge_name = m.get('DnsChallengeName')
        if m.get('DnsChallengeValue') is not None:
            self.dns_challenge_value = m.get('DnsChallengeValue')
        if m.get('DnsType') is not None:
            self.dns_type = m.get('DnsType')
        return self


class GetDomainDnsChallengeResponseBody(TeaModel):
    def __init__(
        self,
        domain_dns_challenge: GetDomainDnsChallengeResponseBodyDomainDnsChallenge = None,
        request_id: str = None,
    ):
        self.domain_dns_challenge = domain_dns_challenge
        self.request_id = request_id

    def validate(self):
        if self.domain_dns_challenge:
            self.domain_dns_challenge.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_dns_challenge is not None:
            result['DomainDnsChallenge'] = self.domain_dns_challenge.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainDnsChallenge') is not None:
            temp_model = GetDomainDnsChallengeResponseBodyDomainDnsChallenge()
            self.domain_dns_challenge = temp_model.from_map(m['DomainDnsChallenge'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDomainDnsChallengeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDomainDnsChallengeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDomainDnsChallengeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetForgetPasswordConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetForgetPasswordConfigurationResponseBodyOpenForgetPasswordConfiguration(TeaModel):
    def __init__(
        self,
        authentication_channels: List[str] = None,
        enable: bool = None,
        enable_email: bool = None,
        enable_sms: bool = None,
        forget_password_status: str = None,
    ):
        # 表示忘记密码认证渠道。枚举取值:email(邮件)、sms(短信)
        self.authentication_channels = authentication_channels
        # Indicates whether the forgot password feature is enabled.
        self.enable = enable
        # Indicates whether email authentication is enabled for the forgot password feature.
        self.enable_email = enable_email
        # Indicates whether Short Message Service (SMS) authentication is enabled for the forgot password feature.
        self.enable_sms = enable_sms
        # 表示忘记密码配置状态。枚举取值:enabled(开启)、disabled(禁用)
        self.forget_password_status = forget_password_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authentication_channels is not None:
            result['AuthenticationChannels'] = self.authentication_channels
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.enable_email is not None:
            result['EnableEmail'] = self.enable_email
        if self.enable_sms is not None:
            result['EnableSms'] = self.enable_sms
        if self.forget_password_status is not None:
            result['ForgetPasswordStatus'] = self.forget_password_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthenticationChannels') is not None:
            self.authentication_channels = m.get('AuthenticationChannels')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EnableEmail') is not None:
            self.enable_email = m.get('EnableEmail')
        if m.get('EnableSms') is not None:
            self.enable_sms = m.get('EnableSms')
        if m.get('ForgetPasswordStatus') is not None:
            self.forget_password_status = m.get('ForgetPasswordStatus')
        return self


class GetForgetPasswordConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        open_forget_password_configuration: GetForgetPasswordConfigurationResponseBodyOpenForgetPasswordConfiguration = None,
        request_id: str = None,
    ):
        # The forgot password configurations.
        self.open_forget_password_configuration = open_forget_password_configuration
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.open_forget_password_configuration:
            self.open_forget_password_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_forget_password_configuration is not None:
            result['OpenForgetPasswordConfiguration'] = self.open_forget_password_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpenForgetPasswordConfiguration') is not None:
            temp_model = GetForgetPasswordConfigurationResponseBodyOpenForgetPasswordConfiguration()
            self.open_forget_password_configuration = temp_model.from_map(m['OpenForgetPasswordConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetForgetPasswordConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetForgetPasswordConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetForgetPasswordConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instance_id: str = None,
    ):
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        group_external_id: str = None,
        group_id: str = None,
        group_name: str = None,
        group_source_id: str = None,
        group_source_type: str = None,
        instance_id: str = None,
        update_time: int = None,
    ):
        # The time at which the group was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The description of the group.
        self.description = description
        # The external ID of the group, which can be used to associate the group with an external system. By default, the external ID is the group ID.
        self.group_external_id = group_external_id
        # The group ID.
        self.group_id = group_id
        # The name of the group.
        self.group_name = group_name
        # The source ID of the group. By default, the source ID is the instance ID.
        self.group_source_id = group_source_id
        # The source type of the group. Only build_in may be returned, which indicates that the group was created in IDaaS.
        # 
        # *build_in:Create By Self.
        self.group_source_type = group_source_type
        # The instance ID.
        self.instance_id = instance_id
        # The time at which the group was last updated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_external_id is not None:
            result['GroupExternalId'] = self.group_external_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_source_id is not None:
            result['GroupSourceId'] = self.group_source_id
        if self.group_source_type is not None:
            result['GroupSourceType'] = self.group_source_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupExternalId') is not None:
            self.group_external_id = m.get('GroupExternalId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupSourceId') is not None:
            self.group_source_id = m.get('GroupSourceId')
        if m.get('GroupSourceType') is not None:
            self.group_source_type = m.get('GroupSourceType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetGroupResponseBody(TeaModel):
    def __init__(
        self,
        group: GetGroupResponseBodyGroup = None,
        request_id: str = None,
    ):
        # The information about the account group.
        self.group = group
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Group') is not None:
            temp_model = GetGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIdentityProviderRequest(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkAppConfig(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        app_secret: str = None,
        corp_id: str = None,
        dingtalk_version: str = None,
    ):
        # IDaaS EIAM 钉钉一方应用的AppKey
        self.app_key = app_key
        # IDaaS EIAM 钉钉一方应用的AppSecret
        self.app_secret = app_secret
        # IDaaS EIAM 钉钉一方应用的corpId
        self.corp_id = corp_id
        # IDaaS EIAM 钉钉版本
        self.dingtalk_version = dingtalk_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.dingtalk_version is not None:
            result['DingtalkVersion'] = self.dingtalk_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('DingtalkVersion') is not None:
            self.dingtalk_version = m.get('DingtalkVersion')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedDepartmentIds(TeaModel):
    def __init__(
        self,
        dept_id: str = None,
        dept_name: str = None,
    ):
        # 钉钉部门Id
        self.dept_id = dept_id
        # 钉钉部门名称
        self.dept_name = dept_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_id is not None:
            result['DeptId'] = self.dept_id
        if self.dept_name is not None:
            result['DeptName'] = self.dept_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeptId') is not None:
            self.dept_id = m.get('DeptId')
        if m.get('DeptName') is not None:
            self.dept_name = m.get('DeptName')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedUsers(TeaModel):
    def __init__(
        self,
        name: str = None,
        user_id: str = None,
    ):
        # 钉钉用户名称
        self.name = name
        # 钉钉用户userId
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfig(TeaModel):
    def __init__(
        self,
        authed_department_ids: List[GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedDepartmentIds] = None,
        authed_users: List[GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedUsers] = None,
        corp_id: str = None,
        corp_name: str = None,
    ):
        # 授权的钉钉部门
        self.authed_department_ids = authed_department_ids
        # 授权的钉钉账户列表
        self.authed_users = authed_users
        # 钉钉企业corpId
        self.corp_id = corp_id
        # 钉钉企业名称
        self.corp_name = corp_name

    def validate(self):
        if self.authed_department_ids:
            for k in self.authed_department_ids:
                if k:
                    k.validate()
        if self.authed_users:
            for k in self.authed_users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AuthedDepartmentIds'] = []
        if self.authed_department_ids is not None:
            for k in self.authed_department_ids:
                result['AuthedDepartmentIds'].append(k.to_map() if k else None)
        result['AuthedUsers'] = []
        if self.authed_users is not None:
            for k in self.authed_users:
                result['AuthedUsers'].append(k.to_map() if k else None)
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_name is not None:
            result['CorpName'] = self.corp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.authed_department_ids = []
        if m.get('AuthedDepartmentIds') is not None:
            for k in m.get('AuthedDepartmentIds'):
                temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedDepartmentIds()
                self.authed_department_ids.append(temp_model.from_map(k))
        self.authed_users = []
        if m.get('AuthedUsers') is not None:
            for k in m.get('AuthedUsers'):
                temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfigAuthedUsers()
                self.authed_users.append(temp_model.from_map(k))
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpName') is not None:
            self.corp_name = m.get('CorpName')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailLarkConfig(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_secret: str = None,
        encrypt_key: str = None,
        enterprise_number: str = None,
        verification_token: str = None,
    ):
        # IDaaS EIAM 飞书自建应用的corpId
        self.app_id = app_id
        # IDaaS EIAM 飞书自建应用的AppSecret
        self.app_secret = app_secret
        self.encrypt_key = encrypt_key
        # IDaaS EIAM 飞书企业编码
        self.enterprise_number = enterprise_number
        self.verification_token = verification_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.encrypt_key is not None:
            result['EncryptKey'] = self.encrypt_key
        if self.enterprise_number is not None:
            result['EnterpriseNumber'] = self.enterprise_number
        if self.verification_token is not None:
            result['VerificationToken'] = self.verification_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('EncryptKey') is not None:
            self.encrypt_key = m.get('EncryptKey')
        if m.get('EnterpriseNumber') is not None:
            self.enterprise_number = m.get('EnterpriseNumber')
        if m.get('VerificationToken') is not None:
            self.verification_token = m.get('VerificationToken')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailLdapConfig(TeaModel):
    def __init__(
        self,
        administrator_password: str = None,
        administrator_username: str = None,
        certificate_fingerprint_status: str = None,
        certificate_fingerprints: List[str] = None,
        ldap_protocol: str = None,
        ldap_server_host: str = None,
        ldap_server_port: int = None,
        start_tls_status: str = None,
    ):
        # 管理员密码
        self.administrator_password = administrator_password
        # 管理员账号
        self.administrator_username = administrator_username
        # 是否验证指纹证书
        self.certificate_fingerprint_status = certificate_fingerprint_status
        # 证书指纹列表
        self.certificate_fingerprints = certificate_fingerprints
        # 通信协议
        self.ldap_protocol = ldap_protocol
        # ad/ldap 服务器地址
        self.ldap_server_host = ldap_server_host
        # ad/ldap 服务器地址
        self.ldap_server_port = ldap_server_port
        # startTls是否开启
        self.start_tls_status = start_tls_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrator_password is not None:
            result['AdministratorPassword'] = self.administrator_password
        if self.administrator_username is not None:
            result['AdministratorUsername'] = self.administrator_username
        if self.certificate_fingerprint_status is not None:
            result['CertificateFingerprintStatus'] = self.certificate_fingerprint_status
        if self.certificate_fingerprints is not None:
            result['CertificateFingerprints'] = self.certificate_fingerprints
        if self.ldap_protocol is not None:
            result['LdapProtocol'] = self.ldap_protocol
        if self.ldap_server_host is not None:
            result['LdapServerHost'] = self.ldap_server_host
        if self.ldap_server_port is not None:
            result['LdapServerPort'] = self.ldap_server_port
        if self.start_tls_status is not None:
            result['StartTlsStatus'] = self.start_tls_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdministratorPassword') is not None:
            self.administrator_password = m.get('AdministratorPassword')
        if m.get('AdministratorUsername') is not None:
            self.administrator_username = m.get('AdministratorUsername')
        if m.get('CertificateFingerprintStatus') is not None:
            self.certificate_fingerprint_status = m.get('CertificateFingerprintStatus')
        if m.get('CertificateFingerprints') is not None:
            self.certificate_fingerprints = m.get('CertificateFingerprints')
        if m.get('LdapProtocol') is not None:
            self.ldap_protocol = m.get('LdapProtocol')
        if m.get('LdapServerHost') is not None:
            self.ldap_server_host = m.get('LdapServerHost')
        if m.get('LdapServerPort') is not None:
            self.ldap_server_port = m.get('LdapServerPort')
        if m.get('StartTlsStatus') is not None:
            self.start_tls_status = m.get('StartTlsStatus')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigAuthnParam(TeaModel):
    def __init__(
        self,
        authn_method: str = None,
        client_id: str = None,
        client_secret: str = None,
    ):
        # OIDC/oAuth2 认证方法。
        self.authn_method = authn_method
        # OIDC/oAuth2 客户端ID。
        self.client_id = client_id
        # OIDC/oAuth2 客户端密钥。
        self.client_secret = client_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_method is not None:
            result['AuthnMethod'] = self.authn_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnMethod') is not None:
            self.authn_method = m.get('AuthnMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigEndpointConfig(TeaModel):
    def __init__(
        self,
        authorization_endpoint: str = None,
        issuer: str = None,
        jwks_uri: str = None,
        token_endpoint: str = None,
        userinfo_endpoint: str = None,
    ):
        # oAuth2 授权端点。
        self.authorization_endpoint = authorization_endpoint
        # OIDC issuer信息。
        self.issuer = issuer
        # OIDC jwks地址。
        self.jwks_uri = jwks_uri
        # oAuth2 Token端点。
        self.token_endpoint = token_endpoint
        # OIDC 用户信息端点。
        self.userinfo_endpoint = userinfo_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_endpoint is not None:
            result['AuthorizationEndpoint'] = self.authorization_endpoint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.jwks_uri is not None:
            result['JwksUri'] = self.jwks_uri
        if self.token_endpoint is not None:
            result['TokenEndpoint'] = self.token_endpoint
        if self.userinfo_endpoint is not None:
            result['UserinfoEndpoint'] = self.userinfo_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationEndpoint') is not None:
            self.authorization_endpoint = m.get('AuthorizationEndpoint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('JwksUri') is not None:
            self.jwks_uri = m.get('JwksUri')
        if m.get('TokenEndpoint') is not None:
            self.token_endpoint = m.get('TokenEndpoint')
        if m.get('UserinfoEndpoint') is not None:
            self.userinfo_endpoint = m.get('UserinfoEndpoint')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfig(TeaModel):
    def __init__(
        self,
        authn_param: GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigAuthnParam = None,
        endpoint_config: GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigEndpointConfig = None,
        grant_scopes: List[str] = None,
        grant_type: str = None,
        pkce_challenge_method: str = None,
        pkce_required: bool = None,
    ):
        # OIDC客户端认证配置。
        self.authn_param = authn_param
        # OIDC 端点配置。
        self.endpoint_config = endpoint_config
        # OIDC标准参数，如profile、email等
        self.grant_scopes = grant_scopes
        # OIDC授权类型。
        self.grant_type = grant_type
        # 支持的PKCE算法类型。
        self.pkce_challenge_method = pkce_challenge_method
        # AuthorizationCode授权模式下是否使用PKCE。
        self.pkce_required = pkce_required

    def validate(self):
        if self.authn_param:
            self.authn_param.validate()
        if self.endpoint_config:
            self.endpoint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_param is not None:
            result['AuthnParam'] = self.authn_param.to_map()
        if self.endpoint_config is not None:
            result['EndpointConfig'] = self.endpoint_config.to_map()
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.grant_type is not None:
            result['GrantType'] = self.grant_type
        if self.pkce_challenge_method is not None:
            result['PkceChallengeMethod'] = self.pkce_challenge_method
        if self.pkce_required is not None:
            result['PkceRequired'] = self.pkce_required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnParam') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigAuthnParam()
            self.authn_param = temp_model.from_map(m['AuthnParam'])
        if m.get('EndpointConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfigEndpointConfig()
            self.endpoint_config = temp_model.from_map(m['EndpointConfig'])
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('GrantType') is not None:
            self.grant_type = m.get('GrantType')
        if m.get('PkceChallengeMethod') is not None:
            self.pkce_challenge_method = m.get('PkceChallengeMethod')
        if m.get('PkceRequired') is not None:
            self.pkce_required = m.get('PkceRequired')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfigUdSyncScopeConfig(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfig(TeaModel):
    def __init__(
        self,
        group_sync_status: str = None,
        incremental_callback_status: str = None,
        ud_sync_scope_config: GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfigUdSyncScopeConfig = None,
    ):
        self.group_sync_status = group_sync_status
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        # 同步入配置信息
        self.ud_sync_scope_config = ud_sync_scope_config

    def validate(self):
        if self.ud_sync_scope_config:
            self.ud_sync_scope_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_sync_status is not None:
            result['GroupSyncStatus'] = self.group_sync_status
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.ud_sync_scope_config is not None:
            result['UdSyncScopeConfig'] = self.ud_sync_scope_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupSyncStatus') is not None:
            self.group_sync_status = m.get('GroupSyncStatus')
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('UdSyncScopeConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfigUdSyncScopeConfig()
            self.ud_sync_scope_config = temp_model.from_map(m['UdSyncScopeConfig'])
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfigUdSyncScopeConfigs(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfig(TeaModel):
    def __init__(
        self,
        incremental_callback_status: str = None,
        ud_sync_scope_configs: List[GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfigUdSyncScopeConfigs] = None,
    ):
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        # 同步出配置信息
        self.ud_sync_scope_configs = ud_sync_scope_configs

    def validate(self):
        if self.ud_sync_scope_configs:
            for k in self.ud_sync_scope_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        result['UdSyncScopeConfigs'] = []
        if self.ud_sync_scope_configs is not None:
            for k in self.ud_sync_scope_configs:
                result['UdSyncScopeConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        self.ud_sync_scope_configs = []
        if m.get('UdSyncScopeConfigs') is not None:
            for k in m.get('UdSyncScopeConfigs'):
                temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfigUdSyncScopeConfigs()
                self.ud_sync_scope_configs.append(temp_model.from_map(k))
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetailWeComConfig(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        authorize_callback_domain: str = None,
        corp_id: str = None,
        corp_secret: str = None,
        trustable_domain: str = None,
    ):
        # IDaaS EIAM 企业微信自建应用的Id
        self.agent_id = agent_id
        # 授权回调域
        self.authorize_callback_domain = authorize_callback_domain
        # IDaaS EIAM 企业微信自建应用的corpId
        self.corp_id = corp_id
        # IDaaS EIAM 企业微信自建应用的corpSecret
        self.corp_secret = corp_secret
        # 可信域名
        self.trustable_domain = trustable_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.authorize_callback_domain is not None:
            result['AuthorizeCallbackDomain'] = self.authorize_callback_domain
        if self.corp_id is not None:
            result['CorpId'] = self.corp_id
        if self.corp_secret is not None:
            result['CorpSecret'] = self.corp_secret
        if self.trustable_domain is not None:
            result['TrustableDomain'] = self.trustable_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AuthorizeCallbackDomain') is not None:
            self.authorize_callback_domain = m.get('AuthorizeCallbackDomain')
        if m.get('CorpId') is not None:
            self.corp_id = m.get('CorpId')
        if m.get('CorpSecret') is not None:
            self.corp_secret = m.get('CorpSecret')
        if m.get('TrustableDomain') is not None:
            self.trustable_domain = m.get('TrustableDomain')
        return self


class GetIdentityProviderResponseBodyIdentityProviderDetail(TeaModel):
    def __init__(
        self,
        advanced_status: str = None,
        authn_source_supplier: str = None,
        authn_source_type: str = None,
        authn_status: str = None,
        create_time: int = None,
        description: str = None,
        dingtalk_app_config: GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkAppConfig = None,
        dingtalk_provisioning_config: GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfig = None,
        identity_provider_external_id: str = None,
        identity_provider_id: str = None,
        identity_provider_name: str = None,
        identity_provider_type: str = None,
        instance_id: str = None,
        lark_config: GetIdentityProviderResponseBodyIdentityProviderDetailLarkConfig = None,
        last_status_check_job_result: str = None,
        ldap_config: GetIdentityProviderResponseBodyIdentityProviderDetailLdapConfig = None,
        lock_reason: str = None,
        logo_url: str = None,
        network_access_endpoint_id: str = None,
        oidc_config: GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfig = None,
        ud_pull_config: GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfig = None,
        ud_pull_status: str = None,
        ud_push_config: GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfig = None,
        ud_push_status: str = None,
        update_time: int = None,
        we_com_config: GetIdentityProviderResponseBodyIdentityProviderDetailWeComConfig = None,
    ):
        # 高阶配置能力
        self.advanced_status = advanced_status
        # IDaaS EIAM 对应的认证来源产品，okta or google or azure ad
        self.authn_source_supplier = authn_source_supplier
        # IDaaS EIAM 认证方式类型 oidc or saml
        self.authn_source_type = authn_source_type
        # IDaaS EIAM 对应IdP是否支持认证
        self.authn_status = authn_status
        # 创建时间
        self.create_time = create_time
        # IDaaS EIAM 身份提供方描述
        self.description = description
        # 钉钉基础配置
        self.dingtalk_app_config = dingtalk_app_config
        # 钉钉同步配置
        self.dingtalk_provisioning_config = dingtalk_provisioning_config
        # IDaaS EIAM 身份提供方外部ID
        self.identity_provider_external_id = identity_provider_external_id
        # IDaaS EIAM 身份提供方ID
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM 身份提供方名称
        self.identity_provider_name = identity_provider_name
        # 身份提供方同步类型
        self.identity_provider_type = identity_provider_type
        # IDaaS EIAM 实例Id
        self.instance_id = instance_id
        # 飞书配置
        self.lark_config = lark_config
        # 最后一次状态检查结果
        self.last_status_check_job_result = last_status_check_job_result
        # AD/LDAP身份提供方相关信息
        self.ldap_config = ldap_config
        # 锁定原因
        self.lock_reason = lock_reason
        self.logo_url = logo_url
        # 网络端点ID
        self.network_access_endpoint_id = network_access_endpoint_id
        # OIDC IdP配置。
        self.oidc_config = oidc_config
        # 同步入配置
        self.ud_pull_config = ud_pull_config
        # IDaaS EIAM 是否支持UD同步
        self.ud_pull_status = ud_pull_status
        # 同步出配置
        self.ud_push_config = ud_push_config
        # 同步出能力
        self.ud_push_status = ud_push_status
        # 更新时间
        self.update_time = update_time
        # 企业微信
        self.we_com_config = we_com_config

    def validate(self):
        if self.dingtalk_app_config:
            self.dingtalk_app_config.validate()
        if self.dingtalk_provisioning_config:
            self.dingtalk_provisioning_config.validate()
        if self.lark_config:
            self.lark_config.validate()
        if self.ldap_config:
            self.ldap_config.validate()
        if self.oidc_config:
            self.oidc_config.validate()
        if self.ud_pull_config:
            self.ud_pull_config.validate()
        if self.ud_push_config:
            self.ud_push_config.validate()
        if self.we_com_config:
            self.we_com_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_status is not None:
            result['AdvancedStatus'] = self.advanced_status
        if self.authn_source_supplier is not None:
            result['AuthnSourceSupplier'] = self.authn_source_supplier
        if self.authn_source_type is not None:
            result['AuthnSourceType'] = self.authn_source_type
        if self.authn_status is not None:
            result['AuthnStatus'] = self.authn_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dingtalk_app_config is not None:
            result['DingtalkAppConfig'] = self.dingtalk_app_config.to_map()
        if self.dingtalk_provisioning_config is not None:
            result['DingtalkProvisioningConfig'] = self.dingtalk_provisioning_config.to_map()
        if self.identity_provider_external_id is not None:
            result['IdentityProviderExternalId'] = self.identity_provider_external_id
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.identity_provider_name is not None:
            result['IdentityProviderName'] = self.identity_provider_name
        if self.identity_provider_type is not None:
            result['IdentityProviderType'] = self.identity_provider_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lark_config is not None:
            result['LarkConfig'] = self.lark_config.to_map()
        if self.last_status_check_job_result is not None:
            result['LastStatusCheckJobResult'] = self.last_status_check_job_result
        if self.ldap_config is not None:
            result['LdapConfig'] = self.ldap_config.to_map()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.oidc_config is not None:
            result['OidcConfig'] = self.oidc_config.to_map()
        if self.ud_pull_config is not None:
            result['UdPullConfig'] = self.ud_pull_config.to_map()
        if self.ud_pull_status is not None:
            result['UdPullStatus'] = self.ud_pull_status
        if self.ud_push_config is not None:
            result['UdPushConfig'] = self.ud_push_config.to_map()
        if self.ud_push_status is not None:
            result['UdPushStatus'] = self.ud_push_status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.we_com_config is not None:
            result['WeComConfig'] = self.we_com_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedStatus') is not None:
            self.advanced_status = m.get('AdvancedStatus')
        if m.get('AuthnSourceSupplier') is not None:
            self.authn_source_supplier = m.get('AuthnSourceSupplier')
        if m.get('AuthnSourceType') is not None:
            self.authn_source_type = m.get('AuthnSourceType')
        if m.get('AuthnStatus') is not None:
            self.authn_status = m.get('AuthnStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DingtalkAppConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkAppConfig()
            self.dingtalk_app_config = temp_model.from_map(m['DingtalkAppConfig'])
        if m.get('DingtalkProvisioningConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailDingtalkProvisioningConfig()
            self.dingtalk_provisioning_config = temp_model.from_map(m['DingtalkProvisioningConfig'])
        if m.get('IdentityProviderExternalId') is not None:
            self.identity_provider_external_id = m.get('IdentityProviderExternalId')
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('IdentityProviderName') is not None:
            self.identity_provider_name = m.get('IdentityProviderName')
        if m.get('IdentityProviderType') is not None:
            self.identity_provider_type = m.get('IdentityProviderType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LarkConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailLarkConfig()
            self.lark_config = temp_model.from_map(m['LarkConfig'])
        if m.get('LastStatusCheckJobResult') is not None:
            self.last_status_check_job_result = m.get('LastStatusCheckJobResult')
        if m.get('LdapConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailLdapConfig()
            self.ldap_config = temp_model.from_map(m['LdapConfig'])
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('OidcConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailOidcConfig()
            self.oidc_config = temp_model.from_map(m['OidcConfig'])
        if m.get('UdPullConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailUdPullConfig()
            self.ud_pull_config = temp_model.from_map(m['UdPullConfig'])
        if m.get('UdPullStatus') is not None:
            self.ud_pull_status = m.get('UdPullStatus')
        if m.get('UdPushConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailUdPushConfig()
            self.ud_push_config = temp_model.from_map(m['UdPushConfig'])
        if m.get('UdPushStatus') is not None:
            self.ud_push_status = m.get('UdPushStatus')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WeComConfig') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetailWeComConfig()
            self.we_com_config = temp_model.from_map(m['WeComConfig'])
        return self


class GetIdentityProviderResponseBody(TeaModel):
    def __init__(
        self,
        identity_provider_detail: GetIdentityProviderResponseBodyIdentityProviderDetail = None,
        request_id: str = None,
    ):
        self.identity_provider_detail = identity_provider_detail
        self.request_id = request_id

    def validate(self):
        if self.identity_provider_detail:
            self.identity_provider_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_detail is not None:
            result['IdentityProviderDetail'] = self.identity_provider_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderDetail') is not None:
            temp_model = GetIdentityProviderResponseBodyIdentityProviderDetail()
            self.identity_provider_detail = temp_model.from_map(m['IdentityProviderDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetIdentityProviderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIdentityProviderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIdentityProviderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIdentityProviderUdPullConfigurationRequest(TeaModel):
    def __init__(
        self,
        identity_provider_id: str = None,
        instance_id: str = None,
    ):
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationLdapUdPullConfig(TeaModel):
    def __init__(
        self,
        group_member_attribute_name: str = None,
        group_object_class: str = None,
        group_object_class_custom_filter: str = None,
        organization_unit_object_class: str = None,
        user_object_class: str = None,
        user_object_class_custom_filter: str = None,
    ):
        # 组成员标识
        self.group_member_attribute_name = group_member_attribute_name
        # 组objectClass
        self.group_object_class = group_object_class
        # 组自定义Filter
        self.group_object_class_custom_filter = group_object_class_custom_filter
        # 组织objectClass
        self.organization_unit_object_class = organization_unit_object_class
        # 用户objectClass
        self.user_object_class = user_object_class
        # 用户自定义Filter
        self.user_object_class_custom_filter = user_object_class_custom_filter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_member_attribute_name is not None:
            result['GroupMemberAttributeName'] = self.group_member_attribute_name
        if self.group_object_class is not None:
            result['GroupObjectClass'] = self.group_object_class
        if self.group_object_class_custom_filter is not None:
            result['GroupObjectClassCustomFilter'] = self.group_object_class_custom_filter
        if self.organization_unit_object_class is not None:
            result['OrganizationUnitObjectClass'] = self.organization_unit_object_class
        if self.user_object_class is not None:
            result['UserObjectClass'] = self.user_object_class
        if self.user_object_class_custom_filter is not None:
            result['UserObjectClassCustomFilter'] = self.user_object_class_custom_filter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupMemberAttributeName') is not None:
            self.group_member_attribute_name = m.get('GroupMemberAttributeName')
        if m.get('GroupObjectClass') is not None:
            self.group_object_class = m.get('GroupObjectClass')
        if m.get('GroupObjectClassCustomFilter') is not None:
            self.group_object_class_custom_filter = m.get('GroupObjectClassCustomFilter')
        if m.get('OrganizationUnitObjectClass') is not None:
            self.organization_unit_object_class = m.get('OrganizationUnitObjectClass')
        if m.get('UserObjectClass') is not None:
            self.user_object_class = m.get('UserObjectClass')
        if m.get('UserObjectClassCustomFilter') is not None:
            self.user_object_class_custom_filter = m.get('UserObjectClassCustomFilter')
        return self


class GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPeriodicSyncConfig(TeaModel):
    def __init__(
        self,
        periodic_sync_cron: str = None,
        periodic_sync_times: int = None,
        periodic_sync_type: str = None,
    ):
        self.periodic_sync_cron = periodic_sync_cron
        self.periodic_sync_times = periodic_sync_times
        self.periodic_sync_type = periodic_sync_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.periodic_sync_cron is not None:
            result['PeriodicSyncCron'] = self.periodic_sync_cron
        if self.periodic_sync_times is not None:
            result['PeriodicSyncTimes'] = self.periodic_sync_times
        if self.periodic_sync_type is not None:
            result['PeriodicSyncType'] = self.periodic_sync_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeriodicSyncCron') is not None:
            self.periodic_sync_cron = m.get('PeriodicSyncCron')
        if m.get('PeriodicSyncTimes') is not None:
            self.periodic_sync_times = m.get('PeriodicSyncTimes')
        if m.get('PeriodicSyncType') is not None:
            self.periodic_sync_type = m.get('PeriodicSyncType')
        return self


class GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPullProtectedRule(TeaModel):
    def __init__(
        self,
        group_deleted_threshold: int = None,
        organizational_unit_deleted_threshold: int = None,
        user_deleted_threshold: int = None,
    ):
        # 同步保护规则-删除组数量
        self.group_deleted_threshold = group_deleted_threshold
        # IDaaS EIAM 钉钉一方应用同步保护规则-删除组织数量
        self.organizational_unit_deleted_threshold = organizational_unit_deleted_threshold
        # IDaaS EIAM 钉钉一方应用同步保护规则-删除账户数量
        self.user_deleted_threshold = user_deleted_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_deleted_threshold is not None:
            result['GroupDeletedThreshold'] = self.group_deleted_threshold
        if self.organizational_unit_deleted_threshold is not None:
            result['OrganizationalUnitDeletedThreshold'] = self.organizational_unit_deleted_threshold
        if self.user_deleted_threshold is not None:
            result['UserDeletedThreshold'] = self.user_deleted_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupDeletedThreshold') is not None:
            self.group_deleted_threshold = m.get('GroupDeletedThreshold')
        if m.get('OrganizationalUnitDeletedThreshold') is not None:
            self.organizational_unit_deleted_threshold = m.get('OrganizationalUnitDeletedThreshold')
        if m.get('UserDeletedThreshold') is not None:
            self.user_deleted_threshold = m.get('UserDeletedThreshold')
        return self


class GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationUdSyncScopeConfig(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfiguration(TeaModel):
    def __init__(
        self,
        group_sync_status: str = None,
        identity_provider_id: str = None,
        incremental_callback_status: str = None,
        instance_id: str = None,
        ldap_ud_pull_config: GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationLdapUdPullConfig = None,
        periodic_sync_config: GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPeriodicSyncConfig = None,
        periodic_sync_status: str = None,
        pull_protected_rule: GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPullProtectedRule = None,
        ud_sync_scope_config: GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationUdSyncScopeConfig = None,
    ):
        # 组同步状态
        self.group_sync_status = group_sync_status
        # IDaaS EIAM 身份提供方ID
        self.identity_provider_id = identity_provider_id
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        # IDaaS EIAM 实例Id
        self.instance_id = instance_id
        # ldap同步侧相关配置信息
        self.ldap_ud_pull_config = ldap_ud_pull_config
        self.periodic_sync_config = periodic_sync_config
        self.periodic_sync_status = periodic_sync_status
        # 同步入用户映射字段配置列表
        self.pull_protected_rule = pull_protected_rule
        # 同步入配置信息
        self.ud_sync_scope_config = ud_sync_scope_config

    def validate(self):
        if self.ldap_ud_pull_config:
            self.ldap_ud_pull_config.validate()
        if self.periodic_sync_config:
            self.periodic_sync_config.validate()
        if self.pull_protected_rule:
            self.pull_protected_rule.validate()
        if self.ud_sync_scope_config:
            self.ud_sync_scope_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_sync_status is not None:
            result['GroupSyncStatus'] = self.group_sync_status
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ldap_ud_pull_config is not None:
            result['LdapUdPullConfig'] = self.ldap_ud_pull_config.to_map()
        if self.periodic_sync_config is not None:
            result['PeriodicSyncConfig'] = self.periodic_sync_config.to_map()
        if self.periodic_sync_status is not None:
            result['PeriodicSyncStatus'] = self.periodic_sync_status
        if self.pull_protected_rule is not None:
            result['PullProtectedRule'] = self.pull_protected_rule.to_map()
        if self.ud_sync_scope_config is not None:
            result['UdSyncScopeConfig'] = self.ud_sync_scope_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupSyncStatus') is not None:
            self.group_sync_status = m.get('GroupSyncStatus')
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LdapUdPullConfig') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationLdapUdPullConfig()
            self.ldap_ud_pull_config = temp_model.from_map(m['LdapUdPullConfig'])
        if m.get('PeriodicSyncConfig') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPeriodicSyncConfig()
            self.periodic_sync_config = temp_model.from_map(m['PeriodicSyncConfig'])
        if m.get('PeriodicSyncStatus') is not None:
            self.periodic_sync_status = m.get('PeriodicSyncStatus')
        if m.get('PullProtectedRule') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationPullProtectedRule()
            self.pull_protected_rule = temp_model.from_map(m['PullProtectedRule'])
        if m.get('UdSyncScopeConfig') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfigurationUdSyncScopeConfig()
            self.ud_sync_scope_config = temp_model.from_map(m['UdSyncScopeConfig'])
        return self


class GetIdentityProviderUdPullConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        ud_pull_configuration: GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfiguration = None,
    ):
        self.request_id = request_id
        self.ud_pull_configuration = ud_pull_configuration

    def validate(self):
        if self.ud_pull_configuration:
            self.ud_pull_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ud_pull_configuration is not None:
            result['UdPullConfiguration'] = self.ud_pull_configuration.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UdPullConfiguration') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBodyUdPullConfiguration()
            self.ud_pull_configuration = temp_model.from_map(m['UdPullConfiguration'])
        return self


class GetIdentityProviderUdPullConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIdentityProviderUdPullConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIdentityProviderUdPullConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceResponseBodyInstanceDefaultEndpoint(TeaModel):
    def __init__(
        self,
        endpoint: str = None,
        status: str = None,
    ):
        # The endpoint of the instance.
        self.endpoint = endpoint
        # The status of the endpoint. Valid values:
        # 
        # *   resolved
        # *   unresolved
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetInstanceResponseBodyInstanceDomainConfig(TeaModel):
    def __init__(
        self,
        default_domain: str = None,
        init_domain: str = None,
        init_domain_auto_redirect_status: str = None,
    ):
        # The default domain of the instance.
        self.default_domain = default_domain
        # The init domain of the instance.
        self.init_domain = init_domain
        # Valid values:
        # 
        # *   true
        # *   false
        self.init_domain_auto_redirect_status = init_domain_auto_redirect_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_domain is not None:
            result['DefaultDomain'] = self.default_domain
        if self.init_domain is not None:
            result['InitDomain'] = self.init_domain
        if self.init_domain_auto_redirect_status is not None:
            result['InitDomainAutoRedirectStatus'] = self.init_domain_auto_redirect_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultDomain') is not None:
            self.default_domain = m.get('DefaultDomain')
        if m.get('InitDomain') is not None:
            self.init_domain = m.get('InitDomain')
        if m.get('InitDomainAutoRedirectStatus') is not None:
            self.init_domain_auto_redirect_status = m.get('InitDomainAutoRedirectStatus')
        return self


class GetInstanceResponseBodyInstance(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        default_endpoint: GetInstanceResponseBodyInstanceDefaultEndpoint = None,
        description: str = None,
        domain_config: GetInstanceResponseBodyInstanceDomainConfig = None,
        egress_addresses: List[str] = None,
        instance_id: str = None,
        status: str = None,
    ):
        # The time when the instance was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The default endpoint of the instance.
        self.default_endpoint = default_endpoint
        # The description of the instance.
        self.description = description
        # The default domain of the instance.
        self.domain_config = domain_config
        # The outbound public CIDR blocks of the instance. For example, when you synchronize Active Directory (AD) accounts, the IDaaS EIAM instance accesses your AD service by using the outbound public CIDR blocks.
        self.egress_addresses = egress_addresses
        # The instance ID.
        self.instance_id = instance_id
        # The status of the instance. Valid values:
        # 
        # *   creating
        # *   running
        self.status = status

    def validate(self):
        if self.default_endpoint:
            self.default_endpoint.validate()
        if self.domain_config:
            self.domain_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.default_endpoint is not None:
            result['DefaultEndpoint'] = self.default_endpoint.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_config is not None:
            result['DomainConfig'] = self.domain_config.to_map()
        if self.egress_addresses is not None:
            result['EgressAddresses'] = self.egress_addresses
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DefaultEndpoint') is not None:
            temp_model = GetInstanceResponseBodyInstanceDefaultEndpoint()
            self.default_endpoint = temp_model.from_map(m['DefaultEndpoint'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainConfig') is not None:
            temp_model = GetInstanceResponseBodyInstanceDomainConfig()
            self.domain_config = temp_model.from_map(m['DomainConfig'])
        if m.get('EgressAddresses') is not None:
            self.egress_addresses = m.get('EgressAddresses')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(
        self,
        instance: GetInstanceResponseBodyInstance = None,
        request_id: str = None,
    ):
        # The details of the instance.
        self.instance = instance
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            temp_model = GetInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceLicenseRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # Instance ID
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetInstanceLicenseResponseBodyLicense(TeaModel):
    def __init__(
        self,
        edition: str = None,
        end_time: int = None,
        license_charge_type: str = None,
        license_config_json: str = None,
        license_create_time: int = None,
        license_id: str = None,
        license_status: str = None,
        purchase_channel: str = None,
        purchase_instance_id: str = None,
        start_time: int = None,
        user_quota: int = None,
    ):
        # Edition of the License
        self.edition = edition
        # End date of the validity period of the License, timestamp
        self.end_time = end_time
        # Payment type of the License
        self.license_charge_type = license_charge_type
        # Detailed configuration JSON string of the License
        self.license_config_json = license_config_json
        # Creation time of the License, timestamp
        self.license_create_time = license_create_time
        # Unique identifier of the License
        self.license_id = license_id
        # Status of the License
        self.license_status = license_status
        # Purchase channel of the License
        self.purchase_channel = purchase_channel
        # Unique external product identifier corresponding to the License
        self.purchase_instance_id = purchase_instance_id
        # Start date of the validity period of the License, timestamp
        self.start_time = start_time
        # User quota of the License
        self.user_quota = user_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edition is not None:
            result['Edition'] = self.edition
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.license_charge_type is not None:
            result['LicenseChargeType'] = self.license_charge_type
        if self.license_config_json is not None:
            result['LicenseConfigJson'] = self.license_config_json
        if self.license_create_time is not None:
            result['LicenseCreateTime'] = self.license_create_time
        if self.license_id is not None:
            result['LicenseId'] = self.license_id
        if self.license_status is not None:
            result['LicenseStatus'] = self.license_status
        if self.purchase_channel is not None:
            result['PurchaseChannel'] = self.purchase_channel
        if self.purchase_instance_id is not None:
            result['PurchaseInstanceId'] = self.purchase_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user_quota is not None:
            result['UserQuota'] = self.user_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Edition') is not None:
            self.edition = m.get('Edition')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LicenseChargeType') is not None:
            self.license_charge_type = m.get('LicenseChargeType')
        if m.get('LicenseConfigJson') is not None:
            self.license_config_json = m.get('LicenseConfigJson')
        if m.get('LicenseCreateTime') is not None:
            self.license_create_time = m.get('LicenseCreateTime')
        if m.get('LicenseId') is not None:
            self.license_id = m.get('LicenseId')
        if m.get('LicenseStatus') is not None:
            self.license_status = m.get('LicenseStatus')
        if m.get('PurchaseChannel') is not None:
            self.purchase_channel = m.get('PurchaseChannel')
        if m.get('PurchaseInstanceId') is not None:
            self.purchase_instance_id = m.get('PurchaseInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UserQuota') is not None:
            self.user_quota = m.get('UserQuota')
        return self


class GetInstanceLicenseResponseBody(TeaModel):
    def __init__(
        self,
        license: GetInstanceLicenseResponseBodyLicense = None,
        request_id: str = None,
    ):
        # Returned result.
        self.license = license
        # Request ID
        self.request_id = request_id

    def validate(self):
        if self.license:
            self.license.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.license is not None:
            result['License'] = self.license.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('License') is not None:
            temp_model = GetInstanceLicenseResponseBodyLicense()
            self.license = temp_model.from_map(m['License'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInstanceLicenseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceLicenseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceLicenseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNetworkAccessEndpointRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 专属网络端点ID。
        # 
        # This parameter is required.
        self.network_access_endpoint_id = network_access_endpoint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        return self


class GetNetworkAccessEndpointResponseBodyNetworkAccessEndpoint(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        egress_private_ip_addresses: List[str] = None,
        egress_public_ip_addresses: List[str] = None,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
        network_access_endpoint_name: str = None,
        network_access_endpoint_type: str = None,
        security_group_id: str = None,
        status: str = None,
        update_time: int = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
        vpc_region_id: str = None,
    ):
        # 专属网络端点创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 网络访问端私网出口IP地址列表。
        self.egress_private_ip_addresses = egress_private_ip_addresses
        # 网络访问端点公网出口IP地址段
        self.egress_public_ip_addresses = egress_public_ip_addresses
        # 实例ID。
        self.instance_id = instance_id
        # 专属网络端点ID。
        self.network_access_endpoint_id = network_access_endpoint_id
        # 专属网络端点名称。
        self.network_access_endpoint_name = network_access_endpoint_name
        # 专属网络端点连接的类型。
        self.network_access_endpoint_type = network_access_endpoint_type
        # 专属网络端点使用的安全组ID。
        self.security_group_id = security_group_id
        # 专属网络端点状态。
        self.status = status
        # 专属网络端点最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time
        # 专属网络端点连接的指定vSwitch列表。
        self.v_switch_ids = v_switch_ids
        # 专属网络端点连接的VpcID。
        self.vpc_id = vpc_id
        # 专属网络端点连接的Vpc所属地域。
        self.vpc_region_id = vpc_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.egress_private_ip_addresses is not None:
            result['EgressPrivateIpAddresses'] = self.egress_private_ip_addresses
        if self.egress_public_ip_addresses is not None:
            result['EgressPublicIpAddresses'] = self.egress_public_ip_addresses
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.network_access_endpoint_name is not None:
            result['NetworkAccessEndpointName'] = self.network_access_endpoint_name
        if self.network_access_endpoint_type is not None:
            result['NetworkAccessEndpointType'] = self.network_access_endpoint_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EgressPrivateIpAddresses') is not None:
            self.egress_private_ip_addresses = m.get('EgressPrivateIpAddresses')
        if m.get('EgressPublicIpAddresses') is not None:
            self.egress_public_ip_addresses = m.get('EgressPublicIpAddresses')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('NetworkAccessEndpointName') is not None:
            self.network_access_endpoint_name = m.get('NetworkAccessEndpointName')
        if m.get('NetworkAccessEndpointType') is not None:
            self.network_access_endpoint_type = m.get('NetworkAccessEndpointType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class GetNetworkAccessEndpointResponseBody(TeaModel):
    def __init__(
        self,
        network_access_endpoint: GetNetworkAccessEndpointResponseBodyNetworkAccessEndpoint = None,
        request_id: str = None,
    ):
        self.network_access_endpoint = network_access_endpoint
        self.request_id = request_id

    def validate(self):
        if self.network_access_endpoint:
            self.network_access_endpoint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_access_endpoint is not None:
            result['NetworkAccessEndpoint'] = self.network_access_endpoint.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkAccessEndpoint') is not None:
            temp_model = GetNetworkAccessEndpointResponseBodyNetworkAccessEndpoint()
            self.network_access_endpoint = temp_model.from_map(m['NetworkAccessEndpoint'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetNetworkAccessEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNetworkAccessEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNetworkAccessEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the organizational unit.
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        return self


class GetOrganizationalUnitResponseBodyOrganizationalUnit(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        instance_id: str = None,
        leaf: bool = None,
        organizational_unit_external_id: str = None,
        organizational_unit_id: str = None,
        organizational_unit_name: str = None,
        organizational_unit_source_id: str = None,
        organizational_unit_source_type: str = None,
        parent_id: str = None,
        update_time: int = None,
    ):
        # The time when the organizational unit was created. This value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the organizational unit.
        self.description = description
        # The ID of the instance.
        self.instance_id = instance_id
        # Indicates whether the node is a leaf node.
        self.leaf = leaf
        # The external ID of the organizational unit. The external ID can be used by external data to map the data of the organizational unit in IDaaS EIAM. By default, the external ID is the organizational unit ID.
        # 
        # For organizational units with the same source type and source ID, each organizational unit has a unique external ID.
        self.organizational_unit_external_id = organizational_unit_external_id
        # The ID of the organizational unit.
        self.organizational_unit_id = organizational_unit_id
        # 组织名称。
        self.organizational_unit_name = organizational_unit_name
        # The source ID of the organizational unit.
        # 
        # If the organizational unit was created in IDaaS, its source ID is the ID of the IDaaS instance. If the organizational unit was imported, its source ID is the enterprise ID in the source. For example, if the organizational unit was imported from DingTalk, its source ID is the corpId value of the enterprise in DingTalk.
        self.organizational_unit_source_id = organizational_unit_source_id
        # The source type of the organizational unit. Valid values:
        # 
        # *   build_in: The organizational unit was created in IDaaS.
        # *   ding_talk: The organizational unit was imported from DingTalk.
        # *   ad: The organizational unit was imported from Microsoft Active Directory (AD).
        # *   ldap: The organizational unit was imported from a Lightweight Directory Access Protocol (LDAP) service.
        self.organizational_unit_source_type = organizational_unit_source_type
        # The ID of the parent organizational unit.
        self.parent_id = parent_id
        # The time when the organizational unit was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.leaf is not None:
            result['Leaf'] = self.leaf
        if self.organizational_unit_external_id is not None:
            result['OrganizationalUnitExternalId'] = self.organizational_unit_external_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.organizational_unit_source_id is not None:
            result['OrganizationalUnitSourceId'] = self.organizational_unit_source_id
        if self.organizational_unit_source_type is not None:
            result['OrganizationalUnitSourceType'] = self.organizational_unit_source_type
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Leaf') is not None:
            self.leaf = m.get('Leaf')
        if m.get('OrganizationalUnitExternalId') is not None:
            self.organizational_unit_external_id = m.get('OrganizationalUnitExternalId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('OrganizationalUnitSourceId') is not None:
            self.organizational_unit_source_id = m.get('OrganizationalUnitSourceId')
        if m.get('OrganizationalUnitSourceType') is not None:
            self.organizational_unit_source_type = m.get('OrganizationalUnitSourceType')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        organizational_unit: GetOrganizationalUnitResponseBodyOrganizationalUnit = None,
        request_id: str = None,
    ):
        # The data object of the organizational unit.
        self.organizational_unit = organizational_unit
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.organizational_unit:
            self.organizational_unit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit is not None:
            result['OrganizationalUnit'] = self.organizational_unit.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnit') is not None:
            temp_model = GetOrganizationalUnitResponseBodyOrganizationalUnit()
            self.organizational_unit = temp_model.from_map(m['OrganizationalUnit'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPasswordComplexityConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfigurationPasswordComplexityRules(TeaModel):
    def __init__(
        self,
        password_check_type: str = None,
    ):
        # The type of the password check. Valid values:
        # 
        # *   inclusion_upper_case: The password must contain uppercase letters.
        # *   inclusion_lower_case: The password must contain lowercase letters.
        # *   inclusion_special_case: The password must contain one or more of the following special characters: @ % + \\ / \\" ! # $ ^ ? : , ( ) { } [ ] ~ - _ .
        # *   inclusion_number: The password must contain digits.
        # *   exclusion_username: The password cannot contain a username.
        # *   exclusion_email: The password cannot contain an email prefix.
        # *   exclusion_phone_number: The password cannot contain a mobile number.
        # *   exclusion_display_name: The password cannot contain a display name.
        self.password_check_type = password_check_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_check_type is not None:
            result['PasswordCheckType'] = self.password_check_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordCheckType') is not None:
            self.password_check_type = m.get('PasswordCheckType')
        return self


class GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfiguration(TeaModel):
    def __init__(
        self,
        password_complexity_rules: List[GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfigurationPasswordComplexityRules] = None,
        password_min_length: int = None,
    ):
        # The password complexity rules.
        self.password_complexity_rules = password_complexity_rules
        # The minimum number of characters in a password.
        self.password_min_length = password_min_length

    def validate(self):
        if self.password_complexity_rules:
            for k in self.password_complexity_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PasswordComplexityRules'] = []
        if self.password_complexity_rules is not None:
            for k in self.password_complexity_rules:
                result['PasswordComplexityRules'].append(k.to_map() if k else None)
        if self.password_min_length is not None:
            result['PasswordMinLength'] = self.password_min_length
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.password_complexity_rules = []
        if m.get('PasswordComplexityRules') is not None:
            for k in m.get('PasswordComplexityRules'):
                temp_model = GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfigurationPasswordComplexityRules()
                self.password_complexity_rules.append(temp_model.from_map(k))
        if m.get('PasswordMinLength') is not None:
            self.password_min_length = m.get('PasswordMinLength')
        return self


class GetPasswordComplexityConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        password_complexity_configuration: GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfiguration = None,
        request_id: str = None,
    ):
        # The password complexity configurations.
        self.password_complexity_configuration = password_complexity_configuration
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.password_complexity_configuration:
            self.password_complexity_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_complexity_configuration is not None:
            result['PasswordComplexityConfiguration'] = self.password_complexity_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordComplexityConfiguration') is not None:
            temp_model = GetPasswordComplexityConfigurationResponseBodyPasswordComplexityConfiguration()
            self.password_complexity_configuration = temp_model.from_map(m['PasswordComplexityConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPasswordComplexityConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPasswordComplexityConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPasswordComplexityConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPasswordExpirationConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPasswordExpirationConfigurationResponseBodyPasswordExpirationConfiguration(TeaModel):
    def __init__(
        self,
        effective_authentication_source_ids: List[str] = None,
        password_expiration_action: str = None,
        password_expiration_notification_channels: List[str] = None,
        password_expiration_notification_duration: int = None,
        password_expiration_notification_status: str = None,
        password_expiration_status: str = None,
        password_forced_update_duration: int = None,
        password_valid_max_day: int = None,
    ):
        # The list of valid authentication IDs. The default is all ["ia_all"]
        # 
        # ia_all: All. If you fill in this value, you cannot fill in other values
        # 
        # ia_password: Account password login
        # 
        # ia_otp_sms: SMS verification code login method
        # 
        # ia_webauthn: WebAuthn authenticator login method
        # 
        # idp_xxx: Specific identity provider authentication method
        self.effective_authentication_source_ids = effective_authentication_source_ids
        # The action to take when a password expires. Valid values:
        # 
        # *   forbid_login: Prohibit the user from using the password to log on to IDaaS.
        # *   force_update_password: Force the user to change the password.
        # *   remind_update_password: Remind the user to change the password.
        self.password_expiration_action = password_expiration_action
        # The methods for receiving password expiration notifications.
        self.password_expiration_notification_channels = password_expiration_notification_channels
        # The number of days before the expiration date during which password expiration notifications are sent. Unit: day.
        self.password_expiration_notification_duration = password_expiration_notification_duration
        # Indicates whether the password expiration notification feature is enabled. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_expiration_notification_status = password_expiration_notification_status
        # Indicates whether the password expiration feature is enabled. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_expiration_status = password_expiration_status
        # The number of days before which users must change the password to prevent password expiration. Unit: day.
        self.password_forced_update_duration = password_forced_update_duration
        # The validity period of a password. Unit: day.
        self.password_valid_max_day = password_valid_max_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective_authentication_source_ids is not None:
            result['EffectiveAuthenticationSourceIds'] = self.effective_authentication_source_ids
        if self.password_expiration_action is not None:
            result['PasswordExpirationAction'] = self.password_expiration_action
        if self.password_expiration_notification_channels is not None:
            result['PasswordExpirationNotificationChannels'] = self.password_expiration_notification_channels
        if self.password_expiration_notification_duration is not None:
            result['PasswordExpirationNotificationDuration'] = self.password_expiration_notification_duration
        if self.password_expiration_notification_status is not None:
            result['PasswordExpirationNotificationStatus'] = self.password_expiration_notification_status
        if self.password_expiration_status is not None:
            result['PasswordExpirationStatus'] = self.password_expiration_status
        if self.password_forced_update_duration is not None:
            result['PasswordForcedUpdateDuration'] = self.password_forced_update_duration
        if self.password_valid_max_day is not None:
            result['PasswordValidMaxDay'] = self.password_valid_max_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectiveAuthenticationSourceIds') is not None:
            self.effective_authentication_source_ids = m.get('EffectiveAuthenticationSourceIds')
        if m.get('PasswordExpirationAction') is not None:
            self.password_expiration_action = m.get('PasswordExpirationAction')
        if m.get('PasswordExpirationNotificationChannels') is not None:
            self.password_expiration_notification_channels = m.get('PasswordExpirationNotificationChannels')
        if m.get('PasswordExpirationNotificationDuration') is not None:
            self.password_expiration_notification_duration = m.get('PasswordExpirationNotificationDuration')
        if m.get('PasswordExpirationNotificationStatus') is not None:
            self.password_expiration_notification_status = m.get('PasswordExpirationNotificationStatus')
        if m.get('PasswordExpirationStatus') is not None:
            self.password_expiration_status = m.get('PasswordExpirationStatus')
        if m.get('PasswordForcedUpdateDuration') is not None:
            self.password_forced_update_duration = m.get('PasswordForcedUpdateDuration')
        if m.get('PasswordValidMaxDay') is not None:
            self.password_valid_max_day = m.get('PasswordValidMaxDay')
        return self


class GetPasswordExpirationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        password_expiration_configuration: GetPasswordExpirationConfigurationResponseBodyPasswordExpirationConfiguration = None,
        request_id: str = None,
    ):
        # The password expiration configurations.
        self.password_expiration_configuration = password_expiration_configuration
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.password_expiration_configuration:
            self.password_expiration_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_expiration_configuration is not None:
            result['PasswordExpirationConfiguration'] = self.password_expiration_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordExpirationConfiguration') is not None:
            temp_model = GetPasswordExpirationConfigurationResponseBodyPasswordExpirationConfiguration()
            self.password_expiration_configuration = temp_model.from_map(m['PasswordExpirationConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPasswordExpirationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPasswordExpirationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPasswordExpirationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPasswordHistoryConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPasswordHistoryConfigurationResponseBodyPasswordHistoryConfiguration(TeaModel):
    def __init__(
        self,
        password_history_max_retention: int = None,
        password_history_status: str = None,
    ):
        # The maximum number of recent passwords that are retained.
        self.password_history_max_retention = password_history_max_retention
        # Indicates whether the password history feature is enabled. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_history_status = password_history_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_history_max_retention is not None:
            result['PasswordHistoryMaxRetention'] = self.password_history_max_retention
        if self.password_history_status is not None:
            result['PasswordHistoryStatus'] = self.password_history_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordHistoryMaxRetention') is not None:
            self.password_history_max_retention = m.get('PasswordHistoryMaxRetention')
        if m.get('PasswordHistoryStatus') is not None:
            self.password_history_status = m.get('PasswordHistoryStatus')
        return self


class GetPasswordHistoryConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        password_history_configuration: GetPasswordHistoryConfigurationResponseBodyPasswordHistoryConfiguration = None,
        request_id: str = None,
    ):
        # The password history configurations.
        self.password_history_configuration = password_history_configuration
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.password_history_configuration:
            self.password_history_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_history_configuration is not None:
            result['PasswordHistoryConfiguration'] = self.password_history_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordHistoryConfiguration') is not None:
            temp_model = GetPasswordHistoryConfigurationResponseBodyPasswordHistoryConfiguration()
            self.password_history_configuration = temp_model.from_map(m['PasswordHistoryConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPasswordHistoryConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPasswordHistoryConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPasswordHistoryConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPasswordInitializationConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetPasswordInitializationConfigurationResponseBodyPasswordInitializationConfiguration(TeaModel):
    def __init__(
        self,
        password_forced_update_status: str = None,
        password_initialization_notification_channels: List[str] = None,
        password_initialization_status: str = None,
        password_initialization_type: str = None,
    ):
        # Indicates whether forcible password change upon first logon is enabled. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_forced_update_status = password_forced_update_status
        # The methods for receiving password initialization notifications.
        self.password_initialization_notification_channels = password_initialization_notification_channels
        # Indicates whether the password initialization feature is enabled. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_initialization_status = password_initialization_status
        # The password initialization method. Set the value to random.
        # 
        # *   random: A randomly generated password is used.
        self.password_initialization_type = password_initialization_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_forced_update_status is not None:
            result['PasswordForcedUpdateStatus'] = self.password_forced_update_status
        if self.password_initialization_notification_channels is not None:
            result['PasswordInitializationNotificationChannels'] = self.password_initialization_notification_channels
        if self.password_initialization_status is not None:
            result['PasswordInitializationStatus'] = self.password_initialization_status
        if self.password_initialization_type is not None:
            result['PasswordInitializationType'] = self.password_initialization_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordForcedUpdateStatus') is not None:
            self.password_forced_update_status = m.get('PasswordForcedUpdateStatus')
        if m.get('PasswordInitializationNotificationChannels') is not None:
            self.password_initialization_notification_channels = m.get('PasswordInitializationNotificationChannels')
        if m.get('PasswordInitializationStatus') is not None:
            self.password_initialization_status = m.get('PasswordInitializationStatus')
        if m.get('PasswordInitializationType') is not None:
            self.password_initialization_type = m.get('PasswordInitializationType')
        return self


class GetPasswordInitializationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        password_initialization_configuration: GetPasswordInitializationConfigurationResponseBodyPasswordInitializationConfiguration = None,
        request_id: str = None,
    ):
        # The password initialization configurations.
        self.password_initialization_configuration = password_initialization_configuration
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.password_initialization_configuration:
            self.password_initialization_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_initialization_configuration is not None:
            result['PasswordInitializationConfiguration'] = self.password_initialization_configuration.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordInitializationConfiguration') is not None:
            temp_model = GetPasswordInitializationConfigurationResponseBodyPasswordInitializationConfiguration()
            self.password_initialization_configuration = temp_model.from_map(m['PasswordInitializationConfiguration'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPasswordInitializationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPasswordInitializationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPasswordInitializationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRootOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRootOrganizationalUnitResponseBodyOrganizationalUnit(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        instance_id: str = None,
        organizational_unit_id: str = None,
        organizational_unit_name: str = None,
        update_time: int = None,
    ):
        # The time when the organizational unit was created. This value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the organizational unit.
        self.description = description
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the organizational unit.
        self.organizational_unit_id = organizational_unit_id
        # The name of the organization.
        self.organizational_unit_name = organizational_unit_name
        # The time when the organizational unit was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetRootOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        organizational_unit: GetRootOrganizationalUnitResponseBodyOrganizationalUnit = None,
        request_id: str = None,
    ):
        # The data object of the organizational unit.
        self.organizational_unit = organizational_unit
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.organizational_unit:
            self.organizational_unit.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit is not None:
            result['OrganizationalUnit'] = self.organizational_unit.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnit') is not None:
            temp_model = GetRootOrganizationalUnitResponseBodyOrganizationalUnit()
            self.organizational_unit = temp_model.from_map(m['OrganizationalUnit'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRootOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRootOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRootOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSynchronizationJobRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        synchronization_job_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 同步任务ID
        # 
        # This parameter is required.
        self.synchronization_job_id = synchronization_job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.synchronization_job_id is not None:
            result['SynchronizationJobId'] = self.synchronization_job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SynchronizationJobId') is not None:
            self.synchronization_job_id = m.get('SynchronizationJobId')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatistics(TeaModel):
    def __init__(
        self,
        binded: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsBinded = None,
        created: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsCreated = None,
        deleted: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsDeleted = None,
        pushed: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsPushed = None,
        same: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsSame = None,
        updated: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatistics(TeaModel):
    def __init__(
        self,
        binded: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsBinded = None,
        created: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsCreated = None,
        deleted: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsDeleted = None,
        pushed: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsPushed = None,
        same: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsSame = None,
        updated: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatistics(TeaModel):
    def __init__(
        self,
        binded: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsBinded = None,
        created: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsCreated = None,
        deleted: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsDeleted = None,
        pushed: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsPushed = None,
        same: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsSame = None,
        updated: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResultUserStatistics(TeaModel):
    def __init__(
        self,
        binded: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsBinded = None,
        created: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsCreated = None,
        deleted: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsDeleted = None,
        pushed: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsPushed = None,
        same: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsSame = None,
        updated: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class GetSynchronizationJobResponseBodySynchronizationJobResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        group_member_statistics: GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatistics = None,
        group_statistics: GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatistics = None,
        organizational_unit_statistics: GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatistics = None,
        user_statistics: GetSynchronizationJobResponseBodySynchronizationJobResultUserStatistics = None,
    ):
        # 同步结果错误码
        self.error_code = error_code
        # 同步结果错误信息描述
        self.error_message = error_message
        # 组成员同步结果统计
        self.group_member_statistics = group_member_statistics
        # 组同步结果统计
        self.group_statistics = group_statistics
        # 组织同步结果统计
        self.organizational_unit_statistics = organizational_unit_statistics
        # 用户同步结果统计
        self.user_statistics = user_statistics

    def validate(self):
        if self.group_member_statistics:
            self.group_member_statistics.validate()
        if self.group_statistics:
            self.group_statistics.validate()
        if self.organizational_unit_statistics:
            self.organizational_unit_statistics.validate()
        if self.user_statistics:
            self.user_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_member_statistics is not None:
            result['GroupMemberStatistics'] = self.group_member_statistics.to_map()
        if self.group_statistics is not None:
            result['GroupStatistics'] = self.group_statistics.to_map()
        if self.organizational_unit_statistics is not None:
            result['OrganizationalUnitStatistics'] = self.organizational_unit_statistics.to_map()
        if self.user_statistics is not None:
            result['UserStatistics'] = self.user_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupMemberStatistics') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupMemberStatistics()
            self.group_member_statistics = temp_model.from_map(m['GroupMemberStatistics'])
        if m.get('GroupStatistics') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultGroupStatistics()
            self.group_statistics = temp_model.from_map(m['GroupStatistics'])
        if m.get('OrganizationalUnitStatistics') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultOrganizationalUnitStatistics()
            self.organizational_unit_statistics = temp_model.from_map(m['OrganizationalUnitStatistics'])
        if m.get('UserStatistics') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResultUserStatistics()
            self.user_statistics = temp_model.from_map(m['UserStatistics'])
        return self


class GetSynchronizationJobResponseBodySynchronizationJob(TeaModel):
    def __init__(
        self,
        direction: str = None,
        end_time: int = None,
        result: GetSynchronizationJobResponseBodySynchronizationJobResult = None,
        start_time: int = None,
        status: str = None,
        synchronization_job_id: str = None,
        target_id: str = None,
        target_type: str = None,
        trigger_type: str = None,
    ):
        # 同步任务方向
        self.direction = direction
        # 同步结束时间
        self.end_time = end_time
        # 同步任务结果
        self.result = result
        # 同步开始时间
        self.start_time = start_time
        # 同步任务状态
        self.status = status
        # 同步任务ID
        self.synchronization_job_id = synchronization_job_id
        # 同步目标ID
        self.target_id = target_id
        # 同步目标类型
        self.target_type = target_type
        # 同步触发类型
        self.trigger_type = trigger_type

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.synchronization_job_id is not None:
            result['SynchronizationJobId'] = self.synchronization_job_id
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.trigger_type is not None:
            result['TriggerType'] = self.trigger_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Result') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJobResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SynchronizationJobId') is not None:
            self.synchronization_job_id = m.get('SynchronizationJobId')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TriggerType') is not None:
            self.trigger_type = m.get('TriggerType')
        return self


class GetSynchronizationJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        synchronization_job: GetSynchronizationJobResponseBodySynchronizationJob = None,
    ):
        self.request_id = request_id
        self.synchronization_job = synchronization_job

    def validate(self):
        if self.synchronization_job:
            self.synchronization_job.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.synchronization_job is not None:
            result['SynchronizationJob'] = self.synchronization_job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SynchronizationJob') is not None:
            temp_model = GetSynchronizationJobResponseBodySynchronizationJob()
            self.synchronization_job = temp_model.from_map(m['SynchronizationJob'])
        return self


class GetSynchronizationJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSynchronizationJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSynchronizationJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the account.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetUserResponseBodyUserCustomFields(TeaModel):
    def __init__(
        self,
        field_name: str = None,
        field_value: str = None,
    ):
        # The identifier of the custom field.
        self.field_name = field_name
        # The value of the custom field.
        self.field_value = field_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        return self


class GetUserResponseBodyUserGroups(TeaModel):
    def __init__(
        self,
        description: str = None,
        group_id: str = None,
        group_name: str = None,
    ):
        # The description of the organizational unit.
        self.description = description
        # The ID of the organizational unit.
        self.group_id = group_id
        # The name of the organizational unit.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class GetUserResponseBodyUserOrganizationalUnits(TeaModel):
    def __init__(
        self,
        organizational_unit_id: str = None,
        organizational_unit_name: str = None,
        primary: bool = None,
    ):
        # The ID of the organizational unit.
        self.organizational_unit_id = organizational_unit_id
        # The name of the organizational unit.
        self.organizational_unit_name = organizational_unit_name
        # Indicates whether the organization is the primary organization.
        self.primary = primary

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.primary is not None:
            result['Primary'] = self.primary
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('Primary') is not None:
            self.primary = m.get('Primary')
        return self


class GetUserResponseBodyUser(TeaModel):
    def __init__(
        self,
        account_expire_time: int = None,
        create_time: int = None,
        custom_fields: List[GetUserResponseBodyUserCustomFields] = None,
        description: str = None,
        display_name: str = None,
        email: str = None,
        email_verified: bool = None,
        groups: List[GetUserResponseBodyUserGroups] = None,
        instance_id: str = None,
        lock_expire_time: int = None,
        organizational_units: List[GetUserResponseBodyUserOrganizationalUnits] = None,
        password_expire_time: int = None,
        password_set: bool = None,
        phone_number: str = None,
        phone_number_verified: bool = None,
        phone_region: str = None,
        preferred_language: str = None,
        primary_organizational_unit_id: str = None,
        register_time: int = None,
        status: str = None,
        update_time: int = None,
        user_external_id: str = None,
        user_id: str = None,
        user_source_id: str = None,
        user_source_type: str = None,
        username: str = None,
    ):
        # The time when the account expires. This value is a UNIX timestamp. Unit: milliseconds.
        self.account_expire_time = account_expire_time
        # The time when the account was created. This value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The list of custom fields that describe the account.
        self.custom_fields = custom_fields
        # The description of the account.
        self.description = description
        # The display name of the account.
        self.display_name = display_name
        # The email address of the user who owns the account.
        self.email = email
        # Indicates whether the email address has been verified. A value of true indicates that the email address has been verified by the user or has been set to the verified status by the administrator. A value of false indicates that the email address has not been verified.
        self.email_verified = email_verified
        # The organizational units to which the account belongs.
        self.groups = groups
        # The ID of the instance
        self.instance_id = instance_id
        # The time when the account lock expires. This value is a UNIX timestamp. Unit: milliseconds.
        self.lock_expire_time = lock_expire_time
        # The organizational units to which the account belongs.
        self.organizational_units = organizational_units
        # The time when the password of the account expires. This value is a UNIX timestamp. Unit: milliseconds.
        # 
        # *   If the value -1 is returned, the password does not expire.
        # *   If no value is returned, the password does not expire.
        # *   If a UNIX timestamp is returned, the password expires at the indicated point of time.
        self.password_expire_time = password_expire_time
        # Indicates whether a password is set.
        self.password_set = password_set
        # The mobile number of the user who owns the account.
        self.phone_number = phone_number
        # Indicates whether the mobile number has been verified. A value of true indicates that the mobile number has been verified by the user or has been set to the verified status by the administrator. A value of false indicates that the mobile number has not been verified.
        self.phone_number_verified = phone_number_verified
        # The country code of the mobile number. For example, the country code of China is 86 without 00 or +.
        self.phone_region = phone_region
        # Preferred language
        self.preferred_language = preferred_language
        # The ID of the primary organizational unit to which the account belongs.
        self.primary_organizational_unit_id = primary_organizational_unit_id
        # The time when the account was registered. This value is a UNIX timestamp. Unit: milliseconds.
        self.register_time = register_time
        # The status of the account. Valid values:
        # 
        # *   enabled: The account is enabled.
        # *   disabled: The account is disabled.
        self.status = status
        # The time when the account was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time
        # The external ID of the account. The external ID can be used by external data to map the data of the account in IDaaS EIAM. By default, the external ID is the account ID.
        # 
        # For accounts with the same source type and source ID, each account has a unique external ID.
        self.user_external_id = user_external_id
        # The ID of the account.
        self.user_id = user_id
        # The source ID of the account.
        # 
        # If the account was created in IDaaS, its source ID is the ID of the IDaaS instance. If the account was imported, its source ID is the enterprise ID in the source. For example, if the account was imported from DingTalk, its source ID is the corpId value of the enterprise in DingTalk.
        self.user_source_id = user_source_id
        # The source type of the account. Valid values:
        # 
        # *   build_in: The account was created in IDaaS.
        # *   ding_talk: The account was imported from DingTalk.
        # *   ad: The account was imported from Microsoft Active Directory (AD).
        # *   ldap: The account was imported from a Lightweight Directory Access Protocol (LDAP) service.
        self.user_source_type = user_source_type
        # The username of the account.
        self.username = username

    def validate(self):
        if self.custom_fields:
            for k in self.custom_fields:
                if k:
                    k.validate()
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.organizational_units:
            for k in self.organizational_units:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_expire_time is not None:
            result['AccountExpireTime'] = self.account_expire_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['CustomFields'] = []
        if self.custom_fields is not None:
            for k in self.custom_fields:
                result['CustomFields'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.email_verified is not None:
            result['EmailVerified'] = self.email_verified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lock_expire_time is not None:
            result['LockExpireTime'] = self.lock_expire_time
        result['OrganizationalUnits'] = []
        if self.organizational_units is not None:
            for k in self.organizational_units:
                result['OrganizationalUnits'].append(k.to_map() if k else None)
        if self.password_expire_time is not None:
            result['PasswordExpireTime'] = self.password_expire_time
        if self.password_set is not None:
            result['PasswordSet'] = self.password_set
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.phone_number_verified is not None:
            result['PhoneNumberVerified'] = self.phone_number_verified
        if self.phone_region is not None:
            result['PhoneRegion'] = self.phone_region
        if self.preferred_language is not None:
            result['PreferredLanguage'] = self.preferred_language
        if self.primary_organizational_unit_id is not None:
            result['PrimaryOrganizationalUnitId'] = self.primary_organizational_unit_id
        if self.register_time is not None:
            result['RegisterTime'] = self.register_time
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_external_id is not None:
            result['UserExternalId'] = self.user_external_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_source_id is not None:
            result['UserSourceId'] = self.user_source_id
        if self.user_source_type is not None:
            result['UserSourceType'] = self.user_source_type
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountExpireTime') is not None:
            self.account_expire_time = m.get('AccountExpireTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.custom_fields = []
        if m.get('CustomFields') is not None:
            for k in m.get('CustomFields'):
                temp_model = GetUserResponseBodyUserCustomFields()
                self.custom_fields.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('EmailVerified') is not None:
            self.email_verified = m.get('EmailVerified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = GetUserResponseBodyUserGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LockExpireTime') is not None:
            self.lock_expire_time = m.get('LockExpireTime')
        self.organizational_units = []
        if m.get('OrganizationalUnits') is not None:
            for k in m.get('OrganizationalUnits'):
                temp_model = GetUserResponseBodyUserOrganizationalUnits()
                self.organizational_units.append(temp_model.from_map(k))
        if m.get('PasswordExpireTime') is not None:
            self.password_expire_time = m.get('PasswordExpireTime')
        if m.get('PasswordSet') is not None:
            self.password_set = m.get('PasswordSet')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PhoneNumberVerified') is not None:
            self.phone_number_verified = m.get('PhoneNumberVerified')
        if m.get('PhoneRegion') is not None:
            self.phone_region = m.get('PhoneRegion')
        if m.get('PreferredLanguage') is not None:
            self.preferred_language = m.get('PreferredLanguage')
        if m.get('PrimaryOrganizationalUnitId') is not None:
            self.primary_organizational_unit_id = m.get('PrimaryOrganizationalUnitId')
        if m.get('RegisterTime') is not None:
            self.register_time = m.get('RegisterTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserExternalId') is not None:
            self.user_external_id = m.get('UserExternalId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserSourceId') is not None:
            self.user_source_id = m.get('UserSourceId')
        if m.get('UserSourceType') is not None:
            self.user_source_type = m.get('UserSourceType')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class GetUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user: GetUserResponseBodyUser = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The data object of the account.
        self.user = user

    def validate(self):
        if self.user:
            self.user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user is not None:
            result['User'] = self.user.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('User') is not None:
            temp_model = GetUserResponseBodyUser()
            self.user = temp_model.from_map(m['User'])
        return self


class GetUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationClientSecretsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to query.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListApplicationClientSecretsResponseBodyApplicationClientSecrets(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        client_id: str = None,
        client_secret: str = None,
        instance_id: str = None,
        last_used_time: int = None,
        secret_id: str = None,
        status: str = None,
    ):
        # The ID of the application that you want to query.
        self.application_id = application_id
        # The client ID of the application.
        self.client_id = client_id
        # The client key secret of the application. The value is not masked.
        self.client_secret = client_secret
        # The ID of the instance.
        self.instance_id = instance_id
        # The time when the client key was last used. The value is a UNIX timestamp. Unit: milliseconds.
        self.last_used_time = last_used_time
        # The client key ID of the application.
        self.secret_id = secret_id
        # The status of the client key. Valid values:
        # 
        # *   Enabled: The client key is enabled.
        # *   Disabled: The client key is disabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_used_time is not None:
            result['LastUsedTime'] = self.last_used_time
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUsedTime') is not None:
            self.last_used_time = m.get('LastUsedTime')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListApplicationClientSecretsResponseBody(TeaModel):
    def __init__(
        self,
        application_client_secrets: List[ListApplicationClientSecretsResponseBodyApplicationClientSecrets] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about the client keys.
        self.application_client_secrets = application_client_secrets
        # The ID of the request.
        self.request_id = request_id
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.application_client_secrets:
            for k in self.application_client_secrets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplicationClientSecrets'] = []
        if self.application_client_secrets is not None:
            for k in self.application_client_secrets:
                result['ApplicationClientSecrets'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_client_secrets = []
        if m.get('ApplicationClientSecrets') is not None:
            for k in m.get('ApplicationClientSecrets'):
                temp_model = ListApplicationClientSecretsResponseBodyApplicationClientSecrets()
                self.application_client_secrets.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListApplicationClientSecretsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationClientSecretsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationClientSecretsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        application_name: str = None,
        authorization_type: str = None,
        instance_id: str = None,
        m_2mclient_status: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_server_status: str = None,
        sso_type: str = None,
        status: str = None,
    ):
        # The IDs of the applications.
        self.application_ids = application_ids
        # The name of the application. Only fuzzy match from the leftmost character is supported.
        self.application_name = application_name
        # The authorization of the application. Valid values:
        # 
        # *   authorize_required: Only the user with explicit authorization can access the application.
        # *   default_all: By default, all users can access the application.
        self.authorization_type = authorization_type
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.m_2mclient_status = m_2mclient_status
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        self.resource_server_status = resource_server_status
        self.sso_type = sso_type
        # The status of the application. Valid values:
        # 
        # *   Enabled: The application is enabled.
        # *   Disabled: The application is disabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.authorization_type is not None:
            result['AuthorizationType'] = self.authorization_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.m_2mclient_status is not None:
            result['M2MClientStatus'] = self.m_2mclient_status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_server_status is not None:
            result['ResourceServerStatus'] = self.resource_server_status
        if self.sso_type is not None:
            result['SsoType'] = self.sso_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('AuthorizationType') is not None:
            self.authorization_type = m.get('AuthorizationType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('M2MClientStatus') is not None:
            self.m_2mclient_status = m.get('M2MClientStatus')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceServerStatus') is not None:
            self.resource_server_status = m.get('ResourceServerStatus')
        if m.get('SsoType') is not None:
            self.sso_type = m.get('SsoType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListApplicationsResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
        application_source_type: str = None,
        application_template_id: str = None,
        client_id: str = None,
        create_time: int = None,
        description: str = None,
        features: str = None,
        instance_id: str = None,
        logo_url: str = None,
        m_2mclient_status: str = None,
        managed_service_code: str = None,
        resource_server_identifier: str = None,
        resource_server_status: str = None,
        service_managed: bool = None,
        sso_type: str = None,
        status: str = None,
        update_time: int = None,
    ):
        # The ID of the application.
        self.application_id = application_id
        # The name of the application.
        self.application_name = application_name
        # The origin of the application. Valid values:
        # 
        # *   urn:alibaba:idaas:app:source:template: The application is created based on a template.
        # *   urn:alibaba:idaas: The application is created based on the standard protocol.
        self.application_source_type = application_source_type
        # 应用模板ID
        self.application_template_id = application_template_id
        # The client ID of the application.
        self.client_id = client_id
        # The time when the application was created. The value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the application.
        self.description = description
        # The features that are supported by the application. The value is a JSON array. Valid values:
        # 
        # *   sso: The application supports SSO.
        # *   provision: The application supports account synchronization.
        # *   api_invoke: The application supports custom APIs.
        self.features = features
        # The ID of the instance.
        self.instance_id = instance_id
        # The URL of the application icon.
        self.logo_url = logo_url
        self.m_2mclient_status = m_2mclient_status
        # The service code of the cloud service that manages the application template.
        self.managed_service_code = managed_service_code
        self.resource_server_identifier = resource_server_identifier
        self.resource_server_status = resource_server_status
        # Indicates whether the application template is managed by a cloud service.
        self.service_managed = service_managed
        # The type of the single sign-on (SSO) protocol. Valid values:
        # 
        # *   saml2: the Security Assertion Markup Language (SAML) 2.0 protocol.
        # *   oidc: the OpenID Connect (OIDC) protocol.
        self.sso_type = sso_type
        # The status of the application. Valid values:
        # 
        # *   Enabled: The application is enabled.
        # *   Disabled: The application is disabled.
        self.status = status
        # The time when the application was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_source_type is not None:
            result['ApplicationSourceType'] = self.application_source_type
        if self.application_template_id is not None:
            result['ApplicationTemplateId'] = self.application_template_id
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.features is not None:
            result['Features'] = self.features
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.m_2mclient_status is not None:
            result['M2MClientStatus'] = self.m_2mclient_status
        if self.managed_service_code is not None:
            result['ManagedServiceCode'] = self.managed_service_code
        if self.resource_server_identifier is not None:
            result['ResourceServerIdentifier'] = self.resource_server_identifier
        if self.resource_server_status is not None:
            result['ResourceServerStatus'] = self.resource_server_status
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.sso_type is not None:
            result['SsoType'] = self.sso_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationSourceType') is not None:
            self.application_source_type = m.get('ApplicationSourceType')
        if m.get('ApplicationTemplateId') is not None:
            self.application_template_id = m.get('ApplicationTemplateId')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Features') is not None:
            self.features = m.get('Features')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('M2MClientStatus') is not None:
            self.m_2mclient_status = m.get('M2MClientStatus')
        if m.get('ManagedServiceCode') is not None:
            self.managed_service_code = m.get('ManagedServiceCode')
        if m.get('ResourceServerIdentifier') is not None:
            self.resource_server_identifier = m.get('ResourceServerIdentifier')
        if m.get('ResourceServerStatus') is not None:
            self.resource_server_status = m.get('ResourceServerStatus')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('SsoType') is not None:
            self.sso_type = m.get('SsoType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListApplicationsResponseBodyApplications] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The details of the applications.
        self.applications = applications
        # The ID of the request.
        self.request_id = request_id
        # The total number of the returned entries.
        self.total_count = total_count

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListApplicationsResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsForOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        instance_id: str = None,
        organizational_unit_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The IDs of the applications that the EIAM organization can access. You can query a maximum of 100 application IDs at a time.
        self.application_ids = application_ids
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the EIAM organization.
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListApplicationsForOrganizationalUnitResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
    ):
        # The ID of the application that the EIAM organization can access.
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class ListApplicationsForOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListApplicationsForOrganizationalUnitResponseBodyApplications] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The applications that the EIAM organization can access.
        self.applications = applications
        # The ID of the request.
        self.request_id = request_id
        # The total number of the returned entries.
        self.total_count = total_count

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListApplicationsForOrganizationalUnitResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListApplicationsForOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsForOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsForOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApplicationsForUserRequest(TeaModel):
    def __init__(
        self,
        application_ids: List[str] = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        query_mode: str = None,
        user_id: str = None,
    ):
        # The IDs of the applications that the EIAM account can access. You can query a maximum of 100 application IDs at a time.
        self.application_ids = application_ids
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The query mode. Default value: **OnlyDirect**. Valid values:
        # 
        # *   OnlyDirect: Only the direct permissions are queried. Direct permissions are the permissions that are directly granted to the account.
        # *   IncludeInherit: Both the permissions that are directly granted to the account and the inherited permissions are queried. Inherited permissions are the permissions that an account inherits from the parent organization or the group to which the account belongs.
        self.query_mode = query_mode
        # The ID of the EIAM account.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_ids is not None:
            result['ApplicationIds'] = self.application_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_mode is not None:
            result['QueryMode'] = self.query_mode
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationIds') is not None:
            self.application_ids = m.get('ApplicationIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryMode') is not None:
            self.query_mode = m.get('QueryMode')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListApplicationsForUserResponseBodyApplications(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        has_direct_authorization: bool = None,
        has_inherit_authorization: bool = None,
    ):
        # The ID of the application that the EIAM account can access.
        self.application_id = application_id
        # Indicates whether the EIAM account has direct permissions on the application. Valid values:
        # 
        # *   true: The EIAM account has direct permissions on the application.
        # *   false: The EIAM account does not have direct permissions on the application.
        self.has_direct_authorization = has_direct_authorization
        # Indicates whether the EIAM account has inherited permissions on the application. Valid values:
        # 
        # *   true: A parent organization or an organization to which the EIAM account belongs has direct permissions on the application.
        # *   false: A parent organization or an organization to which the EIAM account belongs does not have direct permissions on the application.
        self.has_inherit_authorization = has_inherit_authorization

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.has_direct_authorization is not None:
            result['HasDirectAuthorization'] = self.has_direct_authorization
        if self.has_inherit_authorization is not None:
            result['HasInheritAuthorization'] = self.has_inherit_authorization
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('HasDirectAuthorization') is not None:
            self.has_direct_authorization = m.get('HasDirectAuthorization')
        if m.get('HasInheritAuthorization') is not None:
            self.has_inherit_authorization = m.get('HasInheritAuthorization')
        return self


class ListApplicationsForUserResponseBody(TeaModel):
    def __init__(
        self,
        applications: List[ListApplicationsForUserResponseBodyApplications] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The applications that the EIAM account can access.
        self.applications = applications
        # The ID of the request.
        self.request_id = request_id
        # The total number of the returned entries.
        self.total_count = total_count

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['Applications'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('Applications') is not None:
            for k in m.get('Applications'):
                temp_model = ListApplicationsForUserResponseBodyApplications()
                self.applications.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListApplicationsForUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListApplicationsForUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListApplicationsForUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConditionalAccessPoliciesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        previous_token: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Number of items per page in a paginated query.
        self.max_results = max_results
        # Token for the next page query.
        self.next_token = next_token
        # Token for the previous page query.
        self.previous_token = previous_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.previous_token is not None:
            result['PreviousToken'] = self.previous_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PreviousToken') is not None:
            self.previous_token = m.get('PreviousToken')
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigApplications(TeaModel):
    def __init__(
        self,
        exclude_applications: List[str] = None,
        include_applications: List[str] = None,
    ):
        # Excluded applications
        self.exclude_applications = exclude_applications
        # Selected applications
        self.include_applications = include_applications

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_applications is not None:
            result['ExcludeApplications'] = self.exclude_applications
        if self.include_applications is not None:
            result['IncludeApplications'] = self.include_applications
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeApplications') is not None:
            self.exclude_applications = m.get('ExcludeApplications')
        if m.get('IncludeApplications') is not None:
            self.include_applications = m.get('IncludeApplications')
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones(TeaModel):
    def __init__(
        self,
        exclude_network_zones: List[str] = None,
        include_network_zones: List[str] = None,
    ):
        # Excluded network zones
        self.exclude_network_zones = exclude_network_zones
        # Included network ranges
        self.include_network_zones = include_network_zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_network_zones is not None:
            result['ExcludeNetworkZones'] = self.exclude_network_zones
        if self.include_network_zones is not None:
            result['IncludeNetworkZones'] = self.include_network_zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeNetworkZones') is not None:
            self.exclude_network_zones = m.get('ExcludeNetworkZones')
        if m.get('IncludeNetworkZones') is not None:
            self.include_network_zones = m.get('IncludeNetworkZones')
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigUsers(TeaModel):
    def __init__(
        self,
        exclude_groups: List[str] = None,
        exclude_organizational_units: List[str] = None,
        exclude_users: List[str] = None,
        include_groups: List[str] = None,
        include_organizational_units: List[str] = None,
        include_users: List[str] = None,
    ):
        # Excluded user groups
        self.exclude_groups = exclude_groups
        # Excluded organizations
        self.exclude_organizational_units = exclude_organizational_units
        # Excluded users
        self.exclude_users = exclude_users
        # Included user groups
        self.include_groups = include_groups
        # Included organizations
        self.include_organizational_units = include_organizational_units
        # Selected users
        self.include_users = include_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_groups is not None:
            result['ExcludeGroups'] = self.exclude_groups
        if self.exclude_organizational_units is not None:
            result['ExcludeOrganizationalUnits'] = self.exclude_organizational_units
        if self.exclude_users is not None:
            result['ExcludeUsers'] = self.exclude_users
        if self.include_groups is not None:
            result['IncludeGroups'] = self.include_groups
        if self.include_organizational_units is not None:
            result['IncludeOrganizationalUnits'] = self.include_organizational_units
        if self.include_users is not None:
            result['IncludeUsers'] = self.include_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeGroups') is not None:
            self.exclude_groups = m.get('ExcludeGroups')
        if m.get('ExcludeOrganizationalUnits') is not None:
            self.exclude_organizational_units = m.get('ExcludeOrganizationalUnits')
        if m.get('ExcludeUsers') is not None:
            self.exclude_users = m.get('ExcludeUsers')
        if m.get('IncludeGroups') is not None:
            self.include_groups = m.get('IncludeGroups')
        if m.get('IncludeOrganizationalUnits') is not None:
            self.include_organizational_units = m.get('IncludeOrganizationalUnits')
        if m.get('IncludeUsers') is not None:
            self.include_users = m.get('IncludeUsers')
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfig(TeaModel):
    def __init__(
        self,
        applications: ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigApplications = None,
        network_zones: ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones = None,
        users: ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigUsers = None,
    ):
        # Target applications of the conditional access policy
        self.applications = applications
        # Network zones for conditional access policies
        self.network_zones = network_zones
        # Target users of the conditional access policy
        self.users = users

    def validate(self):
        if self.applications:
            self.applications.validate()
        if self.network_zones:
            self.network_zones.validate()
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applications is not None:
            result['Applications'] = self.applications.to_map()
        if self.network_zones is not None:
            result['NetworkZones'] = self.network_zones.to_map()
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applications') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigApplications()
            self.applications = temp_model.from_map(m['Applications'])
        if m.get('NetworkZones') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones()
            self.network_zones = temp_model.from_map(m['NetworkZones'])
        if m.get('Users') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfigUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesDecisionConfig(TeaModel):
    def __init__(
        self,
        active_session_reuse_status: str = None,
        effect: str = None,
        mfa_authentication_interval_seconds: int = None,
        mfa_authentication_methods: List[str] = None,
        mfa_type: str = None,
    ):
        # Whether to enable session reuse for secondary authentication
        self.active_session_reuse_status = active_session_reuse_status
        # Decision action of the conditional access policy:
        # deny  Deny
        # allow Allow
        self.effect = effect
        # Re-authentication interval for the conditional access policy (in seconds) 300-86400
        self.mfa_authentication_interval_seconds = mfa_authentication_interval_seconds
        # MFA types allowed by the conditional access policy
        self.mfa_authentication_methods = mfa_authentication_methods
        # Conditional Access Policy Mfa Type
        self.mfa_type = mfa_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_reuse_status is not None:
            result['ActiveSessionReuseStatus'] = self.active_session_reuse_status
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.mfa_authentication_interval_seconds is not None:
            result['MfaAuthenticationIntervalSeconds'] = self.mfa_authentication_interval_seconds
        if self.mfa_authentication_methods is not None:
            result['MfaAuthenticationMethods'] = self.mfa_authentication_methods
        if self.mfa_type is not None:
            result['MfaType'] = self.mfa_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionReuseStatus') is not None:
            self.active_session_reuse_status = m.get('ActiveSessionReuseStatus')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('MfaAuthenticationIntervalSeconds') is not None:
            self.mfa_authentication_interval_seconds = m.get('MfaAuthenticationIntervalSeconds')
        if m.get('MfaAuthenticationMethods') is not None:
            self.mfa_authentication_methods = m.get('MfaAuthenticationMethods')
        if m.get('MfaType') is not None:
            self.mfa_type = m.get('MfaType')
        return self


class ListConditionalAccessPoliciesResponseBodyConditionalAccessPolicies(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        conditional_access_policy_name: str = None,
        conditional_access_policy_type: str = None,
        conditions_config: ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfig = None,
        create_time: int = None,
        decision_config: ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesDecisionConfig = None,
        decision_type: str = None,
        description: str = None,
        evaluate_at: str = None,
        instance_id: str = None,
        last_updated_time: int = None,
        priority: int = None,
        status: str = None,
    ):
        # Conditional access policy ID
        self.conditional_access_policy_id = conditional_access_policy_id
        # Conditional access policy name
        self.conditional_access_policy_name = conditional_access_policy_name
        # Type of the conditional access policy
        self.conditional_access_policy_type = conditional_access_policy_type
        # Content of the conditional access policy
        self.conditions_config = conditions_config
        # Creation time
        self.create_time = create_time
        # Action of the conditional access policy
        self.decision_config = decision_config
        # Execution type of the conditional access policy
        self.decision_type = decision_type
        # Description of the conditional access policy
        self.description = description
        # Execution point of the conditional access policy
        self.evaluate_at = evaluate_at
        # Instance ID
        self.instance_id = instance_id
        # Last updated time
        self.last_updated_time = last_updated_time
        # Priority, 1-100
        self.priority = priority
        # Enable or disable status of the conditional access policy
        self.status = status

    def validate(self):
        if self.conditions_config:
            self.conditions_config.validate()
        if self.decision_config:
            self.decision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.conditional_access_policy_name is not None:
            result['ConditionalAccessPolicyName'] = self.conditional_access_policy_name
        if self.conditional_access_policy_type is not None:
            result['ConditionalAccessPolicyType'] = self.conditional_access_policy_type
        if self.conditions_config is not None:
            result['ConditionsConfig'] = self.conditions_config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.decision_config is not None:
            result['DecisionConfig'] = self.decision_config.to_map()
        if self.decision_type is not None:
            result['DecisionType'] = self.decision_type
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluate_at is not None:
            result['EvaluateAt'] = self.evaluate_at
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_updated_time is not None:
            result['LastUpdatedTime'] = self.last_updated_time
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('ConditionalAccessPolicyName') is not None:
            self.conditional_access_policy_name = m.get('ConditionalAccessPolicyName')
        if m.get('ConditionalAccessPolicyType') is not None:
            self.conditional_access_policy_type = m.get('ConditionalAccessPolicyType')
        if m.get('ConditionsConfig') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesConditionsConfig()
            self.conditions_config = temp_model.from_map(m['ConditionsConfig'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DecisionConfig') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPoliciesDecisionConfig()
            self.decision_config = temp_model.from_map(m['DecisionConfig'])
        if m.get('DecisionType') is not None:
            self.decision_type = m.get('DecisionType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluateAt') is not None:
            self.evaluate_at = m.get('EvaluateAt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUpdatedTime') is not None:
            self.last_updated_time = m.get('LastUpdatedTime')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListConditionalAccessPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        conditional_access_policies: List[ListConditionalAccessPoliciesResponseBodyConditionalAccessPolicies] = None,
        next_token: str = None,
        previous_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Collection of conditional access policies
        self.conditional_access_policies = conditional_access_policies
        # The token value returned by this call for the next page query.
        self.next_token = next_token
        # Previous page query token (Token)
        self.previous_token = previous_token
        # Request ID.
        self.request_id = request_id
        # Total number of items in the list.
        self.total_count = total_count

    def validate(self):
        if self.conditional_access_policies:
            for k in self.conditional_access_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionalAccessPolicies'] = []
        if self.conditional_access_policies is not None:
            for k in self.conditional_access_policies:
                result['ConditionalAccessPolicies'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.previous_token is not None:
            result['PreviousToken'] = self.previous_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditional_access_policies = []
        if m.get('ConditionalAccessPolicies') is not None:
            for k in m.get('ConditionalAccessPolicies'):
                temp_model = ListConditionalAccessPoliciesResponseBodyConditionalAccessPolicies()
                self.conditional_access_policies.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PreviousToken') is not None:
            self.previous_token = m.get('PreviousToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListConditionalAccessPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListConditionalAccessPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListConditionalAccessPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConditionalAccessPoliciesForNetworkZoneRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        network_zone_id: str = None,
    ):
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Application ID associated with the conditional access policy
        # 
        # This parameter is required.
        self.network_zone_id = network_zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_zone_id is not None:
            result['NetworkZoneId'] = self.network_zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkZoneId') is not None:
            self.network_zone_id = m.get('NetworkZoneId')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigApplications(TeaModel):
    def __init__(
        self,
        exclude_applications: List[str] = None,
        include_applications: List[str] = None,
    ):
        # Excluded applications
        self.exclude_applications = exclude_applications
        # Selected applications
        self.include_applications = include_applications

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_applications is not None:
            result['ExcludeApplications'] = self.exclude_applications
        if self.include_applications is not None:
            result['IncludeApplications'] = self.include_applications
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeApplications') is not None:
            self.exclude_applications = m.get('ExcludeApplications')
        if m.get('IncludeApplications') is not None:
            self.include_applications = m.get('IncludeApplications')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones(TeaModel):
    def __init__(
        self,
        exclude_network_zones: List[str] = None,
        include_network_zones: List[str] = None,
    ):
        # Excluded network zones
        self.exclude_network_zones = exclude_network_zones
        # Included network zones
        self.include_network_zones = include_network_zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_network_zones is not None:
            result['ExcludeNetworkZones'] = self.exclude_network_zones
        if self.include_network_zones is not None:
            result['IncludeNetworkZones'] = self.include_network_zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeNetworkZones') is not None:
            self.exclude_network_zones = m.get('ExcludeNetworkZones')
        if m.get('IncludeNetworkZones') is not None:
            self.include_network_zones = m.get('IncludeNetworkZones')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigUsers(TeaModel):
    def __init__(
        self,
        exclude_groups: List[str] = None,
        exclude_organizational_units: List[str] = None,
        exclude_users: List[str] = None,
        include_groups: List[str] = None,
        include_organizational_units: List[str] = None,
        include_users: List[str] = None,
    ):
        # Excluded user groups
        self.exclude_groups = exclude_groups
        # Excluded organizations
        self.exclude_organizational_units = exclude_organizational_units
        # Excluded Users
        self.exclude_users = exclude_users
        # Selected user groups
        self.include_groups = include_groups
        # Selected organizations
        self.include_organizational_units = include_organizational_units
        # Selected users
        self.include_users = include_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_groups is not None:
            result['ExcludeGroups'] = self.exclude_groups
        if self.exclude_organizational_units is not None:
            result['ExcludeOrganizationalUnits'] = self.exclude_organizational_units
        if self.exclude_users is not None:
            result['ExcludeUsers'] = self.exclude_users
        if self.include_groups is not None:
            result['IncludeGroups'] = self.include_groups
        if self.include_organizational_units is not None:
            result['IncludeOrganizationalUnits'] = self.include_organizational_units
        if self.include_users is not None:
            result['IncludeUsers'] = self.include_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeGroups') is not None:
            self.exclude_groups = m.get('ExcludeGroups')
        if m.get('ExcludeOrganizationalUnits') is not None:
            self.exclude_organizational_units = m.get('ExcludeOrganizationalUnits')
        if m.get('ExcludeUsers') is not None:
            self.exclude_users = m.get('ExcludeUsers')
        if m.get('IncludeGroups') is not None:
            self.include_groups = m.get('IncludeGroups')
        if m.get('IncludeOrganizationalUnits') is not None:
            self.include_organizational_units = m.get('IncludeOrganizationalUnits')
        if m.get('IncludeUsers') is not None:
            self.include_users = m.get('IncludeUsers')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfig(TeaModel):
    def __init__(
        self,
        applications: ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigApplications = None,
        network_zones: ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones = None,
        users: ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigUsers = None,
    ):
        # Target applications of the conditional access policy
        self.applications = applications
        # Network zones for conditional access policies
        self.network_zones = network_zones
        # Target users of the conditional access policy
        self.users = users

    def validate(self):
        if self.applications:
            self.applications.validate()
        if self.network_zones:
            self.network_zones.validate()
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applications is not None:
            result['Applications'] = self.applications.to_map()
        if self.network_zones is not None:
            result['NetworkZones'] = self.network_zones.to_map()
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applications') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigApplications()
            self.applications = temp_model.from_map(m['Applications'])
        if m.get('NetworkZones') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigNetworkZones()
            self.network_zones = temp_model.from_map(m['NetworkZones'])
        if m.get('Users') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfigUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesDecisionConfig(TeaModel):
    def __init__(
        self,
        active_session_reuse_status: str = None,
        effect: str = None,
        mfa_authentication_interval_seconds: int = None,
        mfa_authentication_methods: List[str] = None,
        mfa_type: str = None,
    ):
        # Whether session reuse is enabled
        self.active_session_reuse_status = active_session_reuse_status
        # Decision action of the conditional access policy
        self.effect = effect
        # Re-authentication interval for conditional access policy (seconds)
        self.mfa_authentication_interval_seconds = mfa_authentication_interval_seconds
        # MFA types allowed by the conditional access policy
        self.mfa_authentication_methods = mfa_authentication_methods
        # MFA type of the conditional access policy
        self.mfa_type = mfa_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_reuse_status is not None:
            result['ActiveSessionReuseStatus'] = self.active_session_reuse_status
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.mfa_authentication_interval_seconds is not None:
            result['MfaAuthenticationIntervalSeconds'] = self.mfa_authentication_interval_seconds
        if self.mfa_authentication_methods is not None:
            result['MfaAuthenticationMethods'] = self.mfa_authentication_methods
        if self.mfa_type is not None:
            result['MfaType'] = self.mfa_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionReuseStatus') is not None:
            self.active_session_reuse_status = m.get('ActiveSessionReuseStatus')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('MfaAuthenticationIntervalSeconds') is not None:
            self.mfa_authentication_interval_seconds = m.get('MfaAuthenticationIntervalSeconds')
        if m.get('MfaAuthenticationMethods') is not None:
            self.mfa_authentication_methods = m.get('MfaAuthenticationMethods')
        if m.get('MfaType') is not None:
            self.mfa_type = m.get('MfaType')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPolicies(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        conditional_access_policy_name: str = None,
        conditional_access_policy_type: str = None,
        conditions_config: ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfig = None,
        create_time: int = None,
        decision_config: ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesDecisionConfig = None,
        decision_type: str = None,
        description: str = None,
        evaluate_at: str = None,
        instance_id: str = None,
        last_updated_time: int = None,
        priority: int = None,
        status: str = None,
    ):
        # Conditional access policy ID
        self.conditional_access_policy_id = conditional_access_policy_id
        # Conditional access policy name
        self.conditional_access_policy_name = conditional_access_policy_name
        # Type of the conditional access policy
        self.conditional_access_policy_type = conditional_access_policy_type
        # Content of the conditional access policy
        self.conditions_config = conditions_config
        # Creation Time
        self.create_time = create_time
        # Action of the conditional access policy
        self.decision_config = decision_config
        # Execution type of the conditional access policy
        self.decision_type = decision_type
        # Description of the conditional access policy
        self.description = description
        # Execution point of the conditional access policy
        self.evaluate_at = evaluate_at
        # Instance ID
        self.instance_id = instance_id
        # Last Updated Time
        self.last_updated_time = last_updated_time
        # Priority
        self.priority = priority
        # Enable or disable status of the conditional access policy
        self.status = status

    def validate(self):
        if self.conditions_config:
            self.conditions_config.validate()
        if self.decision_config:
            self.decision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.conditional_access_policy_name is not None:
            result['ConditionalAccessPolicyName'] = self.conditional_access_policy_name
        if self.conditional_access_policy_type is not None:
            result['ConditionalAccessPolicyType'] = self.conditional_access_policy_type
        if self.conditions_config is not None:
            result['ConditionsConfig'] = self.conditions_config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.decision_config is not None:
            result['DecisionConfig'] = self.decision_config.to_map()
        if self.decision_type is not None:
            result['DecisionType'] = self.decision_type
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluate_at is not None:
            result['EvaluateAt'] = self.evaluate_at
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_updated_time is not None:
            result['LastUpdatedTime'] = self.last_updated_time
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('ConditionalAccessPolicyName') is not None:
            self.conditional_access_policy_name = m.get('ConditionalAccessPolicyName')
        if m.get('ConditionalAccessPolicyType') is not None:
            self.conditional_access_policy_type = m.get('ConditionalAccessPolicyType')
        if m.get('ConditionsConfig') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesConditionsConfig()
            self.conditions_config = temp_model.from_map(m['ConditionsConfig'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DecisionConfig') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPoliciesDecisionConfig()
            self.decision_config = temp_model.from_map(m['DecisionConfig'])
        if m.get('DecisionType') is not None:
            self.decision_type = m.get('DecisionType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluateAt') is not None:
            self.evaluate_at = m.get('EvaluateAt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUpdatedTime') is not None:
            self.last_updated_time = m.get('LastUpdatedTime')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponseBody(TeaModel):
    def __init__(
        self,
        conditional_access_policies: List[ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPolicies] = None,
        request_id: str = None,
    ):
        # Collection of conditional access policies
        self.conditional_access_policies = conditional_access_policies
        # Request ID.
        self.request_id = request_id

    def validate(self):
        if self.conditional_access_policies:
            for k in self.conditional_access_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionalAccessPolicies'] = []
        if self.conditional_access_policies is not None:
            for k in self.conditional_access_policies:
                result['ConditionalAccessPolicies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditional_access_policies = []
        if m.get('ConditionalAccessPolicies') is not None:
            for k in m.get('ConditionalAccessPolicies'):
                temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBodyConditionalAccessPolicies()
                self.conditional_access_policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListConditionalAccessPoliciesForNetworkZoneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListConditionalAccessPoliciesForNetworkZoneResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListConditionalAccessPoliciesForNetworkZoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDomainProxyTokensRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDomainProxyTokensResponseBodyDomainProxyTokens(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        domain_id: str = None,
        domain_proxy_token: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
        last_used_time: int = None,
        status: str = None,
        update_time: int = None,
    ):
        # 域名代理Token创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 域名ID。
        self.domain_id = domain_id
        # 域名代理Token。
        self.domain_proxy_token = domain_proxy_token
        # 域名代理Token ID。
        self.domain_proxy_token_id = domain_proxy_token_id
        # 实例ID。
        self.instance_id = instance_id
        # 域名代理Token最近使用时间，Unix时间戳格式，单位为毫秒。
        self.last_used_time = last_used_time
        # token状态，枚举类型：(enabled）启用,（disabled）禁用。
        self.status = status
        # 域名代理Token最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token is not None:
            result['DomainProxyToken'] = self.domain_proxy_token
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_used_time is not None:
            result['LastUsedTime'] = self.last_used_time
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyToken') is not None:
            self.domain_proxy_token = m.get('DomainProxyToken')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUsedTime') is not None:
            self.last_used_time = m.get('LastUsedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListDomainProxyTokensResponseBody(TeaModel):
    def __init__(
        self,
        domain_proxy_tokens: List[ListDomainProxyTokensResponseBodyDomainProxyTokens] = None,
        request_id: str = None,
    ):
        self.domain_proxy_tokens = domain_proxy_tokens
        self.request_id = request_id

    def validate(self):
        if self.domain_proxy_tokens:
            for k in self.domain_proxy_tokens:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainProxyTokens'] = []
        if self.domain_proxy_tokens is not None:
            for k in self.domain_proxy_tokens:
                result['DomainProxyTokens'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_proxy_tokens = []
        if m.get('DomainProxyTokens') is not None:
            for k in m.get('DomainProxyTokens'):
                temp_model = ListDomainProxyTokensResponseBodyDomainProxyTokens()
                self.domain_proxy_tokens.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDomainProxyTokensResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDomainProxyTokensResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDomainProxyTokensResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDomainsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDomainsResponseBodyDomainsFiling(TeaModel):
    def __init__(
        self,
        icp_number: str = None,
    ):
        # 域名关联的备案号, 长度最大限制64。
        self.icp_number = icp_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.icp_number is not None:
            result['IcpNumber'] = self.icp_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IcpNumber') is not None:
            self.icp_number = m.get('IcpNumber')
        return self


class ListDomainsResponseBodyDomains(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        default_domain: bool = None,
        domain: str = None,
        domain_id: str = None,
        domain_type: str = None,
        filing: ListDomainsResponseBodyDomainsFiling = None,
        instance_id: str = None,
        lock_mode: str = None,
        update_time: int = None,
    ):
        # 域名创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 是否默认域名。true表示实例默认域名，false表示非默认域名
        self.default_domain = default_domain
        # 域名。
        self.domain = domain
        # 域名ID。
        self.domain_id = domain_id
        # 域名类型。枚举取值:system_init(系统初始化)、user_custom(用户自定义)。
        self.domain_type = domain_type
        # 域名备案信息。
        self.filing = filing
        # 实例ID。
        self.instance_id = instance_id
        # 域名锁定状态。枚举取值:unlock(正常)、lockByLicense(因License限制不可用)。
        self.lock_mode = lock_mode
        # 域名最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time

    def validate(self):
        if self.filing:
            self.filing.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.default_domain is not None:
            result['DefaultDomain'] = self.default_domain
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.filing is not None:
            result['Filing'] = self.filing.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DefaultDomain') is not None:
            self.default_domain = m.get('DefaultDomain')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('Filing') is not None:
            temp_model = ListDomainsResponseBodyDomainsFiling()
            self.filing = temp_model.from_map(m['Filing'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListDomainsResponseBody(TeaModel):
    def __init__(
        self,
        domains: List[ListDomainsResponseBodyDomains] = None,
        request_id: str = None,
    ):
        self.domains = domains
        self.request_id = request_id

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = ListDomainsResponseBodyDomains()
                self.domains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEiamInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        instance_region_id: str = None,
    ):
        # 实例ID列表，支持0到100个
        self.instance_ids = instance_ids
        # 实例所属Region
        self.instance_region_id = instance_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.instance_region_id is not None:
            result['InstanceRegionId'] = self.instance_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('InstanceRegionId') is not None:
            self.instance_region_id = m.get('InstanceRegionId')
        return self


class ListEiamInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        description: str = None,
        developer_apiprivate_domain: str = None,
        developer_apipublic_domain: str = None,
        instance_id: str = None,
        instance_status: str = None,
        instance_version: str = None,
        open_apiprivate_domain: str = None,
        open_apipublic_domain: str = None,
        ssodomain: str = None,
        start_time: int = None,
    ):
        # 实例描述信息
        self.description = description
        # 实例developer私网域名地址
        self.developer_apiprivate_domain = developer_apiprivate_domain
        # 实例developer公网域名地址
        self.developer_apipublic_domain = developer_apipublic_domain
        # 实例id
        self.instance_id = instance_id
        # 实例状态，Pending(初始状态)、Creating(创建中)、Running(运行中)、Disabled(禁用)、CreateFailed(创建失败)
        self.instance_status = instance_status
        # 实例版本，EIAM2.0/ EIAM1.0
        self.instance_version = instance_version
        # 实例openApi私网域名地址
        self.open_apiprivate_domain = open_apiprivate_domain
        # 实例openApi公网域名地址
        self.open_apipublic_domain = open_apipublic_domain
        # 实例域名地址
        self.ssodomain = ssodomain
        # 实例的创建时间
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.developer_apiprivate_domain is not None:
            result['DeveloperAPIPrivateDomain'] = self.developer_apiprivate_domain
        if self.developer_apipublic_domain is not None:
            result['DeveloperAPIPublicDomain'] = self.developer_apipublic_domain
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        if self.instance_version is not None:
            result['InstanceVersion'] = self.instance_version
        if self.open_apiprivate_domain is not None:
            result['OpenAPIPrivateDomain'] = self.open_apiprivate_domain
        if self.open_apipublic_domain is not None:
            result['OpenAPIPublicDomain'] = self.open_apipublic_domain
        if self.ssodomain is not None:
            result['SSODomain'] = self.ssodomain
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeveloperAPIPrivateDomain') is not None:
            self.developer_apiprivate_domain = m.get('DeveloperAPIPrivateDomain')
        if m.get('DeveloperAPIPublicDomain') is not None:
            self.developer_apipublic_domain = m.get('DeveloperAPIPublicDomain')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        if m.get('InstanceVersion') is not None:
            self.instance_version = m.get('InstanceVersion')
        if m.get('OpenAPIPrivateDomain') is not None:
            self.open_apiprivate_domain = m.get('OpenAPIPrivateDomain')
        if m.get('OpenAPIPublicDomain') is not None:
            self.open_apipublic_domain = m.get('OpenAPIPublicDomain')
        if m.get('SSODomain') is not None:
            self.ssodomain = m.get('SSODomain')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListEiamInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[ListEiamInstancesResponseBodyInstances] = None,
        request_id: str = None,
    ):
        self.instances = instances
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListEiamInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListEiamInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEiamInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEiamInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEiamRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_id: str = None,
    ):
        # 地域名称
        self.local_name = local_name
        # 地域ID
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListEiamRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[ListEiamRegionsResponseBodyRegions] = None,
        request_id: str = None,
    ):
        self.regions = regions
        self.request_id = request_id

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = ListEiamRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListEiamRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListEiamRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListEiamRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGroupsRequest(TeaModel):
    def __init__(
        self,
        group_external_id: str = None,
        group_ids: List[str] = None,
        group_name: str = None,
        group_name_starts_with: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The external ID of the group.
        self.group_external_id = group_external_id
        # The group IDs.
        self.group_ids = group_ids
        # The name of the group. If you specify this parameter, the query is based on an exact match.
        self.group_name = group_name
        # The prefix of the group name. If you specify this parameter, the query follows the leftmost matching principle.
        self.group_name_starts_with = group_name_starts_with
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_external_id is not None:
            result['GroupExternalId'] = self.group_external_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_name_starts_with is not None:
            result['GroupNameStartsWith'] = self.group_name_starts_with
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupExternalId') is not None:
            self.group_external_id = m.get('GroupExternalId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupNameStartsWith') is not None:
            self.group_name_starts_with = m.get('GroupNameStartsWith')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGroupsResponseBodyGroups(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        group_external_id: str = None,
        group_id: str = None,
        group_name: str = None,
        group_source_id: str = None,
        group_source_type: str = None,
        instance_id: str = None,
        update_time: int = None,
    ):
        # The time at which the group was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The description of the group.
        self.description = description
        # The external ID of the group, which can be used to associate the group with an external system. By default, the external ID is the group ID.
        self.group_external_id = group_external_id
        # The group ID.
        self.group_id = group_id
        # The name of the group.
        self.group_name = group_name
        # The source ID of the group. If the group was imported from other services, this value indicates the external source ID. By default, the source ID is the instance ID.
        self.group_source_id = group_source_id
        # The source type of the group. Only build_in may be returned, which indicates that the group was created in IDaaS.
        self.group_source_type = group_source_type
        # The instance ID.
        self.instance_id = instance_id
        # The time at which the group was last updated. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_external_id is not None:
            result['GroupExternalId'] = self.group_external_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_source_id is not None:
            result['GroupSourceId'] = self.group_source_id
        if self.group_source_type is not None:
            result['GroupSourceType'] = self.group_source_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupExternalId') is not None:
            self.group_external_id = m.get('GroupExternalId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupSourceId') is not None:
            self.group_source_id = m.get('GroupSourceId')
        if m.get('GroupSourceType') is not None:
            self.group_source_type = m.get('GroupSourceType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListGroupsResponseBody(TeaModel):
    def __init__(
        self,
        groups: List[ListGroupsResponseBodyGroups] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried account groups.
        self.groups = groups
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned. The maximum number of entries returned at a time depends on the value of PageSize.
        self.total_count = total_count

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = ListGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGroupsForApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        group_ids: List[str] = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The group IDs. You can specify up to 100 group IDs at a time.
        self.group_ids = group_ids
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListGroupsForApplicationResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_id: str = None,
    ):
        # The group ID.
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ListGroupsForApplicationResponseBody(TeaModel):
    def __init__(
        self,
        groups: List[ListGroupsForApplicationResponseBodyGroups] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The group IDs.
        self.groups = groups
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = ListGroupsForApplicationResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListGroupsForApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGroupsForApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGroupsForApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGroupsForUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListGroupsForUserResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_member_relation_source_id: str = None,
        group_member_relation_source_type: str = None,
    ):
        # The group ID.
        self.group_id = group_id
        # Account membership source ID
        self.group_member_relation_source_id = group_member_relation_source_id
        # Account membership source type
        self.group_member_relation_source_type = group_member_relation_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_member_relation_source_id is not None:
            result['GroupMemberRelationSourceId'] = self.group_member_relation_source_id
        if self.group_member_relation_source_type is not None:
            result['GroupMemberRelationSourceType'] = self.group_member_relation_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupMemberRelationSourceId') is not None:
            self.group_member_relation_source_id = m.get('GroupMemberRelationSourceId')
        if m.get('GroupMemberRelationSourceType') is not None:
            self.group_member_relation_source_type = m.get('GroupMemberRelationSourceType')
        return self


class ListGroupsForUserResponseBody(TeaModel):
    def __init__(
        self,
        groups: List[ListGroupsForUserResponseBodyGroups] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The queried account groups.
        self.groups = groups
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned. The maximum number of entries returned at a time depends on the value of PageSize.
        self.total_count = total_count

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = ListGroupsForUserResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListGroupsForUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListGroupsForUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGroupsForUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIdentityProvidersRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 当前查询的列表页码，默认为1。
        self.page_number = page_number
        # 当前查询的列表页码，默认为20。
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListIdentityProvidersResponseBodyIdentityProviders(TeaModel):
    def __init__(
        self,
        advanced_status: str = None,
        authn_source_supplier: str = None,
        authn_source_type: str = None,
        authn_status: str = None,
        create_time: int = None,
        description: str = None,
        identity_provider_external_id: str = None,
        identity_provider_id: str = None,
        identity_provider_name: str = None,
        identity_provider_type: str = None,
        incremental_callback_status: str = None,
        instance_id: str = None,
        last_status_check_job_result: str = None,
        lock_reason: str = None,
        logo_url: str = None,
        periodic_sync_status: str = None,
        ud_pull_status: str = None,
        ud_pull_target_scope: str = None,
        ud_push_status: str = None,
        update_time: int = None,
    ):
        # 高阶配置能力
        self.advanced_status = advanced_status
        # IDaaS EIAM 对应的认证来源产品，okta or google or azure ad
        self.authn_source_supplier = authn_source_supplier
        # IDaaS EIAM 认证方式类型 oidc or saml
        self.authn_source_type = authn_source_type
        # IDaaS EIAM 对应IdP是否支持认证
        self.authn_status = authn_status
        self.create_time = create_time
        # IDaaS EIAM 身份提供方描述
        self.description = description
        # IDaaS EIAM 身份提供方外部ID
        self.identity_provider_external_id = identity_provider_external_id
        # IDaaS EIAM 身份提供方ID
        self.identity_provider_id = identity_provider_id
        # IDaaS EIAM 身份提供方名称
        self.identity_provider_name = identity_provider_name
        # 身份提供方同步类型
        self.identity_provider_type = identity_provider_type
        # 增量回调状态，是否处理来自IdP的增量回调数据
        self.incremental_callback_status = incremental_callback_status
        # IDaaS EIAM 实例Id
        self.instance_id = instance_id
        self.last_status_check_job_result = last_status_check_job_result
        # 锁定原因
        self.lock_reason = lock_reason
        self.logo_url = logo_url
        self.periodic_sync_status = periodic_sync_status
        # IDaaS EIAM 是否支持UD同步
        self.ud_pull_status = ud_pull_status
        # 当支持ud_pullIDaaS侧UD中的范围
        self.ud_pull_target_scope = ud_pull_target_scope
        # 同步出能力
        self.ud_push_status = ud_push_status
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_status is not None:
            result['AdvancedStatus'] = self.advanced_status
        if self.authn_source_supplier is not None:
            result['AuthnSourceSupplier'] = self.authn_source_supplier
        if self.authn_source_type is not None:
            result['AuthnSourceType'] = self.authn_source_type
        if self.authn_status is not None:
            result['AuthnStatus'] = self.authn_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.identity_provider_external_id is not None:
            result['IdentityProviderExternalId'] = self.identity_provider_external_id
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.identity_provider_name is not None:
            result['IdentityProviderName'] = self.identity_provider_name
        if self.identity_provider_type is not None:
            result['IdentityProviderType'] = self.identity_provider_type
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_status_check_job_result is not None:
            result['LastStatusCheckJobResult'] = self.last_status_check_job_result
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.periodic_sync_status is not None:
            result['PeriodicSyncStatus'] = self.periodic_sync_status
        if self.ud_pull_status is not None:
            result['UdPullStatus'] = self.ud_pull_status
        if self.ud_pull_target_scope is not None:
            result['UdPullTargetScope'] = self.ud_pull_target_scope
        if self.ud_push_status is not None:
            result['UdPushStatus'] = self.ud_push_status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdvancedStatus') is not None:
            self.advanced_status = m.get('AdvancedStatus')
        if m.get('AuthnSourceSupplier') is not None:
            self.authn_source_supplier = m.get('AuthnSourceSupplier')
        if m.get('AuthnSourceType') is not None:
            self.authn_source_type = m.get('AuthnSourceType')
        if m.get('AuthnStatus') is not None:
            self.authn_status = m.get('AuthnStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IdentityProviderExternalId') is not None:
            self.identity_provider_external_id = m.get('IdentityProviderExternalId')
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('IdentityProviderName') is not None:
            self.identity_provider_name = m.get('IdentityProviderName')
        if m.get('IdentityProviderType') is not None:
            self.identity_provider_type = m.get('IdentityProviderType')
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastStatusCheckJobResult') is not None:
            self.last_status_check_job_result = m.get('LastStatusCheckJobResult')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('PeriodicSyncStatus') is not None:
            self.periodic_sync_status = m.get('PeriodicSyncStatus')
        if m.get('UdPullStatus') is not None:
            self.ud_pull_status = m.get('UdPullStatus')
        if m.get('UdPullTargetScope') is not None:
            self.ud_pull_target_scope = m.get('UdPullTargetScope')
        if m.get('UdPushStatus') is not None:
            self.ud_push_status = m.get('UdPushStatus')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListIdentityProvidersResponseBody(TeaModel):
    def __init__(
        self,
        identity_providers: List[ListIdentityProvidersResponseBodyIdentityProviders] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.identity_providers = identity_providers
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.identity_providers:
            for k in self.identity_providers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IdentityProviders'] = []
        if self.identity_providers is not None:
            for k in self.identity_providers:
                result['IdentityProviders'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.identity_providers = []
        if m.get('IdentityProviders') is not None:
            for k in m.get('IdentityProviders'):
                temp_model = ListIdentityProvidersResponseBodyIdentityProviders()
                self.identity_providers.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListIdentityProvidersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListIdentityProvidersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListIdentityProvidersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        page_number: int = None,
        page_size: int = None,
        status: str = None,
    ):
        # The list of instance IDs.
        self.instance_ids = instance_ids
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The status of the instance. Valid values:
        # 
        # *   creating
        # *   running
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBodyInstancesDefaultEndpoint(TeaModel):
    def __init__(
        self,
        endpoint: str = None,
        status: str = None,
    ):
        # The endpoint of the instance.
        self.endpoint = endpoint
        # The status of the endpoint. Valid values:
        # 
        # *   resolved
        # *   unresolved
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        default_endpoint: ListInstancesResponseBodyInstancesDefaultEndpoint = None,
        description: str = None,
        instance_id: str = None,
        status: str = None,
    ):
        # The time when the instance was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The default endpoint of the instance.
        self.default_endpoint = default_endpoint
        # The description of the instance.
        self.description = description
        # The instance ID.
        self.instance_id = instance_id
        # The status of the instance. Valid values:
        # 
        # *   creating
        # *   running
        self.status = status

    def validate(self):
        if self.default_endpoint:
            self.default_endpoint.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.default_endpoint is not None:
            result['DefaultEndpoint'] = self.default_endpoint.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DefaultEndpoint') is not None:
            temp_model = ListInstancesResponseBodyInstancesDefaultEndpoint()
            self.default_endpoint = temp_model.from_map(m['DefaultEndpoint'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[ListInstancesResponseBodyInstances] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information of instances.
        self.instances = instances
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNetworkAccessEndpointAvailableRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_id: str = None,
    ):
        # 地域名称。
        self.local_name = local_name
        # 地域ID。
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListNetworkAccessEndpointAvailableRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[ListNetworkAccessEndpointAvailableRegionsResponseBodyRegions] = None,
        request_id: str = None,
    ):
        self.regions = regions
        self.request_id = request_id

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = ListNetworkAccessEndpointAvailableRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListNetworkAccessEndpointAvailableRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNetworkAccessEndpointAvailableRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNetworkAccessEndpointAvailableRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNetworkAccessEndpointAvailableZonesRequest(TeaModel):
    def __init__(
        self,
        nae_region_id: str = None,
    ):
        # 专属网络端点支持的地域
        # 
        # This parameter is required.
        self.nae_region_id = nae_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nae_region_id is not None:
            result['NaeRegionId'] = self.nae_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NaeRegionId') is not None:
            self.nae_region_id = m.get('NaeRegionId')
        return self


class ListNetworkAccessEndpointAvailableZonesResponseBodyZones(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        zone_id: str = None,
    ):
        # 可用区名称。
        self.local_name = local_name
        # 可用区ID。
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class ListNetworkAccessEndpointAvailableZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zones: List[ListNetworkAccessEndpointAvailableZonesResponseBodyZones] = None,
    ):
        self.request_id = request_id
        self.zones = zones

    def validate(self):
        if self.zones:
            for k in self.zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Zones'] = []
        if self.zones is not None:
            for k in self.zones:
                result['Zones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.zones = []
        if m.get('Zones') is not None:
            for k in m.get('Zones'):
                temp_model = ListNetworkAccessEndpointAvailableZonesResponseBodyZones()
                self.zones.append(temp_model.from_map(k))
        return self


class ListNetworkAccessEndpointAvailableZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNetworkAccessEndpointAvailableZonesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNetworkAccessEndpointAvailableZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNetworkAccessEndpointsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        network_access_endpoint_status: str = None,
        network_access_endpoint_type: str = None,
        next_token: str = None,
        vpc_id: str = None,
        vpc_region_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 分页查询时每页行数。默认值为20，最大值为100。
        self.max_results = max_results
        # 专属网络端点连接的状态。NetworkAccessEndpointType取值为shared时不生效。
        self.network_access_endpoint_status = network_access_endpoint_status
        # 专属网络端点连接的类型。取值可选范围：1. private - 专属网络端点；2. shared - 共享网络端点
        self.network_access_endpoint_type = network_access_endpoint_type
        # 查询凭证（Token），取值为上一次API调用返回的NextToken参数值。
        self.next_token = next_token
        # 专属网络端点连接的Vpc ID。NetworkAccessEndpointType取值为shared时不生效。
        self.vpc_id = vpc_id
        # 专属网络端点连接的Vpc所属地域，该地域取值必须在ListNetworkAccessEndpointAvailableRegions接口中返回。NetworkAccessEndpointType取值为shared时不生效。
        self.vpc_region_id = vpc_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_access_endpoint_status is not None:
            result['NetworkAccessEndpointStatus'] = self.network_access_endpoint_status
        if self.network_access_endpoint_type is not None:
            result['NetworkAccessEndpointType'] = self.network_access_endpoint_type
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkAccessEndpointStatus') is not None:
            self.network_access_endpoint_status = m.get('NetworkAccessEndpointStatus')
        if m.get('NetworkAccessEndpointType') is not None:
            self.network_access_endpoint_type = m.get('NetworkAccessEndpointType')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class ListNetworkAccessEndpointsResponseBodyNetworkAccessEndpoints(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
        network_access_endpoint_name: str = None,
        network_access_endpoint_type: str = None,
        security_group_id: str = None,
        status: str = None,
        update_time: int = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
        vpc_region_id: str = None,
    ):
        # 专属网络端点创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 实例ID。
        self.instance_id = instance_id
        # 专属网络端点ID。
        self.network_access_endpoint_id = network_access_endpoint_id
        # 专属网络端点名称。
        self.network_access_endpoint_name = network_access_endpoint_name
        # 专属网络端点连接的类型。
        self.network_access_endpoint_type = network_access_endpoint_type
        # 专属网络端点使用的安全组ID。
        self.security_group_id = security_group_id
        # 专属网络端点状态。
        self.status = status
        # 专属网络端点最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time
        # 专属网络端点连接的指定vSwitch列表。
        self.v_switch_ids = v_switch_ids
        # 专属网络端点连接的VpcID。
        self.vpc_id = vpc_id
        # 专属网络端点连接的Vpc所属地域。
        self.vpc_region_id = vpc_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.network_access_endpoint_name is not None:
            result['NetworkAccessEndpointName'] = self.network_access_endpoint_name
        if self.network_access_endpoint_type is not None:
            result['NetworkAccessEndpointType'] = self.network_access_endpoint_type
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('NetworkAccessEndpointName') is not None:
            self.network_access_endpoint_name = m.get('NetworkAccessEndpointName')
        if m.get('NetworkAccessEndpointType') is not None:
            self.network_access_endpoint_type = m.get('NetworkAccessEndpointType')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class ListNetworkAccessEndpointsResponseBody(TeaModel):
    def __init__(
        self,
        network_access_endpoints: List[ListNetworkAccessEndpointsResponseBodyNetworkAccessEndpoints] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.network_access_endpoints = network_access_endpoints
        # 本次调用返回的查询凭证（Token）值，用于下一次翻页查询。
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.network_access_endpoints:
            for k in self.network_access_endpoints:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkAccessEndpoints'] = []
        if self.network_access_endpoints is not None:
            for k in self.network_access_endpoints:
                result['NetworkAccessEndpoints'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_access_endpoints = []
        if m.get('NetworkAccessEndpoints') is not None:
            for k in m.get('NetworkAccessEndpoints'):
                temp_model = ListNetworkAccessEndpointsResponseBodyNetworkAccessEndpoints()
                self.network_access_endpoints.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListNetworkAccessEndpointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNetworkAccessEndpointsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNetworkAccessEndpointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNetworkAccessPathsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 专属网络端点ID。
        # 
        # This parameter is required.
        self.network_access_endpoint_id = network_access_endpoint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        return self


class ListNetworkAccessPathsResponseBodyNetworkAccessPaths(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        instance_id: str = None,
        network_access_endpoint_id: str = None,
        network_access_path_id: str = None,
        network_interface_id: str = None,
        private_ip_address: str = None,
        status: str = None,
        update_time: int = None,
        v_switch_id: str = None,
    ):
        # 专属网络端点访问路径创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 实例ID。
        self.instance_id = instance_id
        # 专属网络端点ID。
        self.network_access_endpoint_id = network_access_endpoint_id
        # 专属网络端点访问路径ID。
        self.network_access_path_id = network_access_path_id
        # 专属网络端点访问路径使用的ENI ID。
        self.network_interface_id = network_interface_id
        # 专属网络端点访问路径使用的ENI私网地址。
        self.private_ip_address = private_ip_address
        # 专属网络端点访问路径状态。
        self.status = status
        # 专属网络端点访问路径最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time
        # 专属网络端点访问路径的ENI归属的交换机ID。
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.network_access_path_id is not None:
            result['NetworkAccessPathId'] = self.network_access_path_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('NetworkAccessPathId') is not None:
            self.network_access_path_id = m.get('NetworkAccessPathId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class ListNetworkAccessPathsResponseBody(TeaModel):
    def __init__(
        self,
        network_access_paths: List[ListNetworkAccessPathsResponseBodyNetworkAccessPaths] = None,
        request_id: str = None,
    ):
        self.network_access_paths = network_access_paths
        self.request_id = request_id

    def validate(self):
        if self.network_access_paths:
            for k in self.network_access_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkAccessPaths'] = []
        if self.network_access_paths is not None:
            for k in self.network_access_paths:
                result['NetworkAccessPaths'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_access_paths = []
        if m.get('NetworkAccessPaths') is not None:
            for k in m.get('NetworkAccessPaths'):
                temp_model = ListNetworkAccessPathsResponseBodyNetworkAccessPaths()
                self.network_access_paths.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListNetworkAccessPathsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListNetworkAccessPathsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListNetworkAccessPathsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrganizationalUnitParentsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_id: str = None,
    ):
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 组织ID。
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        return self


class ListOrganizationalUnitParentsResponseBodyParents(TeaModel):
    def __init__(
        self,
        organizational_unit_id: str = None,
        parent_id: str = None,
    ):
        # 组织ID
        self.organizational_unit_id = organizational_unit_id
        # 父组织ID
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ListOrganizationalUnitParentsResponseBody(TeaModel):
    def __init__(
        self,
        parents: List[ListOrganizationalUnitParentsResponseBodyParents] = None,
        request_id: str = None,
    ):
        self.parents = parents
        self.request_id = request_id

    def validate(self):
        if self.parents:
            for k in self.parents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Parents'] = []
        if self.parents is not None:
            for k in self.parents:
                result['Parents'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parents = []
        if m.get('Parents') is not None:
            for k in m.get('Parents'):
                temp_model = ListOrganizationalUnitParentsResponseBodyParents()
                self.parents.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListOrganizationalUnitParentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrganizationalUnitParentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrganizationalUnitParentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrganizationalUnitsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
        organizational_unit_name: str = None,
        organizational_unit_name_starts_with: str = None,
        page_number: int = None,
        page_size: int = None,
        parent_id: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of organizational units.
        self.organizational_unit_ids = organizational_unit_ids
        # The name of the organizational unit.
        self.organizational_unit_name = organizational_unit_name
        # Organization name, matching left
        self.organizational_unit_name_starts_with = organizational_unit_name_starts_with
        # The number of the page to return. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 20.
        self.page_size = page_size
        # The ID of the parent organizational unit.
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.organizational_unit_name_starts_with is not None:
            result['OrganizationalUnitNameStartsWith'] = self.organizational_unit_name_starts_with
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('OrganizationalUnitNameStartsWith') is not None:
            self.organizational_unit_name_starts_with = m.get('OrganizationalUnitNameStartsWith')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ListOrganizationalUnitsResponseBodyOrganizationalUnits(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        instance_id: str = None,
        leaf: bool = None,
        organizational_unit_external_id: str = None,
        organizational_unit_id: str = None,
        organizational_unit_name: str = None,
        organizational_unit_source_id: str = None,
        organizational_unit_source_type: str = None,
        parent_id: str = None,
        update_time: int = None,
    ):
        # The time when the organizational unit was created. This value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the organizational unit.
        self.description = description
        # The ID of the instance.
        self.instance_id = instance_id
        # Indicates whether the node is a leaf node.
        self.leaf = leaf
        # The external ID of the organizational unit. The external ID can be used by external data to map the data of the organizational unit in IDaaS EIAM. By default, the external ID is the organizational unit ID.
        # 
        # For organizational units with the same source type and source ID, each organizational unit has a unique external ID.
        self.organizational_unit_external_id = organizational_unit_external_id
        # The ID of the organizational unit.
        self.organizational_unit_id = organizational_unit_id
        # 组织名称。
        self.organizational_unit_name = organizational_unit_name
        # The source ID of the organizational unit.
        self.organizational_unit_source_id = organizational_unit_source_id
        # The source type of the organizational unit. Valid values:
        # 
        # *   build_in: The organizational unit was created in IDaaS.
        # *   ding_talk: The organizational unit was imported from DingTalk.
        # *   ad: The organizational unit was imported from Microsoft Active Directory (AD).
        # *   ldap: The organizational unit was imported from a Lightweight Directory Access Protocol (LDAP) service.
        self.organizational_unit_source_type = organizational_unit_source_type
        # The ID of the parent organizational unit.
        self.parent_id = parent_id
        # The time when the organizational unit was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.leaf is not None:
            result['Leaf'] = self.leaf
        if self.organizational_unit_external_id is not None:
            result['OrganizationalUnitExternalId'] = self.organizational_unit_external_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.organizational_unit_name is not None:
            result['OrganizationalUnitName'] = self.organizational_unit_name
        if self.organizational_unit_source_id is not None:
            result['OrganizationalUnitSourceId'] = self.organizational_unit_source_id
        if self.organizational_unit_source_type is not None:
            result['OrganizationalUnitSourceType'] = self.organizational_unit_source_type
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Leaf') is not None:
            self.leaf = m.get('Leaf')
        if m.get('OrganizationalUnitExternalId') is not None:
            self.organizational_unit_external_id = m.get('OrganizationalUnitExternalId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('OrganizationalUnitName') is not None:
            self.organizational_unit_name = m.get('OrganizationalUnitName')
        if m.get('OrganizationalUnitSourceId') is not None:
            self.organizational_unit_source_id = m.get('OrganizationalUnitSourceId')
        if m.get('OrganizationalUnitSourceType') is not None:
            self.organizational_unit_source_type = m.get('OrganizationalUnitSourceType')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListOrganizationalUnitsResponseBody(TeaModel):
    def __init__(
        self,
        organizational_units: List[ListOrganizationalUnitsResponseBodyOrganizationalUnits] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of data objects of organizational units.
        self.organizational_units = organizational_units
        # The ID of the request.
        self.request_id = request_id
        # The number of entries in the list.
        self.total_count = total_count

    def validate(self):
        if self.organizational_units:
            for k in self.organizational_units:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OrganizationalUnits'] = []
        if self.organizational_units is not None:
            for k in self.organizational_units:
                result['OrganizationalUnits'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.organizational_units = []
        if m.get('OrganizationalUnits') is not None:
            for k in m.get('OrganizationalUnits'):
                temp_model = ListOrganizationalUnitsResponseBodyOrganizationalUnits()
                self.organizational_units.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListOrganizationalUnitsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrganizationalUnitsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrganizationalUnitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOrganizationalUnitsForApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the application that you want to query.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of the organizations that are allowed to access the application. You can query a maximum of 100 organization IDs at a time.
        self.organizational_unit_ids = organizational_unit_ids
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListOrganizationalUnitsForApplicationResponseBodyOrganizationalUnits(TeaModel):
    def __init__(
        self,
        organizational_unit_id: str = None,
    ):
        # The ID of the organization that is allowed to access the application.
        self.organizational_unit_id = organizational_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        return self


class ListOrganizationalUnitsForApplicationResponseBody(TeaModel):
    def __init__(
        self,
        organizational_units: List[ListOrganizationalUnitsForApplicationResponseBodyOrganizationalUnits] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The IDs of the organizations that are allowed to access the application.
        self.organizational_units = organizational_units
        # The ID of the request.
        self.request_id = request_id
        # The total number of the returned entries.
        self.total_count = total_count

    def validate(self):
        if self.organizational_units:
            for k in self.organizational_units:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OrganizationalUnits'] = []
        if self.organizational_units is not None:
            for k in self.organizational_units:
                result['OrganizationalUnits'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.organizational_units = []
        if m.get('OrganizationalUnits') is not None:
            for k in m.get('OrganizationalUnits'):
                temp_model = ListOrganizationalUnitsForApplicationResponseBodyOrganizationalUnits()
                self.organizational_units.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListOrganizationalUnitsForApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOrganizationalUnitsForApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOrganizationalUnitsForApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_endpoint: str = None,
        region_id: str = None,
    ):
        # The name of the region.
        self.local_name = local_name
        # The endpoint of the region.
        self.region_endpoint = region_endpoint
        # The ID of the region.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[ListRegionsResponseBodyRegions] = None,
        request_id: str = None,
    ):
        # The supported regions.
        self.regions = regions
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = ListRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSynchronizationJobsRequestFilters(TeaModel):
    def __init__(
        self,
        key: str = None,
        values: List[str] = None,
    ):
        self.key = key
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class ListSynchronizationJobsRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        end_time: int = None,
        filters: List[ListSynchronizationJobsRequestFilters] = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: int = None,
        status: str = None,
        target_ids: List[str] = None,
        target_type: str = None,
    ):
        # 同步方向[ingress,egress]
        self.direction = direction
        # 同步结束时间
        self.end_time = end_time
        self.filters = filters
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 分页查询时每页行数。默认值为20，最大值为100。
        self.max_results = max_results
        # 查询凭证（Token），取值为上一次API调用返回的NextToken参数值。
        self.next_token = next_token
        # 当前查询的列表页码，默认为1。
        self.page_number = page_number
        # 当前查询的列表页码，默认为20。
        self.page_size = page_size
        # 同步开始时间
        self.start_time = start_time
        # 同步状态[pending,running,suspending,failed,partial_success,success]
        self.status = status
        # 同步目标ID
        self.target_ids = target_ids
        # 同步目标类型[identity_provider,organizational_unit,application,user]
        self.target_type = target_type

    def validate(self):
        if self.filters:
            for k in self.filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['Filters'] = []
        if self.filters is not None:
            for k in self.filters:
                result['Filters'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.filters = []
        if m.get('Filters') is not None:
            for k in m.get('Filters'):
                temp_model = ListSynchronizationJobsRequestFilters()
                self.filters.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatistics(TeaModel):
    def __init__(
        self,
        binded: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsBinded = None,
        created: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsCreated = None,
        deleted: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsDeleted = None,
        pushed: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsPushed = None,
        same: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsSame = None,
        updated: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatistics(TeaModel):
    def __init__(
        self,
        binded: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsBinded = None,
        created: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsCreated = None,
        deleted: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsDeleted = None,
        pushed: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsPushed = None,
        same: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsSame = None,
        updated: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatistics(TeaModel):
    def __init__(
        self,
        binded: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsBinded = None,
        created: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsCreated = None,
        deleted: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsDeleted = None,
        pushed: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsPushed = None,
        same: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsSame = None,
        updated: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Pushed') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsBinded(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsCreated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsDeleted(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsExported(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        self.failed = failed
        self.skipped = skipped
        self.success = success
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsPushed(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsSame(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsUpdated(TeaModel):
    def __init__(
        self,
        failed: int = None,
        skipped: int = None,
        success: int = None,
        total: int = None,
    ):
        # 失败数目
        self.failed = failed
        # 跳过数目
        self.skipped = skipped
        # 成功数目
        self.success = success
        # 总共数目
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.skipped is not None:
            result['Skipped'] = self.skipped
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('Skipped') is not None:
            self.skipped = m.get('Skipped')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatistics(TeaModel):
    def __init__(
        self,
        binded: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsBinded = None,
        created: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsCreated = None,
        deleted: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsDeleted = None,
        exported: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsExported = None,
        pushed: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsPushed = None,
        same: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsSame = None,
        updated: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsUpdated = None,
    ):
        # 绑定结果统计
        self.binded = binded
        # 创建结果统计
        self.created = created
        # 删除结果统计
        self.deleted = deleted
        self.exported = exported
        # 推送结果统计
        self.pushed = pushed
        # 相同结果统计
        self.same = same
        # 更新结果统计
        self.updated = updated

    def validate(self):
        if self.binded:
            self.binded.validate()
        if self.created:
            self.created.validate()
        if self.deleted:
            self.deleted.validate()
        if self.exported:
            self.exported.validate()
        if self.pushed:
            self.pushed.validate()
        if self.same:
            self.same.validate()
        if self.updated:
            self.updated.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binded is not None:
            result['Binded'] = self.binded.to_map()
        if self.created is not None:
            result['Created'] = self.created.to_map()
        if self.deleted is not None:
            result['Deleted'] = self.deleted.to_map()
        if self.exported is not None:
            result['Exported'] = self.exported.to_map()
        if self.pushed is not None:
            result['Pushed'] = self.pushed.to_map()
        if self.same is not None:
            result['Same'] = self.same.to_map()
        if self.updated is not None:
            result['Updated'] = self.updated.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Binded') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsBinded()
            self.binded = temp_model.from_map(m['Binded'])
        if m.get('Created') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsCreated()
            self.created = temp_model.from_map(m['Created'])
        if m.get('Deleted') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsDeleted()
            self.deleted = temp_model.from_map(m['Deleted'])
        if m.get('Exported') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsExported()
            self.exported = temp_model.from_map(m['Exported'])
        if m.get('Pushed') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsPushed()
            self.pushed = temp_model.from_map(m['Pushed'])
        if m.get('Same') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsSame()
            self.same = temp_model.from_map(m['Same'])
        if m.get('Updated') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatisticsUpdated()
            self.updated = temp_model.from_map(m['Updated'])
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobsResult(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_message: str = None,
        group_member_statistics: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatistics = None,
        group_statistics: ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatistics = None,
        organizational_unit_statistics: ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatistics = None,
        user_statistics: ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatistics = None,
    ):
        # 同步结果错误码
        self.error_code = error_code
        # 同步结果错误信息描述
        self.error_message = error_message
        # 组成员同步结果统计
        self.group_member_statistics = group_member_statistics
        # 组同步结果统计
        self.group_statistics = group_statistics
        # 组织同步结果统计
        self.organizational_unit_statistics = organizational_unit_statistics
        # 用户同步结果统计
        self.user_statistics = user_statistics

    def validate(self):
        if self.group_member_statistics:
            self.group_member_statistics.validate()
        if self.group_statistics:
            self.group_statistics.validate()
        if self.organizational_unit_statistics:
            self.organizational_unit_statistics.validate()
        if self.user_statistics:
            self.user_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_member_statistics is not None:
            result['GroupMemberStatistics'] = self.group_member_statistics.to_map()
        if self.group_statistics is not None:
            result['GroupStatistics'] = self.group_statistics.to_map()
        if self.organizational_unit_statistics is not None:
            result['OrganizationalUnitStatistics'] = self.organizational_unit_statistics.to_map()
        if self.user_statistics is not None:
            result['UserStatistics'] = self.user_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupMemberStatistics') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupMemberStatistics()
            self.group_member_statistics = temp_model.from_map(m['GroupMemberStatistics'])
        if m.get('GroupStatistics') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultGroupStatistics()
            self.group_statistics = temp_model.from_map(m['GroupStatistics'])
        if m.get('OrganizationalUnitStatistics') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultOrganizationalUnitStatistics()
            self.organizational_unit_statistics = temp_model.from_map(m['OrganizationalUnitStatistics'])
        if m.get('UserStatistics') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResultUserStatistics()
            self.user_statistics = temp_model.from_map(m['UserStatistics'])
        return self


class ListSynchronizationJobsResponseBodySynchronizationJobs(TeaModel):
    def __init__(
        self,
        description: str = None,
        direction: str = None,
        end_time: int = None,
        result: ListSynchronizationJobsResponseBodySynchronizationJobsResult = None,
        start_time: int = None,
        status: str = None,
        synchronization_job_id: str = None,
        target_id: str = None,
        target_type: str = None,
        trigger_type: str = None,
    ):
        self.description = description
        # 同步任务方向
        self.direction = direction
        # 同步结束时间
        self.end_time = end_time
        # 同步任务结果
        self.result = result
        # 同步开始时间
        self.start_time = start_time
        # 同步任务状态
        self.status = status
        # 同步任务ID
        self.synchronization_job_id = synchronization_job_id
        # 同步目标ID
        self.target_id = target_id
        # 同步目标类型
        self.target_type = target_type
        # 同步触发类型
        self.trigger_type = trigger_type

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.synchronization_job_id is not None:
            result['SynchronizationJobId'] = self.synchronization_job_id
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.trigger_type is not None:
            result['TriggerType'] = self.trigger_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Result') is not None:
            temp_model = ListSynchronizationJobsResponseBodySynchronizationJobsResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SynchronizationJobId') is not None:
            self.synchronization_job_id = m.get('SynchronizationJobId')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TriggerType') is not None:
            self.trigger_type = m.get('TriggerType')
        return self


class ListSynchronizationJobsResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        synchronization_jobs: List[ListSynchronizationJobsResponseBodySynchronizationJobs] = None,
        total_count: int = None,
    ):
        # 本次调用返回的查询凭证（Token）值，用于下一次翻页查询。
        self.next_token = next_token
        self.request_id = request_id
        self.synchronization_jobs = synchronization_jobs
        self.total_count = total_count

    def validate(self):
        if self.synchronization_jobs:
            for k in self.synchronization_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SynchronizationJobs'] = []
        if self.synchronization_jobs is not None:
            for k in self.synchronization_jobs:
                result['SynchronizationJobs'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.synchronization_jobs = []
        if m.get('SynchronizationJobs') is not None:
            for k in m.get('SynchronizationJobs'):
                temp_model = ListSynchronizationJobsResponseBodySynchronizationJobs()
                self.synchronization_jobs.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSynchronizationJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSynchronizationJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSynchronizationJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(
        self,
        display_name_starts_with: str = None,
        email: str = None,
        instance_id: str = None,
        organizational_unit_id: str = None,
        page_number: int = None,
        page_size: int = None,
        phone_number: str = None,
        phone_region: str = None,
        status: str = None,
        user_external_id: str = None,
        user_ids: List[str] = None,
        user_source_id: str = None,
        user_source_type: str = None,
        username_starts_with: str = None,
    ):
        # Displayname
        self.display_name_starts_with = display_name_starts_with
        # The email address of the user who owns the account.
        self.email = email
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the organizational unit.
        self.organizational_unit_id = organizational_unit_id
        # The number of the page to return. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 20.
        self.page_size = page_size
        # The mobile number of the user who owns the account.
        self.phone_number = phone_number
        # The country code of the mobile number. For example, the country code of China is 86 without 00 or +.
        self.phone_region = phone_region
        # The status of the account. Valid values:
        # 
        # *   enabled: The account is enabled.
        # *   disabled: The account is disabled.
        self.status = status
        # The external ID of the account. The external ID can be used by external data to map the data of the account in IDaaS EIAM.
        # 
        # For accounts with the same source type and source ID, each account has a unique external ID.
        self.user_external_id = user_external_id
        # User ID set
        self.user_ids = user_ids
        # The source ID of the account.
        # 
        # If the account was created in IDaaS, its source ID is the ID of the IDaaS instance. If the account was imported, its source ID is the enterprise ID in the source. For example, if the account was imported from DingTalk, its source ID is the corpId value of the enterprise in DingTalk.
        self.user_source_id = user_source_id
        # The source type of the account. Valid values:
        # 
        # *   build_in: The account was created in IDaaS.
        # *   ding_talk: The account was imported from DingTalk.
        # *   ad: The account was imported from Microsoft Active Directory (AD).
        # *   ldap: The account was imported from a Lightweight Directory Access Protocol (LDAP) service.
        self.user_source_type = user_source_type
        # Username
        self.username_starts_with = username_starts_with

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name_starts_with is not None:
            result['DisplayNameStartsWith'] = self.display_name_starts_with
        if self.email is not None:
            result['Email'] = self.email
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.phone_region is not None:
            result['PhoneRegion'] = self.phone_region
        if self.status is not None:
            result['Status'] = self.status
        if self.user_external_id is not None:
            result['UserExternalId'] = self.user_external_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        if self.user_source_id is not None:
            result['UserSourceId'] = self.user_source_id
        if self.user_source_type is not None:
            result['UserSourceType'] = self.user_source_type
        if self.username_starts_with is not None:
            result['UsernameStartsWith'] = self.username_starts_with
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayNameStartsWith') is not None:
            self.display_name_starts_with = m.get('DisplayNameStartsWith')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PhoneRegion') is not None:
            self.phone_region = m.get('PhoneRegion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserExternalId') is not None:
            self.user_external_id = m.get('UserExternalId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        if m.get('UserSourceId') is not None:
            self.user_source_id = m.get('UserSourceId')
        if m.get('UserSourceType') is not None:
            self.user_source_type = m.get('UserSourceType')
        if m.get('UsernameStartsWith') is not None:
            self.username_starts_with = m.get('UsernameStartsWith')
        return self


class ListUsersResponseBodyUsers(TeaModel):
    def __init__(
        self,
        account_expire_time: int = None,
        create_time: int = None,
        description: str = None,
        display_name: str = None,
        email: str = None,
        email_verified: bool = None,
        instance_id: str = None,
        lock_expire_time: int = None,
        password_expire_time: int = None,
        password_set: bool = None,
        phone_number: str = None,
        phone_number_verified: bool = None,
        phone_region: str = None,
        register_time: int = None,
        status: str = None,
        update_time: int = None,
        user_external_id: str = None,
        user_id: str = None,
        user_source_id: str = None,
        user_source_type: str = None,
        username: str = None,
    ):
        # The time when the account expires. This value is a UNIX timestamp. Unit: milliseconds.
        self.account_expire_time = account_expire_time
        # The time when the account was created. This value is a UNIX timestamp. Unit: milliseconds.
        self.create_time = create_time
        # The description of the account.
        self.description = description
        # The display name of the account.
        self.display_name = display_name
        # The email address of the user who owns the account.
        self.email = email
        # Indicates whether the email address has been verified. A value of true indicates that the email address has been verified by the user or has been set to the verified status by the administrator. A value of false indicates that the email address has not been verified.
        self.email_verified = email_verified
        # The ID of the instance
        self.instance_id = instance_id
        # The time when the account lock expires. This value is a UNIX timestamp. Unit: milliseconds.
        self.lock_expire_time = lock_expire_time
        # Time When Password Expires
        self.password_expire_time = password_expire_time
        # Indicates whether a password is set.
        self.password_set = password_set
        # The mobile number of the user who owns the account.
        self.phone_number = phone_number
        # Indicates whether the mobile number has been verified. A value of true indicates that the mobile number has been verified by the user or has been set to the verified status by the administrator. A value of false indicates that the mobile number has not been verified.
        self.phone_number_verified = phone_number_verified
        # The country code of the mobile number. For example, the country code of China is 86 without 00 or +.
        self.phone_region = phone_region
        # The time when the account was registered. This value is a UNIX timestamp. Unit: milliseconds.
        self.register_time = register_time
        # The status of the account. Valid values:
        # 
        # *   enabled: The account is enabled.
        # *   disabled: The account is disabled.
        self.status = status
        # The time when the account was last updated. The value is a UNIX timestamp. Unit: milliseconds.
        self.update_time = update_time
        # The external ID of the account. The external ID can be used by external data to map the data of the account in IDaaS EIAM. By default, the external ID is the account ID.
        # 
        # For accounts with the same source type and source ID, each account has a unique external ID.
        self.user_external_id = user_external_id
        # The ID of the account.
        self.user_id = user_id
        # The source ID of the account.
        # 
        # If the account was created in IDaaS, its source ID is the ID of the IDaaS instance. If the account was imported, its source ID is the enterprise ID in the source. For example, if the account was imported from DingTalk, its source ID is the corpId value of the enterprise in DingTalk.
        self.user_source_id = user_source_id
        # The source type of the account. Valid values:
        # 
        # *   build_in: The account was created in IDaaS.
        # *   ding_talk: The account was imported from DingTalk.
        # *   ad: The account was imported from Microsoft Active Directory (AD).
        # *   ldap: The account was imported from a Lightweight Directory Access Protocol (LDAP) service.
        self.user_source_type = user_source_type
        # The username of the account.
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_expire_time is not None:
            result['AccountExpireTime'] = self.account_expire_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.email is not None:
            result['Email'] = self.email
        if self.email_verified is not None:
            result['EmailVerified'] = self.email_verified
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lock_expire_time is not None:
            result['LockExpireTime'] = self.lock_expire_time
        if self.password_expire_time is not None:
            result['PasswordExpireTime'] = self.password_expire_time
        if self.password_set is not None:
            result['PasswordSet'] = self.password_set
        if self.phone_number is not None:
            result['PhoneNumber'] = self.phone_number
        if self.phone_number_verified is not None:
            result['PhoneNumberVerified'] = self.phone_number_verified
        if self.phone_region is not None:
            result['PhoneRegion'] = self.phone_region
        if self.register_time is not None:
            result['RegisterTime'] = self.register_time
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.user_external_id is not None:
            result['UserExternalId'] = self.user_external_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_source_id is not None:
            result['UserSourceId'] = self.user_source_id
        if self.user_source_type is not None:
            result['UserSourceType'] = self.user_source_type
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountExpireTime') is not None:
            self.account_expire_time = m.get('AccountExpireTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('EmailVerified') is not None:
            self.email_verified = m.get('EmailVerified')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LockExpireTime') is not None:
            self.lock_expire_time = m.get('LockExpireTime')
        if m.get('PasswordExpireTime') is not None:
            self.password_expire_time = m.get('PasswordExpireTime')
        if m.get('PasswordSet') is not None:
            self.password_set = m.get('PasswordSet')
        if m.get('PhoneNumber') is not None:
            self.phone_number = m.get('PhoneNumber')
        if m.get('PhoneNumberVerified') is not None:
            self.phone_number_verified = m.get('PhoneNumberVerified')
        if m.get('PhoneRegion') is not None:
            self.phone_region = m.get('PhoneRegion')
        if m.get('RegisterTime') is not None:
            self.register_time = m.get('RegisterTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UserExternalId') is not None:
            self.user_external_id = m.get('UserExternalId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserSourceId') is not None:
            self.user_source_id = m.get('UserSourceId')
        if m.get('UserSourceType') is not None:
            self.user_source_type = m.get('UserSourceType')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        users: List[ListUsersResponseBodyUsers] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The number of entries in the list.
        self.total_count = total_count
        # The list of data objects of accounts.
        self.users = users

    def validate(self):
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = ListUsersResponseBodyUsers()
                self.users.append(temp_model.from_map(k))
        return self


class ListUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersForApplicationRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        user_ids: List[str] = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The IDs of the accounts. You can query a maximum of 100 accounts at a time.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class ListUsersForApplicationResponseBodyUsers(TeaModel):
    def __init__(
        self,
        user_id: str = None,
    ):
        # The ID of the account.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListUsersForApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        users: List[ListUsersForApplicationResponseBodyUsers] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of returned entries.
        self.total_count = total_count
        # The IDs of the accounts.
        self.users = users

    def validate(self):
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = ListUsersForApplicationResponseBodyUsers()
                self.users.append(temp_model.from_map(k))
        return self


class ListUsersForApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUsersForApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUsersForApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersForGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        user_ids: List[str] = None,
    ):
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Default value: 20. Maximum value: 100.
        self.page_size = page_size
        # The account IDs. A maximum of 100 accounts can be queried.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class ListUsersForGroupResponseBodyUsers(TeaModel):
    def __init__(
        self,
        group_member_relation_source_id: str = None,
        group_member_relation_source_type: str = None,
        user_id: str = None,
    ):
        # Account membership source id
        self.group_member_relation_source_id = group_member_relation_source_id
        # Account membership source type
        self.group_member_relation_source_type = group_member_relation_source_type
        # The account ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_member_relation_source_id is not None:
            result['GroupMemberRelationSourceId'] = self.group_member_relation_source_id
        if self.group_member_relation_source_type is not None:
            result['GroupMemberRelationSourceType'] = self.group_member_relation_source_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupMemberRelationSourceId') is not None:
            self.group_member_relation_source_id = m.get('GroupMemberRelationSourceId')
        if m.get('GroupMemberRelationSourceType') is not None:
            self.group_member_relation_source_type = m.get('GroupMemberRelationSourceType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class ListUsersForGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        users: List[ListUsersForGroupResponseBodyUsers] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned. The maximum number of entries that can be returned per page is specified by PageSize.
        self.total_count = total_count
        # The information about accounts.
        self.users = users

    def validate(self):
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = ListUsersForGroupResponseBodyUsers()
                self.users.append(temp_model.from_map(k))
        return self


class ListUsersForGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListUsersForGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListUsersForGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ObtainApplicationClientSecretRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        secret_id: str = None,
    ):
        # The ID of the application whose client key you want to query.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The client key ID of the application.
        # 
        # This parameter is required.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class ObtainApplicationClientSecretResponseBodyApplicationClientSecret(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        client_id: str = None,
        client_secret: str = None,
        instance_id: str = None,
        last_used_time: int = None,
        secret_id: str = None,
        status: str = None,
    ):
        # The ID of the application whose client key you want to query.
        self.application_id = application_id
        # The client ID of the application.
        self.client_id = client_id
        # The client key secret of the application.
        self.client_secret = client_secret
        # The ID of the instance.
        self.instance_id = instance_id
        # The time when the client key was last used. The value is a UNIX timestamp. Unit: milliseconds.
        self.last_used_time = last_used_time
        # The client key ID of the application.
        self.secret_id = secret_id
        # The status of the client key. Valid values:
        # 
        # *   Enabled: The client key is enabled.
        # *   Disabled: The client key is disabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_used_time is not None:
            result['LastUsedTime'] = self.last_used_time
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUsedTime') is not None:
            self.last_used_time = m.get('LastUsedTime')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ObtainApplicationClientSecretResponseBody(TeaModel):
    def __init__(
        self,
        application_client_secret: ObtainApplicationClientSecretResponseBodyApplicationClientSecret = None,
        request_id: str = None,
    ):
        # The information about the client key.
        self.application_client_secret = application_client_secret
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.application_client_secret:
            self.application_client_secret.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_client_secret is not None:
            result['ApplicationClientSecret'] = self.application_client_secret.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationClientSecret') is not None:
            temp_model = ObtainApplicationClientSecretResponseBodyApplicationClientSecret()
            self.application_client_secret = temp_model.from_map(m['ApplicationClientSecret'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ObtainApplicationClientSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ObtainApplicationClientSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ObtainApplicationClientSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ObtainDomainProxyTokenRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # 域名代理Token ID。
        # 
        # This parameter is required.
        self.domain_proxy_token_id = domain_proxy_token_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ObtainDomainProxyTokenResponseBodyDomainProxyToken(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        domain_id: str = None,
        domain_proxy_token: str = None,
        domain_proxy_token_id: str = None,
        instance_id: str = None,
        last_used_time: int = None,
        status: str = None,
        update_time: int = None,
    ):
        # 域名代理Token创建时间，Unix时间戳格式，单位为毫秒。
        self.create_time = create_time
        # 域名ID。
        self.domain_id = domain_id
        # 域名代理Token。
        self.domain_proxy_token = domain_proxy_token
        # 域名代理Token ID。
        self.domain_proxy_token_id = domain_proxy_token_id
        # 实例ID。
        self.instance_id = instance_id
        # 域名代理Token最近使用时间，Unix时间戳格式，单位为毫秒。
        self.last_used_time = last_used_time
        # token状态，枚举类型：(enabled）启用,（disabled）禁用。
        self.status = status
        # 域名代理Token最近更新时间，Unix时间戳格式，单位为毫秒。
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_proxy_token is not None:
            result['DomainProxyToken'] = self.domain_proxy_token
        if self.domain_proxy_token_id is not None:
            result['DomainProxyTokenId'] = self.domain_proxy_token_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_used_time is not None:
            result['LastUsedTime'] = self.last_used_time
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainProxyToken') is not None:
            self.domain_proxy_token = m.get('DomainProxyToken')
        if m.get('DomainProxyTokenId') is not None:
            self.domain_proxy_token_id = m.get('DomainProxyTokenId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastUsedTime') is not None:
            self.last_used_time = m.get('LastUsedTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ObtainDomainProxyTokenResponseBody(TeaModel):
    def __init__(
        self,
        domain_proxy_token: ObtainDomainProxyTokenResponseBodyDomainProxyToken = None,
        request_id: str = None,
    ):
        self.domain_proxy_token = domain_proxy_token
        self.request_id = request_id

    def validate(self):
        if self.domain_proxy_token:
            self.domain_proxy_token.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_proxy_token is not None:
            result['DomainProxyToken'] = self.domain_proxy_token.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainProxyToken') is not None:
            temp_model = ObtainDomainProxyTokenResponseBodyDomainProxyToken()
            self.domain_proxy_token = temp_model.from_map(m['DomainProxyToken'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ObtainDomainProxyTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ObtainDomainProxyTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ObtainDomainProxyTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveUserFromOrganizationalUnitsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The organization IDs. You can remove an account from a maximum of 100 organizations.
        # 
        # This parameter is required.
        self.organizational_unit_ids = organizational_unit_ids
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class RemoveUserFromOrganizationalUnitsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemoveUserFromOrganizationalUnitsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemoveUserFromOrganizationalUnitsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveUserFromOrganizationalUnitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveUsersFromGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        instance_id: str = None,
        user_ids: List[str] = None,
    ):
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The account IDs. A maximum of 100 accounts can be removed from a group.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class RemoveUsersFromGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemoveUsersFromGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemoveUsersFromGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveUsersFromGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RevokeApplicationFromGroupsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        group_ids: List[str] = None,
        instance_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The group IDs. You can specify up to 100 group IDs at a time.
        # 
        # This parameter is required.
        self.group_ids = group_ids
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class RevokeApplicationFromGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RevokeApplicationFromGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RevokeApplicationFromGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RevokeApplicationFromGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RevokeApplicationFromOrganizationalUnitsRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of the organizations. You can revoke the access permissions from a maximum of 100 organizations at a time.
        # 
        # This parameter is required.
        self.organizational_unit_ids = organizational_unit_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        return self


class RevokeApplicationFromOrganizationalUnitsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RevokeApplicationFromOrganizationalUnitsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RevokeApplicationFromOrganizationalUnitsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RevokeApplicationFromOrganizationalUnitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RevokeApplicationFromUsersRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        instance_id: str = None,
        user_ids: List[str] = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IDs of the accounts. You can revoke the access permissions from a maximum of 100 accounts at a time.
        # 
        # This parameter is required.
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class RevokeApplicationFromUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RevokeApplicationFromUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RevokeApplicationFromUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RevokeApplicationFromUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RunSynchronizationJobRequestSynchronizationScopeConfig(TeaModel):
    def __init__(
        self,
        group_ids: List[str] = None,
        organizational_unit_ids: List[str] = None,
        user_ids: List[str] = None,
    ):
        self.group_ids = group_ids
        self.organizational_unit_ids = organizational_unit_ids
        self.user_ids = user_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        if self.user_ids is not None:
            result['UserIds'] = self.user_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        if m.get('UserIds') is not None:
            self.user_ids = m.get('UserIds')
        return self


class RunSynchronizationJobRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        instance_id: str = None,
        password_initialization: bool = None,
        synchronization_scope_config: RunSynchronizationJobRequestSynchronizationScopeConfig = None,
        target_id: str = None,
        target_type: str = None,
        user_identity_types: List[str] = None,
    ):
        self.description = description
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.password_initialization = password_initialization
        self.synchronization_scope_config = synchronization_scope_config
        # 同步目标ID
        # 
        # This parameter is required.
        self.target_id = target_id
        # 同步目标类型
        # 
        # This parameter is required.
        self.target_type = target_type
        self.user_identity_types = user_identity_types

    def validate(self):
        if self.synchronization_scope_config:
            self.synchronization_scope_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password_initialization is not None:
            result['PasswordInitialization'] = self.password_initialization
        if self.synchronization_scope_config is not None:
            result['SynchronizationScopeConfig'] = self.synchronization_scope_config.to_map()
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.user_identity_types is not None:
            result['UserIdentityTypes'] = self.user_identity_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PasswordInitialization') is not None:
            self.password_initialization = m.get('PasswordInitialization')
        if m.get('SynchronizationScopeConfig') is not None:
            temp_model = RunSynchronizationJobRequestSynchronizationScopeConfig()
            self.synchronization_scope_config = temp_model.from_map(m['SynchronizationScopeConfig'])
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('UserIdentityTypes') is not None:
            self.user_identity_types = m.get('UserIdentityTypes')
        return self


class RunSynchronizationJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        synchronization_job_id: str = None,
    ):
        self.request_id = request_id
        self.synchronization_job_id = synchronization_job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.synchronization_job_id is not None:
            result['SynchronizationJobId'] = self.synchronization_job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SynchronizationJobId') is not None:
            self.synchronization_job_id = m.get('SynchronizationJobId')
        return self


class RunSynchronizationJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RunSynchronizationJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RunSynchronizationJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetApplicationGrantScopeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        grant_scopes: List[str] = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to configure.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The permissions of the Developer API feature.
        self.grant_scopes = grant_scopes
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class SetApplicationGrantScopeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetApplicationGrantScopeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetApplicationGrantScopeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetApplicationGrantScopeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetApplicationProvisioningConfigRequestCallbackProvisioningConfig(TeaModel):
    def __init__(
        self,
        callback_url: str = None,
        encrypt_key: str = None,
        encrypt_required: bool = None,
        listen_event_scopes: List[str] = None,
    ):
        # The URL that the application uses to receive IDaaS event callbacks.
        self.callback_url = callback_url
        # The symmetric key for IDaaS event callbacks. The key is an AES-256 encryption key in the HEX format.
        self.encrypt_key = encrypt_key
        # Specifies whether to encrypt IDaaS event callback messages. Valid values:
        # 
        # *   true: encrypt the messages.
        # *   false: transmit the messages in plaintext.
        self.encrypt_required = encrypt_required
        # The list of types of IDaaS event callback messages that are supported by the listener.
        self.listen_event_scopes = listen_event_scopes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.encrypt_key is not None:
            result['EncryptKey'] = self.encrypt_key
        if self.encrypt_required is not None:
            result['EncryptRequired'] = self.encrypt_required
        if self.listen_event_scopes is not None:
            result['ListenEventScopes'] = self.listen_event_scopes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('EncryptKey') is not None:
            self.encrypt_key = m.get('EncryptKey')
        if m.get('EncryptRequired') is not None:
            self.encrypt_required = m.get('EncryptRequired')
        if m.get('ListenEventScopes') is not None:
            self.listen_event_scopes = m.get('ListenEventScopes')
        return self


class SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfigurationAuthnParam(TeaModel):
    def __init__(
        self,
        access_token: str = None,
        authn_method: str = None,
        client_id: str = None,
        client_secret: str = None,
        token_endpoint: str = None,
    ):
        # The access token. If the GrantType parameter is set to bearer_token, you can set this parameter.
        self.access_token = access_token
        # The authentication mode of the SCIM protocol. Valid values:
        # 
        # *   client_secret_basic: The client secret is passed in the request header.
        # *   client_secret_post: The client secret is passed in the request body.
        self.authn_method = authn_method
        # The client ID of the application.
        self.client_id = client_id
        # The client secret of the application.
        self.client_secret = client_secret
        # The token endpoint.
        self.token_endpoint = token_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token is not None:
            result['AccessToken'] = self.access_token
        if self.authn_method is not None:
            result['AuthnMethod'] = self.authn_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        if self.token_endpoint is not None:
            result['TokenEndpoint'] = self.token_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessToken') is not None:
            self.access_token = m.get('AccessToken')
        if m.get('AuthnMethod') is not None:
            self.authn_method = m.get('AuthnMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        if m.get('TokenEndpoint') is not None:
            self.token_endpoint = m.get('TokenEndpoint')
        return self


class SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfiguration(TeaModel):
    def __init__(
        self,
        authn_mode: str = None,
        authn_param: SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfigurationAuthnParam = None,
        grant_type: str = None,
    ):
        # The authentication mode of the SCIM protocol. Valid value:
        # 
        # *   oauth2: OAuth2.0 mode.
        self.authn_mode = authn_mode
        # The configuration parameters related to authorization.
        # 
        # *   If the GrantType parameter is set to client_credentials, you can set the configuration parameters ClientId, ClientSecret, and AuthnMethod.
        # *   If the GrantType parameter is set to bearer_token, you can set the configuration parameter AccessToken.
        self.authn_param = authn_param
        # The grant type of the SCIM protocol. Valid values:
        # 
        # *   client_credentials: client mode.
        # *   bearer_token: key mode.
        self.grant_type = grant_type

    def validate(self):
        if self.authn_param:
            self.authn_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_mode is not None:
            result['AuthnMode'] = self.authn_mode
        if self.authn_param is not None:
            result['AuthnParam'] = self.authn_param.to_map()
        if self.grant_type is not None:
            result['GrantType'] = self.grant_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnMode') is not None:
            self.authn_mode = m.get('AuthnMode')
        if m.get('AuthnParam') is not None:
            temp_model = SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfigurationAuthnParam()
            self.authn_param = temp_model.from_map(m['AuthnParam'])
        if m.get('GrantType') is not None:
            self.grant_type = m.get('GrantType')
        return self


class SetApplicationProvisioningConfigRequestScimProvisioningConfig(TeaModel):
    def __init__(
        self,
        authn_configuration: SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfiguration = None,
        full_push_scopes: List[str] = None,
        provisioning_actions: List[str] = None,
        scim_base_url: str = None,
    ):
        # The configuration parameters related to SCIM-based synchronization.
        self.authn_configuration = authn_configuration
        # The full synchronization scope of the SCIM protocol. Valid value:
        # 
        # *   urn:alibaba:idaas:app:scim:User:PUSH: full account data synchronization.
        self.full_push_scopes = full_push_scopes
        # The resource operations of the SCIM protocol. Valid values:
        # 
        # *   urn:alibaba:idaas:app:scim:User:CREATE: account creation.
        # *   urn:alibaba:idaas:app:scim:User:UPDATE: account update.
        # *   urn:alibaba:idaas:app:scim:User:DELETE: account deletion.
        self.provisioning_actions = provisioning_actions
        # The base URL that the application uses to receive the SCIM protocol for IDaaS synchronization.
        self.scim_base_url = scim_base_url

    def validate(self):
        if self.authn_configuration:
            self.authn_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_configuration is not None:
            result['AuthnConfiguration'] = self.authn_configuration.to_map()
        if self.full_push_scopes is not None:
            result['FullPushScopes'] = self.full_push_scopes
        if self.provisioning_actions is not None:
            result['ProvisioningActions'] = self.provisioning_actions
        if self.scim_base_url is not None:
            result['ScimBaseUrl'] = self.scim_base_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnConfiguration') is not None:
            temp_model = SetApplicationProvisioningConfigRequestScimProvisioningConfigAuthnConfiguration()
            self.authn_configuration = temp_model.from_map(m['AuthnConfiguration'])
        if m.get('FullPushScopes') is not None:
            self.full_push_scopes = m.get('FullPushScopes')
        if m.get('ProvisioningActions') is not None:
            self.provisioning_actions = m.get('ProvisioningActions')
        if m.get('ScimBaseUrl') is not None:
            self.scim_base_url = m.get('ScimBaseUrl')
        return self


class SetApplicationProvisioningConfigRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        callback_provisioning_config: SetApplicationProvisioningConfigRequestCallbackProvisioningConfig = None,
        instance_id: str = None,
        provision_password: bool = None,
        provision_protocol_type: str = None,
        scim_provisioning_config: SetApplicationProvisioningConfigRequestScimProvisioningConfig = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The configuration of event callback synchronization. This parameter is required when the ProvisionProtocolType parameter is set to idaas_callback.
        self.callback_provisioning_config = callback_provisioning_config
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Specifies whether to synchronize the password in IDaaS user event callbacks. Valid values:
        # 
        # *   true: synchronize the password.
        # *   false: do not synchronize the password.
        self.provision_password = provision_password
        # The synchronization protocol type of the application. Valid values:
        # 
        # *   idaas_callback: custom event callback protocol of IDaaS.
        # *   scim2: System for Cross-domain Identity Management (SCIM) protocol.
        # 
        # This parameter is required.
        self.provision_protocol_type = provision_protocol_type
        # The configuration of SCIM-based IDaaS synchronization. This parameter is required when the ProvisionProtocolType parameter is set to scim2.
        self.scim_provisioning_config = scim_provisioning_config

    def validate(self):
        if self.callback_provisioning_config:
            self.callback_provisioning_config.validate()
        if self.scim_provisioning_config:
            self.scim_provisioning_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.callback_provisioning_config is not None:
            result['CallbackProvisioningConfig'] = self.callback_provisioning_config.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.provision_password is not None:
            result['ProvisionPassword'] = self.provision_password
        if self.provision_protocol_type is not None:
            result['ProvisionProtocolType'] = self.provision_protocol_type
        if self.scim_provisioning_config is not None:
            result['ScimProvisioningConfig'] = self.scim_provisioning_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('CallbackProvisioningConfig') is not None:
            temp_model = SetApplicationProvisioningConfigRequestCallbackProvisioningConfig()
            self.callback_provisioning_config = temp_model.from_map(m['CallbackProvisioningConfig'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProvisionPassword') is not None:
            self.provision_password = m.get('ProvisionPassword')
        if m.get('ProvisionProtocolType') is not None:
            self.provision_protocol_type = m.get('ProvisionProtocolType')
        if m.get('ScimProvisioningConfig') is not None:
            temp_model = SetApplicationProvisioningConfigRequestScimProvisioningConfig()
            self.scim_provisioning_config = temp_model.from_map(m['ScimProvisioningConfig'])
        return self


class SetApplicationProvisioningConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetApplicationProvisioningConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetApplicationProvisioningConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetApplicationProvisioningConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetApplicationProvisioningScopeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        group_ids: List[str] = None,
        instance_id: str = None,
        organizational_unit_ids: List[str] = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        # List of groups that are authorized to be synchronized from
        self.group_ids = group_ids
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The list of organizational units that are authorized for account synchronization.
        self.organizational_unit_ids = organizational_unit_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_ids is not None:
            result['OrganizationalUnitIds'] = self.organizational_unit_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitIds') is not None:
            self.organizational_unit_ids = m.get('OrganizationalUnitIds')
        return self


class SetApplicationProvisioningScopeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetApplicationProvisioningScopeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetApplicationProvisioningScopeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetApplicationProvisioningScopeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetApplicationSsoConfigRequestOidcSsoConfigCustomClaims(TeaModel):
    def __init__(
        self,
        claim_name: str = None,
        claim_value_expression: str = None,
    ):
        # The claim name.
        self.claim_name = claim_name
        # The expression that is used to generate the value of the claim.
        self.claim_value_expression = claim_value_expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.claim_name is not None:
            result['ClaimName'] = self.claim_name
        if self.claim_value_expression is not None:
            result['ClaimValueExpression'] = self.claim_value_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClaimName') is not None:
            self.claim_name = m.get('ClaimName')
        if m.get('ClaimValueExpression') is not None:
            self.claim_value_expression = m.get('ClaimValueExpression')
        return self


class SetApplicationSsoConfigRequestOidcSsoConfig(TeaModel):
    def __init__(
        self,
        access_token_effective_time: int = None,
        code_effective_time: int = None,
        custom_claims: List[SetApplicationSsoConfigRequestOidcSsoConfigCustomClaims] = None,
        grant_scopes: List[str] = None,
        grant_types: List[str] = None,
        id_token_effective_time: int = None,
        password_authentication_source_id: str = None,
        password_totp_mfa_required: bool = None,
        pkce_challenge_methods: List[str] = None,
        pkce_required: bool = None,
        post_logout_redirect_uris: List[str] = None,
        redirect_uris: List[str] = None,
        refresh_token_effective: int = None,
        response_types: List[str] = None,
        subject_id_expression: str = None,
    ):
        # The validity period of the issued access token. Unit: seconds. Default value: 1200.
        self.access_token_effective_time = access_token_effective_time
        # The validity period of the issued code. Unit: seconds. Default value: 60.
        self.code_effective_time = code_effective_time
        # The custom claims that are returned for the ID token.
        self.custom_claims = custom_claims
        # The scopes of user attributes that can be returned for the UserInfo endpoint or ID token.
        self.grant_scopes = grant_scopes
        # The list of grant types that are supported for OIDC protocols.
        self.grant_types = grant_types
        # The validity period of the issued ID token. Unit: seconds. Default value: 300.
        self.id_token_effective_time = id_token_effective_time
        # The ID of the identity authentication source in password mode. Specify this parameter only when the value of the GrantTypes parameter includes the password mode.
        self.password_authentication_source_id = password_authentication_source_id
        # Specifies whether time-based one-time password (TOTP) authentication is required in password mode. Specify this parameter only when the value of the GrantTypes parameter includes the password mode.
        self.password_totp_mfa_required = password_totp_mfa_required
        # The algorithms that are used to calculate the code challenge for PKCE.
        self.pkce_challenge_methods = pkce_challenge_methods
        # Specifies whether the SSO of the application requires Proof Key for Code Exchange (PKCE) (RFC 7636).
        self.pkce_required = pkce_required
        # The list of logout redirect URIs that are supported by the application.
        self.post_logout_redirect_uris = post_logout_redirect_uris
        # The list of redirect URIs that are supported by the application.
        self.redirect_uris = redirect_uris
        # The validity period of the issued refresh token. Unit: seconds. Default value: 86400.
        self.refresh_token_effective = refresh_token_effective
        # The response types that are supported by the application. Specify this parameter when the value of the GrantTypes parameter includes the implicit mode.
        self.response_types = response_types
        # The custom expression that is used to generate the subject ID returned for the ID token.
        self.subject_id_expression = subject_id_expression

    def validate(self):
        if self.custom_claims:
            for k in self.custom_claims:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_token_effective_time is not None:
            result['AccessTokenEffectiveTime'] = self.access_token_effective_time
        if self.code_effective_time is not None:
            result['CodeEffectiveTime'] = self.code_effective_time
        result['CustomClaims'] = []
        if self.custom_claims is not None:
            for k in self.custom_claims:
                result['CustomClaims'].append(k.to_map() if k else None)
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.grant_types is not None:
            result['GrantTypes'] = self.grant_types
        if self.id_token_effective_time is not None:
            result['IdTokenEffectiveTime'] = self.id_token_effective_time
        if self.password_authentication_source_id is not None:
            result['PasswordAuthenticationSourceId'] = self.password_authentication_source_id
        if self.password_totp_mfa_required is not None:
            result['PasswordTotpMfaRequired'] = self.password_totp_mfa_required
        if self.pkce_challenge_methods is not None:
            result['PkceChallengeMethods'] = self.pkce_challenge_methods
        if self.pkce_required is not None:
            result['PkceRequired'] = self.pkce_required
        if self.post_logout_redirect_uris is not None:
            result['PostLogoutRedirectUris'] = self.post_logout_redirect_uris
        if self.redirect_uris is not None:
            result['RedirectUris'] = self.redirect_uris
        if self.refresh_token_effective is not None:
            result['RefreshTokenEffective'] = self.refresh_token_effective
        if self.response_types is not None:
            result['ResponseTypes'] = self.response_types
        if self.subject_id_expression is not None:
            result['SubjectIdExpression'] = self.subject_id_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessTokenEffectiveTime') is not None:
            self.access_token_effective_time = m.get('AccessTokenEffectiveTime')
        if m.get('CodeEffectiveTime') is not None:
            self.code_effective_time = m.get('CodeEffectiveTime')
        self.custom_claims = []
        if m.get('CustomClaims') is not None:
            for k in m.get('CustomClaims'):
                temp_model = SetApplicationSsoConfigRequestOidcSsoConfigCustomClaims()
                self.custom_claims.append(temp_model.from_map(k))
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('GrantTypes') is not None:
            self.grant_types = m.get('GrantTypes')
        if m.get('IdTokenEffectiveTime') is not None:
            self.id_token_effective_time = m.get('IdTokenEffectiveTime')
        if m.get('PasswordAuthenticationSourceId') is not None:
            self.password_authentication_source_id = m.get('PasswordAuthenticationSourceId')
        if m.get('PasswordTotpMfaRequired') is not None:
            self.password_totp_mfa_required = m.get('PasswordTotpMfaRequired')
        if m.get('PkceChallengeMethods') is not None:
            self.pkce_challenge_methods = m.get('PkceChallengeMethods')
        if m.get('PkceRequired') is not None:
            self.pkce_required = m.get('PkceRequired')
        if m.get('PostLogoutRedirectUris') is not None:
            self.post_logout_redirect_uris = m.get('PostLogoutRedirectUris')
        if m.get('RedirectUris') is not None:
            self.redirect_uris = m.get('RedirectUris')
        if m.get('RefreshTokenEffective') is not None:
            self.refresh_token_effective = m.get('RefreshTokenEffective')
        if m.get('ResponseTypes') is not None:
            self.response_types = m.get('ResponseTypes')
        if m.get('SubjectIdExpression') is not None:
            self.subject_id_expression = m.get('SubjectIdExpression')
        return self


class SetApplicationSsoConfigRequestSamlSsoConfigAttributeStatements(TeaModel):
    def __init__(
        self,
        attribute_name: str = None,
        attribute_value_expression: str = None,
    ):
        # The attribute name.
        self.attribute_name = attribute_name
        # The expression that is used to generate the value of the attribute.
        self.attribute_value_expression = attribute_value_expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_value_expression is not None:
            result['AttributeValueExpression'] = self.attribute_value_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValueExpression') is not None:
            self.attribute_value_expression = m.get('AttributeValueExpression')
        return self


class SetApplicationSsoConfigRequestSamlSsoConfigOptionalRelayStates(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        relay_state: str = None,
    ):
        self.display_name = display_name
        self.relay_state = relay_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.relay_state is not None:
            result['RelayState'] = self.relay_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('RelayState') is not None:
            self.relay_state = m.get('RelayState')
        return self


class SetApplicationSsoConfigRequestSamlSsoConfig(TeaModel):
    def __init__(
        self,
        assertion_signed: bool = None,
        attribute_statements: List[SetApplicationSsoConfigRequestSamlSsoConfigAttributeStatements] = None,
        default_relay_state: str = None,
        id_pentity_id: str = None,
        name_id_format: str = None,
        name_id_value_expression: str = None,
        optional_relay_states: List[SetApplicationSsoConfigRequestSamlSsoConfigOptionalRelayStates] = None,
        response_signed: bool = None,
        signature_algorithm: str = None,
        sp_entity_id: str = None,
        sp_sso_acs_url: str = None,
    ):
        # Specifies whether to calculate the signature for the assertion. You cannot set ResponseSigned and AssertionSigned to false at the same time.
        # 
        # *   true
        # *   false
        self.assertion_signed = assertion_signed
        # The additional user attributes in the SAML assertion.
        self.attribute_statements = attribute_statements
        # The default value of the RelayState attribute. If the SSO request is initiated in EIAM, the RelayState attribute in the SAML response is set to this default value.
        self.default_relay_state = default_relay_state
        self.id_pentity_id = id_pentity_id
        # The Format attribute of the NameID element in the SAML assertion. Valid values:
        # 
        # *   urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified: No format is specified. How to resolve the NameID element depends on the application.
        # *   urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress: The NameID element must be an email address.
        # *   urn:oasis:names:tc:SAML:2.0:nameid-format:persistent: The NameID element must be persistent.
        # *   urn:oasis:names:tc:SAML:2.0:nameid-format:transient: The NameID element must be transient.
        self.name_id_format = name_id_format
        # The expression that is used to generate the value of NameID in the SAML assertion.
        self.name_id_value_expression = name_id_value_expression
        self.optional_relay_states = optional_relay_states
        # Specifies whether to calculate the signature for the response. You cannot set ResponseSigned and AssertionSigned to false at the same time.
        # 
        # *   true
        # *   false
        self.response_signed = response_signed
        # The algorithm that is used to calculate the signature for the SAML assertion.
        # 
        # Enumeration value:
        # 
        # *   RSA-SHA256
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     the Rivest-Shamir-Adleman (RSA)-Secure Hash Algorithm 256 (SHA-256) algorithm
        # 
        #     <!-- -->
        # 
        #     .
        self.signature_algorithm = signature_algorithm
        # The entity ID of the application in SAML.
        self.sp_entity_id = sp_entity_id
        # The Assertion Consumer Service (ACS) URL of the application in SAML.
        self.sp_sso_acs_url = sp_sso_acs_url

    def validate(self):
        if self.attribute_statements:
            for k in self.attribute_statements:
                if k:
                    k.validate()
        if self.optional_relay_states:
            for k in self.optional_relay_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assertion_signed is not None:
            result['AssertionSigned'] = self.assertion_signed
        result['AttributeStatements'] = []
        if self.attribute_statements is not None:
            for k in self.attribute_statements:
                result['AttributeStatements'].append(k.to_map() if k else None)
        if self.default_relay_state is not None:
            result['DefaultRelayState'] = self.default_relay_state
        if self.id_pentity_id is not None:
            result['IdPEntityId'] = self.id_pentity_id
        if self.name_id_format is not None:
            result['NameIdFormat'] = self.name_id_format
        if self.name_id_value_expression is not None:
            result['NameIdValueExpression'] = self.name_id_value_expression
        result['OptionalRelayStates'] = []
        if self.optional_relay_states is not None:
            for k in self.optional_relay_states:
                result['OptionalRelayStates'].append(k.to_map() if k else None)
        if self.response_signed is not None:
            result['ResponseSigned'] = self.response_signed
        if self.signature_algorithm is not None:
            result['SignatureAlgorithm'] = self.signature_algorithm
        if self.sp_entity_id is not None:
            result['SpEntityId'] = self.sp_entity_id
        if self.sp_sso_acs_url is not None:
            result['SpSsoAcsUrl'] = self.sp_sso_acs_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssertionSigned') is not None:
            self.assertion_signed = m.get('AssertionSigned')
        self.attribute_statements = []
        if m.get('AttributeStatements') is not None:
            for k in m.get('AttributeStatements'):
                temp_model = SetApplicationSsoConfigRequestSamlSsoConfigAttributeStatements()
                self.attribute_statements.append(temp_model.from_map(k))
        if m.get('DefaultRelayState') is not None:
            self.default_relay_state = m.get('DefaultRelayState')
        if m.get('IdPEntityId') is not None:
            self.id_pentity_id = m.get('IdPEntityId')
        if m.get('NameIdFormat') is not None:
            self.name_id_format = m.get('NameIdFormat')
        if m.get('NameIdValueExpression') is not None:
            self.name_id_value_expression = m.get('NameIdValueExpression')
        self.optional_relay_states = []
        if m.get('OptionalRelayStates') is not None:
            for k in m.get('OptionalRelayStates'):
                temp_model = SetApplicationSsoConfigRequestSamlSsoConfigOptionalRelayStates()
                self.optional_relay_states.append(temp_model.from_map(k))
        if m.get('ResponseSigned') is not None:
            self.response_signed = m.get('ResponseSigned')
        if m.get('SignatureAlgorithm') is not None:
            self.signature_algorithm = m.get('SignatureAlgorithm')
        if m.get('SpEntityId') is not None:
            self.sp_entity_id = m.get('SpEntityId')
        if m.get('SpSsoAcsUrl') is not None:
            self.sp_sso_acs_url = m.get('SpSsoAcsUrl')
        return self


class SetApplicationSsoConfigRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        client_token: str = None,
        init_login_type: str = None,
        init_login_url: str = None,
        instance_id: str = None,
        oidc_sso_config: SetApplicationSsoConfigRequestOidcSsoConfig = None,
        saml_sso_config: SetApplicationSsoConfigRequestSamlSsoConfig = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.application_id = application_id
        self.client_token = client_token
        # The initial SSO method. Valid values:
        # 
        # *   only_app_init_sso: Only application-initiated SSO is allowed. This method is selected by default when the SSO protocol of the application is an OIDC protocol. If this method is selected when the SSO protocol of the application is SAML, the InitLoginUrl parameter is required.
        # *   idaas_or_app_init_sso: IDaaS-initiated SSO and application-initiated SSO are allowed. This method is selected by default when the SSO protocol of the application is SAML. If this method is selected when the SSO protocol of the application is an OIDC protocol, the InitLoginUrl parameter is required.
        self.init_login_type = init_login_type
        # The initial webhook URL of SSO. This parameter is required when the SSO protocol of the application is an OIDC protocol and the InitLoginType parameters is set to idaas_or_app_init_sso or when the SSO protocol of the application is SAML and the InitLoginType parameter is set to only_app_init_sso.
        self.init_login_url = init_login_url
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The Open ID Connect (OIDC)-based SSO configuration attributes of the application.
        self.oidc_sso_config = oidc_sso_config
        # The Security Assertion Markup Language (SAML)-based single sign-on (SSO) configuration attributes of the application.
        self.saml_sso_config = saml_sso_config

    def validate(self):
        if self.oidc_sso_config:
            self.oidc_sso_config.validate()
        if self.saml_sso_config:
            self.saml_sso_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.init_login_type is not None:
            result['InitLoginType'] = self.init_login_type
        if self.init_login_url is not None:
            result['InitLoginUrl'] = self.init_login_url
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.oidc_sso_config is not None:
            result['OidcSsoConfig'] = self.oidc_sso_config.to_map()
        if self.saml_sso_config is not None:
            result['SamlSsoConfig'] = self.saml_sso_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InitLoginType') is not None:
            self.init_login_type = m.get('InitLoginType')
        if m.get('InitLoginUrl') is not None:
            self.init_login_url = m.get('InitLoginUrl')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OidcSsoConfig') is not None:
            temp_model = SetApplicationSsoConfigRequestOidcSsoConfig()
            self.oidc_sso_config = temp_model.from_map(m['OidcSsoConfig'])
        if m.get('SamlSsoConfig') is not None:
            temp_model = SetApplicationSsoConfigRequestSamlSsoConfig()
            self.saml_sso_config = temp_model.from_map(m['SamlSsoConfig'])
        return self


class SetApplicationSsoConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetApplicationSsoConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetApplicationSsoConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetApplicationSsoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetDefaultDomainRequest(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        instance_id: str = None,
    ):
        # 域名ID。
        # 
        # This parameter is required.
        self.domain_id = domain_id
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class SetDefaultDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetDefaultDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetDefaultDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetDefaultDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetForgetPasswordConfigurationRequest(TeaModel):
    def __init__(
        self,
        authentication_channels: List[str] = None,
        forget_password_status: str = None,
        instance_id: str = None,
    ):
        # The authentication channels. Valid values: email and sms.
        self.authentication_channels = authentication_channels
        # The status of the forgot password feature. Valid values: enabled and disabled.
        # 
        # This parameter is required.
        self.forget_password_status = forget_password_status
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authentication_channels is not None:
            result['AuthenticationChannels'] = self.authentication_channels
        if self.forget_password_status is not None:
            result['ForgetPasswordStatus'] = self.forget_password_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthenticationChannels') is not None:
            self.authentication_channels = m.get('AuthenticationChannels')
        if m.get('ForgetPasswordStatus') is not None:
            self.forget_password_status = m.get('ForgetPasswordStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class SetForgetPasswordConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetForgetPasswordConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetForgetPasswordConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetForgetPasswordConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetIdentityProviderUdPullConfigurationRequestLdapUdPullConfig(TeaModel):
    def __init__(
        self,
        group_member_attribute_name: str = None,
        group_object_class: str = None,
        group_object_class_custom_filter: str = None,
        organization_unit_object_class: str = None,
        user_object_class: str = None,
        user_object_class_custom_filter: str = None,
    ):
        # 组成员标识
        self.group_member_attribute_name = group_member_attribute_name
        # 组objectClass
        self.group_object_class = group_object_class
        # 组自定义Filter
        self.group_object_class_custom_filter = group_object_class_custom_filter
        # 组织ObjectClass
        self.organization_unit_object_class = organization_unit_object_class
        # 用户ObjectClass
        self.user_object_class = user_object_class
        # 用户自定义Filter
        self.user_object_class_custom_filter = user_object_class_custom_filter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_member_attribute_name is not None:
            result['GroupMemberAttributeName'] = self.group_member_attribute_name
        if self.group_object_class is not None:
            result['GroupObjectClass'] = self.group_object_class
        if self.group_object_class_custom_filter is not None:
            result['GroupObjectClassCustomFilter'] = self.group_object_class_custom_filter
        if self.organization_unit_object_class is not None:
            result['OrganizationUnitObjectClass'] = self.organization_unit_object_class
        if self.user_object_class is not None:
            result['UserObjectClass'] = self.user_object_class
        if self.user_object_class_custom_filter is not None:
            result['UserObjectClassCustomFilter'] = self.user_object_class_custom_filter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupMemberAttributeName') is not None:
            self.group_member_attribute_name = m.get('GroupMemberAttributeName')
        if m.get('GroupObjectClass') is not None:
            self.group_object_class = m.get('GroupObjectClass')
        if m.get('GroupObjectClassCustomFilter') is not None:
            self.group_object_class_custom_filter = m.get('GroupObjectClassCustomFilter')
        if m.get('OrganizationUnitObjectClass') is not None:
            self.organization_unit_object_class = m.get('OrganizationUnitObjectClass')
        if m.get('UserObjectClass') is not None:
            self.user_object_class = m.get('UserObjectClass')
        if m.get('UserObjectClassCustomFilter') is not None:
            self.user_object_class_custom_filter = m.get('UserObjectClassCustomFilter')
        return self


class SetIdentityProviderUdPullConfigurationRequestPeriodicSyncConfig(TeaModel):
    def __init__(
        self,
        periodic_sync_cron: str = None,
        periodic_sync_times: List[int] = None,
        periodic_sync_type: str = None,
    ):
        self.periodic_sync_cron = periodic_sync_cron
        self.periodic_sync_times = periodic_sync_times
        self.periodic_sync_type = periodic_sync_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.periodic_sync_cron is not None:
            result['PeriodicSyncCron'] = self.periodic_sync_cron
        if self.periodic_sync_times is not None:
            result['PeriodicSyncTimes'] = self.periodic_sync_times
        if self.periodic_sync_type is not None:
            result['PeriodicSyncType'] = self.periodic_sync_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PeriodicSyncCron') is not None:
            self.periodic_sync_cron = m.get('PeriodicSyncCron')
        if m.get('PeriodicSyncTimes') is not None:
            self.periodic_sync_times = m.get('PeriodicSyncTimes')
        if m.get('PeriodicSyncType') is not None:
            self.periodic_sync_type = m.get('PeriodicSyncType')
        return self


class SetIdentityProviderUdPullConfigurationRequestPullProtectedRule(TeaModel):
    def __init__(
        self,
        group_deleted_threshold: int = None,
        organizational_unit_deleted_threshold: int = None,
        user_deleted_threshold: int = None,
    ):
        # 同步保护规则-删除组数量
        self.group_deleted_threshold = group_deleted_threshold
        # 钉钉一方应用同步保护规则-删除组织数量
        self.organizational_unit_deleted_threshold = organizational_unit_deleted_threshold
        # 钉钉一方应用同步保护规则-删除账户数量
        self.user_deleted_threshold = user_deleted_threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_deleted_threshold is not None:
            result['GroupDeletedThreshold'] = self.group_deleted_threshold
        if self.organizational_unit_deleted_threshold is not None:
            result['OrganizationalUnitDeletedThreshold'] = self.organizational_unit_deleted_threshold
        if self.user_deleted_threshold is not None:
            result['UserDeletedThreshold'] = self.user_deleted_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupDeletedThreshold') is not None:
            self.group_deleted_threshold = m.get('GroupDeletedThreshold')
        if m.get('OrganizationalUnitDeletedThreshold') is not None:
            self.organizational_unit_deleted_threshold = m.get('OrganizationalUnitDeletedThreshold')
        if m.get('UserDeletedThreshold') is not None:
            self.user_deleted_threshold = m.get('UserDeletedThreshold')
        return self


class SetIdentityProviderUdPullConfigurationRequestUdSyncScopeConfig(TeaModel):
    def __init__(
        self,
        source_scopes: List[str] = None,
        target_scope: str = None,
    ):
        # 同步来源节点
        self.source_scopes = source_scopes
        # 同步目标节点
        self.target_scope = target_scope

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_scopes is not None:
            result['SourceScopes'] = self.source_scopes
        if self.target_scope is not None:
            result['TargetScope'] = self.target_scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceScopes') is not None:
            self.source_scopes = m.get('SourceScopes')
        if m.get('TargetScope') is not None:
            self.target_scope = m.get('TargetScope')
        return self


class SetIdentityProviderUdPullConfigurationRequest(TeaModel):
    def __init__(
        self,
        group_sync_status: str = None,
        identity_provider_id: str = None,
        incremental_callback_status: str = None,
        instance_id: str = None,
        ldap_ud_pull_config: SetIdentityProviderUdPullConfigurationRequestLdapUdPullConfig = None,
        periodic_sync_config: SetIdentityProviderUdPullConfigurationRequestPeriodicSyncConfig = None,
        periodic_sync_status: str = None,
        pull_protected_rule: SetIdentityProviderUdPullConfigurationRequestPullProtectedRule = None,
        ud_sync_scope_config: SetIdentityProviderUdPullConfigurationRequestUdSyncScopeConfig = None,
    ):
        # 组同步状态
        self.group_sync_status = group_sync_status
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # 增量回调状态，是否处理来自IdP的增量回调数据
        # 
        # This parameter is required.
        self.incremental_callback_status = incremental_callback_status
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # ldap同步侧相关配置信息
        self.ldap_ud_pull_config = ldap_ud_pull_config
        self.periodic_sync_config = periodic_sync_config
        self.periodic_sync_status = periodic_sync_status
        # 同步入保护规则,根据IdP的type做解析
        self.pull_protected_rule = pull_protected_rule
        # 同步入配置信息
        self.ud_sync_scope_config = ud_sync_scope_config

    def validate(self):
        if self.ldap_ud_pull_config:
            self.ldap_ud_pull_config.validate()
        if self.periodic_sync_config:
            self.periodic_sync_config.validate()
        if self.pull_protected_rule:
            self.pull_protected_rule.validate()
        if self.ud_sync_scope_config:
            self.ud_sync_scope_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_sync_status is not None:
            result['GroupSyncStatus'] = self.group_sync_status
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.incremental_callback_status is not None:
            result['IncrementalCallbackStatus'] = self.incremental_callback_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ldap_ud_pull_config is not None:
            result['LdapUdPullConfig'] = self.ldap_ud_pull_config.to_map()
        if self.periodic_sync_config is not None:
            result['PeriodicSyncConfig'] = self.periodic_sync_config.to_map()
        if self.periodic_sync_status is not None:
            result['PeriodicSyncStatus'] = self.periodic_sync_status
        if self.pull_protected_rule is not None:
            result['PullProtectedRule'] = self.pull_protected_rule.to_map()
        if self.ud_sync_scope_config is not None:
            result['UdSyncScopeConfig'] = self.ud_sync_scope_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupSyncStatus') is not None:
            self.group_sync_status = m.get('GroupSyncStatus')
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('IncrementalCallbackStatus') is not None:
            self.incremental_callback_status = m.get('IncrementalCallbackStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LdapUdPullConfig') is not None:
            temp_model = SetIdentityProviderUdPullConfigurationRequestLdapUdPullConfig()
            self.ldap_ud_pull_config = temp_model.from_map(m['LdapUdPullConfig'])
        if m.get('PeriodicSyncConfig') is not None:
            temp_model = SetIdentityProviderUdPullConfigurationRequestPeriodicSyncConfig()
            self.periodic_sync_config = temp_model.from_map(m['PeriodicSyncConfig'])
        if m.get('PeriodicSyncStatus') is not None:
            self.periodic_sync_status = m.get('PeriodicSyncStatus')
        if m.get('PullProtectedRule') is not None:
            temp_model = SetIdentityProviderUdPullConfigurationRequestPullProtectedRule()
            self.pull_protected_rule = temp_model.from_map(m['PullProtectedRule'])
        if m.get('UdSyncScopeConfig') is not None:
            temp_model = SetIdentityProviderUdPullConfigurationRequestUdSyncScopeConfig()
            self.ud_sync_scope_config = temp_model.from_map(m['UdSyncScopeConfig'])
        return self


class SetIdentityProviderUdPullConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetIdentityProviderUdPullConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetIdentityProviderUdPullConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetIdentityProviderUdPullConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetPasswordComplexityConfigurationRequestPasswordComplexityRules(TeaModel):
    def __init__(
        self,
        password_check_type: str = None,
    ):
        # The type of the password check. Valid values:
        # 
        # *   inclusion_upper_case: The password must contain uppercase letters.
        # *   inclusion_lower_case: The password must contain lowercase letters.
        # *   inclusion_special_case: The password must contain one or more of the following special characters: @ % + \\ / \\" ! # $ ^ ? : , ( ) { } [ ] ~ - _ .
        # *   inclusion_number: The password must contain digits.
        # *   exclusion_username: The password cannot contain a username.
        # *   exclusion_email: The password cannot contain an email prefix.
        # *   exclusion_phone_number: The password cannot contain a mobile number.
        # *   exclusion_display_name: The password cannot contain a display name.
        self.password_check_type = password_check_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password_check_type is not None:
            result['PasswordCheckType'] = self.password_check_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PasswordCheckType') is not None:
            self.password_check_type = m.get('PasswordCheckType')
        return self


class SetPasswordComplexityConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        password_complexity_rules: List[SetPasswordComplexityConfigurationRequestPasswordComplexityRules] = None,
        password_min_length: int = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The password complexity rules.
        self.password_complexity_rules = password_complexity_rules
        # The minimum number of characters in a password.
        # 
        # This parameter is required.
        self.password_min_length = password_min_length

    def validate(self):
        if self.password_complexity_rules:
            for k in self.password_complexity_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['PasswordComplexityRules'] = []
        if self.password_complexity_rules is not None:
            for k in self.password_complexity_rules:
                result['PasswordComplexityRules'].append(k.to_map() if k else None)
        if self.password_min_length is not None:
            result['PasswordMinLength'] = self.password_min_length
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.password_complexity_rules = []
        if m.get('PasswordComplexityRules') is not None:
            for k in m.get('PasswordComplexityRules'):
                temp_model = SetPasswordComplexityConfigurationRequestPasswordComplexityRules()
                self.password_complexity_rules.append(temp_model.from_map(k))
        if m.get('PasswordMinLength') is not None:
            self.password_min_length = m.get('PasswordMinLength')
        return self


class SetPasswordComplexityConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetPasswordComplexityConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetPasswordComplexityConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetPasswordComplexityConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetPasswordExpirationConfigurationRequest(TeaModel):
    def __init__(
        self,
        effective_authentication_source_ids: List[str] = None,
        instance_id: str = None,
        password_expiration_action: str = None,
        password_expiration_notification_channels: List[str] = None,
        password_expiration_notification_duration: int = None,
        password_expiration_notification_status: str = None,
        password_expiration_status: str = None,
        password_forced_update_duration: int = None,
        password_valid_max_day: int = None,
    ):
        self.effective_authentication_source_ids = effective_authentication_source_ids
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The action to take upon password expiration. This parameter must be specified when PasswordExpirationStatus is set to enabled. Valid values:
        # 
        # *   forbid_login: Users cannot log on to IDaaS.
        # *   force_update_password: Users must change the password.
        # *   remind_update_password: IDaaS reminds users to change the password upon each logon.
        self.password_expiration_action = password_expiration_action
        # The methods for receiving password expiration notifications. This parameter must be specified when PasswordExpirationNotificationStatus is set to enabled.
        self.password_expiration_notification_channels = password_expiration_notification_channels
        # The number of days before the expiration date during which password expiration notifications are sent. Unit: day. This parameter must be specified when PasswordExpirationNotificationStatus is set to enabled.
        self.password_expiration_notification_duration = password_expiration_notification_duration
        # Specifies whether to enable the password expiration notification feature. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_expiration_notification_status = password_expiration_notification_status
        # Specifies whether to enable the password expiration feature. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # This parameter is required.
        self.password_expiration_status = password_expiration_status
        # The number of days before which users must change the password to prevent password expiration. Unit: day. You must set this parameter to a value greater than the value of PasswordExpirationNotificationDuration.
        self.password_forced_update_duration = password_forced_update_duration
        # The validity period of a password. Unit: day. This parameter must be specified when PasswordExpirationStatus is set to enabled.
        self.password_valid_max_day = password_valid_max_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective_authentication_source_ids is not None:
            result['EffectiveAuthenticationSourceIds'] = self.effective_authentication_source_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password_expiration_action is not None:
            result['PasswordExpirationAction'] = self.password_expiration_action
        if self.password_expiration_notification_channels is not None:
            result['PasswordExpirationNotificationChannels'] = self.password_expiration_notification_channels
        if self.password_expiration_notification_duration is not None:
            result['PasswordExpirationNotificationDuration'] = self.password_expiration_notification_duration
        if self.password_expiration_notification_status is not None:
            result['PasswordExpirationNotificationStatus'] = self.password_expiration_notification_status
        if self.password_expiration_status is not None:
            result['PasswordExpirationStatus'] = self.password_expiration_status
        if self.password_forced_update_duration is not None:
            result['PasswordForcedUpdateDuration'] = self.password_forced_update_duration
        if self.password_valid_max_day is not None:
            result['PasswordValidMaxDay'] = self.password_valid_max_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectiveAuthenticationSourceIds') is not None:
            self.effective_authentication_source_ids = m.get('EffectiveAuthenticationSourceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PasswordExpirationAction') is not None:
            self.password_expiration_action = m.get('PasswordExpirationAction')
        if m.get('PasswordExpirationNotificationChannels') is not None:
            self.password_expiration_notification_channels = m.get('PasswordExpirationNotificationChannels')
        if m.get('PasswordExpirationNotificationDuration') is not None:
            self.password_expiration_notification_duration = m.get('PasswordExpirationNotificationDuration')
        if m.get('PasswordExpirationNotificationStatus') is not None:
            self.password_expiration_notification_status = m.get('PasswordExpirationNotificationStatus')
        if m.get('PasswordExpirationStatus') is not None:
            self.password_expiration_status = m.get('PasswordExpirationStatus')
        if m.get('PasswordForcedUpdateDuration') is not None:
            self.password_forced_update_duration = m.get('PasswordForcedUpdateDuration')
        if m.get('PasswordValidMaxDay') is not None:
            self.password_valid_max_day = m.get('PasswordValidMaxDay')
        return self


class SetPasswordExpirationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetPasswordExpirationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetPasswordExpirationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetPasswordExpirationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetPasswordHistoryConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        password_history_max_retention: int = None,
        password_history_status: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The maximum number of recent passwords that can be retained. This parameter must be specified when PasswordHistoryStatus is set to enabled.
        self.password_history_max_retention = password_history_max_retention
        # Specifies whether to enable the password history feature. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # This parameter is required.
        self.password_history_status = password_history_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password_history_max_retention is not None:
            result['PasswordHistoryMaxRetention'] = self.password_history_max_retention
        if self.password_history_status is not None:
            result['PasswordHistoryStatus'] = self.password_history_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PasswordHistoryMaxRetention') is not None:
            self.password_history_max_retention = m.get('PasswordHistoryMaxRetention')
        if m.get('PasswordHistoryStatus') is not None:
            self.password_history_status = m.get('PasswordHistoryStatus')
        return self


class SetPasswordHistoryConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetPasswordHistoryConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetPasswordHistoryConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetPasswordHistoryConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetPasswordInitializationConfigurationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        password_forced_update_status: str = None,
        password_initialization_notification_channels: List[str] = None,
        password_initialization_status: str = None,
        password_initialization_type: str = None,
    ):
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Specifies whether to enable forcible password change upon first logon. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.password_forced_update_status = password_forced_update_status
        # The methods for receiving password initialization notifications.
        self.password_initialization_notification_channels = password_initialization_notification_channels
        # Specifies whether to enable password initialization. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # This parameter is required.
        self.password_initialization_status = password_initialization_status
        # The password initialization method. This parameter is required when PasswordInitializationStatus is set to enabled. Set the value to random.
        # 
        # *   random: A randomly generated password is used.
        self.password_initialization_type = password_initialization_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.password_forced_update_status is not None:
            result['PasswordForcedUpdateStatus'] = self.password_forced_update_status
        if self.password_initialization_notification_channels is not None:
            result['PasswordInitializationNotificationChannels'] = self.password_initialization_notification_channels
        if self.password_initialization_status is not None:
            result['PasswordInitializationStatus'] = self.password_initialization_status
        if self.password_initialization_type is not None:
            result['PasswordInitializationType'] = self.password_initialization_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PasswordForcedUpdateStatus') is not None:
            self.password_forced_update_status = m.get('PasswordForcedUpdateStatus')
        if m.get('PasswordInitializationNotificationChannels') is not None:
            self.password_initialization_notification_channels = m.get('PasswordInitializationNotificationChannels')
        if m.get('PasswordInitializationStatus') is not None:
            self.password_initialization_status = m.get('PasswordInitializationStatus')
        if m.get('PasswordInitializationType') is not None:
            self.password_initialization_type = m.get('PasswordInitializationType')
        return self


class SetPasswordInitializationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetPasswordInitializationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetPasswordInitializationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetPasswordInitializationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetUserPrimaryOrganizationalUnitRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        organizational_unit_id: str = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the new primary organizational unit.
        # 
        # This parameter is required.
        self.organizational_unit_id = organizational_unit_id
        # The ID of the account.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.organizational_unit_id is not None:
            result['OrganizationalUnitId'] = self.organizational_unit_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrganizationalUnitId') is not None:
            self.organizational_unit_id = m.get('OrganizationalUnitId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class SetUserPrimaryOrganizationalUnitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetUserPrimaryOrganizationalUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetUserPrimaryOrganizationalUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetUserPrimaryOrganizationalUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UnlockUserRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The account ID.
        # 
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class UnlockUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UnlockUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UnlockUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UnlockUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateApplicationAuthorizationTypeRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        authorization_type: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to modify.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The authorization type of the application. Valid values:
        # 
        # *   authorize_required: Only the user with explicit authorization can access the application.
        # *   default_all: By default, all users can access the application.
        # 
        # This parameter is required.
        self.authorization_type = authorization_type
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.authorization_type is not None:
            result['AuthorizationType'] = self.authorization_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('AuthorizationType') is not None:
            self.authorization_type = m.get('AuthorizationType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateApplicationAuthorizationTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateApplicationAuthorizationTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateApplicationAuthorizationTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateApplicationAuthorizationTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateApplicationDescriptionRequest(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        description: str = None,
        instance_id: str = None,
    ):
        # The ID of the application that you want to modify.
        # 
        # This parameter is required.
        self.application_id = application_id
        # The description of the application.
        self.description = description
        # The ID of the instance.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateApplicationDescriptionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateApplicationDescriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateApplicationDescriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateApplicationDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConditionalAccessPolicyRequestConditionsConfigApplications(TeaModel):
    def __init__(
        self,
        exclude_applications: List[str] = None,
        include_applications: List[str] = None,
    ):
        # Excluded Applications
        self.exclude_applications = exclude_applications
        # Included Applications
        self.include_applications = include_applications

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_applications is not None:
            result['ExcludeApplications'] = self.exclude_applications
        if self.include_applications is not None:
            result['IncludeApplications'] = self.include_applications
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeApplications') is not None:
            self.exclude_applications = m.get('ExcludeApplications')
        if m.get('IncludeApplications') is not None:
            self.include_applications = m.get('IncludeApplications')
        return self


class UpdateConditionalAccessPolicyRequestConditionsConfigNetworkZones(TeaModel):
    def __init__(
        self,
        exclude_network_zones: List[str] = None,
        include_network_zones: List[str] = None,
    ):
        # Excluded network zones
        self.exclude_network_zones = exclude_network_zones
        # Included network zones
        self.include_network_zones = include_network_zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_network_zones is not None:
            result['ExcludeNetworkZones'] = self.exclude_network_zones
        if self.include_network_zones is not None:
            result['IncludeNetworkZones'] = self.include_network_zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeNetworkZones') is not None:
            self.exclude_network_zones = m.get('ExcludeNetworkZones')
        if m.get('IncludeNetworkZones') is not None:
            self.include_network_zones = m.get('IncludeNetworkZones')
        return self


class UpdateConditionalAccessPolicyRequestConditionsConfigUsers(TeaModel):
    def __init__(
        self,
        exclude_groups: List[str] = None,
        exclude_organizational_units: List[str] = None,
        exclude_users: List[str] = None,
        include_groups: List[str] = None,
        include_organizational_units: List[str] = None,
        include_users: List[str] = None,
    ):
        # Excluded user groups
        self.exclude_groups = exclude_groups
        # Excluded organizations
        self.exclude_organizational_units = exclude_organizational_units
        # Excluded Users
        self.exclude_users = exclude_users
        # Included User Groups
        self.include_groups = include_groups
        # Included organizations
        self.include_organizational_units = include_organizational_units
        # Included Users
        self.include_users = include_users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exclude_groups is not None:
            result['ExcludeGroups'] = self.exclude_groups
        if self.exclude_organizational_units is not None:
            result['ExcludeOrganizationalUnits'] = self.exclude_organizational_units
        if self.exclude_users is not None:
            result['ExcludeUsers'] = self.exclude_users
        if self.include_groups is not None:
            result['IncludeGroups'] = self.include_groups
        if self.include_organizational_units is not None:
            result['IncludeOrganizationalUnits'] = self.include_organizational_units
        if self.include_users is not None:
            result['IncludeUsers'] = self.include_users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExcludeGroups') is not None:
            self.exclude_groups = m.get('ExcludeGroups')
        if m.get('ExcludeOrganizationalUnits') is not None:
            self.exclude_organizational_units = m.get('ExcludeOrganizationalUnits')
        if m.get('ExcludeUsers') is not None:
            self.exclude_users = m.get('ExcludeUsers')
        if m.get('IncludeGroups') is not None:
            self.include_groups = m.get('IncludeGroups')
        if m.get('IncludeOrganizationalUnits') is not None:
            self.include_organizational_units = m.get('IncludeOrganizationalUnits')
        if m.get('IncludeUsers') is not None:
            self.include_users = m.get('IncludeUsers')
        return self


class UpdateConditionalAccessPolicyRequestConditionsConfig(TeaModel):
    def __init__(
        self,
        applications: UpdateConditionalAccessPolicyRequestConditionsConfigApplications = None,
        network_zones: UpdateConditionalAccessPolicyRequestConditionsConfigNetworkZones = None,
        users: UpdateConditionalAccessPolicyRequestConditionsConfigUsers = None,
    ):
        # Target Applications for the Conditional Access Policy
        self.applications = applications
        # Network zones for conditional access policy
        self.network_zones = network_zones
        # Target Users for the Conditional Access Policy
        self.users = users

    def validate(self):
        if self.applications:
            self.applications.validate()
        if self.network_zones:
            self.network_zones.validate()
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applications is not None:
            result['Applications'] = self.applications.to_map()
        if self.network_zones is not None:
            result['NetworkZones'] = self.network_zones.to_map()
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applications') is not None:
            temp_model = UpdateConditionalAccessPolicyRequestConditionsConfigApplications()
            self.applications = temp_model.from_map(m['Applications'])
        if m.get('NetworkZones') is not None:
            temp_model = UpdateConditionalAccessPolicyRequestConditionsConfigNetworkZones()
            self.network_zones = temp_model.from_map(m['NetworkZones'])
        if m.get('Users') is not None:
            temp_model = UpdateConditionalAccessPolicyRequestConditionsConfigUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class UpdateConditionalAccessPolicyRequestDecisionConfig(TeaModel):
    def __init__(
        self,
        active_session_reuse_status: str = None,
        effect: str = None,
        mfa_authentication_interval_seconds: int = None,
        mfa_authentication_methods: List[str] = None,
        mfa_type: str = None,
    ):
        # Whether to enable session reuse
        self.active_session_reuse_status = active_session_reuse_status
        # Conditional Access Policy Decision Action
        self.effect = effect
        # Conditional Access Policy Re-authentication Interval (seconds)
        self.mfa_authentication_interval_seconds = mfa_authentication_interval_seconds
        # Allowed MFA types for the Conditional Access Policy
        self.mfa_authentication_methods = mfa_authentication_methods
        # Conditional Access Policy MFA Type
        self.mfa_type = mfa_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_reuse_status is not None:
            result['ActiveSessionReuseStatus'] = self.active_session_reuse_status
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.mfa_authentication_interval_seconds is not None:
            result['MfaAuthenticationIntervalSeconds'] = self.mfa_authentication_interval_seconds
        if self.mfa_authentication_methods is not None:
            result['MfaAuthenticationMethods'] = self.mfa_authentication_methods
        if self.mfa_type is not None:
            result['MfaType'] = self.mfa_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionReuseStatus') is not None:
            self.active_session_reuse_status = m.get('ActiveSessionReuseStatus')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('MfaAuthenticationIntervalSeconds') is not None:
            self.mfa_authentication_interval_seconds = m.get('MfaAuthenticationIntervalSeconds')
        if m.get('MfaAuthenticationMethods') is not None:
            self.mfa_authentication_methods = m.get('MfaAuthenticationMethods')
        if m.get('MfaType') is not None:
            self.mfa_type = m.get('MfaType')
        return self


class UpdateConditionalAccessPolicyRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        conditional_access_policy_name: str = None,
        conditions_config: UpdateConditionalAccessPolicyRequestConditionsConfig = None,
        decision_config: UpdateConditionalAccessPolicyRequestDecisionConfig = None,
        decision_type: str = None,
        instance_id: str = None,
        priority: int = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Conditional Access Policy Name
        # 
        # This parameter is required.
        self.conditional_access_policy_name = conditional_access_policy_name
        # Conditional Access Policy Condition Content Configuration
        self.conditions_config = conditions_config
        # Conditional Access Policy Action Configuration
        self.decision_config = decision_config
        # Conditional Access Policy Execution Type
        # 
        # This parameter is required.
        self.decision_type = decision_type
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Priority of the conditional access policy
        self.priority = priority

    def validate(self):
        if self.conditions_config:
            self.conditions_config.validate()
        if self.decision_config:
            self.decision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.conditional_access_policy_name is not None:
            result['ConditionalAccessPolicyName'] = self.conditional_access_policy_name
        if self.conditions_config is not None:
            result['ConditionsConfig'] = self.conditions_config.to_map()
        if self.decision_config is not None:
            result['DecisionConfig'] = self.decision_config.to_map()
        if self.decision_type is not None:
            result['DecisionType'] = self.decision_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.priority is not None:
            result['Priority'] = self.priority
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('ConditionalAccessPolicyName') is not None:
            self.conditional_access_policy_name = m.get('ConditionalAccessPolicyName')
        if m.get('ConditionsConfig') is not None:
            temp_model = UpdateConditionalAccessPolicyRequestConditionsConfig()
            self.conditions_config = temp_model.from_map(m['ConditionsConfig'])
        if m.get('DecisionConfig') is not None:
            temp_model = UpdateConditionalAccessPolicyRequestDecisionConfig()
            self.decision_config = temp_model.from_map(m['DecisionConfig'])
        if m.get('DecisionType') is not None:
            self.decision_type = m.get('DecisionType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        return self


class UpdateConditionalAccessPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConditionalAccessPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateConditionalAccessPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateConditionalAccessPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConditionalAccessPolicyDescriptionRequest(TeaModel):
    def __init__(
        self,
        conditional_access_policy_id: str = None,
        description: str = None,
        instance_id: str = None,
    ):
        # Conditional Access Policy ID
        # 
        # This parameter is required.
        self.conditional_access_policy_id = conditional_access_policy_id
        # Description of the conditional access policy
        # 
        # This parameter is required.
        self.description = description
        # Instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conditional_access_policy_id is not None:
            result['ConditionalAccessPolicyId'] = self.conditional_access_policy_id
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionalAccessPolicyId') is not None:
            self.conditional_access_policy_id = m.get('ConditionalAccessPolicyId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateConditionalAccessPolicyDescriptionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConditionalAccessPolicyDescriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateConditionalAccessPolicyDescriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateConditionalAccessPolicyDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateGroupRequest(TeaModel):
    def __init__(
        self,
        group_external_id: str = None,
        group_id: str = None,
        group_name: str = None,
        instance_id: str = None,
    ):
        # The external ID of the group.
        self.group_external_id = group_external_id
        # The group ID.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The name of the group.
        self.group_name = group_name
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_external_id is not None:
            result['GroupExternalId'] = self.group_external_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupExternalId') is not None:
            self.group_external_id = m.get('GroupExternalId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateGroupDescriptionRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        group_id: str = None,
        instance_id: str = None,
    ):
        # The description of the account group.
        self.description = description
        # The ID of the account group.
        # 
        # This parameter is required.
        self.group_id = group_id
        # The instance ID.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateGroupDescriptionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateGroupDescriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateGroupDescriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateGroupDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateIdentityProviderRequestDingtalkAppConfig(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        app_secret: str = None,
    ):
        # 钉钉一方应用的AppKey
        # 
        # This parameter is required.
        self.app_key = app_key
        # 钉钉一方应用的AppSecret
        # 
        # This parameter is required.
        self.app_secret = app_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        return self


class UpdateIdentityProviderRequestLarkConfig(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_secret: str = None,
        encrypt_key: str = None,
        verification_token: str = None,
    ):
        self.app_id = app_id
        self.app_secret = app_secret
        self.encrypt_key = encrypt_key
        self.verification_token = verification_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_secret is not None:
            result['AppSecret'] = self.app_secret
        if self.encrypt_key is not None:
            result['EncryptKey'] = self.encrypt_key
        if self.verification_token is not None:
            result['VerificationToken'] = self.verification_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppSecret') is not None:
            self.app_secret = m.get('AppSecret')
        if m.get('EncryptKey') is not None:
            self.encrypt_key = m.get('EncryptKey')
        if m.get('VerificationToken') is not None:
            self.verification_token = m.get('VerificationToken')
        return self


class UpdateIdentityProviderRequestLdapConfig(TeaModel):
    def __init__(
        self,
        administrator_password: str = None,
        administrator_username: str = None,
        certificate_fingerprint_status: str = None,
        certificate_fingerprints: List[str] = None,
        ldap_protocol: str = None,
        ldap_server_host: str = None,
        ldap_server_port: int = None,
        start_tls_status: str = None,
    ):
        # 管理员密码
        self.administrator_password = administrator_password
        # 管理员账号
        self.administrator_username = administrator_username
        # 是否验证指纹证书
        self.certificate_fingerprint_status = certificate_fingerprint_status
        # 证书指纹列表
        self.certificate_fingerprints = certificate_fingerprints
        # 通信协议
        self.ldap_protocol = ldap_protocol
        # ad/ldap 服务器地址
        self.ldap_server_host = ldap_server_host
        # 端口号
        self.ldap_server_port = ldap_server_port
        # startTls是否开启
        self.start_tls_status = start_tls_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrator_password is not None:
            result['AdministratorPassword'] = self.administrator_password
        if self.administrator_username is not None:
            result['AdministratorUsername'] = self.administrator_username
        if self.certificate_fingerprint_status is not None:
            result['CertificateFingerprintStatus'] = self.certificate_fingerprint_status
        if self.certificate_fingerprints is not None:
            result['CertificateFingerprints'] = self.certificate_fingerprints
        if self.ldap_protocol is not None:
            result['LdapProtocol'] = self.ldap_protocol
        if self.ldap_server_host is not None:
            result['LdapServerHost'] = self.ldap_server_host
        if self.ldap_server_port is not None:
            result['LdapServerPort'] = self.ldap_server_port
        if self.start_tls_status is not None:
            result['StartTlsStatus'] = self.start_tls_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdministratorPassword') is not None:
            self.administrator_password = m.get('AdministratorPassword')
        if m.get('AdministratorUsername') is not None:
            self.administrator_username = m.get('AdministratorUsername')
        if m.get('CertificateFingerprintStatus') is not None:
            self.certificate_fingerprint_status = m.get('CertificateFingerprintStatus')
        if m.get('CertificateFingerprints') is not None:
            self.certificate_fingerprints = m.get('CertificateFingerprints')
        if m.get('LdapProtocol') is not None:
            self.ldap_protocol = m.get('LdapProtocol')
        if m.get('LdapServerHost') is not None:
            self.ldap_server_host = m.get('LdapServerHost')
        if m.get('LdapServerPort') is not None:
            self.ldap_server_port = m.get('LdapServerPort')
        if m.get('StartTlsStatus') is not None:
            self.start_tls_status = m.get('StartTlsStatus')
        return self


class UpdateIdentityProviderRequestOidcConfigAuthnParam(TeaModel):
    def __init__(
        self,
        authn_method: str = None,
        client_secret: str = None,
    ):
        # OIDC/oAuth2 认证方法。
        self.authn_method = authn_method
        # OIDC/oAuth2 客户端密钥。
        self.client_secret = client_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_method is not None:
            result['AuthnMethod'] = self.authn_method
        if self.client_secret is not None:
            result['ClientSecret'] = self.client_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnMethod') is not None:
            self.authn_method = m.get('AuthnMethod')
        if m.get('ClientSecret') is not None:
            self.client_secret = m.get('ClientSecret')
        return self


class UpdateIdentityProviderRequestOidcConfigEndpointConfig(TeaModel):
    def __init__(
        self,
        authorization_endpoint: str = None,
        issuer: str = None,
        jwks_uri: str = None,
        token_endpoint: str = None,
        userinfo_endpoint: str = None,
    ):
        # oAuth2 授权端点。
        self.authorization_endpoint = authorization_endpoint
        # OIDC issuer信息。
        self.issuer = issuer
        # OIDC jwks地址。
        self.jwks_uri = jwks_uri
        # oAuth2 Token端点。
        self.token_endpoint = token_endpoint
        # OIDC 用户信息端点。
        self.userinfo_endpoint = userinfo_endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorization_endpoint is not None:
            result['AuthorizationEndpoint'] = self.authorization_endpoint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.jwks_uri is not None:
            result['JwksUri'] = self.jwks_uri
        if self.token_endpoint is not None:
            result['TokenEndpoint'] = self.token_endpoint
        if self.userinfo_endpoint is not None:
            result['UserinfoEndpoint'] = self.userinfo_endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthorizationEndpoint') is not None:
            self.authorization_endpoint = m.get('AuthorizationEndpoint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('JwksUri') is not None:
            self.jwks_uri = m.get('JwksUri')
        if m.get('TokenEndpoint') is not None:
            self.token_endpoint = m.get('TokenEndpoint')
        if m.get('UserinfoEndpoint') is not None:
            self.userinfo_endpoint = m.get('UserinfoEndpoint')
        return self


class UpdateIdentityProviderRequestOidcConfig(TeaModel):
    def __init__(
        self,
        authn_param: UpdateIdentityProviderRequestOidcConfigAuthnParam = None,
        endpoint_config: UpdateIdentityProviderRequestOidcConfigEndpointConfig = None,
        grant_scopes: List[str] = None,
        grant_type: str = None,
        pkce_challenge_method: str = None,
        pkce_required: bool = None,
    ):
        # OIDC客户端认证配置。
        self.authn_param = authn_param
        # OIDC 端点配置。
        self.endpoint_config = endpoint_config
        # OIDC标准参数，如profile、email等
        self.grant_scopes = grant_scopes
        # OIDC授权类型。
        self.grant_type = grant_type
        # 支持的PKCE算法类型。
        self.pkce_challenge_method = pkce_challenge_method
        # AuthorizationCode授权模式下是否使用PKCE。
        self.pkce_required = pkce_required

    def validate(self):
        if self.authn_param:
            self.authn_param.validate()
        if self.endpoint_config:
            self.endpoint_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authn_param is not None:
            result['AuthnParam'] = self.authn_param.to_map()
        if self.endpoint_config is not None:
            result['EndpointConfig'] = self.endpoint_config.to_map()
        if self.grant_scopes is not None:
            result['GrantScopes'] = self.grant_scopes
        if self.grant_type is not None:
            result['GrantType'] = self.grant_type
        if self.pkce_challenge_method is not None:
            result['PkceChallengeMethod'] = self.pkce_challenge_method
        if self.pkce_required is not None:
            result['PkceRequired'] = self.pkce_required
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthnParam') is not None:
            temp_model = UpdateIdentityProviderRequestOidcConfigAuthnParam()
            self.authn_param = temp_model.from_map(m['AuthnParam'])
        if m.get('EndpointConfig') is not None:
            temp_model = UpdateIdentityProviderRequestOidcConfigEndpointConfig()
            self.endpoint_config = temp_model.from_map(m['EndpointConfig'])
        if m.get('GrantScopes') is not None:
            self.grant_scopes = m.get('GrantScopes')
        if m.get('GrantType') is not None:
            self.grant_type = m.get('GrantType')
        if m.get('PkceChallengeMethod') is not None:
            self.pkce_challenge_method = m.get('PkceChallengeMethod')
        if m.get('PkceRequired') is not None:
            self.pkce_required = m.get('PkceRequired')
        return self


class UpdateIdentityProviderRequestWeComConfig(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        authorize_callback_domain: str = None,
        corp_secret: str = None,
        trustable_domain: str = None,
    ):
        # 企业微信自建应用的Id
        self.agent_id = agent_id
        # 授权回调域
        self.authorize_callback_domain = authorize_callback_domain
        # 企业微信自建应用的corpSecret
        self.corp_secret = corp_secret
        # 可信域名
        self.trustable_domain = trustable_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.authorize_callback_domain is not None:
            result['AuthorizeCallbackDomain'] = self.authorize_callback_domain
        if self.corp_secret is not None:
            result['CorpSecret'] = self.corp_secret
        if self.trustable_domain is not None:
            result['TrustableDomain'] = self.trustable_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AuthorizeCallbackDomain') is not None:
            self.authorize_callback_domain = m.get('AuthorizeCallbackDomain')
        if m.get('CorpSecret') is not None:
            self.corp_secret = m.get('CorpSecret')
        if m.get('TrustableDomain') is not None:
            self.trustable_domain = m.get('TrustableDomain')
        return self


class UpdateIdentityProviderRequest(TeaModel):
    def __init__(
        self,
        dingtalk_app_config: UpdateIdentityProviderRequestDingtalkAppConfig = None,
        identity_provider_id: str = None,
        identity_provider_name: str = None,
        instance_id: str = None,
        lark_config: UpdateIdentityProviderRequestLarkConfig = None,
        ldap_config: UpdateIdentityProviderRequestLdapConfig = None,
        logo_url: str = None,
        network_access_endpoint_id: str = None,
        oidc_config: UpdateIdentityProviderRequestOidcConfig = None,
        we_com_config: UpdateIdentityProviderRequestWeComConfig = None,
    ):
        # 钉钉出基本信息
        self.dingtalk_app_config = dingtalk_app_config
        # IDaaS的身份提供方主键id
        # 
        # This parameter is required.
        self.identity_provider_id = identity_provider_id
        # 身份提供方名称
        self.identity_provider_name = identity_provider_name
        # IDaaS EIAM实例的ID。
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # 飞书配置
        self.lark_config = lark_config
        # AD/LDAP基本信息
        self.ldap_config = ldap_config
        self.logo_url = logo_url
        # 网络端点ID
        self.network_access_endpoint_id = network_access_endpoint_id
        # OIDC IdP配置。
        self.oidc_config = oidc_config
        # 企业微信基本信息
        self.we_com_config = we_com_config

    def validate(self):
        if self.dingtalk_app_config:
            self.dingtalk_app_config.validate()
        if self.lark_config:
            self.lark_config.validate()
        if self.ldap_config:
            self.ldap_config.validate()
        if self.oidc_config:
            self.oidc_config.validate()
        if self.we_com_config:
            self.we_com_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_app_config is not None:
            result['DingtalkAppConfig'] = self.dingtalk_app_config.to_map()
        if self.identity_provider_id is not None:
            result['IdentityProviderId'] = self.identity_provider_id
        if self.identity_provider_name is not None:
            result['IdentityProviderName'] = self.identity_provider_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lark_config is not None:
            result['LarkConfig'] = self.lark_config.to_map()
        if self.ldap_config is not None:
            result['LdapConfig'] = self.ldap_config.to_map()
        if self.logo_url is not None:
            result['LogoUrl'] = self.logo_url
        if self.network_access_endpoint_id is not None:
            result['NetworkAccessEndpointId'] = self.network_access_endpoint_id
        if self.oidc_config is not None:
            result['OidcConfig'] = self.oidc_config.to_map()
        if self.we_com_config is not None:
            result['WeComConfig'] = self.we_com_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingtalkAppConfig') is not None:
            temp_model = UpdateIdentityProviderRequestDingtalkAppConfig()
            self.dingtalk_app_config = temp_model.from_map(m['DingtalkAppConfig'])
        if m.get('IdentityProviderId') is not None:
            self.identity_provider_id = m.get('IdentityProviderId')
        if m.get('IdentityProviderName') is not None:
            self.identity_provider_name = m.get('IdentityProviderName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LarkConfig') is not None:
            temp_model = UpdateIdentityProviderRequestLarkConfig()
            self.lark_config = temp_model.from_map(m['LarkConfig'])
        if m.get('LdapConfig') is not None:
            temp_model = UpdateIdentityProviderRequestLdapConfig()
            self.ldap_config = temp_model.from_map(m['LdapConfig'])
        if m.get('LogoUrl') is not None:
            self.logo_url = m.get('LogoUrl')
        if m.get('NetworkAccessEndpointId') is not None:
            self.network_access_endpoint_id = m.get('NetworkAccessEndpointId')
        if m.get('OidcConfig') is not None:
            temp_model = UpdateIdentityProviderRequestOidcConfig()
            self.oidc_config = temp_model.from_map(m['OidcConfig'])
        if m.get('WeComConfig') is not None:
            temp_model = UpdateIdentityProviderRequestWeComConfig()
            self.we_com_config = temp_model.from_map(m['WeComConfig'])
        return self


class UpdateIdentityProviderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateIdentityProviderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateIdentityProviderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateIdentityProviderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateInstanceDescriptionRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        instance_id: str = None,
    ):
        # The new description of the instance.
        self.description = description
        # The ID of the instance whose description you want to modify.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateInstanceDescriptionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateInstanceDescriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateInstanceDescriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateInstanceDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return s