/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.handle;

import io.ray.api.BaseActorHandle;
import io.ray.api.ObjectRef;
import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Metrics;
import io.ray.serve.generated.RequestMetadata;
import io.ray.serve.handle.HandleOptions;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.router.Router;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.RandomStringUtils;

public class RayServeHandle {
    private String deploymentName;
    private HandleOptions handleOptions;
    private String handleTag;
    private Count requestCounter;
    private Router router;

    public RayServeHandle(BaseActorHandle controllerHandle, String deploymentName, HandleOptions handleOptions, Router router) {
        this.deploymentName = deploymentName;
        this.handleOptions = handleOptions != null ? handleOptions : new HandleOptions();
        this.handleTag = deploymentName + "#" + RandomStringUtils.randomAlphabetic(6);
        this.router = router != null ? router : new Router(controllerHandle, deploymentName);
        RayServeMetrics.execute(() -> {
            this.requestCounter = (Count)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)Metrics.count().name(RayServeMetrics.SERVE_HANDLE_REQUEST_COUNTER.name())).description(RayServeMetrics.SERVE_HANDLE_REQUEST_COUNTER.getDescription())).unit("")).tags(ImmutableMap.of("handle", this.handleTag, "endpoint", deploymentName))).register();
        });
    }

    public ObjectRef<Object> remote(Object ... parameters) {
        RayServeMetrics.execute(() -> this.requestCounter.inc(1.0));
        RequestMetadata.Builder requestMetadata = RequestMetadata.newBuilder();
        requestMetadata.setRequestId(RandomStringUtils.randomAlphabetic(10));
        requestMetadata.setEndpoint(this.deploymentName);
        requestMetadata.setCallMethod(this.handleOptions != null ? this.handleOptions.getMethodName() : "call");
        return this.router.assignRequest(requestMetadata.build(), parameters);
    }

    public RayServeHandle method(String methodName) {
        this.handleOptions.setMethodName(methodName);
        return this;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isPolling() {
        return this.router.getLongPollClient().isRunning();
    }
}

