/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.proxy;

import io.ray.serve.api.Serve;
import io.ray.serve.generated.EndpointInfo;
import io.ray.serve.handle.RayServeHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyRouter.class);
    private Map<String, EndpointInfo> routeInfo = new HashMap<String, EndpointInfo>();
    private Map<String, RayServeHandle> handles = new ConcurrentHashMap<String, RayServeHandle>();

    public void updateRoutes(Map<String, EndpointInfo> endpoints) {
        LOGGER.info("Got updated endpoints: {}.", (Object)endpoints);
        HashSet<String> existingHandles = new HashSet<String>(this.handles.keySet());
        HashMap<String, EndpointInfo> routeInfo = new HashMap<String, EndpointInfo>();
        if (endpoints != null) {
            for (Map.Entry<String, EndpointInfo> entry : endpoints.entrySet()) {
                String route = StringUtils.isNotBlank(entry.getValue().getRoute()) ? entry.getValue().getRoute() : entry.getKey();
                routeInfo.put(route, entry.getValue());
                if (this.handles.containsKey(entry.getKey())) {
                    existingHandles.remove(entry.getKey());
                    continue;
                }
                this.handles.put(entry.getKey(), Serve.getGlobalClient().getHandle(entry.getKey(), true));
            }
        }
        this.routeInfo = routeInfo;
        for (String endpoint : existingHandles) {
            this.handles.remove(endpoint);
        }
        LOGGER.info("The final route info: {}.", (Object)routeInfo);
    }

    public RayServeHandle matchRoute(String route) {
        EndpointInfo endpointInfo = this.routeInfo.get(route);
        return endpointInfo == null ? null : this.handles.get(endpointInfo.getEndpointName());
    }

    public Map<String, EndpointInfo> getRouteInfo() {
        return this.routeInfo;
    }

    public Map<String, RayServeHandle> getHandles() {
        return this.handles;
    }
}

