/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import com.datapps.linkoopdb.jdbc.util.DataAccessPoint;
import com.datapps.linkoopdb.jdbc.util.SQLStatements;
import com.datapps.linkoopdb.jdbc.util.Traceable;
import com.datapps.linkoopdb.jdbc.util.TransferResultSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;

class TransferTable
implements Serializable {
    Hashtable hTypes;
    DataAccessPoint sourceDb;
    DataAccessPoint destDb;
    SQLStatements Stmts = new SQLStatements();
    Traceable tracer;

    TransferTable(DataAccessPoint src, String name, String schema, String type, Traceable t) {
        this.sourceDb = src;
        this.Stmts.sSchema = "";
        if (schema != null && schema.length() > 0) {
            this.Stmts.sSchema = schema;
        }
        this.Stmts.sType = type;
        this.Stmts.sDatabaseToConvert = src.databaseToConvert;
        this.Stmts.sSourceTable = this.Stmts.sDestTable = name;
        this.tracer = t;
        if (this.Stmts.sType.compareTo("TABLE") == 0) {
            this.Stmts.sSourceSelect = "SELECT * FROM " + src.helper.formatName(this.Stmts.sSourceTable);
        } else if (this.Stmts.sType.compareTo("VIEW") == 0) {
            this.Stmts.sSourceSelect = "";
        }
    }

    void setDest(String _Schema, DataAccessPoint dest) throws Exception {
        this.destDb = dest;
        dest.helper.setSchema(_Schema);
    }

    void extractTableStructure(DataAccessPoint Source2, DataAccessPoint Destination) throws Exception {
        this.initTypes();
        Source2.getTableStructure(this, Destination);
    }

    void transferStructure() throws Exception {
        String Statement2 = new String("");
        if (this.destDb.helper.needTransferTransaction()) {
            try {
                this.destDb.setAutoCommit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.Stmts.bTransfer) {
            this.tracer.trace("Table " + this.Stmts.sSourceTable + " not transfered");
            return;
        }
        this.tracer.trace("Table " + this.Stmts.sSourceTable + ": start transfer");
        try {
            int nextsemicolon;
            if (this.Stmts.bDropIndex) {
                if (this.Stmts.sDestDropIndex.charAt(this.Stmts.sDestDropIndex.length() - 1) != ';') {
                    this.Stmts.sDestDropIndex = this.Stmts.sDestDropIndex + ";";
                }
                int lastsemicolon = 0;
                nextsemicolon = this.Stmts.sDestDropIndex.indexOf(59);
                while (nextsemicolon > lastsemicolon) {
                    Statement2 = this.Stmts.sDestDropIndex.substring(lastsemicolon, nextsemicolon);
                    while (Statement2.charAt(Statement2.length() - 1) == ';') {
                        Statement2 = Statement2.substring(0, Statement2.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + Statement2);
                        this.destDb.execute(Statement2);
                    }
                    catch (Exception e) {
                        this.tracer.trace("Ignoring error " + e.getMessage());
                    }
                    lastsemicolon = nextsemicolon + 1;
                    nextsemicolon = lastsemicolon + this.Stmts.sDestDropIndex.substring(lastsemicolon).indexOf(59);
                }
            }
            if (this.Stmts.bDelete) {
                if (this.Stmts.sDestDelete.charAt(this.Stmts.sDestDelete.length() - 1) != ';') {
                    this.Stmts.sDestDelete = this.Stmts.sDestDelete + ";";
                }
                int lastsemicolon = 0;
                nextsemicolon = this.Stmts.sDestDelete.indexOf(59);
                while (nextsemicolon > lastsemicolon) {
                    Statement2 = this.Stmts.sDestDelete.substring(lastsemicolon, nextsemicolon);
                    while (Statement2.charAt(Statement2.length() - 1) == ';') {
                        Statement2 = Statement2.substring(0, Statement2.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + Statement2);
                        this.destDb.execute(Statement2);
                    }
                    catch (Exception e) {
                        this.tracer.trace("Ignoring error " + e.getMessage());
                    }
                    lastsemicolon = nextsemicolon + 1;
                    nextsemicolon = lastsemicolon + this.Stmts.sDestDelete.substring(lastsemicolon).indexOf(59);
                }
            }
            if (this.Stmts.bDrop) {
                if (this.Stmts.sDestDrop.charAt(this.Stmts.sDestDrop.length() - 1) != ';') {
                    this.Stmts.sDestDrop = this.Stmts.sDestDrop + ";";
                }
                int lastsemicolon = 0;
                nextsemicolon = this.Stmts.sDestDrop.indexOf(59);
                while (nextsemicolon > lastsemicolon) {
                    Statement2 = this.Stmts.sDestDrop.substring(lastsemicolon, nextsemicolon);
                    while (Statement2.charAt(Statement2.length() - 1) == ';') {
                        Statement2 = Statement2.substring(0, Statement2.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + Statement2);
                        this.destDb.execute(Statement2);
                    }
                    catch (Exception e) {
                        this.tracer.trace("Ignoring error " + e.getMessage());
                    }
                    lastsemicolon = nextsemicolon + 1;
                    nextsemicolon = lastsemicolon + this.Stmts.sDestDrop.substring(lastsemicolon).indexOf(59);
                }
            }
            if (this.Stmts.bCreate) {
                if (this.Stmts.sDestCreate.charAt(this.Stmts.sDestCreate.length() - 1) != ';') {
                    this.Stmts.sDestCreate = this.Stmts.sDestCreate + ";";
                }
                int lastsemicolon = 0;
                nextsemicolon = this.Stmts.sDestCreate.indexOf(59);
                while (nextsemicolon > lastsemicolon) {
                    Statement2 = this.Stmts.sDestCreate.substring(lastsemicolon, nextsemicolon);
                    while (Statement2.charAt(Statement2.length() - 1) == ';') {
                        Statement2 = Statement2.substring(0, Statement2.length() - 1);
                    }
                    this.tracer.trace("Executing " + Statement2);
                    this.destDb.execute(Statement2);
                    lastsemicolon = nextsemicolon + 1;
                    nextsemicolon = lastsemicolon + this.Stmts.sDestCreate.substring(lastsemicolon).indexOf(59);
                }
            }
        }
        catch (Exception e) {
            try {
                if (!this.destDb.getAutoCommit()) {
                    this.destDb.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void transferData(int iMaxRows) throws Exception, SQLException {
        block17: {
            if (this.destDb.helper.needTransferTransaction()) {
                try {
                    this.destDb.setAutoCommit(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (!this.Stmts.bInsert) break block17;
                if (this.destDb.helper.needTransferTransaction()) {
                    try {
                        this.destDb.setAutoCommit(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.tracer.trace("Executing " + this.Stmts.sSourceSelect);
                TransferResultSet r = this.sourceDb.getData(this.Stmts.sSourceSelect);
                this.tracer.trace("Start transfering data...");
                this.destDb.beginDataTransfer();
                this.tracer.trace("Executing " + this.Stmts.sDestInsert);
                this.destDb.putData(this.Stmts.sDestInsert, r, iMaxRows);
                this.destDb.endDataTransfer();
                this.tracer.trace("Finished");
                if (!this.destDb.getAutoCommit()) {
                    this.destDb.commit();
                    try {
                        this.destDb.setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                try {
                    if (!this.destDb.getAutoCommit()) {
                        this.destDb.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void transferAlter() throws Exception {
        block23: {
            String Statement2 = new String("");
            if (this.destDb.helper.needTransferTransaction()) {
                try {
                    this.destDb.setAutoCommit(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.Stmts.bTransfer) {
                this.tracer.trace("Table " + this.Stmts.sSourceTable + " not transfered");
                return;
            }
            this.tracer.trace("Table " + this.Stmts.sSourceTable + ": start alter");
            try {
                int nextsemicolon;
                if (this.Stmts.bCreateIndex) {
                    if (this.Stmts.sDestCreateIndex.charAt(this.Stmts.sDestCreateIndex.length() - 1) != ';') {
                        this.Stmts.sDestCreateIndex = this.Stmts.sDestCreateIndex + ";";
                    }
                    int lastsemicolon = 0;
                    nextsemicolon = this.Stmts.sDestCreateIndex.indexOf(59);
                    while (nextsemicolon > lastsemicolon) {
                        Statement2 = this.Stmts.sDestCreateIndex.substring(lastsemicolon, nextsemicolon);
                        while (Statement2.charAt(Statement2.length() - 1) == ';') {
                            Statement2 = Statement2.substring(0, Statement2.length() - 1);
                        }
                        try {
                            this.tracer.trace("Executing " + this.Stmts.sDestCreateIndex);
                            this.destDb.execute(Statement2);
                        }
                        catch (Exception e) {
                            this.tracer.trace("Ignoring error " + e.getMessage());
                        }
                        lastsemicolon = nextsemicolon + 1;
                        nextsemicolon = lastsemicolon + this.Stmts.sDestCreateIndex.substring(lastsemicolon).indexOf(59);
                    }
                }
                if (!this.Stmts.bAlter) break block23;
                if (this.Stmts.sDestAlter.charAt(this.Stmts.sDestAlter.length() - 1) != ';') {
                    this.Stmts.sDestAlter = this.Stmts.sDestAlter + ";";
                }
                int lastsemicolon = 0;
                nextsemicolon = this.Stmts.sDestAlter.indexOf(59);
                while (nextsemicolon > lastsemicolon) {
                    Statement2 = this.Stmts.sDestAlter.substring(lastsemicolon, nextsemicolon);
                    while (Statement2.charAt(Statement2.length() - 1) == ';') {
                        Statement2 = Statement2.substring(0, Statement2.length() - 1);
                    }
                    try {
                        this.tracer.trace("Executing " + Statement2);
                        this.destDb.execute(Statement2);
                    }
                    catch (Exception e) {
                        this.tracer.trace("Ignoring error " + e.getMessage());
                    }
                    lastsemicolon = nextsemicolon + 1;
                    nextsemicolon = lastsemicolon + this.Stmts.sDestAlter.substring(lastsemicolon).indexOf(59);
                }
            }
            catch (Exception e) {
                try {
                    if (!this.destDb.getAutoCommit()) {
                        this.destDb.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (!this.destDb.getAutoCommit()) {
            this.destDb.commit();
            try {
                this.destDb.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initTypes() throws SQLException {
        if (this.hTypes != null) {
            return;
        }
        this.hTypes = this.destDb.helper.getSupportedTypes();
    }
}

