/*
 * Decompiled with CFR 0.152.
 */
package xsdvi.svg;

import xsdvi.svg.SvgForXsd;
import xsdvi.utils.TreeElement;

public abstract class AbstractSymbol
extends TreeElement {
    private SvgForXsd svg;
    protected int xPosition;
    protected int yPosition;
    protected int width;
    protected int height;
    private static int highestYPosition;
    public static final int PC_STRICT = 1;
    public static final int PC_SKIP = 2;
    public static final int PC_LAX = 3;
    public static final int X_INDENT = 45;
    public static final int Y_INDENT = 25;
    public static final int MIN_WIDTH = 60;
    public static final int MAX_HEIGHT = 46;
    public static final int MID_HEIGHT = 31;
    public static final int MIN_HEIGHT = 21;

    public int getXEnd() {
        return this.xPosition + this.width;
    }

    public int getYEnd() {
        return this.yPosition + 46;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public void setXPosition(int n) {
        this.xPosition = n;
    }

    public void setYPosition(int n) {
        this.yPosition = n;
    }

    public void setSvg(SvgForXsd svgForXsd) {
        this.svg = svgForXsd;
    }

    public SvgForXsd getSvg() {
        return this.svg;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    protected void print(String string) {
        this.svg.print(string);
    }

    protected void drawGStart() {
        this.print("<g id='" + this.code() + "' class='box' transform='translate(" + this.xPosition + "," + this.yPosition + ")'>");
    }

    protected void drawGEnd() {
        this.print("</g>\n");
    }

    protected void drawConnection() {
        if (this.isLastChild() && !this.isFirstChild()) {
            this.print("<line class='connection' id='p" + this.code() + "' x1='" + -35 + "' y1='" + (((AbstractSymbol)this.getParent()).yPosition - this.yPosition + 23) + "' x2='" + -35 + "' y2='" + -40 + "'/>");
            this.print("<path class='connection' d='M-35,-40 Q-35,15 0,23'/>");
        } else {
            this.print("<line class='connection' x1='-35' y1='23' x2='0' y2='23'/>");
        }
    }

    protected void drawUse() {
        if (this.hasChildren()) {
            String string = this.code();
            this.print("<use x='" + (this.width - 1) + "' y='" + 17 + "' xlink:href='#minus' id='s" + string + "' onclick='show(\"" + string + "\")'/>");
        }
    }

    protected void drawMouseover() {
        this.print("onmouseover='makeVisible(\"" + this.code() + "\")' onmouseout='makeHidden(\"" + this.code() + "\")'/>");
    }

    public void prepareBox() {
        if (this.hasParent()) {
            this.xPosition = ((AbstractSymbol)this.getParent()).getXEnd() + 45;
            this.yPosition = this.isFirstChild() ? highestYPosition : highestYPosition + 46 + 25;
        } else {
            this.xPosition = 20;
            this.yPosition = 50;
        }
        this.width = this.getWidth();
        this.height = this.getHeight();
        highestYPosition = this.yPosition;
    }

    public abstract void draw();

    public abstract int getWidth();

    public abstract int getHeight();
}

