# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: v2
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobTaskSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'reference': 'str',
        'partitions': 'int',
        'runtime': 'int',
        'task_distribution': 'str',
        'hyperthreading': 'bool'
    }

    attribute_map = {
        'reference': 'reference',
        'partitions': 'partitions',
        'runtime': 'runtime',
        'task_distribution': 'task_distribution',
        'hyperthreading': 'hyperthreading'
    }

    def __init__(self, reference=None, partitions=None, runtime=None, task_distribution=None, hyperthreading=True, local_vars_configuration=None):  # noqa: E501
        """JobTaskSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._reference = None
        self._partitions = None
        self._runtime = None
        self._task_distribution = None
        self._hyperthreading = None
        self.discriminator = None

        self.reference = reference
        self.partitions = partitions
        self.runtime = runtime
        self.task_distribution = task_distribution
        if hyperthreading is not None:
            self.hyperthreading = hyperthreading

    @property
    def reference(self):
        """Gets the reference of this JobTaskSpec.  # noqa: E501

        A reference to help you identify this task  # noqa: E501

        :return: The reference of this JobTaskSpec.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this JobTaskSpec.

        A reference to help you identify this task  # noqa: E501

        :param reference: The reference of this JobTaskSpec.  # noqa: E501
        :type reference: str
        """
        if self.local_vars_configuration.client_side_validation and reference is None:  # noqa: E501
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                reference is not None and len(reference) > 25):
            raise ValueError("Invalid value for `reference`, length must be less than or equal to `25`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                reference is not None and len(reference) < 1):
            raise ValueError("Invalid value for `reference`, length must be greater than or equal to `1`")  # noqa: E501

        self._reference = reference

    @property
    def partitions(self):
        """Gets the partitions of this JobTaskSpec.  # noqa: E501

        How many partitions/tasks will this task be submitted as.  # noqa: E501

        :return: The partitions of this JobTaskSpec.  # noqa: E501
        :rtype: int
        """
        return self._partitions

    @partitions.setter
    def partitions(self, partitions):
        """Sets the partitions of this JobTaskSpec.

        How many partitions/tasks will this task be submitted as.  # noqa: E501

        :param partitions: The partitions of this JobTaskSpec.  # noqa: E501
        :type partitions: int
        """
        if self.local_vars_configuration.client_side_validation and partitions is None:  # noqa: E501
            raise ValueError("Invalid value for `partitions`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                partitions is not None and partitions < 1):  # noqa: E501
            raise ValueError("Invalid value for `partitions`, must be a value greater than or equal to `1`")  # noqa: E501

        self._partitions = partitions

    @property
    def runtime(self):
        """Gets the runtime of this JobTaskSpec.  # noqa: E501

        Maximum runtime for this task in whole hours.  # noqa: E501

        :return: The runtime of this JobTaskSpec.  # noqa: E501
        :rtype: int
        """
        return self._runtime

    @runtime.setter
    def runtime(self, runtime):
        """Sets the runtime of this JobTaskSpec.

        Maximum runtime for this task in whole hours.  # noqa: E501

        :param runtime: The runtime of this JobTaskSpec.  # noqa: E501
        :type runtime: int
        """
        if self.local_vars_configuration.client_side_validation and runtime is None:  # noqa: E501
            raise ValueError("Invalid value for `runtime`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                runtime is not None and runtime < 1):  # noqa: E501
            raise ValueError("Invalid value for `runtime`, must be a value greater than or equal to `1`")  # noqa: E501

        self._runtime = runtime

    @property
    def task_distribution(self):
        """Gets the task_distribution of this JobTaskSpec.  # noqa: E501

        How should the partitions be distributed on the HPC cluster  # noqa: E501

        :return: The task_distribution of this JobTaskSpec.  # noqa: E501
        :rtype: str
        """
        return self._task_distribution

    @task_distribution.setter
    def task_distribution(self, task_distribution):
        """Sets the task_distribution of this JobTaskSpec.

        How should the partitions be distributed on the HPC cluster  # noqa: E501

        :param task_distribution: The task_distribution of this JobTaskSpec.  # noqa: E501
        :type task_distribution: str
        """
        if self.local_vars_configuration.client_side_validation and task_distribution is None:  # noqa: E501
            raise ValueError("Invalid value for `task_distribution`, must not be `None`")  # noqa: E501
        allowed_values = ["core", "socket", "node", "device"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and task_distribution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `task_distribution` ({0}), must be one of {1}"  # noqa: E501
                .format(task_distribution, allowed_values)
            )

        self._task_distribution = task_distribution

    @property
    def hyperthreading(self):
        """Gets the hyperthreading of this JobTaskSpec.  # noqa: E501

        Make use of hyperthreaded core where available  # noqa: E501

        :return: The hyperthreading of this JobTaskSpec.  # noqa: E501
        :rtype: bool
        """
        return self._hyperthreading

    @hyperthreading.setter
    def hyperthreading(self, hyperthreading):
        """Sets the hyperthreading of this JobTaskSpec.

        Make use of hyperthreaded core where available  # noqa: E501

        :param hyperthreading: The hyperthreading of this JobTaskSpec.  # noqa: E501
        :type hyperthreading: bool
        """

        self._hyperthreading = hyperthreading

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobTaskSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobTaskSpec):
            return True

        return self.to_dict() != other.to_dict()
