# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_path.ipynb.

# %% auto 0
__all__ = ['pathchain', 'try2path', 'path2str', 'aspath']

# %% ../nbs/10_path.ipynb 6
import os
from functools import wraps

try: from pathlib import Path
except: ...

# %% ../nbs/10_path.ipynb 8
from typing import TypeGuard

# %% ../nbs/10_path.ipynb 10
#| export


# %% ../nbs/10_path.ipynb 12
from nchr import DOT
from nlit import __DOC__, __NAME__, __MODULE__, __ANNOTATIONS__
from nlit import (PATH, PBCOPY, CLIP, ECHO, POSIX, NT, __FSPATH__, )
from quac import plibpath, pathlike, boolq
from chck import isfile, isdir, isnone, ispath, ispathlike
from sigr import applyfns

# %% ../nbs/10_path.ipynb 14
from .atyp import P

# %% ../nbs/10_path.ipynb 17
def pathchain(x, funcs, *args: P.args, **kwargs: P.kwargs): 
    '''Applies a sequence of functions (`funcs`) to an initial value `x`, 
    optionally stopping when the typeguard function `isarng` returns `True`.
    
    See Also
    --------
    sigr.applyfns
    ''' 
    return applyfns(x, funcs, *args, check=ispathlike, **kwargs)

# %% ../nbs/10_path.ipynb 20
def try2path(a) -> plibpath:
    '''Attempts to convert `a` to a numpy array representing an arithmetic range starting at 0.
    
    Parameters
    ----------
    a : Any
        The input object to convert.
        
    Returns
    -------
    np.array
        An arithmetic range numpy array if possible, otherwise `a` itself.
    '''
    if ispath(a): return a
    try: return Path(a)
    except: return a

# %% ../nbs/10_path.ipynb 22
def path2str(path: pathlike, failsafe: boolq = True) -> str:
    if issubclass(type(path), os.PathLike): return str(path.__fspath__())
    elif hasattr(path, __FSPATH__):         return str(path.__fspath__())
    elif hasattr(path, PATH):               return path2str(path.path)
    elif isinstance(path, str):             return path
    elif failsafe:                          return DOT
    else: raise ValueError(f'path2str: path {path} not recognized')

# %% ../nbs/10_path.ipynb 24
def aspath(path) -> Path:
    return Path(path2str(path))

def aspath(a, *args: P.args, **kwargs: P.kwargs) -> Path:
    if ispath(a): return a
    return Path(pathchain(a, (path2str, ), *args, **kwargs))

# %% ../nbs/10_path.ipynb 26
#| export

