/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#api_management_name ApiManagementBackend#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#description ApiManagementBackend#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#id ApiManagementBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#name ApiManagementBackend#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#protocol ApiManagementBackend#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#resource_group_name ApiManagementBackend#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#resource_id ApiManagementBackend#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#title ApiManagementBackend#title}
    */
    readonly title?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#url ApiManagementBackend#url}
    */
    readonly url: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#credentials ApiManagementBackend#credentials}
    */
    readonly credentials?: ApiManagementBackendCredentials;
    /**
    * proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#proxy ApiManagementBackend#proxy}
    */
    readonly proxy?: ApiManagementBackendProxy;
    /**
    * service_fabric_cluster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#service_fabric_cluster ApiManagementBackend#service_fabric_cluster}
    */
    readonly serviceFabricCluster?: ApiManagementBackendServiceFabricCluster;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#timeouts ApiManagementBackend#timeouts}
    */
    readonly timeouts?: ApiManagementBackendTimeouts;
    /**
    * tls block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#tls ApiManagementBackend#tls}
    */
    readonly tls?: ApiManagementBackendTls;
}
export interface ApiManagementBackendCredentialsAuthorization {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#parameter ApiManagementBackend#parameter}
    */
    readonly parameter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#scheme ApiManagementBackend#scheme}
    */
    readonly scheme?: string;
}
export declare function apiManagementBackendCredentialsAuthorizationToTerraform(struct?: ApiManagementBackendCredentialsAuthorizationOutputReference | ApiManagementBackendCredentialsAuthorization): any;
export declare class ApiManagementBackendCredentialsAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendCredentialsAuthorization | undefined;
    set internalValue(value: ApiManagementBackendCredentialsAuthorization | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _scheme?;
    get scheme(): string;
    set scheme(value: string);
    resetScheme(): void;
    get schemeInput(): string | undefined;
}
export interface ApiManagementBackendCredentials {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#certificate ApiManagementBackend#certificate}
    */
    readonly certificate?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#header ApiManagementBackend#header}
    */
    readonly header?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#query ApiManagementBackend#query}
    */
    readonly query?: {
        [key: string]: string;
    };
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#authorization ApiManagementBackend#authorization}
    */
    readonly authorization?: ApiManagementBackendCredentialsAuthorization;
}
export declare function apiManagementBackendCredentialsToTerraform(struct?: ApiManagementBackendCredentialsOutputReference | ApiManagementBackendCredentials): any;
export declare class ApiManagementBackendCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendCredentials | undefined;
    set internalValue(value: ApiManagementBackendCredentials | undefined);
    private _certificate?;
    get certificate(): string[];
    set certificate(value: string[]);
    resetCertificate(): void;
    get certificateInput(): string[] | undefined;
    private _header?;
    get header(): {
        [key: string]: string;
    };
    set header(value: {
        [key: string]: string;
    });
    resetHeader(): void;
    get headerInput(): {
        [key: string]: string;
    } | undefined;
    private _query?;
    get query(): {
        [key: string]: string;
    };
    set query(value: {
        [key: string]: string;
    });
    resetQuery(): void;
    get queryInput(): {
        [key: string]: string;
    } | undefined;
    private _authorization;
    get authorization(): ApiManagementBackendCredentialsAuthorizationOutputReference;
    putAuthorization(value: ApiManagementBackendCredentialsAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): ApiManagementBackendCredentialsAuthorization | undefined;
}
export interface ApiManagementBackendProxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#password ApiManagementBackend#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#url ApiManagementBackend#url}
    */
    readonly url: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#username ApiManagementBackend#username}
    */
    readonly username: string;
}
export declare function apiManagementBackendProxyToTerraform(struct?: ApiManagementBackendProxyOutputReference | ApiManagementBackendProxy): any;
export declare class ApiManagementBackendProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendProxy | undefined;
    set internalValue(value: ApiManagementBackendProxy | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface ApiManagementBackendServiceFabricClusterServerX509Name {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#issuer_certificate_thumbprint ApiManagementBackend#issuer_certificate_thumbprint}
    */
    readonly issuerCertificateThumbprint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#name ApiManagementBackend#name}
    */
    readonly name: string;
}
export declare function apiManagementBackendServiceFabricClusterServerX509NameToTerraform(struct?: ApiManagementBackendServiceFabricClusterServerX509Name | cdktf.IResolvable): any;
export declare class ApiManagementBackendServiceFabricClusterServerX509NameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementBackendServiceFabricClusterServerX509Name | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementBackendServiceFabricClusterServerX509Name | cdktf.IResolvable | undefined);
    private _issuerCertificateThumbprint?;
    get issuerCertificateThumbprint(): string;
    set issuerCertificateThumbprint(value: string);
    get issuerCertificateThumbprintInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class ApiManagementBackendServiceFabricClusterServerX509NameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementBackendServiceFabricClusterServerX509NameOutputReference;
}
export interface ApiManagementBackendServiceFabricCluster {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#client_certificate_id ApiManagementBackend#client_certificate_id}
    */
    readonly clientCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#client_certificate_thumbprint ApiManagementBackend#client_certificate_thumbprint}
    */
    readonly clientCertificateThumbprint?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#management_endpoints ApiManagementBackend#management_endpoints}
    */
    readonly managementEndpoints: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#max_partition_resolution_retries ApiManagementBackend#max_partition_resolution_retries}
    */
    readonly maxPartitionResolutionRetries: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#server_certificate_thumbprints ApiManagementBackend#server_certificate_thumbprints}
    */
    readonly serverCertificateThumbprints?: string[];
    /**
    * server_x509_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#server_x509_name ApiManagementBackend#server_x509_name}
    */
    readonly serverX509Name?: ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable;
}
export declare function apiManagementBackendServiceFabricClusterToTerraform(struct?: ApiManagementBackendServiceFabricClusterOutputReference | ApiManagementBackendServiceFabricCluster): any;
export declare class ApiManagementBackendServiceFabricClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendServiceFabricCluster | undefined;
    set internalValue(value: ApiManagementBackendServiceFabricCluster | undefined);
    private _clientCertificateId?;
    get clientCertificateId(): string;
    set clientCertificateId(value: string);
    resetClientCertificateId(): void;
    get clientCertificateIdInput(): string | undefined;
    private _clientCertificateThumbprint?;
    get clientCertificateThumbprint(): string;
    set clientCertificateThumbprint(value: string);
    resetClientCertificateThumbprint(): void;
    get clientCertificateThumbprintInput(): string | undefined;
    private _managementEndpoints?;
    get managementEndpoints(): string[];
    set managementEndpoints(value: string[]);
    get managementEndpointsInput(): string[] | undefined;
    private _maxPartitionResolutionRetries?;
    get maxPartitionResolutionRetries(): number;
    set maxPartitionResolutionRetries(value: number);
    get maxPartitionResolutionRetriesInput(): number | undefined;
    private _serverCertificateThumbprints?;
    get serverCertificateThumbprints(): string[];
    set serverCertificateThumbprints(value: string[]);
    resetServerCertificateThumbprints(): void;
    get serverCertificateThumbprintsInput(): string[] | undefined;
    private _serverX509Name;
    get serverX509Name(): ApiManagementBackendServiceFabricClusterServerX509NameList;
    putServerX509Name(value: ApiManagementBackendServiceFabricClusterServerX509Name[] | cdktf.IResolvable): void;
    resetServerX509Name(): void;
    get serverX509NameInput(): cdktf.IResolvable | ApiManagementBackendServiceFabricClusterServerX509Name[] | undefined;
}
export interface ApiManagementBackendTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#create ApiManagementBackend#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#delete ApiManagementBackend#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#read ApiManagementBackend#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#update ApiManagementBackend#update}
    */
    readonly update?: string;
}
export declare function apiManagementBackendTimeoutsToTerraform(struct?: ApiManagementBackendTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementBackendTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementBackendTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApiManagementBackendTls {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#validate_certificate_chain ApiManagementBackend#validate_certificate_chain}
    */
    readonly validateCertificateChain?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend#validate_certificate_name ApiManagementBackend#validate_certificate_name}
    */
    readonly validateCertificateName?: boolean | cdktf.IResolvable;
}
export declare function apiManagementBackendTlsToTerraform(struct?: ApiManagementBackendTlsOutputReference | ApiManagementBackendTls): any;
export declare class ApiManagementBackendTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementBackendTls | undefined;
    set internalValue(value: ApiManagementBackendTls | undefined);
    private _validateCertificateChain?;
    get validateCertificateChain(): boolean | cdktf.IResolvable;
    set validateCertificateChain(value: boolean | cdktf.IResolvable);
    resetValidateCertificateChain(): void;
    get validateCertificateChainInput(): boolean | cdktf.IResolvable | undefined;
    private _validateCertificateName?;
    get validateCertificateName(): boolean | cdktf.IResolvable;
    set validateCertificateName(value: boolean | cdktf.IResolvable);
    resetValidateCertificateName(): void;
    get validateCertificateNameInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend azurerm_api_management_backend}
*/
export declare class ApiManagementBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_backend";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_backend azurerm_api_management_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementBackendConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementBackendConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _credentials;
    get credentials(): ApiManagementBackendCredentialsOutputReference;
    putCredentials(value: ApiManagementBackendCredentials): void;
    resetCredentials(): void;
    get credentialsInput(): ApiManagementBackendCredentials | undefined;
    private _proxy;
    get proxy(): ApiManagementBackendProxyOutputReference;
    putProxy(value: ApiManagementBackendProxy): void;
    resetProxy(): void;
    get proxyInput(): ApiManagementBackendProxy | undefined;
    private _serviceFabricCluster;
    get serviceFabricCluster(): ApiManagementBackendServiceFabricClusterOutputReference;
    putServiceFabricCluster(value: ApiManagementBackendServiceFabricCluster): void;
    resetServiceFabricCluster(): void;
    get serviceFabricClusterInput(): ApiManagementBackendServiceFabricCluster | undefined;
    private _timeouts;
    get timeouts(): ApiManagementBackendTimeoutsOutputReference;
    putTimeouts(value: ApiManagementBackendTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementBackendTimeouts | undefined;
    private _tls;
    get tls(): ApiManagementBackendTlsOutputReference;
    putTls(value: ApiManagementBackendTls): void;
    resetTls(): void;
    get tlsInput(): ApiManagementBackendTls | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
