/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementLoggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#api_management_name ApiManagementLogger#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#buffered ApiManagementLogger#buffered}
    */
    readonly buffered?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#description ApiManagementLogger#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#id ApiManagementLogger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#name ApiManagementLogger#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#resource_group_name ApiManagementLogger#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#resource_id ApiManagementLogger#resource_id}
    */
    readonly resourceId?: string;
    /**
    * application_insights block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#application_insights ApiManagementLogger#application_insights}
    */
    readonly applicationInsights?: ApiManagementLoggerApplicationInsights;
    /**
    * eventhub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#eventhub ApiManagementLogger#eventhub}
    */
    readonly eventhub?: ApiManagementLoggerEventhub;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#timeouts ApiManagementLogger#timeouts}
    */
    readonly timeouts?: ApiManagementLoggerTimeouts;
}
export interface ApiManagementLoggerApplicationInsights {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#instrumentation_key ApiManagementLogger#instrumentation_key}
    */
    readonly instrumentationKey: string;
}
export declare function apiManagementLoggerApplicationInsightsToTerraform(struct?: ApiManagementLoggerApplicationInsightsOutputReference | ApiManagementLoggerApplicationInsights): any;
export declare class ApiManagementLoggerApplicationInsightsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementLoggerApplicationInsights | undefined;
    set internalValue(value: ApiManagementLoggerApplicationInsights | undefined);
    private _instrumentationKey?;
    get instrumentationKey(): string;
    set instrumentationKey(value: string);
    get instrumentationKeyInput(): string | undefined;
}
export interface ApiManagementLoggerEventhub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#connection_string ApiManagementLogger#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#name ApiManagementLogger#name}
    */
    readonly name: string;
}
export declare function apiManagementLoggerEventhubToTerraform(struct?: ApiManagementLoggerEventhubOutputReference | ApiManagementLoggerEventhub): any;
export declare class ApiManagementLoggerEventhubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementLoggerEventhub | undefined;
    set internalValue(value: ApiManagementLoggerEventhub | undefined);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ApiManagementLoggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#create ApiManagementLogger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#delete ApiManagementLogger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#read ApiManagementLogger#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger#update ApiManagementLogger#update}
    */
    readonly update?: string;
}
export declare function apiManagementLoggerTimeoutsToTerraform(struct?: ApiManagementLoggerTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementLoggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementLoggerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementLoggerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger azurerm_api_management_logger}
*/
export declare class ApiManagementLogger extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_logger";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/api_management_logger azurerm_api_management_logger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementLoggerConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementLoggerConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _buffered?;
    get buffered(): boolean | cdktf.IResolvable;
    set buffered(value: boolean | cdktf.IResolvable);
    resetBuffered(): void;
    get bufferedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _applicationInsights;
    get applicationInsights(): ApiManagementLoggerApplicationInsightsOutputReference;
    putApplicationInsights(value: ApiManagementLoggerApplicationInsights): void;
    resetApplicationInsights(): void;
    get applicationInsightsInput(): ApiManagementLoggerApplicationInsights | undefined;
    private _eventhub;
    get eventhub(): ApiManagementLoggerEventhubOutputReference;
    putEventhub(value: ApiManagementLoggerEventhub): void;
    resetEventhub(): void;
    get eventhubInput(): ApiManagementLoggerEventhub | undefined;
    private _timeouts;
    get timeouts(): ApiManagementLoggerTimeoutsOutputReference;
    putTimeouts(value: ApiManagementLoggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementLoggerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
