/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AvailabilitySetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#id AvailabilitySet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#location AvailabilitySet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#managed AvailabilitySet#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#name AvailabilitySet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#platform_fault_domain_count AvailabilitySet#platform_fault_domain_count}
    */
    readonly platformFaultDomainCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#platform_update_domain_count AvailabilitySet#platform_update_domain_count}
    */
    readonly platformUpdateDomainCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#proximity_placement_group_id AvailabilitySet#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#resource_group_name AvailabilitySet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#tags AvailabilitySet#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#timeouts AvailabilitySet#timeouts}
    */
    readonly timeouts?: AvailabilitySetTimeouts;
}
export interface AvailabilitySetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#create AvailabilitySet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#delete AvailabilitySet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#read AvailabilitySet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set#update AvailabilitySet#update}
    */
    readonly update?: string;
}
export declare function availabilitySetTimeoutsToTerraform(struct?: AvailabilitySetTimeouts | cdktf.IResolvable): any;
export declare class AvailabilitySetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AvailabilitySetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AvailabilitySetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set azurerm_availability_set}
*/
export declare class AvailabilitySet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_availability_set";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/availability_set azurerm_availability_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AvailabilitySetConfig
    */
    constructor(scope: Construct, id: string, config: AvailabilitySetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platformFaultDomainCount?;
    get platformFaultDomainCount(): number;
    set platformFaultDomainCount(value: number);
    resetPlatformFaultDomainCount(): void;
    get platformFaultDomainCountInput(): number | undefined;
    private _platformUpdateDomainCount?;
    get platformUpdateDomainCount(): number;
    set platformUpdateDomainCount(value: number);
    resetPlatformUpdateDomainCount(): void;
    get platformUpdateDomainCountInput(): number | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): AvailabilitySetTimeoutsOutputReference;
    putTimeouts(value: AvailabilitySetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AvailabilitySetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
