/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the Container App Environment to host this Container App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#container_app_environment_id ContainerApp#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#id ContainerApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for this Container App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#resource_group_name ContainerApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#revision_mode ContainerApp#revision_mode}
    */
    readonly revisionMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#tags ContainerApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * dapr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#dapr ContainerApp#dapr}
    */
    readonly dapr?: ContainerAppDapr;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#identity ContainerApp#identity}
    */
    readonly identity?: ContainerAppIdentity;
    /**
    * ingress block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#ingress ContainerApp#ingress}
    */
    readonly ingress?: ContainerAppIngress;
    /**
    * registry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#registry ContainerApp#registry}
    */
    readonly registry?: ContainerAppRegistry[] | cdktf.IResolvable;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#secret ContainerApp#secret}
    */
    readonly secret?: ContainerAppSecret[] | cdktf.IResolvable;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#template ContainerApp#template}
    */
    readonly template: ContainerAppTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#timeouts ContainerApp#timeouts}
    */
    readonly timeouts?: ContainerAppTimeouts;
}
export interface ContainerAppDapr {
    /**
    * The Dapr Application Identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#app_id ContainerApp#app_id}
    */
    readonly appId: string;
    /**
    * The port which the application is listening on. This is the same as the `ingress` port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#app_port ContainerApp#app_port}
    */
    readonly appPort?: number;
    /**
    * The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#app_protocol ContainerApp#app_protocol}
    */
    readonly appProtocol?: string;
}
export declare function containerAppDaprToTerraform(struct?: ContainerAppDaprOutputReference | ContainerAppDapr): any;
export declare class ContainerAppDaprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppDapr | undefined;
    set internalValue(value: ContainerAppDapr | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appPort?;
    get appPort(): number;
    set appPort(value: number);
    resetAppPort(): void;
    get appPortInput(): number | undefined;
    private _appProtocol?;
    get appProtocol(): string;
    set appProtocol(value: string);
    resetAppProtocol(): void;
    get appProtocolInput(): string | undefined;
}
export interface ContainerAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#identity_ids ContainerApp#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#type ContainerApp#type}
    */
    readonly type: string;
}
export declare function containerAppIdentityToTerraform(struct?: ContainerAppIdentityOutputReference | ContainerAppIdentity): any;
export declare class ContainerAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppIdentity | undefined;
    set internalValue(value: ContainerAppIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ContainerAppIngressCustomDomain {
    /**
    * The Binding type. Possible values include `Disabled` and `SniEnabled`. Defaults to `Disabled`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#certificate_binding_type ContainerApp#certificate_binding_type}
    */
    readonly certificateBindingType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#certificate_id ContainerApp#certificate_id}
    */
    readonly certificateId: string;
    /**
    * The hostname of the Certificate. Must be the CN or a named SAN in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
}
export declare function containerAppIngressCustomDomainToTerraform(struct?: ContainerAppIngressCustomDomainOutputReference | ContainerAppIngressCustomDomain): any;
export declare class ContainerAppIngressCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppIngressCustomDomain | undefined;
    set internalValue(value: ContainerAppIngressCustomDomain | undefined);
    private _certificateBindingType?;
    get certificateBindingType(): string;
    set certificateBindingType(value: string);
    resetCertificateBindingType(): void;
    get certificateBindingTypeInput(): string | undefined;
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    get certificateIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ContainerAppIngressTrafficWeight {
    /**
    * The label to apply to the revision as a name prefix for routing traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#label ContainerApp#label}
    */
    readonly label?: string;
    /**
    * This traffic Weight relates to the latest stable Container Revision.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#latest_revision ContainerApp#latest_revision}
    */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
    * The percentage of traffic to send to this revision.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#percentage ContainerApp#percentage}
    */
    readonly percentage: number;
    /**
    * The suffix string to append to the revision. This must be unique for the Container App's lifetime. A default hash created by the service will be used if this value is omitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#revision_suffix ContainerApp#revision_suffix}
    */
    readonly revisionSuffix?: string;
}
export declare function containerAppIngressTrafficWeightToTerraform(struct?: ContainerAppIngressTrafficWeight | cdktf.IResolvable): any;
export declare class ContainerAppIngressTrafficWeightOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppIngressTrafficWeight | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppIngressTrafficWeight | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _latestRevision?;
    get latestRevision(): boolean | cdktf.IResolvable;
    set latestRevision(value: boolean | cdktf.IResolvable);
    resetLatestRevision(): void;
    get latestRevisionInput(): boolean | cdktf.IResolvable | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _revisionSuffix?;
    get revisionSuffix(): string;
    set revisionSuffix(value: string);
    resetRevisionSuffix(): void;
    get revisionSuffixInput(): string | undefined;
}
export declare class ContainerAppIngressTrafficWeightList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppIngressTrafficWeight[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppIngressTrafficWeightOutputReference;
}
export interface ContainerAppIngress {
    /**
    * Should this ingress allow insecure connections?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#allow_insecure_connections ContainerApp#allow_insecure_connections}
    */
    readonly allowInsecureConnections?: boolean | cdktf.IResolvable;
    /**
    * Is this an external Ingress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#external_enabled ContainerApp#external_enabled}
    */
    readonly externalEnabled?: boolean | cdktf.IResolvable;
    /**
    * The target port on the container for the Ingress traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#target_port ContainerApp#target_port}
    */
    readonly targetPort: number;
    /**
    * The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#transport ContainerApp#transport}
    */
    readonly transport?: string;
    /**
    * custom_domain block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#custom_domain ContainerApp#custom_domain}
    */
    readonly customDomain?: ContainerAppIngressCustomDomain;
    /**
    * traffic_weight block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#traffic_weight ContainerApp#traffic_weight}
    */
    readonly trafficWeight: ContainerAppIngressTrafficWeight[] | cdktf.IResolvable;
}
export declare function containerAppIngressToTerraform(struct?: ContainerAppIngressOutputReference | ContainerAppIngress): any;
export declare class ContainerAppIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppIngress | undefined;
    set internalValue(value: ContainerAppIngress | undefined);
    private _allowInsecureConnections?;
    get allowInsecureConnections(): boolean | cdktf.IResolvable;
    set allowInsecureConnections(value: boolean | cdktf.IResolvable);
    resetAllowInsecureConnections(): void;
    get allowInsecureConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _externalEnabled?;
    get externalEnabled(): boolean | cdktf.IResolvable;
    set externalEnabled(value: boolean | cdktf.IResolvable);
    resetExternalEnabled(): void;
    get externalEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get fqdn(): string;
    private _targetPort?;
    get targetPort(): number;
    set targetPort(value: number);
    get targetPortInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    resetTransport(): void;
    get transportInput(): string | undefined;
    private _customDomain;
    get customDomain(): ContainerAppIngressCustomDomainOutputReference;
    putCustomDomain(value: ContainerAppIngressCustomDomain): void;
    resetCustomDomain(): void;
    get customDomainInput(): ContainerAppIngressCustomDomain | undefined;
    private _trafficWeight;
    get trafficWeight(): ContainerAppIngressTrafficWeightList;
    putTrafficWeight(value: ContainerAppIngressTrafficWeight[] | cdktf.IResolvable): void;
    get trafficWeightInput(): cdktf.IResolvable | ContainerAppIngressTrafficWeight[] | undefined;
}
export interface ContainerAppRegistry {
    /**
    * ID of the System or User Managed Identity used to pull images from the Container Registry
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#identity ContainerApp#identity}
    */
    readonly identity?: string;
    /**
    * The name of the Secret Reference containing the password value for this user on the Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#password_secret_name ContainerApp#password_secret_name}
    */
    readonly passwordSecretName?: string;
    /**
    * The hostname for the Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#server ContainerApp#server}
    */
    readonly server: string;
    /**
    * The username to use for this Container Registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#username ContainerApp#username}
    */
    readonly username?: string;
}
export declare function containerAppRegistryToTerraform(struct?: ContainerAppRegistry | cdktf.IResolvable): any;
export declare class ContainerAppRegistryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppRegistry | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppRegistry | cdktf.IResolvable | undefined);
    private _identity?;
    get identity(): string;
    set identity(value: string);
    resetIdentity(): void;
    get identityInput(): string | undefined;
    private _passwordSecretName?;
    get passwordSecretName(): string;
    set passwordSecretName(value: string);
    resetPasswordSecretName(): void;
    get passwordSecretNameInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class ContainerAppRegistryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppRegistry[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppRegistryOutputReference;
}
export interface ContainerAppSecret {
    /**
    * The Secret name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The value for this secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#value ContainerApp#value}
    */
    readonly value: string;
}
export declare function containerAppSecretToTerraform(struct?: ContainerAppSecret | cdktf.IResolvable): any;
export declare class ContainerAppSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppSecret | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppSecretOutputReference;
}
export interface ContainerAppTemplateContainerEnv {
    /**
    * The name of the environment variable for the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The name of the secret that contains the value for this environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#secret_name ContainerApp#secret_name}
    */
    readonly secretName?: string;
    /**
    * The value for this environment variable. **NOTE:** This value is ignored if `secret_name` is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#value ContainerApp#value}
    */
    readonly value?: string;
}
export declare function containerAppTemplateContainerEnvToTerraform(struct?: ContainerAppTemplateContainerEnv | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerEnv | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ContainerAppTemplateContainerEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerEnvOutputReference;
}
export interface ContainerAppTemplateContainerLivenessProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#value ContainerApp#value}
    */
    readonly value: string;
}
export declare function containerAppTemplateContainerLivenessProbeHeaderToTerraform(struct?: ContainerAppTemplateContainerLivenessProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerLivenessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerLivenessProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerLivenessProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppTemplateContainerLivenessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerLivenessProbeHeaderOutputReference;
}
export interface ContainerAppTemplateContainerLivenessProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#failure_count_threshold ContainerApp#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#host ContainerApp#host}
    */
    readonly host?: string;
    /**
    * The time in seconds to wait after the container has started before the probe is started.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#initial_delay ContainerApp#initial_delay}
    */
    readonly initialDelay?: number;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#interval_seconds ContainerApp#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#path ContainerApp#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#port ContainerApp#port}
    */
    readonly port: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#timeout ContainerApp#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#transport ContainerApp#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#header ContainerApp#header}
    */
    readonly header?: ContainerAppTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppTemplateContainerLivenessProbeToTerraform(struct?: ContainerAppTemplateContainerLivenessProbe | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerLivenessProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerLivenessProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): number;
    set initialDelay(value: number);
    resetInitialDelay(): void;
    get initialDelayInput(): number | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get terminationGracePeriodSeconds(): number;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppTemplateContainerLivenessProbeHeaderList;
    putHeader(value: ContainerAppTemplateContainerLivenessProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppTemplateContainerLivenessProbeHeader[] | undefined;
}
export declare class ContainerAppTemplateContainerLivenessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerLivenessProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerLivenessProbeOutputReference;
}
export interface ContainerAppTemplateContainerReadinessProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#value ContainerApp#value}
    */
    readonly value: string;
}
export declare function containerAppTemplateContainerReadinessProbeHeaderToTerraform(struct?: ContainerAppTemplateContainerReadinessProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerReadinessProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerReadinessProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerReadinessProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppTemplateContainerReadinessProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerReadinessProbeHeaderOutputReference;
}
export interface ContainerAppTemplateContainerReadinessProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#failure_count_threshold ContainerApp#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#host ContainerApp#host}
    */
    readonly host?: string;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#interval_seconds ContainerApp#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#path ContainerApp#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#port ContainerApp#port}
    */
    readonly port: number;
    /**
    * The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#success_count_threshold ContainerApp#success_count_threshold}
    */
    readonly successCountThreshold?: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#timeout ContainerApp#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#transport ContainerApp#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#header ContainerApp#header}
    */
    readonly header?: ContainerAppTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppTemplateContainerReadinessProbeToTerraform(struct?: ContainerAppTemplateContainerReadinessProbe | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerReadinessProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerReadinessProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _successCountThreshold?;
    get successCountThreshold(): number;
    set successCountThreshold(value: number);
    resetSuccessCountThreshold(): void;
    get successCountThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppTemplateContainerReadinessProbeHeaderList;
    putHeader(value: ContainerAppTemplateContainerReadinessProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppTemplateContainerReadinessProbeHeader[] | undefined;
}
export declare class ContainerAppTemplateContainerReadinessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerReadinessProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerReadinessProbeOutputReference;
}
export interface ContainerAppTemplateContainerStartupProbeHeader {
    /**
    * The HTTP Header Name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The HTTP Header value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#value ContainerApp#value}
    */
    readonly value: string;
}
export declare function containerAppTemplateContainerStartupProbeHeaderToTerraform(struct?: ContainerAppTemplateContainerStartupProbeHeader | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerStartupProbeHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerStartupProbeHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerStartupProbeHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAppTemplateContainerStartupProbeHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerStartupProbeHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerStartupProbeHeaderOutputReference;
}
export interface ContainerAppTemplateContainerStartupProbe {
    /**
    * The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#failure_count_threshold ContainerApp#failure_count_threshold}
    */
    readonly failureCountThreshold?: number;
    /**
    * The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `http` and `https` type probes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#host ContainerApp#host}
    */
    readonly host?: string;
    /**
    * How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#interval_seconds ContainerApp#interval_seconds}
    */
    readonly intervalSeconds?: number;
    /**
    * The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#path ContainerApp#path}
    */
    readonly path?: string;
    /**
    * The port number on which to connect. Possible values are between `1` and `65535`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#port ContainerApp#port}
    */
    readonly port: number;
    /**
    * Time in seconds after which the probe times out. Possible values are between `1` an `240`. Defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#timeout ContainerApp#timeout}
    */
    readonly timeout?: number;
    /**
    * Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#transport ContainerApp#transport}
    */
    readonly transport: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#header ContainerApp#header}
    */
    readonly header?: ContainerAppTemplateContainerStartupProbeHeader[] | cdktf.IResolvable;
}
export declare function containerAppTemplateContainerStartupProbeToTerraform(struct?: ContainerAppTemplateContainerStartupProbe | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerStartupProbe | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerStartupProbe | cdktf.IResolvable | undefined);
    private _failureCountThreshold?;
    get failureCountThreshold(): number;
    set failureCountThreshold(value: number);
    resetFailureCountThreshold(): void;
    get failureCountThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    resetIntervalSeconds(): void;
    get intervalSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get terminationGracePeriodSeconds(): number;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _transport?;
    get transport(): string;
    set transport(value: string);
    get transportInput(): string | undefined;
    private _header;
    get header(): ContainerAppTemplateContainerStartupProbeHeaderList;
    putHeader(value: ContainerAppTemplateContainerStartupProbeHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ContainerAppTemplateContainerStartupProbeHeader[] | undefined;
}
export declare class ContainerAppTemplateContainerStartupProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerStartupProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerStartupProbeOutputReference;
}
export interface ContainerAppTemplateContainerVolumeMounts {
    /**
    * The name of the Volume to be mounted in the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The path in the container at which to mount this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#path ContainerApp#path}
    */
    readonly path: string;
}
export declare function containerAppTemplateContainerVolumeMountsToTerraform(struct?: ContainerAppTemplateContainerVolumeMounts | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainerVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainerVolumeMounts | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class ContainerAppTemplateContainerVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainerVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerVolumeMountsOutputReference;
}
export interface ContainerAppTemplateContainer {
    /**
    * A list of args to pass to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#args ContainerApp#args}
    */
    readonly args?: string[];
    /**
    * A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#command ContainerApp#command}
    */
    readonly command?: string[];
    /**
    * The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#cpu ContainerApp#cpu}
    */
    readonly cpu: number;
    /**
    * The image to use to create the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#image ContainerApp#image}
    */
    readonly image: string;
    /**
    * The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1.0Gi`, `1.5Gi`, `2.0Gi`, `2.5Gi`, `3.0Gi`, `3.5Gi`, and `4.0Gi`. **NOTE:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#memory ContainerApp#memory}
    */
    readonly memory: string;
    /**
    * The name of the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#env ContainerApp#env}
    */
    readonly env?: ContainerAppTemplateContainerEnv[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#liveness_probe ContainerApp#liveness_probe}
    */
    readonly livenessProbe?: ContainerAppTemplateContainerLivenessProbe[] | cdktf.IResolvable;
    /**
    * readiness_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#readiness_probe ContainerApp#readiness_probe}
    */
    readonly readinessProbe?: ContainerAppTemplateContainerReadinessProbe[] | cdktf.IResolvable;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#startup_probe ContainerApp#startup_probe}
    */
    readonly startupProbe?: ContainerAppTemplateContainerStartupProbe[] | cdktf.IResolvable;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#volume_mounts ContainerApp#volume_mounts}
    */
    readonly volumeMounts?: ContainerAppTemplateContainerVolumeMounts[] | cdktf.IResolvable;
}
export declare function containerAppTemplateContainerToTerraform(struct?: ContainerAppTemplateContainer | cdktf.IResolvable): any;
export declare class ContainerAppTemplateContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateContainer | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateContainer | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    get cpuInput(): number | undefined;
    get ephemeralStorage(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    get memoryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _env;
    get env(): ContainerAppTemplateContainerEnvList;
    putEnv(value: ContainerAppTemplateContainerEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | ContainerAppTemplateContainerEnv[] | undefined;
    private _livenessProbe;
    get livenessProbe(): ContainerAppTemplateContainerLivenessProbeList;
    putLivenessProbe(value: ContainerAppTemplateContainerLivenessProbe[] | cdktf.IResolvable): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): cdktf.IResolvable | ContainerAppTemplateContainerLivenessProbe[] | undefined;
    private _readinessProbe;
    get readinessProbe(): ContainerAppTemplateContainerReadinessProbeList;
    putReadinessProbe(value: ContainerAppTemplateContainerReadinessProbe[] | cdktf.IResolvable): void;
    resetReadinessProbe(): void;
    get readinessProbeInput(): cdktf.IResolvable | ContainerAppTemplateContainerReadinessProbe[] | undefined;
    private _startupProbe;
    get startupProbe(): ContainerAppTemplateContainerStartupProbeList;
    putStartupProbe(value: ContainerAppTemplateContainerStartupProbe[] | cdktf.IResolvable): void;
    resetStartupProbe(): void;
    get startupProbeInput(): cdktf.IResolvable | ContainerAppTemplateContainerStartupProbe[] | undefined;
    private _volumeMounts;
    get volumeMounts(): ContainerAppTemplateContainerVolumeMountsList;
    putVolumeMounts(value: ContainerAppTemplateContainerVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | ContainerAppTemplateContainerVolumeMounts[] | undefined;
}
export declare class ContainerAppTemplateContainerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateContainer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateContainerOutputReference;
}
export interface ContainerAppTemplateVolume {
    /**
    * The name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#name ContainerApp#name}
    */
    readonly name: string;
    /**
    * The name of the `AzureFile` storage. Required when `storage_type` is `AzureFile`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#storage_name ContainerApp#storage_name}
    */
    readonly storageName?: string;
    /**
    * The type of storage volume. Possible values include `AzureFile` and `EmptyDir`. Defaults to `EmptyDir`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#storage_type ContainerApp#storage_type}
    */
    readonly storageType?: string;
}
export declare function containerAppTemplateVolumeToTerraform(struct?: ContainerAppTemplateVolume | cdktf.IResolvable): any;
export declare class ContainerAppTemplateVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAppTemplateVolume | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTemplateVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageName?;
    get storageName(): string;
    set storageName(value: string);
    resetStorageName(): void;
    get storageNameInput(): string | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    resetStorageType(): void;
    get storageTypeInput(): string | undefined;
}
export declare class ContainerAppTemplateVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAppTemplateVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAppTemplateVolumeOutputReference;
}
export interface ContainerAppTemplate {
    /**
    * The maximum number of replicas for this container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#max_replicas ContainerApp#max_replicas}
    */
    readonly maxReplicas?: number;
    /**
    * The minimum number of replicas for this container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#min_replicas ContainerApp#min_replicas}
    */
    readonly minReplicas?: number;
    /**
    * The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#revision_suffix ContainerApp#revision_suffix}
    */
    readonly revisionSuffix?: string;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#container ContainerApp#container}
    */
    readonly container: ContainerAppTemplateContainer[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#volume ContainerApp#volume}
    */
    readonly volume?: ContainerAppTemplateVolume[] | cdktf.IResolvable;
}
export declare function containerAppTemplateToTerraform(struct?: ContainerAppTemplateOutputReference | ContainerAppTemplate): any;
export declare class ContainerAppTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppTemplate | undefined;
    set internalValue(value: ContainerAppTemplate | undefined);
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    resetMaxReplicas(): void;
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    resetMinReplicas(): void;
    get minReplicasInput(): number | undefined;
    private _revisionSuffix?;
    get revisionSuffix(): string;
    set revisionSuffix(value: string);
    resetRevisionSuffix(): void;
    get revisionSuffixInput(): string | undefined;
    private _container;
    get container(): ContainerAppTemplateContainerList;
    putContainer(value: ContainerAppTemplateContainer[] | cdktf.IResolvable): void;
    get containerInput(): cdktf.IResolvable | ContainerAppTemplateContainer[] | undefined;
    private _volume;
    get volume(): ContainerAppTemplateVolumeList;
    putVolume(value: ContainerAppTemplateVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | ContainerAppTemplateVolume[] | undefined;
}
export interface ContainerAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#create ContainerApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#delete ContainerApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#read ContainerApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app#update ContainerApp#update}
    */
    readonly update?: string;
}
export declare function containerAppTimeoutsToTerraform(struct?: ContainerAppTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app azurerm_container_app}
*/
export declare class ContainerApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/container_app azurerm_container_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppConfig);
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    get customDomainVerificationId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get latestRevisionFqdn(): string;
    get latestRevisionName(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _revisionMode?;
    get revisionMode(): string;
    set revisionMode(value: string);
    get revisionModeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dapr;
    get dapr(): ContainerAppDaprOutputReference;
    putDapr(value: ContainerAppDapr): void;
    resetDapr(): void;
    get daprInput(): ContainerAppDapr | undefined;
    private _identity;
    get identity(): ContainerAppIdentityOutputReference;
    putIdentity(value: ContainerAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): ContainerAppIdentity | undefined;
    private _ingress;
    get ingress(): ContainerAppIngressOutputReference;
    putIngress(value: ContainerAppIngress): void;
    resetIngress(): void;
    get ingressInput(): ContainerAppIngress | undefined;
    private _registry;
    get registry(): ContainerAppRegistryList;
    putRegistry(value: ContainerAppRegistry[] | cdktf.IResolvable): void;
    resetRegistry(): void;
    get registryInput(): cdktf.IResolvable | ContainerAppRegistry[] | undefined;
    private _secret;
    get secret(): ContainerAppSecretList;
    putSecret(value: ContainerAppSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | ContainerAppSecret[] | undefined;
    private _template;
    get template(): ContainerAppTemplateOutputReference;
    putTemplate(value: ContainerAppTemplate): void;
    get templateInput(): ContainerAppTemplate | undefined;
    private _timeouts;
    get timeouts(): ContainerAppTimeoutsOutputReference;
    putTimeouts(value: ContainerAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
