/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbMongoCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#account_name CosmosdbMongoCollection#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#analytical_storage_ttl CosmosdbMongoCollection#analytical_storage_ttl}
    */
    readonly analyticalStorageTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#database_name CosmosdbMongoCollection#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#default_ttl_seconds CosmosdbMongoCollection#default_ttl_seconds}
    */
    readonly defaultTtlSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#id CosmosdbMongoCollection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#name CosmosdbMongoCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#resource_group_name CosmosdbMongoCollection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#shard_key CosmosdbMongoCollection#shard_key}
    */
    readonly shardKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#throughput CosmosdbMongoCollection#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#autoscale_settings CosmosdbMongoCollection#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbMongoCollectionAutoscaleSettings;
    /**
    * index block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#index CosmosdbMongoCollection#index}
    */
    readonly index?: CosmosdbMongoCollectionIndex[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#timeouts CosmosdbMongoCollection#timeouts}
    */
    readonly timeouts?: CosmosdbMongoCollectionTimeouts;
}
export interface CosmosdbMongoCollectionSystemIndexes {
}
export declare function cosmosdbMongoCollectionSystemIndexesToTerraform(struct?: CosmosdbMongoCollectionSystemIndexes): any;
export declare class CosmosdbMongoCollectionSystemIndexesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbMongoCollectionSystemIndexes | undefined;
    set internalValue(value: CosmosdbMongoCollectionSystemIndexes | undefined);
    get keys(): string[];
    get unique(): cdktf.IResolvable;
}
export declare class CosmosdbMongoCollectionSystemIndexesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbMongoCollectionSystemIndexesOutputReference;
}
export interface CosmosdbMongoCollectionAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#max_throughput CosmosdbMongoCollection#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbMongoCollectionAutoscaleSettingsToTerraform(struct?: CosmosdbMongoCollectionAutoscaleSettingsOutputReference | CosmosdbMongoCollectionAutoscaleSettings): any;
export declare class CosmosdbMongoCollectionAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbMongoCollectionAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbMongoCollectionAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbMongoCollectionIndex {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#keys CosmosdbMongoCollection#keys}
    */
    readonly keys: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#unique CosmosdbMongoCollection#unique}
    */
    readonly unique?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbMongoCollectionIndexToTerraform(struct?: CosmosdbMongoCollectionIndex | cdktf.IResolvable): any;
export declare class CosmosdbMongoCollectionIndexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbMongoCollectionIndex | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbMongoCollectionIndex | cdktf.IResolvable | undefined);
    private _keys?;
    get keys(): string[];
    set keys(value: string[]);
    get keysInput(): string[] | undefined;
    private _unique?;
    get unique(): boolean | cdktf.IResolvable;
    set unique(value: boolean | cdktf.IResolvable);
    resetUnique(): void;
    get uniqueInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class CosmosdbMongoCollectionIndexList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbMongoCollectionIndex[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbMongoCollectionIndexOutputReference;
}
export interface CosmosdbMongoCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#create CosmosdbMongoCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#delete CosmosdbMongoCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#read CosmosdbMongoCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection#update CosmosdbMongoCollection#update}
    */
    readonly update?: string;
}
export declare function cosmosdbMongoCollectionTimeoutsToTerraform(struct?: CosmosdbMongoCollectionTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbMongoCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbMongoCollectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbMongoCollectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection azurerm_cosmosdb_mongo_collection}
*/
export declare class CosmosdbMongoCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_mongo_collection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/cosmosdb_mongo_collection azurerm_cosmosdb_mongo_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbMongoCollectionConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbMongoCollectionConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _analyticalStorageTtl?;
    get analyticalStorageTtl(): number;
    set analyticalStorageTtl(value: number);
    resetAnalyticalStorageTtl(): void;
    get analyticalStorageTtlInput(): number | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _defaultTtlSeconds?;
    get defaultTtlSeconds(): number;
    set defaultTtlSeconds(value: number);
    resetDefaultTtlSeconds(): void;
    get defaultTtlSecondsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shardKey?;
    get shardKey(): string;
    set shardKey(value: string);
    resetShardKey(): void;
    get shardKeyInput(): string | undefined;
    private _systemIndexes;
    get systemIndexes(): CosmosdbMongoCollectionSystemIndexesList;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbMongoCollectionAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbMongoCollectionAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbMongoCollectionAutoscaleSettings | undefined;
    private _index;
    get index(): CosmosdbMongoCollectionIndexList;
    putIndex(value: CosmosdbMongoCollectionIndex[] | cdktf.IResolvable): void;
    resetIndex(): void;
    get indexInput(): cdktf.IResolvable | CosmosdbMongoCollectionIndex[] | undefined;
    private _timeouts;
    get timeouts(): CosmosdbMongoCollectionTimeoutsOutputReference;
    putTimeouts(value: CosmosdbMongoCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbMongoCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
