/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbRestorableDatabaseAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts#id DataAzurermCosmosdbRestorableDatabaseAccounts#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts#location DataAzurermCosmosdbRestorableDatabaseAccounts#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts#name DataAzurermCosmosdbRestorableDatabaseAccounts#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts#timeouts DataAzurermCosmosdbRestorableDatabaseAccounts#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts;
}
export interface DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations {
}
export declare function dataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocationsToTerraform(struct?: DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations): any;
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations | undefined;
    set internalValue(value: DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations | undefined);
    get creationTime(): string;
    get deletionTime(): string;
    get location(): string;
    get regionalDatabaseAccountInstanceId(): string;
}
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocationsOutputReference;
}
export interface DataAzurermCosmosdbRestorableDatabaseAccountsAccounts {
}
export declare function dataAzurermCosmosdbRestorableDatabaseAccountsAccountsToTerraform(struct?: DataAzurermCosmosdbRestorableDatabaseAccountsAccounts): any;
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCosmosdbRestorableDatabaseAccountsAccounts | undefined;
    set internalValue(value: DataAzurermCosmosdbRestorableDatabaseAccountsAccounts | undefined);
    get apiType(): string;
    get creationTime(): string;
    get deletionTime(): string;
    get id(): string;
    private _restorableLocations;
    get restorableLocations(): DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocationsList;
}
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCosmosdbRestorableDatabaseAccountsAccountsOutputReference;
}
export interface DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts#read DataAzurermCosmosdbRestorableDatabaseAccounts#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsToTerraform(struct?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts azurerm_cosmosdb_restorable_database_accounts}
*/
export declare class DataAzurermCosmosdbRestorableDatabaseAccounts extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cosmosdb_restorable_database_accounts";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/cosmosdb_restorable_database_accounts azurerm_cosmosdb_restorable_database_accounts} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbRestorableDatabaseAccountsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbRestorableDatabaseAccountsConfig);
    private _accounts;
    get accounts(): DataAzurermCosmosdbRestorableDatabaseAccountsAccountsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
