/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogAnalyticsWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace#id DataAzurermLogAnalyticsWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace#name DataAzurermLogAnalyticsWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace#resource_group_name DataAzurermLogAnalyticsWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace#timeouts DataAzurermLogAnalyticsWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermLogAnalyticsWorkspaceTimeouts;
}
export interface DataAzurermLogAnalyticsWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace#read DataAzurermLogAnalyticsWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogAnalyticsWorkspaceTimeoutsToTerraform(struct?: DataAzurermLogAnalyticsWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLogAnalyticsWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLogAnalyticsWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace azurerm_log_analytics_workspace}
*/
export declare class DataAzurermLogAnalyticsWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_log_analytics_workspace";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/log_analytics_workspace azurerm_log_analytics_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogAnalyticsWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogAnalyticsWorkspaceConfig);
    get dailyQuotaGb(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primarySharedKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get retentionInDays(): number;
    get secondarySharedKey(): string;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get workspaceId(): string;
    private _timeouts;
    get timeouts(): DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogAnalyticsWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLogAnalyticsWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
