/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMysqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server#id DataAzurermMysqlServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server#name DataAzurermMysqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server#resource_group_name DataAzurermMysqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server#timeouts DataAzurermMysqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermMysqlServerTimeouts;
}
export interface DataAzurermMysqlServerIdentity {
}
export declare function dataAzurermMysqlServerIdentityToTerraform(struct?: DataAzurermMysqlServerIdentity): any;
export declare class DataAzurermMysqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMysqlServerIdentity | undefined;
    set internalValue(value: DataAzurermMysqlServerIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermMysqlServerIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMysqlServerIdentityOutputReference;
}
export interface DataAzurermMysqlServerThreatDetectionPolicy {
}
export declare function dataAzurermMysqlServerThreatDetectionPolicyToTerraform(struct?: DataAzurermMysqlServerThreatDetectionPolicy): any;
export declare class DataAzurermMysqlServerThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMysqlServerThreatDetectionPolicy | undefined;
    set internalValue(value: DataAzurermMysqlServerThreatDetectionPolicy | undefined);
    get disabledAlerts(): string[];
    get emailAccountAdmins(): cdktf.IResolvable;
    get emailAddresses(): string[];
    get enabled(): cdktf.IResolvable;
    get retentionDays(): number;
    get storageAccountAccessKey(): string;
    get storageEndpoint(): string;
}
export declare class DataAzurermMysqlServerThreatDetectionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMysqlServerThreatDetectionPolicyOutputReference;
}
export interface DataAzurermMysqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server#read DataAzurermMysqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMysqlServerTimeoutsToTerraform(struct?: DataAzurermMysqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMysqlServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMysqlServerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server azurerm_mysql_server}
*/
export declare class DataAzurermMysqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mysql_server";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/mysql_server azurerm_mysql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMysqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlServerConfig);
    get administratorLogin(): string;
    get autoGrowEnabled(): cdktf.IResolvable;
    get backupRetentionDays(): number;
    get fqdn(): string;
    get geoRedundantBackupEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermMysqlServerIdentityList;
    get infrastructureEncryptionEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorePointInTime(): string;
    get skuName(): string;
    get sslEnforcementEnabled(): cdktf.IResolvable;
    get sslMinimalTlsVersionEnforced(): string;
    get storageMb(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    private _threatDetectionPolicy;
    get threatDetectionPolicy(): DataAzurermMysqlServerThreatDetectionPolicyList;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermMysqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMysqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMysqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
