/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#gallery_name DataAzurermSharedImageVersion#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#id DataAzurermSharedImageVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#image_name DataAzurermSharedImageVersion#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#name DataAzurermSharedImageVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#resource_group_name DataAzurermSharedImageVersion#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#sort_versions_by_semver DataAzurermSharedImageVersion#sort_versions_by_semver}
    */
    readonly sortVersionsBySemver?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#timeouts DataAzurermSharedImageVersion#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageVersionTimeouts;
}
export interface DataAzurermSharedImageVersionTargetRegion {
}
export declare function dataAzurermSharedImageVersionTargetRegionToTerraform(struct?: DataAzurermSharedImageVersionTargetRegion): any;
export declare class DataAzurermSharedImageVersionTargetRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSharedImageVersionTargetRegion | undefined;
    set internalValue(value: DataAzurermSharedImageVersionTargetRegion | undefined);
    get name(): string;
    get regionalReplicaCount(): number;
    get storageAccountType(): string;
}
export declare class DataAzurermSharedImageVersionTargetRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSharedImageVersionTargetRegionOutputReference;
}
export interface DataAzurermSharedImageVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version#read DataAzurermSharedImageVersion#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSharedImageVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSharedImageVersionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version azurerm_shared_image_version}
*/
export declare class DataAzurermSharedImageVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_shared_image_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/shared_image_version azurerm_shared_image_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionConfig);
    get excludeFromLatest(): cdktf.IResolvable;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    get location(): string;
    get managedImageId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osDiskImageSizeGb(): number;
    get osDiskSnapshotId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sortVersionsBySemver?;
    get sortVersionsBySemver(): boolean | cdktf.IResolvable;
    set sortVersionsBySemver(value: boolean | cdktf.IResolvable);
    resetSortVersionsBySemver(): void;
    get sortVersionsBySemverInput(): boolean | cdktf.IResolvable | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _targetRegion;
    get targetRegion(): DataAzurermSharedImageVersionTargetRegionList;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageVersionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSharedImageVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
