/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubscriptionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions#display_name_contains DataAzurermSubscriptions#display_name_contains}
    */
    readonly displayNameContains?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions#display_name_prefix DataAzurermSubscriptions#display_name_prefix}
    */
    readonly displayNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions#id DataAzurermSubscriptions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions#timeouts DataAzurermSubscriptions#timeouts}
    */
    readonly timeouts?: DataAzurermSubscriptionsTimeouts;
}
export interface DataAzurermSubscriptionsSubscriptions {
}
export declare function dataAzurermSubscriptionsSubscriptionsToTerraform(struct?: DataAzurermSubscriptionsSubscriptions): any;
export declare class DataAzurermSubscriptionsSubscriptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSubscriptionsSubscriptions | undefined;
    set internalValue(value: DataAzurermSubscriptionsSubscriptions | undefined);
    get displayName(): string;
    get id(): string;
    get locationPlacementId(): string;
    get quotaId(): string;
    get spendingLimit(): string;
    get state(): string;
    get subscriptionId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
}
export declare class DataAzurermSubscriptionsSubscriptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSubscriptionsSubscriptionsOutputReference;
}
export interface DataAzurermSubscriptionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions#read DataAzurermSubscriptions#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionsTimeoutsToTerraform(struct?: DataAzurermSubscriptionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubscriptionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSubscriptionsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSubscriptionsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions azurerm_subscriptions}
*/
export declare class DataAzurermSubscriptions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_subscriptions";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/subscriptions azurerm_subscriptions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubscriptionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionsConfig);
    private _displayNameContains?;
    get displayNameContains(): string;
    set displayNameContains(value: string);
    resetDisplayNameContains(): void;
    get displayNameContainsInput(): string | undefined;
    private _displayNamePrefix?;
    get displayNamePrefix(): string;
    set displayNamePrefix(value: string);
    resetDisplayNamePrefix(): void;
    get displayNamePrefixInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _subscriptions;
    get subscriptions(): DataAzurermSubscriptionsSubscriptionsList;
    private _timeouts;
    get timeouts(): DataAzurermSubscriptionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubscriptionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSubscriptionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
