/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermTenantTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment#id DataAzurermTenantTemplateDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment#name DataAzurermTenantTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment#timeouts DataAzurermTenantTemplateDeployment#timeouts}
    */
    readonly timeouts?: DataAzurermTenantTemplateDeploymentTimeouts;
}
export interface DataAzurermTenantTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment#read DataAzurermTenantTemplateDeployment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermTenantTemplateDeploymentTimeoutsToTerraform(struct?: DataAzurermTenantTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermTenantTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermTenantTemplateDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermTenantTemplateDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment azurerm_tenant_template_deployment}
*/
export declare class DataAzurermTenantTemplateDeployment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_tenant_template_deployment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/data-sources/tenant_template_deployment azurerm_tenant_template_deployment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermTenantTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermTenantTemplateDeploymentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _timeouts;
    get timeouts(): DataAzurermTenantTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermTenantTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermTenantTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
