/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryTriggerBlobEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#activated DataFactoryTriggerBlobEvent#activated}
    */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#additional_properties DataFactoryTriggerBlobEvent#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#annotations DataFactoryTriggerBlobEvent#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#blob_path_begins_with DataFactoryTriggerBlobEvent#blob_path_begins_with}
    */
    readonly blobPathBeginsWith?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#blob_path_ends_with DataFactoryTriggerBlobEvent#blob_path_ends_with}
    */
    readonly blobPathEndsWith?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#data_factory_id DataFactoryTriggerBlobEvent#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#description DataFactoryTriggerBlobEvent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#events DataFactoryTriggerBlobEvent#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#id DataFactoryTriggerBlobEvent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#ignore_empty_blobs DataFactoryTriggerBlobEvent#ignore_empty_blobs}
    */
    readonly ignoreEmptyBlobs?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#name DataFactoryTriggerBlobEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#storage_account_id DataFactoryTriggerBlobEvent#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * pipeline block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#pipeline DataFactoryTriggerBlobEvent#pipeline}
    */
    readonly pipeline: DataFactoryTriggerBlobEventPipeline[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#timeouts DataFactoryTriggerBlobEvent#timeouts}
    */
    readonly timeouts?: DataFactoryTriggerBlobEventTimeouts;
}
export interface DataFactoryTriggerBlobEventPipeline {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#name DataFactoryTriggerBlobEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#parameters DataFactoryTriggerBlobEvent#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerBlobEventPipelineToTerraform(struct?: DataFactoryTriggerBlobEventPipeline | cdktf.IResolvable): any;
export declare class DataFactoryTriggerBlobEventPipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryTriggerBlobEventPipeline | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerBlobEventPipeline | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class DataFactoryTriggerBlobEventPipelineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryTriggerBlobEventPipeline[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryTriggerBlobEventPipelineOutputReference;
}
export interface DataFactoryTriggerBlobEventTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#create DataFactoryTriggerBlobEvent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#delete DataFactoryTriggerBlobEvent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#read DataFactoryTriggerBlobEvent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event#update DataFactoryTriggerBlobEvent#update}
    */
    readonly update?: string;
}
export declare function dataFactoryTriggerBlobEventTimeoutsToTerraform(struct?: DataFactoryTriggerBlobEventTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryTriggerBlobEventTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryTriggerBlobEventTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerBlobEventTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event azurerm_data_factory_trigger_blob_event}
*/
export declare class DataFactoryTriggerBlobEvent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_trigger_blob_event";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/data_factory_trigger_blob_event azurerm_data_factory_trigger_blob_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryTriggerBlobEventConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerBlobEventConfig);
    private _activated?;
    get activated(): boolean | cdktf.IResolvable;
    set activated(value: boolean | cdktf.IResolvable);
    resetActivated(): void;
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _blobPathBeginsWith?;
    get blobPathBeginsWith(): string;
    set blobPathBeginsWith(value: string);
    resetBlobPathBeginsWith(): void;
    get blobPathBeginsWithInput(): string | undefined;
    private _blobPathEndsWith?;
    get blobPathEndsWith(): string;
    set blobPathEndsWith(value: string);
    resetBlobPathEndsWith(): void;
    get blobPathEndsWithInput(): string | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _events?;
    get events(): string[];
    set events(value: string[]);
    get eventsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreEmptyBlobs?;
    get ignoreEmptyBlobs(): boolean | cdktf.IResolvable;
    set ignoreEmptyBlobs(value: boolean | cdktf.IResolvable);
    resetIgnoreEmptyBlobs(): void;
    get ignoreEmptyBlobsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _pipeline;
    get pipeline(): DataFactoryTriggerBlobEventPipelineList;
    putPipeline(value: DataFactoryTriggerBlobEventPipeline[] | cdktf.IResolvable): void;
    get pipelineInput(): cdktf.IResolvable | DataFactoryTriggerBlobEventPipeline[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryTriggerBlobEventTimeoutsOutputReference;
    putTimeouts(value: DataFactoryTriggerBlobEventTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryTriggerBlobEventTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
