/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#auto_create_topic_with_first_subscription EventgridDomain#auto_create_topic_with_first_subscription}
    */
    readonly autoCreateTopicWithFirstSubscription?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#auto_delete_topic_with_last_subscription EventgridDomain#auto_delete_topic_with_last_subscription}
    */
    readonly autoDeleteTopicWithLastSubscription?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#id EventgridDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#inbound_ip_rule EventgridDomain#inbound_ip_rule}
    */
    readonly inboundIpRule?: EventgridDomainInboundIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#input_schema EventgridDomain#input_schema}
    */
    readonly inputSchema?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#local_auth_enabled EventgridDomain#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#location EventgridDomain#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#name EventgridDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#public_network_access_enabled EventgridDomain#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#resource_group_name EventgridDomain#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#tags EventgridDomain#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#identity EventgridDomain#identity}
    */
    readonly identity?: EventgridDomainIdentity;
    /**
    * input_mapping_default_values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#input_mapping_default_values EventgridDomain#input_mapping_default_values}
    */
    readonly inputMappingDefaultValues?: EventgridDomainInputMappingDefaultValues;
    /**
    * input_mapping_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#input_mapping_fields EventgridDomain#input_mapping_fields}
    */
    readonly inputMappingFields?: EventgridDomainInputMappingFields;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#timeouts EventgridDomain#timeouts}
    */
    readonly timeouts?: EventgridDomainTimeouts;
}
export interface EventgridDomainInboundIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#action EventgridDomain#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#ip_mask EventgridDomain#ip_mask}
    */
    readonly ipMask?: string;
}
export declare function eventgridDomainInboundIpRuleToTerraform(struct?: EventgridDomainInboundIpRule | cdktf.IResolvable): any;
export declare class EventgridDomainInboundIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridDomainInboundIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridDomainInboundIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    resetIpMask(): void;
    get ipMaskInput(): string | undefined;
}
export declare class EventgridDomainInboundIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridDomainInboundIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridDomainInboundIpRuleOutputReference;
}
export interface EventgridDomainIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#identity_ids EventgridDomain#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#type EventgridDomain#type}
    */
    readonly type: string;
}
export declare function eventgridDomainIdentityToTerraform(struct?: EventgridDomainIdentityOutputReference | EventgridDomainIdentity): any;
export declare class EventgridDomainIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridDomainIdentity | undefined;
    set internalValue(value: EventgridDomainIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventgridDomainInputMappingDefaultValues {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#data_version EventgridDomain#data_version}
    */
    readonly dataVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#event_type EventgridDomain#event_type}
    */
    readonly eventType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#subject EventgridDomain#subject}
    */
    readonly subject?: string;
}
export declare function eventgridDomainInputMappingDefaultValuesToTerraform(struct?: EventgridDomainInputMappingDefaultValuesOutputReference | EventgridDomainInputMappingDefaultValues): any;
export declare class EventgridDomainInputMappingDefaultValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridDomainInputMappingDefaultValues | undefined;
    set internalValue(value: EventgridDomainInputMappingDefaultValues | undefined);
    private _dataVersion?;
    get dataVersion(): string;
    set dataVersion(value: string);
    resetDataVersion(): void;
    get dataVersionInput(): string | undefined;
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    resetEventType(): void;
    get eventTypeInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
}
export interface EventgridDomainInputMappingFields {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#data_version EventgridDomain#data_version}
    */
    readonly dataVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#event_time EventgridDomain#event_time}
    */
    readonly eventTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#event_type EventgridDomain#event_type}
    */
    readonly eventType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#id EventgridDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#subject EventgridDomain#subject}
    */
    readonly subject?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#topic EventgridDomain#topic}
    */
    readonly topic?: string;
}
export declare function eventgridDomainInputMappingFieldsToTerraform(struct?: EventgridDomainInputMappingFieldsOutputReference | EventgridDomainInputMappingFields): any;
export declare class EventgridDomainInputMappingFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridDomainInputMappingFields | undefined;
    set internalValue(value: EventgridDomainInputMappingFields | undefined);
    private _dataVersion?;
    get dataVersion(): string;
    set dataVersion(value: string);
    resetDataVersion(): void;
    get dataVersionInput(): string | undefined;
    private _eventTime?;
    get eventTime(): string;
    set eventTime(value: string);
    resetEventTime(): void;
    get eventTimeInput(): string | undefined;
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    resetEventType(): void;
    get eventTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface EventgridDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#create EventgridDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#delete EventgridDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#read EventgridDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain#update EventgridDomain#update}
    */
    readonly update?: string;
}
export declare function eventgridDomainTimeoutsToTerraform(struct?: EventgridDomainTimeouts | cdktf.IResolvable): any;
export declare class EventgridDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain azurerm_eventgrid_domain}
*/
export declare class EventgridDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventgrid_domain";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/eventgrid_domain azurerm_eventgrid_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridDomainConfig
    */
    constructor(scope: Construct, id: string, config: EventgridDomainConfig);
    private _autoCreateTopicWithFirstSubscription?;
    get autoCreateTopicWithFirstSubscription(): boolean | cdktf.IResolvable;
    set autoCreateTopicWithFirstSubscription(value: boolean | cdktf.IResolvable);
    resetAutoCreateTopicWithFirstSubscription(): void;
    get autoCreateTopicWithFirstSubscriptionInput(): boolean | cdktf.IResolvable | undefined;
    private _autoDeleteTopicWithLastSubscription?;
    get autoDeleteTopicWithLastSubscription(): boolean | cdktf.IResolvable;
    set autoDeleteTopicWithLastSubscription(value: boolean | cdktf.IResolvable);
    resetAutoDeleteTopicWithLastSubscription(): void;
    get autoDeleteTopicWithLastSubscriptionInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundIpRule;
    get inboundIpRule(): EventgridDomainInboundIpRuleList;
    putInboundIpRule(value: EventgridDomainInboundIpRule[] | cdktf.IResolvable): void;
    resetInboundIpRule(): void;
    get inboundIpRuleInput(): cdktf.IResolvable | EventgridDomainInboundIpRule[] | undefined;
    private _inputSchema?;
    get inputSchema(): string;
    set inputSchema(value: string);
    resetInputSchema(): void;
    get inputSchemaInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): EventgridDomainIdentityOutputReference;
    putIdentity(value: EventgridDomainIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventgridDomainIdentity | undefined;
    private _inputMappingDefaultValues;
    get inputMappingDefaultValues(): EventgridDomainInputMappingDefaultValuesOutputReference;
    putInputMappingDefaultValues(value: EventgridDomainInputMappingDefaultValues): void;
    resetInputMappingDefaultValues(): void;
    get inputMappingDefaultValuesInput(): EventgridDomainInputMappingDefaultValues | undefined;
    private _inputMappingFields;
    get inputMappingFields(): EventgridDomainInputMappingFieldsOutputReference;
    putInputMappingFields(value: EventgridDomainInputMappingFields): void;
    resetInputMappingFields(): void;
    get inputMappingFieldsInput(): EventgridDomainInputMappingFields | undefined;
    private _timeouts;
    get timeouts(): EventgridDomainTimeoutsOutputReference;
    putTimeouts(value: EventgridDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventgridDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
