/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogzMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#company_name LogzMonitor#company_name}
    */
    readonly companyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#enabled LogzMonitor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#enterprise_app_id LogzMonitor#enterprise_app_id}
    */
    readonly enterpriseAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#id LogzMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#location LogzMonitor#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#name LogzMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#resource_group_name LogzMonitor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#tags LogzMonitor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#plan LogzMonitor#plan}
    */
    readonly plan: LogzMonitorPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#timeouts LogzMonitor#timeouts}
    */
    readonly timeouts?: LogzMonitorTimeouts;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#user LogzMonitor#user}
    */
    readonly user: LogzMonitorUser;
}
export interface LogzMonitorPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#billing_cycle LogzMonitor#billing_cycle}
    */
    readonly billingCycle: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#effective_date LogzMonitor#effective_date}
    */
    readonly effectiveDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#plan_id LogzMonitor#plan_id}
    */
    readonly planId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#usage_type LogzMonitor#usage_type}
    */
    readonly usageType: string;
}
export declare function logzMonitorPlanToTerraform(struct?: LogzMonitorPlanOutputReference | LogzMonitorPlan): any;
export declare class LogzMonitorPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogzMonitorPlan | undefined;
    set internalValue(value: LogzMonitorPlan | undefined);
    private _billingCycle?;
    get billingCycle(): string;
    set billingCycle(value: string);
    get billingCycleInput(): string | undefined;
    private _effectiveDate?;
    get effectiveDate(): string;
    set effectiveDate(value: string);
    get effectiveDateInput(): string | undefined;
    private _planId?;
    get planId(): string;
    set planId(value: string);
    resetPlanId(): void;
    get planIdInput(): string | undefined;
    private _usageType?;
    get usageType(): string;
    set usageType(value: string);
    get usageTypeInput(): string | undefined;
}
export interface LogzMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#create LogzMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#delete LogzMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#read LogzMonitor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#update LogzMonitor#update}
    */
    readonly update?: string;
}
export declare function logzMonitorTimeoutsToTerraform(struct?: LogzMonitorTimeouts | cdktf.IResolvable): any;
export declare class LogzMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogzMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogzMonitorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface LogzMonitorUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#email LogzMonitor#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#first_name LogzMonitor#first_name}
    */
    readonly firstName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#last_name LogzMonitor#last_name}
    */
    readonly lastName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor#phone_number LogzMonitor#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function logzMonitorUserToTerraform(struct?: LogzMonitorUserOutputReference | LogzMonitorUser): any;
export declare class LogzMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogzMonitorUser | undefined;
    set internalValue(value: LogzMonitorUser | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    get firstNameInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor azurerm_logz_monitor}
*/
export declare class LogzMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logz_monitor";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/logz_monitor azurerm_logz_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogzMonitorConfig
    */
    constructor(scope: Construct, id: string, config: LogzMonitorConfig);
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    resetCompanyName(): void;
    get companyNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enterpriseAppId?;
    get enterpriseAppId(): string;
    set enterpriseAppId(value: string);
    resetEnterpriseAppId(): void;
    get enterpriseAppIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get logzOrganizationId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get singleSignOnUrl(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _plan;
    get plan(): LogzMonitorPlanOutputReference;
    putPlan(value: LogzMonitorPlan): void;
    get planInput(): LogzMonitorPlan | undefined;
    private _timeouts;
    get timeouts(): LogzMonitorTimeoutsOutputReference;
    putTimeouts(value: LogzMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogzMonitorTimeouts | undefined;
    private _user;
    get user(): LogzMonitorUserOutputReference;
    putUser(value: LogzMonitorUser): void;
    get userInput(): LogzMonitorUser | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
