/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#administrator_login MssqlManagedInstance#administrator_login}
    */
    readonly administratorLogin: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#administrator_login_password MssqlManagedInstance#administrator_login_password}
    */
    readonly administratorLoginPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#collation MssqlManagedInstance#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#dns_zone_partner_id MssqlManagedInstance#dns_zone_partner_id}
    */
    readonly dnsZonePartnerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#id MssqlManagedInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#license_type MssqlManagedInstance#license_type}
    */
    readonly licenseType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#location MssqlManagedInstance#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#maintenance_configuration_name MssqlManagedInstance#maintenance_configuration_name}
    */
    readonly maintenanceConfigurationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#minimum_tls_version MssqlManagedInstance#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#name MssqlManagedInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#proxy_override MssqlManagedInstance#proxy_override}
    */
    readonly proxyOverride?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#public_data_endpoint_enabled MssqlManagedInstance#public_data_endpoint_enabled}
    */
    readonly publicDataEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#resource_group_name MssqlManagedInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#sku_name MssqlManagedInstance#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#storage_account_type MssqlManagedInstance#storage_account_type}
    */
    readonly storageAccountType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#storage_size_in_gb MssqlManagedInstance#storage_size_in_gb}
    */
    readonly storageSizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#subnet_id MssqlManagedInstance#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#tags MssqlManagedInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#timezone_id MssqlManagedInstance#timezone_id}
    */
    readonly timezoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#vcores MssqlManagedInstance#vcores}
    */
    readonly vcores: number;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#identity MssqlManagedInstance#identity}
    */
    readonly identity?: MssqlManagedInstanceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#timeouts MssqlManagedInstance#timeouts}
    */
    readonly timeouts?: MssqlManagedInstanceTimeouts;
}
export interface MssqlManagedInstanceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#identity_ids MssqlManagedInstance#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#type MssqlManagedInstance#type}
    */
    readonly type: string;
}
export declare function mssqlManagedInstanceIdentityToTerraform(struct?: MssqlManagedInstanceIdentityOutputReference | MssqlManagedInstanceIdentity): any;
export declare class MssqlManagedInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedInstanceIdentity | undefined;
    set internalValue(value: MssqlManagedInstanceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MssqlManagedInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#create MssqlManagedInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#delete MssqlManagedInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#read MssqlManagedInstance#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance#update MssqlManagedInstance#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedInstanceTimeoutsToTerraform(struct?: MssqlManagedInstanceTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlManagedInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance azurerm_mssql_managed_instance}
*/
export declare class MssqlManagedInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_managed_instance";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/mssql_managed_instance azurerm_mssql_managed_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedInstanceConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedInstanceConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    get administratorLoginPasswordInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _dnsZonePartnerId?;
    get dnsZonePartnerId(): string;
    set dnsZonePartnerId(value: string);
    resetDnsZonePartnerId(): void;
    get dnsZonePartnerIdInput(): string | undefined;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maintenanceConfigurationName?;
    get maintenanceConfigurationName(): string;
    set maintenanceConfigurationName(value: string);
    resetMaintenanceConfigurationName(): void;
    get maintenanceConfigurationNameInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _proxyOverride?;
    get proxyOverride(): string;
    set proxyOverride(value: string);
    resetProxyOverride(): void;
    get proxyOverrideInput(): string | undefined;
    private _publicDataEndpointEnabled?;
    get publicDataEndpointEnabled(): boolean | cdktf.IResolvable;
    set publicDataEndpointEnabled(value: boolean | cdktf.IResolvable);
    resetPublicDataEndpointEnabled(): void;
    get publicDataEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    resetStorageAccountType(): void;
    get storageAccountTypeInput(): string | undefined;
    private _storageSizeInGb?;
    get storageSizeInGb(): number;
    set storageSizeInGb(value: number);
    get storageSizeInGbInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timezoneId?;
    get timezoneId(): string;
    set timezoneId(value: string);
    resetTimezoneId(): void;
    get timezoneIdInput(): string | undefined;
    private _vcores?;
    get vcores(): number;
    set vcores(value: number);
    get vcoresInput(): number | undefined;
    private _identity;
    get identity(): MssqlManagedInstanceIdentityOutputReference;
    putIdentity(value: MssqlManagedInstanceIdentity): void;
    resetIdentity(): void;
    get identityInput(): MssqlManagedInstanceIdentity | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedInstanceTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlManagedInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
