/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourcePolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#description ResourcePolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#display_name ResourcePolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#enforce ResourcePolicyAssignment#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#id ResourcePolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#location ResourcePolicyAssignment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#metadata ResourcePolicyAssignment#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#name ResourcePolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#not_scopes ResourcePolicyAssignment#not_scopes}
    */
    readonly notScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#parameters ResourcePolicyAssignment#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#policy_definition_id ResourcePolicyAssignment#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#resource_id ResourcePolicyAssignment#resource_id}
    */
    readonly resourceId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#identity ResourcePolicyAssignment#identity}
    */
    readonly identity?: ResourcePolicyAssignmentIdentity;
    /**
    * non_compliance_message block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#non_compliance_message ResourcePolicyAssignment#non_compliance_message}
    */
    readonly nonComplianceMessage?: ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#overrides ResourcePolicyAssignment#overrides}
    */
    readonly overrides?: ResourcePolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * resource_selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#resource_selectors ResourcePolicyAssignment#resource_selectors}
    */
    readonly resourceSelectors?: ResourcePolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#timeouts ResourcePolicyAssignment#timeouts}
    */
    readonly timeouts?: ResourcePolicyAssignmentTimeouts;
}
export interface ResourcePolicyAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#identity_ids ResourcePolicyAssignment#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#type ResourcePolicyAssignment#type}
    */
    readonly type: string;
}
export declare function resourcePolicyAssignmentIdentityToTerraform(struct?: ResourcePolicyAssignmentIdentityOutputReference | ResourcePolicyAssignmentIdentity): any;
export declare class ResourcePolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourcePolicyAssignmentIdentity | undefined;
    set internalValue(value: ResourcePolicyAssignmentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourcePolicyAssignmentNonComplianceMessage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#content ResourcePolicyAssignment#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#policy_definition_reference_id ResourcePolicyAssignment#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
}
export declare function resourcePolicyAssignmentNonComplianceMessageToTerraform(struct?: ResourcePolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentNonComplianceMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourcePolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _policyDefinitionReferenceId?;
    get policyDefinitionReferenceId(): string;
    set policyDefinitionReferenceId(value: string);
    resetPolicyDefinitionReferenceId(): void;
    get policyDefinitionReferenceIdInput(): string | undefined;
}
export declare class ResourcePolicyAssignmentNonComplianceMessageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourcePolicyAssignmentNonComplianceMessageOutputReference;
}
export interface ResourcePolicyAssignmentOverridesSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#in ResourcePolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#not_in ResourcePolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function resourcePolicyAssignmentOverridesSelectorsToTerraform(struct?: ResourcePolicyAssignmentOverridesSelectors | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentOverridesSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourcePolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    get kind(): string;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class ResourcePolicyAssignmentOverridesSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourcePolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourcePolicyAssignmentOverridesSelectorsOutputReference;
}
export interface ResourcePolicyAssignmentOverrides {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#value ResourcePolicyAssignment#value}
    */
    readonly value: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#selectors ResourcePolicyAssignment#selectors}
    */
    readonly selectors?: ResourcePolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
}
export declare function resourcePolicyAssignmentOverridesToTerraform(struct?: ResourcePolicyAssignmentOverrides | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourcePolicyAssignmentOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentOverrides | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _selectors;
    get selectors(): ResourcePolicyAssignmentOverridesSelectorsList;
    putSelectors(value: ResourcePolicyAssignmentOverridesSelectors[] | cdktf.IResolvable): void;
    resetSelectors(): void;
    get selectorsInput(): cdktf.IResolvable | ResourcePolicyAssignmentOverridesSelectors[] | undefined;
}
export declare class ResourcePolicyAssignmentOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourcePolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourcePolicyAssignmentOverridesOutputReference;
}
export interface ResourcePolicyAssignmentResourceSelectorsSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#in ResourcePolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#kind ResourcePolicyAssignment#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#not_in ResourcePolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function resourcePolicyAssignmentResourceSelectorsSelectorsToTerraform(struct?: ResourcePolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentResourceSelectorsSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourcePolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class ResourcePolicyAssignmentResourceSelectorsSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourcePolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourcePolicyAssignmentResourceSelectorsSelectorsOutputReference;
}
export interface ResourcePolicyAssignmentResourceSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#name ResourcePolicyAssignment#name}
    */
    readonly name?: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#selectors ResourcePolicyAssignment#selectors}
    */
    readonly selectors: ResourcePolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
}
export declare function resourcePolicyAssignmentResourceSelectorsToTerraform(struct?: ResourcePolicyAssignmentResourceSelectors | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentResourceSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourcePolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _selectors;
    get selectors(): ResourcePolicyAssignmentResourceSelectorsSelectorsList;
    putSelectors(value: ResourcePolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable): void;
    get selectorsInput(): cdktf.IResolvable | ResourcePolicyAssignmentResourceSelectorsSelectors[] | undefined;
}
export declare class ResourcePolicyAssignmentResourceSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourcePolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourcePolicyAssignmentResourceSelectorsOutputReference;
}
export interface ResourcePolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#create ResourcePolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#delete ResourcePolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#read ResourcePolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment#update ResourcePolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function resourcePolicyAssignmentTimeoutsToTerraform(struct?: ResourcePolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class ResourcePolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourcePolicyAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment azurerm_resource_policy_assignment}
*/
export declare class ResourcePolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_policy_assignment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_policy_assignment azurerm_resource_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourcePolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ResourcePolicyAssignmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notScopes?;
    get notScopes(): string[];
    set notScopes(value: string[]);
    resetNotScopes(): void;
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _identity;
    get identity(): ResourcePolicyAssignmentIdentityOutputReference;
    putIdentity(value: ResourcePolicyAssignmentIdentity): void;
    resetIdentity(): void;
    get identityInput(): ResourcePolicyAssignmentIdentity | undefined;
    private _nonComplianceMessage;
    get nonComplianceMessage(): ResourcePolicyAssignmentNonComplianceMessageList;
    putNonComplianceMessage(value: ResourcePolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable): void;
    resetNonComplianceMessage(): void;
    get nonComplianceMessageInput(): cdktf.IResolvable | ResourcePolicyAssignmentNonComplianceMessage[] | undefined;
    private _overrides;
    get overrides(): ResourcePolicyAssignmentOverridesList;
    putOverrides(value: ResourcePolicyAssignmentOverrides[] | cdktf.IResolvable): void;
    resetOverrides(): void;
    get overridesInput(): cdktf.IResolvable | ResourcePolicyAssignmentOverrides[] | undefined;
    private _resourceSelectors;
    get resourceSelectors(): ResourcePolicyAssignmentResourceSelectorsList;
    putResourceSelectors(value: ResourcePolicyAssignmentResourceSelectors[] | cdktf.IResolvable): void;
    resetResourceSelectors(): void;
    get resourceSelectorsInput(): cdktf.IResolvable | ResourcePolicyAssignmentResourceSelectors[] | undefined;
    private _timeouts;
    get timeouts(): ResourcePolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: ResourcePolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourcePolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
