/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceProviderRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#id ResourceProviderRegistration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#name ResourceProviderRegistration#name}
    */
    readonly name: string;
    /**
    * feature block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#feature ResourceProviderRegistration#feature}
    */
    readonly feature?: ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#timeouts ResourceProviderRegistration#timeouts}
    */
    readonly timeouts?: ResourceProviderRegistrationTimeouts;
}
export interface ResourceProviderRegistrationFeature {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#name ResourceProviderRegistration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#registered ResourceProviderRegistration#registered}
    */
    readonly registered: boolean | cdktf.IResolvable;
}
export declare function resourceProviderRegistrationFeatureToTerraform(struct?: ResourceProviderRegistrationFeature | cdktf.IResolvable): any;
export declare class ResourceProviderRegistrationFeatureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceProviderRegistrationFeature | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceProviderRegistrationFeature | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _registered?;
    get registered(): boolean | cdktf.IResolvable;
    set registered(value: boolean | cdktf.IResolvable);
    get registeredInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ResourceProviderRegistrationFeatureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceProviderRegistrationFeatureOutputReference;
}
export interface ResourceProviderRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#create ResourceProviderRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#delete ResourceProviderRegistration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#read ResourceProviderRegistration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration#update ResourceProviderRegistration#update}
    */
    readonly update?: string;
}
export declare function resourceProviderRegistrationTimeoutsToTerraform(struct?: ResourceProviderRegistrationTimeouts | cdktf.IResolvable): any;
export declare class ResourceProviderRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceProviderRegistrationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceProviderRegistrationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration azurerm_resource_provider_registration}
*/
export declare class ResourceProviderRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_provider_registration";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/resource_provider_registration azurerm_resource_provider_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceProviderRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: ResourceProviderRegistrationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _feature;
    get feature(): ResourceProviderRegistrationFeatureList;
    putFeature(value: ResourceProviderRegistrationFeature[] | cdktf.IResolvable): void;
    resetFeature(): void;
    get featureInput(): cdktf.IResolvable | ResourceProviderRegistrationFeature[] | undefined;
    private _timeouts;
    get timeouts(): ResourceProviderRegistrationTimeoutsOutputReference;
    putTimeouts(value: ResourceProviderRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceProviderRegistrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
