/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RouteServerBgpConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#id RouteServerBgpConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#name RouteServerBgpConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#peer_asn RouteServerBgpConnection#peer_asn}
    */
    readonly peerAsn: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#peer_ip RouteServerBgpConnection#peer_ip}
    */
    readonly peerIp: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#route_server_id RouteServerBgpConnection#route_server_id}
    */
    readonly routeServerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#timeouts RouteServerBgpConnection#timeouts}
    */
    readonly timeouts?: RouteServerBgpConnectionTimeouts;
}
export interface RouteServerBgpConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#create RouteServerBgpConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#delete RouteServerBgpConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection#read RouteServerBgpConnection#read}
    */
    readonly read?: string;
}
export declare function routeServerBgpConnectionTimeoutsToTerraform(struct?: RouteServerBgpConnectionTimeouts | cdktf.IResolvable): any;
export declare class RouteServerBgpConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RouteServerBgpConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RouteServerBgpConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection azurerm_route_server_bgp_connection}
*/
export declare class RouteServerBgpConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_route_server_bgp_connection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/route_server_bgp_connection azurerm_route_server_bgp_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RouteServerBgpConnectionConfig
    */
    constructor(scope: Construct, id: string, config: RouteServerBgpConnectionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerAsn?;
    get peerAsn(): number;
    set peerAsn(value: number);
    get peerAsnInput(): number | undefined;
    private _peerIp?;
    get peerIp(): string;
    set peerIp(value: string);
    get peerIpInput(): string | undefined;
    private _routeServerId?;
    get routeServerId(): string;
    set routeServerId(value: string);
    get routeServerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): RouteServerBgpConnectionTimeoutsOutputReference;
    putTimeouts(value: RouteServerBgpConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RouteServerBgpConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
