/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#content_id SentinelMetadata#content_id}
    */
    readonly contentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#content_schema_version SentinelMetadata#content_schema_version}
    */
    readonly contentSchemaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#custom_version SentinelMetadata#custom_version}
    */
    readonly customVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#dependency SentinelMetadata#dependency}
    */
    readonly dependency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#first_publish_date SentinelMetadata#first_publish_date}
    */
    readonly firstPublishDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#icon_id SentinelMetadata#icon_id}
    */
    readonly iconId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#id SentinelMetadata#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#kind SentinelMetadata#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#last_publish_date SentinelMetadata#last_publish_date}
    */
    readonly lastPublishDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#name SentinelMetadata#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#parent_id SentinelMetadata#parent_id}
    */
    readonly parentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#preview_images SentinelMetadata#preview_images}
    */
    readonly previewImages?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#preview_images_dark SentinelMetadata#preview_images_dark}
    */
    readonly previewImagesDark?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#providers SentinelMetadata#providers}
    */
    readonly providers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#threat_analysis_tactics SentinelMetadata#threat_analysis_tactics}
    */
    readonly threatAnalysisTactics?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#threat_analysis_techniques SentinelMetadata#threat_analysis_techniques}
    */
    readonly threatAnalysisTechniques?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#version SentinelMetadata#version}
    */
    readonly version?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#workspace_id SentinelMetadata#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * author block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#author SentinelMetadata#author}
    */
    readonly author?: SentinelMetadataAuthor;
    /**
    * category block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#category SentinelMetadata#category}
    */
    readonly category?: SentinelMetadataCategory;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#source SentinelMetadata#source}
    */
    readonly source?: SentinelMetadataSource;
    /**
    * support block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#support SentinelMetadata#support}
    */
    readonly support?: SentinelMetadataSupport;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#timeouts SentinelMetadata#timeouts}
    */
    readonly timeouts?: SentinelMetadataTimeouts;
}
export interface SentinelMetadataAuthor {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#email SentinelMetadata#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#link SentinelMetadata#link}
    */
    readonly link?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#name SentinelMetadata#name}
    */
    readonly name?: string;
}
export declare function sentinelMetadataAuthorToTerraform(struct?: SentinelMetadataAuthorOutputReference | SentinelMetadataAuthor): any;
export declare class SentinelMetadataAuthorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelMetadataAuthor | undefined;
    set internalValue(value: SentinelMetadataAuthor | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface SentinelMetadataCategory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#domains SentinelMetadata#domains}
    */
    readonly domains?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#verticals SentinelMetadata#verticals}
    */
    readonly verticals?: string[];
}
export declare function sentinelMetadataCategoryToTerraform(struct?: SentinelMetadataCategoryOutputReference | SentinelMetadataCategory): any;
export declare class SentinelMetadataCategoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelMetadataCategory | undefined;
    set internalValue(value: SentinelMetadataCategory | undefined);
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    private _verticals?;
    get verticals(): string[];
    set verticals(value: string[]);
    resetVerticals(): void;
    get verticalsInput(): string[] | undefined;
}
export interface SentinelMetadataSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#id SentinelMetadata#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#kind SentinelMetadata#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#name SentinelMetadata#name}
    */
    readonly name?: string;
}
export declare function sentinelMetadataSourceToTerraform(struct?: SentinelMetadataSourceOutputReference | SentinelMetadataSource): any;
export declare class SentinelMetadataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelMetadataSource | undefined;
    set internalValue(value: SentinelMetadataSource | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface SentinelMetadataSupport {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#email SentinelMetadata#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#link SentinelMetadata#link}
    */
    readonly link?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#name SentinelMetadata#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#tier SentinelMetadata#tier}
    */
    readonly tier: string;
}
export declare function sentinelMetadataSupportToTerraform(struct?: SentinelMetadataSupportOutputReference | SentinelMetadataSupport): any;
export declare class SentinelMetadataSupportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelMetadataSupport | undefined;
    set internalValue(value: SentinelMetadataSupport | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _link?;
    get link(): string;
    set link(value: string);
    resetLink(): void;
    get linkInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
}
export interface SentinelMetadataTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#create SentinelMetadata#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#delete SentinelMetadata#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#read SentinelMetadata#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata#update SentinelMetadata#update}
    */
    readonly update?: string;
}
export declare function sentinelMetadataTimeoutsToTerraform(struct?: SentinelMetadataTimeouts | cdktf.IResolvable): any;
export declare class SentinelMetadataTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelMetadataTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelMetadataTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata azurerm_sentinel_metadata}
*/
export declare class SentinelMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_metadata";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/sentinel_metadata azurerm_sentinel_metadata} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelMetadataConfig
    */
    constructor(scope: Construct, id: string, config: SentinelMetadataConfig);
    private _contentId?;
    get contentId(): string;
    set contentId(value: string);
    get contentIdInput(): string | undefined;
    private _contentSchemaVersion?;
    get contentSchemaVersion(): string;
    set contentSchemaVersion(value: string);
    resetContentSchemaVersion(): void;
    get contentSchemaVersionInput(): string | undefined;
    private _customVersion?;
    get customVersion(): string;
    set customVersion(value: string);
    resetCustomVersion(): void;
    get customVersionInput(): string | undefined;
    private _dependency?;
    get dependency(): string;
    set dependency(value: string);
    resetDependency(): void;
    get dependencyInput(): string | undefined;
    private _firstPublishDate?;
    get firstPublishDate(): string;
    set firstPublishDate(value: string);
    resetFirstPublishDate(): void;
    get firstPublishDateInput(): string | undefined;
    private _iconId?;
    get iconId(): string;
    set iconId(value: string);
    resetIconId(): void;
    get iconIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _lastPublishDate?;
    get lastPublishDate(): string;
    set lastPublishDate(value: string);
    resetLastPublishDate(): void;
    get lastPublishDateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentId?;
    get parentId(): string;
    set parentId(value: string);
    get parentIdInput(): string | undefined;
    private _previewImages?;
    get previewImages(): string[];
    set previewImages(value: string[]);
    resetPreviewImages(): void;
    get previewImagesInput(): string[] | undefined;
    private _previewImagesDark?;
    get previewImagesDark(): string[];
    set previewImagesDark(value: string[]);
    resetPreviewImagesDark(): void;
    get previewImagesDarkInput(): string[] | undefined;
    private _providers?;
    get providers(): string[];
    set providers(value: string[]);
    resetProviders(): void;
    get providersInput(): string[] | undefined;
    private _threatAnalysisTactics?;
    get threatAnalysisTactics(): string[];
    set threatAnalysisTactics(value: string[]);
    resetThreatAnalysisTactics(): void;
    get threatAnalysisTacticsInput(): string[] | undefined;
    private _threatAnalysisTechniques?;
    get threatAnalysisTechniques(): string[];
    set threatAnalysisTechniques(value: string[]);
    resetThreatAnalysisTechniques(): void;
    get threatAnalysisTechniquesInput(): string[] | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _author;
    get author(): SentinelMetadataAuthorOutputReference;
    putAuthor(value: SentinelMetadataAuthor): void;
    resetAuthor(): void;
    get authorInput(): SentinelMetadataAuthor | undefined;
    private _category;
    get category(): SentinelMetadataCategoryOutputReference;
    putCategory(value: SentinelMetadataCategory): void;
    resetCategory(): void;
    get categoryInput(): SentinelMetadataCategory | undefined;
    private _source;
    get source(): SentinelMetadataSourceOutputReference;
    putSource(value: SentinelMetadataSource): void;
    resetSource(): void;
    get sourceInput(): SentinelMetadataSource | undefined;
    private _support;
    get support(): SentinelMetadataSupportOutputReference;
    putSupport(value: SentinelMetadataSupport): void;
    resetSupport(): void;
    get supportInput(): SentinelMetadataSupport | undefined;
    private _timeouts;
    get timeouts(): SentinelMetadataTimeoutsOutputReference;
    putTimeouts(value: SentinelMetadataTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelMetadataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
