/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryReplicationRecoveryPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#id SiteRecoveryReplicationRecoveryPlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#recovery_vault_id SiteRecoveryReplicationRecoveryPlan#recovery_vault_id}
    */
    readonly recoveryVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#source_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#source_recovery_fabric_id}
    */
    readonly sourceRecoveryFabricId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#target_recovery_fabric_id SiteRecoveryReplicationRecoveryPlan#target_recovery_fabric_id}
    */
    readonly targetRecoveryFabricId: string;
    /**
    * azure_to_azure_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#azure_to_azure_settings SiteRecoveryReplicationRecoveryPlan#azure_to_azure_settings}
    */
    readonly azureToAzureSettings?: SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings;
    /**
    * recovery_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#recovery_group SiteRecoveryReplicationRecoveryPlan#recovery_group}
    */
    readonly recoveryGroup?: SiteRecoveryReplicationRecoveryPlanRecoveryGroup[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#timeouts SiteRecoveryReplicationRecoveryPlan#timeouts}
    */
    readonly timeouts?: SiteRecoveryReplicationRecoveryPlanTimeouts;
}
export interface SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#primary_edge_zone SiteRecoveryReplicationRecoveryPlan#primary_edge_zone}
    */
    readonly primaryEdgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#primary_zone SiteRecoveryReplicationRecoveryPlan#primary_zone}
    */
    readonly primaryZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#recovery_edge_zone SiteRecoveryReplicationRecoveryPlan#recovery_edge_zone}
    */
    readonly recoveryEdgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#recovery_zone SiteRecoveryReplicationRecoveryPlan#recovery_zone}
    */
    readonly recoveryZone?: string;
}
export declare function siteRecoveryReplicationRecoveryPlanAzureToAzureSettingsToTerraform(struct?: SiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsOutputReference | SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings): any;
export declare class SiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings | undefined;
    set internalValue(value: SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings | undefined);
    private _primaryEdgeZone?;
    get primaryEdgeZone(): string;
    set primaryEdgeZone(value: string);
    resetPrimaryEdgeZone(): void;
    get primaryEdgeZoneInput(): string | undefined;
    private _primaryZone?;
    get primaryZone(): string;
    set primaryZone(value: string);
    resetPrimaryZone(): void;
    get primaryZoneInput(): string | undefined;
    private _recoveryEdgeZone?;
    get recoveryEdgeZone(): string;
    set recoveryEdgeZone(value: string);
    resetRecoveryEdgeZone(): void;
    get recoveryEdgeZoneInput(): string | undefined;
    private _recoveryZone?;
    get recoveryZone(): string;
    set recoveryZone(value: string);
    resetRecoveryZone(): void;
    get recoveryZoneInput(): string | undefined;
}
export interface SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}
    */
    readonly fabricLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}
    */
    readonly failOverDirections: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}
    */
    readonly failOverTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}
    */
    readonly manualActionInstruction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}
    */
    readonly runbookId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}
    */
    readonly scriptPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}
    */
    readonly type: string;
}
export declare function siteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionToTerraform(struct?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction | cdktf.IResolvable | undefined);
    private _fabricLocation?;
    get fabricLocation(): string;
    set fabricLocation(value: string);
    resetFabricLocation(): void;
    get fabricLocationInput(): string | undefined;
    private _failOverDirections?;
    get failOverDirections(): string[];
    set failOverDirections(value: string[]);
    get failOverDirectionsInput(): string[] | undefined;
    private _failOverTypes?;
    get failOverTypes(): string[];
    set failOverTypes(value: string[]);
    get failOverTypesInput(): string[] | undefined;
    private _manualActionInstruction?;
    get manualActionInstruction(): string;
    set manualActionInstruction(value: string);
    resetManualActionInstruction(): void;
    get manualActionInstructionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runbookId?;
    get runbookId(): string;
    set runbookId(value: string);
    resetRunbookId(): void;
    get runbookIdInput(): string | undefined;
    private _scriptPath?;
    get scriptPath(): string;
    set scriptPath(value: string);
    resetScriptPath(): void;
    get scriptPathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference;
}
export interface SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fabric_location SiteRecoveryReplicationRecoveryPlan#fabric_location}
    */
    readonly fabricLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fail_over_directions SiteRecoveryReplicationRecoveryPlan#fail_over_directions}
    */
    readonly failOverDirections: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#fail_over_types SiteRecoveryReplicationRecoveryPlan#fail_over_types}
    */
    readonly failOverTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#manual_action_instruction SiteRecoveryReplicationRecoveryPlan#manual_action_instruction}
    */
    readonly manualActionInstruction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#name SiteRecoveryReplicationRecoveryPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#runbook_id SiteRecoveryReplicationRecoveryPlan#runbook_id}
    */
    readonly runbookId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#script_path SiteRecoveryReplicationRecoveryPlan#script_path}
    */
    readonly scriptPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}
    */
    readonly type: string;
}
export declare function siteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionToTerraform(struct?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction | cdktf.IResolvable | undefined);
    private _fabricLocation?;
    get fabricLocation(): string;
    set fabricLocation(value: string);
    resetFabricLocation(): void;
    get fabricLocationInput(): string | undefined;
    private _failOverDirections?;
    get failOverDirections(): string[];
    set failOverDirections(value: string[]);
    get failOverDirectionsInput(): string[] | undefined;
    private _failOverTypes?;
    get failOverTypes(): string[];
    set failOverTypes(value: string[]);
    get failOverTypesInput(): string[] | undefined;
    private _manualActionInstruction?;
    get manualActionInstruction(): string;
    set manualActionInstruction(value: string);
    resetManualActionInstruction(): void;
    get manualActionInstructionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runbookId?;
    get runbookId(): string;
    set runbookId(value: string);
    resetRunbookId(): void;
    get runbookIdInput(): string | undefined;
    private _scriptPath?;
    get scriptPath(): string;
    set scriptPath(value: string);
    resetScriptPath(): void;
    get scriptPathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference;
}
export interface SiteRecoveryReplicationRecoveryPlanRecoveryGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#replicated_protected_items SiteRecoveryReplicationRecoveryPlan#replicated_protected_items}
    */
    readonly replicatedProtectedItems?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#type SiteRecoveryReplicationRecoveryPlan#type}
    */
    readonly type: string;
    /**
    * post_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#post_action SiteRecoveryReplicationRecoveryPlan#post_action}
    */
    readonly postAction?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction[] | cdktf.IResolvable;
    /**
    * pre_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#pre_action SiteRecoveryReplicationRecoveryPlan#pre_action}
    */
    readonly preAction?: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction[] | cdktf.IResolvable;
}
export declare function siteRecoveryReplicationRecoveryPlanRecoveryGroupToTerraform(struct?: SiteRecoveryReplicationRecoveryPlanRecoveryGroup | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryReplicationRecoveryPlanRecoveryGroup | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroup | cdktf.IResolvable | undefined);
    private _replicatedProtectedItems?;
    get replicatedProtectedItems(): string[];
    set replicatedProtectedItems(value: string[]);
    resetReplicatedProtectedItems(): void;
    get replicatedProtectedItemsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _postAction;
    get postAction(): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList;
    putPostAction(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction[] | cdktf.IResolvable): void;
    resetPostAction(): void;
    get postActionInput(): cdktf.IResolvable | SiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction[] | undefined;
    private _preAction;
    get preAction(): SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList;
    putPreAction(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction[] | cdktf.IResolvable): void;
    resetPreAction(): void;
    get preActionInput(): cdktf.IResolvable | SiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction[] | undefined;
}
export declare class SiteRecoveryReplicationRecoveryPlanRecoveryGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryReplicationRecoveryPlanRecoveryGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference;
}
export interface SiteRecoveryReplicationRecoveryPlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#create SiteRecoveryReplicationRecoveryPlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#delete SiteRecoveryReplicationRecoveryPlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#read SiteRecoveryReplicationRecoveryPlan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan#update SiteRecoveryReplicationRecoveryPlan#update}
    */
    readonly update?: string;
}
export declare function siteRecoveryReplicationRecoveryPlanTimeoutsToTerraform(struct?: SiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan}
*/
export declare class SiteRecoveryReplicationRecoveryPlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_replication_recovery_plan";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryReplicationRecoveryPlanConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryReplicationRecoveryPlanConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultId?;
    get recoveryVaultId(): string;
    set recoveryVaultId(value: string);
    get recoveryVaultIdInput(): string | undefined;
    private _sourceRecoveryFabricId?;
    get sourceRecoveryFabricId(): string;
    set sourceRecoveryFabricId(value: string);
    get sourceRecoveryFabricIdInput(): string | undefined;
    private _targetRecoveryFabricId?;
    get targetRecoveryFabricId(): string;
    set targetRecoveryFabricId(value: string);
    get targetRecoveryFabricIdInput(): string | undefined;
    private _azureToAzureSettings;
    get azureToAzureSettings(): SiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsOutputReference;
    putAzureToAzureSettings(value: SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings): void;
    resetAzureToAzureSettings(): void;
    get azureToAzureSettingsInput(): SiteRecoveryReplicationRecoveryPlanAzureToAzureSettings | undefined;
    private _recoveryGroup;
    get recoveryGroup(): SiteRecoveryReplicationRecoveryPlanRecoveryGroupList;
    putRecoveryGroup(value: SiteRecoveryReplicationRecoveryPlanRecoveryGroup[] | cdktf.IResolvable): void;
    resetRecoveryGroup(): void;
    get recoveryGroupInput(): cdktf.IResolvable | SiteRecoveryReplicationRecoveryPlanRecoveryGroup[] | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryReplicationRecoveryPlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SiteRecoveryReplicationRecoveryPlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
