/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudBuilderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#id SpringCloudBuilder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#name SpringCloudBuilder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#spring_cloud_service_id SpringCloudBuilder#spring_cloud_service_id}
    */
    readonly springCloudServiceId: string;
    /**
    * build_pack_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#build_pack_group SpringCloudBuilder#build_pack_group}
    */
    readonly buildPackGroup: SpringCloudBuilderBuildPackGroup[] | cdktf.IResolvable;
    /**
    * stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#stack SpringCloudBuilder#stack}
    */
    readonly stack: SpringCloudBuilderStack;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#timeouts SpringCloudBuilder#timeouts}
    */
    readonly timeouts?: SpringCloudBuilderTimeouts;
}
export interface SpringCloudBuilderBuildPackGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#build_pack_ids SpringCloudBuilder#build_pack_ids}
    */
    readonly buildPackIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#name SpringCloudBuilder#name}
    */
    readonly name: string;
}
export declare function springCloudBuilderBuildPackGroupToTerraform(struct?: SpringCloudBuilderBuildPackGroup | cdktf.IResolvable): any;
export declare class SpringCloudBuilderBuildPackGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudBuilderBuildPackGroup | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudBuilderBuildPackGroup | cdktf.IResolvable | undefined);
    private _buildPackIds?;
    get buildPackIds(): string[];
    set buildPackIds(value: string[]);
    resetBuildPackIds(): void;
    get buildPackIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class SpringCloudBuilderBuildPackGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudBuilderBuildPackGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudBuilderBuildPackGroupOutputReference;
}
export interface SpringCloudBuilderStack {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#id SpringCloudBuilder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#version SpringCloudBuilder#version}
    */
    readonly version: string;
}
export declare function springCloudBuilderStackToTerraform(struct?: SpringCloudBuilderStackOutputReference | SpringCloudBuilderStack): any;
export declare class SpringCloudBuilderStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudBuilderStack | undefined;
    set internalValue(value: SpringCloudBuilderStack | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface SpringCloudBuilderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#create SpringCloudBuilder#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#delete SpringCloudBuilder#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#read SpringCloudBuilder#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder#update SpringCloudBuilder#update}
    */
    readonly update?: string;
}
export declare function springCloudBuilderTimeoutsToTerraform(struct?: SpringCloudBuilderTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudBuilderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudBuilderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudBuilderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder azurerm_spring_cloud_builder}
*/
export declare class SpringCloudBuilder extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_builder";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/spring_cloud_builder azurerm_spring_cloud_builder} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudBuilderConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudBuilderConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudServiceId?;
    get springCloudServiceId(): string;
    set springCloudServiceId(value: string);
    get springCloudServiceIdInput(): string | undefined;
    private _buildPackGroup;
    get buildPackGroup(): SpringCloudBuilderBuildPackGroupList;
    putBuildPackGroup(value: SpringCloudBuilderBuildPackGroup[] | cdktf.IResolvable): void;
    get buildPackGroupInput(): cdktf.IResolvable | SpringCloudBuilderBuildPackGroup[] | undefined;
    private _stack;
    get stack(): SpringCloudBuilderStackOutputReference;
    putStack(value: SpringCloudBuilderStack): void;
    get stackInput(): SpringCloudBuilderStack | undefined;
    private _timeouts;
    get timeouts(): SpringCloudBuilderTimeoutsOutputReference;
    putTimeouts(value: SpringCloudBuilderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudBuilderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
