/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsFunctionJavascriptUdaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#id StreamAnalyticsFunctionJavascriptUda#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#name StreamAnalyticsFunctionJavascriptUda#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#script StreamAnalyticsFunctionJavascriptUda#script}
    */
    readonly script: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#stream_analytics_job_id StreamAnalyticsFunctionJavascriptUda#stream_analytics_job_id}
    */
    readonly streamAnalyticsJobId: string;
    /**
    * input block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#input StreamAnalyticsFunctionJavascriptUda#input}
    */
    readonly input: StreamAnalyticsFunctionJavascriptUdaInput[] | cdktf.IResolvable;
    /**
    * output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#output StreamAnalyticsFunctionJavascriptUda#output}
    */
    readonly output: StreamAnalyticsFunctionJavascriptUdaOutput;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#timeouts StreamAnalyticsFunctionJavascriptUda#timeouts}
    */
    readonly timeouts?: StreamAnalyticsFunctionJavascriptUdaTimeouts;
}
export interface StreamAnalyticsFunctionJavascriptUdaInput {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#configuration_parameter StreamAnalyticsFunctionJavascriptUda#configuration_parameter}
    */
    readonly configurationParameter?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#type StreamAnalyticsFunctionJavascriptUda#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdaInputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdaInput | cdktf.IResolvable): any;
export declare class StreamAnalyticsFunctionJavascriptUdaInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamAnalyticsFunctionJavascriptUdaInput | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdaInput | cdktf.IResolvable | undefined);
    private _configurationParameter?;
    get configurationParameter(): boolean | cdktf.IResolvable;
    set configurationParameter(value: boolean | cdktf.IResolvable);
    resetConfigurationParameter(): void;
    get configurationParameterInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class StreamAnalyticsFunctionJavascriptUdaInputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StreamAnalyticsFunctionJavascriptUdaInput[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamAnalyticsFunctionJavascriptUdaInputOutputReference;
}
export interface StreamAnalyticsFunctionJavascriptUdaOutput {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#type StreamAnalyticsFunctionJavascriptUda#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdaOutputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdaOutputOutputReference | StreamAnalyticsFunctionJavascriptUdaOutput): any;
export declare class StreamAnalyticsFunctionJavascriptUdaOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsFunctionJavascriptUdaOutput | undefined;
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdaOutput | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsFunctionJavascriptUdaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#create StreamAnalyticsFunctionJavascriptUda#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#delete StreamAnalyticsFunctionJavascriptUda#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#read StreamAnalyticsFunctionJavascriptUda#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda#update StreamAnalyticsFunctionJavascriptUda#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsFunctionJavascriptUdaTimeoutsToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdaTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsFunctionJavascriptUdaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsFunctionJavascriptUdaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda azurerm_stream_analytics_function_javascript_uda}
*/
export declare class StreamAnalyticsFunctionJavascriptUda extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_function_javascript_uda";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/stream_analytics_function_javascript_uda azurerm_stream_analytics_function_javascript_uda} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsFunctionJavascriptUdaConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsFunctionJavascriptUdaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _streamAnalyticsJobId?;
    get streamAnalyticsJobId(): string;
    set streamAnalyticsJobId(value: string);
    get streamAnalyticsJobIdInput(): string | undefined;
    private _input;
    get input(): StreamAnalyticsFunctionJavascriptUdaInputList;
    putInput(value: StreamAnalyticsFunctionJavascriptUdaInput[] | cdktf.IResolvable): void;
    get inputInput(): cdktf.IResolvable | StreamAnalyticsFunctionJavascriptUdaInput[] | undefined;
    private _output;
    get output(): StreamAnalyticsFunctionJavascriptUdaOutputOutputReference;
    putOutput(value: StreamAnalyticsFunctionJavascriptUdaOutput): void;
    get outputInput(): StreamAnalyticsFunctionJavascriptUdaOutput | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsFunctionJavascriptUdaTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsFunctionJavascriptUdaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsFunctionJavascriptUdaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
