/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerExternalEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#enabled TrafficManagerExternalEndpoint#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#endpoint_location TrafficManagerExternalEndpoint#endpoint_location}
    */
    readonly endpointLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#geo_mappings TrafficManagerExternalEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#id TrafficManagerExternalEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#priority TrafficManagerExternalEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#profile_id TrafficManagerExternalEndpoint#profile_id}
    */
    readonly profileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#target TrafficManagerExternalEndpoint#target}
    */
    readonly target: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#weight TrafficManagerExternalEndpoint#weight}
    */
    readonly weight?: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#custom_header TrafficManagerExternalEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#subnet TrafficManagerExternalEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#timeouts TrafficManagerExternalEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerExternalEndpointTimeouts;
}
export interface TrafficManagerExternalEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#name TrafficManagerExternalEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#value TrafficManagerExternalEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerExternalEndpointCustomHeaderToTerraform(struct?: TrafficManagerExternalEndpointCustomHeader | cdktf.IResolvable): any;
export declare class TrafficManagerExternalEndpointCustomHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TrafficManagerExternalEndpointCustomHeader | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerExternalEndpointCustomHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class TrafficManagerExternalEndpointCustomHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TrafficManagerExternalEndpointCustomHeaderOutputReference;
}
export interface TrafficManagerExternalEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#first TrafficManagerExternalEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#last TrafficManagerExternalEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#scope TrafficManagerExternalEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerExternalEndpointSubnetToTerraform(struct?: TrafficManagerExternalEndpointSubnet | cdktf.IResolvable): any;
export declare class TrafficManagerExternalEndpointSubnetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TrafficManagerExternalEndpointSubnet | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerExternalEndpointSubnet | cdktf.IResolvable | undefined);
    private _first?;
    get first(): string;
    set first(value: string);
    get firstInput(): string | undefined;
    private _last?;
    get last(): string;
    set last(value: string);
    resetLast(): void;
    get lastInput(): string | undefined;
    private _scope?;
    get scope(): number;
    set scope(value: number);
    resetScope(): void;
    get scopeInput(): number | undefined;
}
export declare class TrafficManagerExternalEndpointSubnetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TrafficManagerExternalEndpointSubnetOutputReference;
}
export interface TrafficManagerExternalEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#create TrafficManagerExternalEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#delete TrafficManagerExternalEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#read TrafficManagerExternalEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint#update TrafficManagerExternalEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerExternalEndpointTimeoutsToTerraform(struct?: TrafficManagerExternalEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerExternalEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerExternalEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TrafficManagerExternalEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint}
*/
export declare class TrafficManagerExternalEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_external_endpoint";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/traffic_manager_external_endpoint azurerm_traffic_manager_external_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerExternalEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerExternalEndpointConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    get endpointLocation(): string;
    set endpointLocation(value: string);
    resetEndpointLocation(): void;
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _customHeader;
    get customHeader(): TrafficManagerExternalEndpointCustomHeaderList;
    putCustomHeader(value: TrafficManagerExternalEndpointCustomHeader[] | cdktf.IResolvable): void;
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerExternalEndpointCustomHeader[] | undefined;
    private _subnet;
    get subnet(): TrafficManagerExternalEndpointSubnetList;
    putSubnet(value: TrafficManagerExternalEndpointSubnet[] | cdktf.IResolvable): void;
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerExternalEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerExternalEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerExternalEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TrafficManagerExternalEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
