/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#allow_forwarded_traffic VirtualNetworkPeering#allow_forwarded_traffic}
    */
    readonly allowForwardedTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#allow_gateway_transit VirtualNetworkPeering#allow_gateway_transit}
    */
    readonly allowGatewayTransit?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#allow_virtual_network_access VirtualNetworkPeering#allow_virtual_network_access}
    */
    readonly allowVirtualNetworkAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#id VirtualNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#name VirtualNetworkPeering#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#remote_virtual_network_id VirtualNetworkPeering#remote_virtual_network_id}
    */
    readonly remoteVirtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#resource_group_name VirtualNetworkPeering#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#triggers VirtualNetworkPeering#triggers}
    */
    readonly triggers?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#use_remote_gateways VirtualNetworkPeering#use_remote_gateways}
    */
    readonly useRemoteGateways?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#virtual_network_name VirtualNetworkPeering#virtual_network_name}
    */
    readonly virtualNetworkName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#timeouts VirtualNetworkPeering#timeouts}
    */
    readonly timeouts?: VirtualNetworkPeeringTimeouts;
}
export interface VirtualNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#create VirtualNetworkPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#delete VirtualNetworkPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#read VirtualNetworkPeering#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering#update VirtualNetworkPeering#update}
    */
    readonly update?: string;
}
export declare function virtualNetworkPeeringTimeoutsToTerraform(struct?: VirtualNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class VirtualNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering azurerm_virtual_network_peering}
*/
export declare class VirtualNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_network_peering";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.61.0/docs/resources/virtual_network_peering azurerm_virtual_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: VirtualNetworkPeeringConfig);
    private _allowForwardedTraffic?;
    get allowForwardedTraffic(): boolean | cdktf.IResolvable;
    set allowForwardedTraffic(value: boolean | cdktf.IResolvable);
    resetAllowForwardedTraffic(): void;
    get allowForwardedTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGatewayTransit?;
    get allowGatewayTransit(): boolean | cdktf.IResolvable;
    set allowGatewayTransit(value: boolean | cdktf.IResolvable);
    resetAllowGatewayTransit(): void;
    get allowGatewayTransitInput(): boolean | cdktf.IResolvable | undefined;
    private _allowVirtualNetworkAccess?;
    get allowVirtualNetworkAccess(): boolean | cdktf.IResolvable;
    set allowVirtualNetworkAccess(value: boolean | cdktf.IResolvable);
    resetAllowVirtualNetworkAccess(): void;
    get allowVirtualNetworkAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _remoteVirtualNetworkId?;
    get remoteVirtualNetworkId(): string;
    set remoteVirtualNetworkId(value: string);
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    };
    set triggers(value: {
        [key: string]: string;
    });
    resetTriggers(): void;
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    private _useRemoteGateways?;
    get useRemoteGateways(): boolean | cdktf.IResolvable;
    set useRemoteGateways(value: boolean | cdktf.IResolvable);
    resetUseRemoteGateways(): void;
    get useRemoteGatewaysInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkName?;
    get virtualNetworkName(): string;
    set virtualNetworkName(value: string);
    get virtualNetworkNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): VirtualNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: VirtualNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
