"""
ZeroQuant Python SDK for agentic DeFi vaults.
"""

__version__ = "0.1.0"

from .client import ZeroQuantClient
from .models import (
    VaultConfig,
    SwapParams,
    ExecuteParams,
    ExecuteBatchParams,
    TransactionResult,
    GasEstimate,
    AgentSession,
    CreateSessionParams,
)
from .intents.swap import SwapIntent
from .exceptions import (
    ZeroQuantError,
    NotConnectedError,
    ReadOnlyError,
    ValidationError,
    TransactionError,
    ContractError,
)
from .retry import (
    RetryConfig,
    with_retry,
    with_retry_async,
    retry_async,
    retry_sync,
)

__all__ = [
    # Client
    "ZeroQuantClient",
    # Models
    "VaultConfig",
    "SwapParams",
    "ExecuteParams",
    "ExecuteBatchParams",
    "TransactionResult",
    "GasEstimate",
    "AgentSession",
    "CreateSessionParams",
    # Intents
    "SwapIntent",
    # Exceptions
    "ZeroQuantError",
    "NotConnectedError",
    "ReadOnlyError",
    "ValidationError",
    "TransactionError",
    "ContractError",
    # Retry utilities
    "RetryConfig",
    "with_retry",
    "with_retry_async",
    "retry_async",
    "retry_sync",
]
