# Copyright 2025 Qilimanjaro Quantum Tech
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from enum import Enum

from pydantic import BaseModel, ConfigDict, Field


class QaaSModel(BaseModel):
    model_config = ConfigDict(validate_by_name=True, validate_by_alias=True)


class LoginPayload(BaseModel): ...


class Token(QaaSModel):
    """
    Represents the structure of the login response:
    {
        "accessToken": "...",
        "expiresIn": 123456789,
        "issuedAt": "123456789",
        "refreshToken": "...",
        "tokenType": "bearer"
    }
    """

    access_token: str = Field(alias="accessToken")
    expires_in: int = Field(alias="expiresIn")
    issued_at: str = Field(alias="issuedAt")
    refresh_token: str = Field(alias="refreshToken")
    token_type: str = Field(alias="tokenType")


class DeviceStatus(str, Enum):
    """Device status typing for posting"""

    ONLINE = "online"
    MAINTENANCE = "maintenance"
    OFFLINE = "offline"


class Device(QaaSModel):
    id: int = Field(...)
    name: str = Field(...)
    status: DeviceStatus = Field(...)
