export declare const POLICY_DESCRIPTION_ANNOTATION = "@cdkDescription";
export declare const POLICY_ID_ANNOTATION = "@cdkId";
export declare function checkParseSchema(schemaStr: string): void;
export declare function checkParsePolicy(policyStatement: string): void;
/**
 * Extracts the Description of the Policy searching for the @see POLICY_DESCRIPTION_ANNOTATION annotation on top of policy contents (before effect)
 * @param policyStatement The policy statement in string format
 * @returns Returns the description if found or null
 */
export declare function getPolicyDescription(policyStatement: string): string | null;
/**
 * Extracts the Description of the Policy searching for the @see POLICY_ID_ANNOTATION annotation on top of policy contents (before effect)
 * @param policyStatement The policy statement in string format
 * @returns Returns the id if found or null
 */
export declare function getPolicyId(policyStatement: string): string | null;
/**
 * Split the Policies in case of multiple Cedar Policies in a string.
 * Please Note: this method doesn't provide a validation of every policy, it just splits
 * them and returns an array.
 * @param policyStatements The policy statements in string format
 * @returns a string array where each element represents a Cedar Policy statement
 */
export declare function splitPolicies(policyStatements: string): string[];
export declare function checkParseTemplate(templateStatement: string): void;
/**
 * Method which validates multple Cedar policies in a single string against a Cedar Schema
 *
 * @param policiesStatements a string containing multiple Cedar policies
 * @param schemaStr a Cedar Schema
 */
export declare function validateMultiplePolicies(policiesStatements: string, schemaStr: string): void;
export declare function cleanUpApiNameForNamespace(apiName: string): string;
export declare function buildSchema(namespace: string, actionNames: string[], principalGroupType?: string): Record<string, Record<string, any>>;
