
let imports = {};
imports['__wbindgen_placeholder__'] = module.exports;
let wasm;
const { TextDecoder, TextEncoder } = require(`util`);

let cachedTextDecoder = new TextDecoder('utf-8', { ignoreBOM: true, fatal: true });

cachedTextDecoder.decode();

let cachedUint8ArrayMemory0 = null;

function getUint8ArrayMemory0() {
    if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
        cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
    }
    return cachedUint8ArrayMemory0;
}

function getStringFromWasm0(ptr, len) {
    ptr = ptr >>> 0;
    return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}

function addToExternrefTable0(obj) {
    const idx = wasm.__externref_table_alloc();
    wasm.__wbindgen_export_2.set(idx, obj);
    return idx;
}

function handleError(f, args) {
    try {
        return f.apply(this, args);
    } catch (e) {
        const idx = addToExternrefTable0(e);
        wasm.__wbindgen_exn_store(idx);
    }
}

let WASM_VECTOR_LEN = 0;

let cachedTextEncoder = new TextEncoder('utf-8');

const encodeString = (typeof cachedTextEncoder.encodeInto === 'function'
    ? function (arg, view) {
    return cachedTextEncoder.encodeInto(arg, view);
}
    : function (arg, view) {
    const buf = cachedTextEncoder.encode(arg);
    view.set(buf);
    return {
        read: arg.length,
        written: buf.length
    };
});

function passStringToWasm0(arg, malloc, realloc) {

    if (realloc === undefined) {
        const buf = cachedTextEncoder.encode(arg);
        const ptr = malloc(buf.length, 1) >>> 0;
        getUint8ArrayMemory0().subarray(ptr, ptr + buf.length).set(buf);
        WASM_VECTOR_LEN = buf.length;
        return ptr;
    }

    let len = arg.length;
    let ptr = malloc(len, 1) >>> 0;

    const mem = getUint8ArrayMemory0();

    let offset = 0;

    for (; offset < len; offset++) {
        const code = arg.charCodeAt(offset);
        if (code > 0x7F) break;
        mem[ptr + offset] = code;
    }

    if (offset !== len) {
        if (offset !== 0) {
            arg = arg.slice(offset);
        }
        ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
        const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
        const ret = encodeString(arg, view);

        offset += ret.written;
        ptr = realloc(ptr, len, offset, 1) >>> 0;
    }

    WASM_VECTOR_LEN = offset;
    return ptr;
}

function isLikeNone(x) {
    return x === undefined || x === null;
}

let cachedDataViewMemory0 = null;

function getDataViewMemory0() {
    if (cachedDataViewMemory0 === null || cachedDataViewMemory0.buffer.detached === true || (cachedDataViewMemory0.buffer.detached === undefined && cachedDataViewMemory0.buffer !== wasm.memory.buffer)) {
        cachedDataViewMemory0 = new DataView(wasm.memory.buffer);
    }
    return cachedDataViewMemory0;
}
/**
 * Get valid request environment
 * @param {Template} t
 * @param {Schema} s
 * @returns {GetValidRequestEnvsResult}
 */
module.exports.getValidRequestEnvsTemplate = function(t, s) {
    const ret = wasm.getValidRequestEnvsTemplate(t, s);
    return ret;
};

/**
 * Get valid request environment
 * @param {Policy} t
 * @param {Schema} s
 * @returns {GetValidRequestEnvsResult}
 */
module.exports.getValidRequestEnvsPolicy = function(t, s) {
    const ret = wasm.getValidRequestEnvsPolicy(t, s);
    return ret;
};

/**
 * @returns {string}
 */
module.exports.getCedarVersion = function() {
    let deferred1_0;
    let deferred1_1;
    try {
        const ret = wasm.getCedarVersion();
        deferred1_0 = ret[0];
        deferred1_1 = ret[1];
        return getStringFromWasm0(ret[0], ret[1]);
    } finally {
        wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
};

/**
 * @returns {string}
 */
module.exports.getCedarSDKVersion = function() {
    let deferred1_0;
    let deferred1_1;
    try {
        const ret = wasm.getCedarSDKVersion();
        deferred1_0 = ret[0];
        deferred1_1 = ret[1];
        return getStringFromWasm0(ret[0], ret[1]);
    } finally {
        wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
};

/**
 * Parse a policy set and optionally validate it against a provided schema
 *
 * This is the basic validator interface, using [`ValidationCall`] and
 * [`ValidationAnswer`] types
 * @param {ValidationCall} call
 * @returns {ValidationAnswer}
 */
module.exports.validate = function(call) {
    const ret = wasm.validate(call);
    return ret;
};

/**
 * Check whether a policy set successfully parses.
 * @param {PolicySet} policies
 * @returns {CheckParseAnswer}
 */
module.exports.checkParsePolicySet = function(policies) {
    const ret = wasm.checkParsePolicySet(policies);
    return ret;
};

/**
 * Check whether a schema successfully parses.
 * @param {Schema} schema
 * @returns {CheckParseAnswer}
 */
module.exports.checkParseSchema = function(schema) {
    const ret = wasm.checkParseSchema(schema);
    return ret;
};

/**
 * Check whether a set of entities successfully parses.
 * @param {EntitiesParsingCall} call
 * @returns {CheckParseAnswer}
 */
module.exports.checkParseEntities = function(call) {
    const ret = wasm.checkParseEntities(call);
    return ret;
};

/**
 * Check whether a context successfully parses.
 * @param {ContextParsingCall} call
 * @returns {CheckParseAnswer}
 */
module.exports.checkParseContext = function(call) {
    const ret = wasm.checkParseContext(call);
    return ret;
};

/**
 * Apply the Cedar policy formatter to a policy set in the Cedar policy format
 * @param {FormattingCall} call
 * @returns {FormattingAnswer}
 */
module.exports.formatPolicies = function(call) {
    const ret = wasm.formatPolicies(call);
    return ret;
};

/**
 * Basic interface, using [`AuthorizationCall`] and [`AuthorizationAnswer`] types
 * @param {AuthorizationCall} call
 * @returns {AuthorizationAnswer}
 */
module.exports.isAuthorized = function(call) {
    const ret = wasm.isAuthorized(call);
    return ret;
};

/**
 * Takes a PolicySet represented as string and return the policies
 * and templates split into vecs and sorted by id.
 * @param {string} policyset_str
 * @returns {PolicySetTextToPartsAnswer}
 */
module.exports.policySetTextToParts = function(policyset_str) {
    const ptr0 = passStringToWasm0(policyset_str, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    const len0 = WASM_VECTOR_LEN;
    const ret = wasm.policySetTextToParts(ptr0, len0);
    return ret;
};

/**
 * Return the Cedar (textual) representation of a policy.
 * @param {Policy} policy
 * @returns {PolicyToTextAnswer}
 */
module.exports.policyToText = function(policy) {
    const ret = wasm.policyToText(policy);
    return ret;
};

/**
 * Return the Cedar (textual) representation of a template.
 * @param {Template} template
 * @returns {PolicyToTextAnswer}
 */
module.exports.templateToText = function(template) {
    const ret = wasm.templateToText(template);
    return ret;
};

/**
 * Return the JSON representation of a policy.
 * @param {Policy} policy
 * @returns {PolicyToJsonAnswer}
 */
module.exports.policyToJson = function(policy) {
    const ret = wasm.policyToJson(policy);
    return ret;
};

/**
 * Return the JSON representation of a template.
 * @param {Template} template
 * @returns {PolicyToJsonAnswer}
 */
module.exports.templateToJson = function(template) {
    const ret = wasm.templateToJson(template);
    return ret;
};

/**
 * Return the Cedar (textual) representation of a schema.
 * @param {Schema} schema
 * @returns {SchemaToTextAnswer}
 */
module.exports.schemaToText = function(schema) {
    const ret = wasm.schemaToText(schema);
    return ret;
};

/**
 * Return the JSON representation of a schema.
 * @param {Schema} schema
 * @returns {SchemaToJsonAnswer}
 */
module.exports.schemaToJson = function(schema) {
    const ret = wasm.schemaToJson(schema);
    return ret;
};

/**
 * Get language version of Cedar
 * @returns {string}
 */
module.exports.getCedarLangVersion = function() {
    let deferred1_0;
    let deferred1_1;
    try {
        const ret = wasm.getCedarLangVersion();
        deferred1_0 = ret[0];
        deferred1_1 = ret[1];
        return getStringFromWasm0(ret[0], ret[1]);
    } finally {
        wasm.__wbindgen_free(deferred1_0, deferred1_1, 1);
    }
};

module.exports.__wbg_parse_def2e24ef1252aff = function() { return handleError(function (arg0, arg1) {
    const ret = JSON.parse(getStringFromWasm0(arg0, arg1));
    return ret;
}, arguments) };

module.exports.__wbg_stringify_f7ed6987935b4a24 = function() { return handleError(function (arg0) {
    const ret = JSON.stringify(arg0);
    return ret;
}, arguments) };

module.exports.__wbindgen_init_externref_table = function() {
    const table = wasm.__wbindgen_export_2;
    const offset = table.grow(4);
    table.set(0, undefined);
    table.set(offset + 0, undefined);
    table.set(offset + 1, null);
    table.set(offset + 2, true);
    table.set(offset + 3, false);
    ;
};

module.exports.__wbindgen_is_undefined = function(arg0) {
    const ret = arg0 === undefined;
    return ret;
};

module.exports.__wbindgen_string_get = function(arg0, arg1) {
    const obj = arg1;
    const ret = typeof(obj) === 'string' ? obj : undefined;
    var ptr1 = isLikeNone(ret) ? 0 : passStringToWasm0(ret, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
    var len1 = WASM_VECTOR_LEN;
    getDataViewMemory0().setInt32(arg0 + 4 * 1, len1, true);
    getDataViewMemory0().setInt32(arg0 + 4 * 0, ptr1, true);
};

module.exports.__wbindgen_throw = function(arg0, arg1) {
    throw new Error(getStringFromWasm0(arg0, arg1));
};

const path = require('path').join(__dirname, 'cedar_wasm_bg.wasm');
const bytes = require('fs').readFileSync(path);

const wasmModule = new WebAssembly.Module(bytes);
const wasmInstance = new WebAssembly.Instance(wasmModule, imports);
wasm = wasmInstance.exports;
module.exports.__wasm = wasm;

wasm.__wbindgen_start();

