# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .fact import Fact
from .message import Message
from .summary import Summary


class Memory(pydantic_v1.BaseModel):
    facts: typing.Optional[typing.List[str]] = pydantic_v1.Field(default=None)
    """
    Most recent list of facts derived from the session. Included only with perpetual memory type.
    Deprecated: Facts will be deprecated in future releases and relevant_facts should be used instead.
    """

    messages: typing.Optional[typing.List[Message]] = pydantic_v1.Field(default=None)
    """
    A list of message objects, where each message contains a role and content.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Any]] = pydantic_v1.Field(default=None)
    """
    A dictionary containing metadata associated with the memory.
    """

    relevant_facts: typing.Optional[typing.List[Fact]] = None
    relevant_summaries: typing.Optional[typing.List[Summary]] = pydantic_v1.Field(default=None)
    """
    Summary list result from Summary Retriever Memory Type.
    """

    summary: typing.Optional[Summary] = pydantic_v1.Field(default=None)
    """
    A Summary object.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
