# Copyright (C) 2020 NextERP Romania
# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl.html).

import base64

from odoo.tests import tagged

from .common_data_setup import CiusRoTestSetup


@tagged("post_install", "-at_install")
class TestCiusRoXmlGeneration(CiusRoTestSetup):
    @classmethod
    def setUpClass(cls):
        super().setUpClass()
        cls.edi_cius_format = cls.env.ref("l10n_ro_account_edi_ubl.edi_ubl_cius_ro")

    # invoice -> move_type = "out_invoice"
    def test_account_invoice_edi_ubl(self):
        self.invoice.action_post()
        invoice_xml = self.invoice.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(self.get_file("invoice.xml"))
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # credit_note -> move_type = "out_refund"
    def test_account_credit_note_edi_ubl(self):
        self.credit_note.action_post()
        invoice_xml = self.credit_note.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(self.get_file("credit_note.xml"))
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # invoice -> move_type = "in_invoice"
    def test_account_invoice_in_edi_ubl(self):
        self.invoice_in.partner_id.l10n_ro_vat_subjected = True
        self.invoice_in.action_post()
        invoice_xml = self.invoice_in.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(self.get_file("invoice_in.xml"))
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # credit_note -> move_type = "in_refund"
    def test_account_credit_note_in_edi_ubl(self):
        self.credit_note_in.partner_id.l10n_ro_vat_subjected = True
        self.credit_note_in.action_post()
        invoice_xml = self.credit_note_in.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(
            self.get_file("credit_note_in.xml")
        )
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # Teste invoice partener neplatitor de TVA (tax 0%)
    # invoice -> move_type = "out_invoice"
    def test_account_invoice_edi_ubl_tax_0(self):
        self.env.company.partner_id.vat = self.env.company.partner_id.vat.replace(
            "RO", ""
        )
        self.env.company.partner_id.l10n_ro_vat_subjected = False
        self.invoice_tax_0.action_post()
        invoice_xml = self.invoice_tax_0.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(
            self.get_file("invoice_tax_0.xml")
        )
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # credit_note -> move_type = "out_refund"
    def test_account_credit_note_edi_ubl_tax_0(self):
        self.env.company.partner_id.vat = self.env.company.partner_id.vat.replace(
            "RO", ""
        )
        self.env.company.partner_id.l10n_ro_vat_subjected = False
        self.credit_note_tax_0.action_post()
        invoice_xml = self.credit_note_tax_0.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(
            self.get_file("credit_note_tax_0.xml")
        )
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # invoice -> move_type = "in_invoice"
    def test_account_invoice_in_edi_ubl_tax_0(self):
        self.partner.l10n_ro_vat_subjected = False
        self.invoice_in_tax_0.action_post()
        invoice_xml = self.invoice_in_tax_0.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(
            self.get_file("invoice_in_tax_0.xml")
        )
        self.assertXmlTreeEqual(current_etree, expected_etree)

    # credit_note -> move_type = "in_refund"
    def test_account_credit_note_in_edi_ubl_tax_0(self):
        self.partner.l10n_ro_vat_subjected = False
        self.credit_note_in_tax_0.action_post()
        invoice_xml = self.credit_note_in_tax_0.attach_ubl_xml_file_button()
        att = self.env["ir.attachment"].browse(invoice_xml["res_id"])
        xml_content = base64.b64decode(att.with_context(bin_size=False).datas)

        current_etree = self.get_xml_tree_from_string(xml_content)
        expected_etree = self.get_xml_tree_from_string(
            self.get_file("credit_note_in_tax_0.xml")
        )
        self.assertXmlTreeEqual(current_etree, expected_etree)
