# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScriptsResult',
    'AwaitableGetScriptsResult',
    'get_scripts',
    'get_scripts_output',
]

@pulumi.output_type
class GetScriptsResult:
    """
    A collection of values returned by getScripts.
    """
    def __init__(__self__, apm_domain_id=None, content_type=None, display_name=None, filters=None, id=None, script_collections=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if script_collections and not isinstance(script_collections, list):
            raise TypeError("Expected argument 'script_collections' to be a list")
        pulumi.set(__self__, "script_collections", script_collections)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Content type of the script.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetScriptsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="scriptCollections")
    def script_collections(self) -> Sequence['outputs.GetScriptsScriptCollectionResult']:
        """
        The list of script_collection.
        """
        return pulumi.get(self, "script_collections")


class AwaitableGetScriptsResult(GetScriptsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScriptsResult(
            apm_domain_id=self.apm_domain_id,
            content_type=self.content_type,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            script_collections=self.script_collections)


def get_scripts(apm_domain_id: Optional[str] = None,
                content_type: Optional[str] = None,
                display_name: Optional[str] = None,
                filters: Optional[Sequence[Union['GetScriptsFilterArgs', 'GetScriptsFilterArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScriptsResult:
    """
    This data source provides the list of Scripts in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of scripts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scripts = oci.ApmSynthetics.get_scripts(apm_domain_id=test_apm_domain["id"],
        content_type=script_content_type,
        display_name=script_display_name)
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str content_type: A filter to return only resources that match the content type given.
    :param str display_name: A filter to return only the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['contentType'] = content_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getScripts:getScripts', __args__, opts=opts, typ=GetScriptsResult).value

    return AwaitableGetScriptsResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        content_type=pulumi.get(__ret__, 'content_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        script_collections=pulumi.get(__ret__, 'script_collections'))
def get_scripts_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                       content_type: Optional[pulumi.Input[Optional[str]]] = None,
                       display_name: Optional[pulumi.Input[Optional[str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetScriptsFilterArgs', 'GetScriptsFilterArgsDict']]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScriptsResult]:
    """
    This data source provides the list of Scripts in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Returns a list of scripts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scripts = oci.ApmSynthetics.get_scripts(apm_domain_id=test_apm_domain["id"],
        content_type=script_content_type,
        display_name=script_display_name)
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str content_type: A filter to return only resources that match the content type given.
    :param str display_name: A filter to return only the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['contentType'] = content_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getScripts:getScripts', __args__, opts=opts, typ=GetScriptsResult)
    return __ret__.apply(lambda __response__: GetScriptsResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        content_type=pulumi.get(__response__, 'content_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        script_collections=pulumi.get(__response__, 'script_collections')))
